/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.smsplatform.service;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.smsplatform.service.ISMSSourceTypeStrategy;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SMBaseSourceStrategy
implements ISMSSourceTypeStrategy {
    private static final Logger log = LoggerFactory.getLogger(SMBaseSourceStrategy.class);
    protected boolean ifExistQueryVal;
    protected boolean ifExistPresetVal;

    @Override
    public abstract void validBlankAndHrOrg(String var1, String var2, Context var3, Object ... var4) throws BOSException;

    @Override
    public Map<String, String> analyContent(String sourceConfig, String logPrefix, Context ctx, Map<String, String> queryParamsCondition, List<String> queryParams) throws BOSException {
        if (!this.ifExistQueryVal) {
            return null;
        }
        try {
            JSONObject sourceConfigs = JSONObject.parseObject((String)sourceConfig);
            sourceConfig = sourceConfigs.getString("queryPath");
        }
        catch (Exception e) {
            log.error(logPrefix + e.getLocalizedMessage(), (Throwable)e);
            String label17 = SHRServerResource.getString((String)"com.kingdee.shr.smsplatform.ShrSmsplatformResource", (String)"label17", (Context)ctx);
            throw new BOSException(label17);
        }
        if (StringUtils.isBlank((CharSequence)sourceConfig)) {
            String label23 = SHRServerResource.getString((String)"com.kingdee.shr.smsplatform.ShrSmsplatformResource", (String)"label23", (Context)ctx);
            throw new BOSException(label23);
        }
        if (-1 == sourceConfig.lastIndexOf(".")) {
            String label22 = SHRServerResource.getString((String)"com.kingdee.shr.smsplatform.ShrSmsplatformResource", (String)"label22", (Context)ctx);
            throw new BOSException(label22);
        }
        MetaDataPK mainQueryPKNew = new MetaDataPK(sourceConfig.substring(0, sourceConfig.lastIndexOf(".")), sourceConfig.substring(sourceConfig.lastIndexOf(".") + 1));
        IQueryExecutor execNew = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)mainQueryPKNew);
        EntityViewInfo entityViewInfoNew = new EntityViewInfo();
        FilterInfo filterInfoNew = new FilterInfo();
        for (Map.Entry<String, String> entry : queryParamsCondition.entrySet()) {
            filterInfoNew.getFilterItems().add(new FilterItemInfo(entry.getKey(), (Object)entry.getValue()));
        }
        entityViewInfoNew.setFilter(filterInfoNew);
        SelectorItemCollection sic = new SelectorItemCollection();
        for (String str : queryParams) {
            sic.add(new SelectorItemInfo(str));
        }
        entityViewInfoNew.setSelector(sic);
        execNew.setObjectView(entityViewInfoNew);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            execNew.option().isIgnoreOrder = true;
            execNew.option().isAutoTranslateEnum = true;
            execNew.option().isAutoTranslateBoolean = true;
            IRowSet rowSet = execNew.executeQuery();
            while (rowSet.next()) {
                for (String str : queryParams) {
                    try {
                        rowSet.getString(str);
                    }
                    catch (SQLException e) {
                        String label24 = SHRServerResource.getString((String)"com.kingdee.shr.smsplatform.ShrSmsplatformResource", (String)"label24", (Context)ctx);
                        log.error(String.format(label24, logPrefix, str, e.getLocalizedMessage()), (Throwable)e);
                        continue;
                    }
                    if (StringUtils.isBlank((CharSequence)rowSet.getString(str))) continue;
                    hashMap.put(str, rowSet.getString(str));
                }
            }
            return hashMap;
        }
        catch (Exception e) {
            log.error(logPrefix + e.getLocalizedMessage(), (Throwable)e);
            String label21 = SHRServerResource.getString((String)"com.kingdee.shr.smsplatform.ShrSmsplatformResource", (String)"label21", (Context)ctx);
            throw new BOSException(label21);
        }
    }

    @Override
    public Map<String, String> analyContent2Preset(Map<String, String> presetParamsValue, List<String> presetParams) {
        if (!this.ifExistPresetVal) {
            return null;
        }
        HashMap<String, String> preSetValues = new HashMap<String, String>();
        for (String str : presetParams) {
            if (StringUtils.isBlank((CharSequence)presetParamsValue.get(str))) continue;
            preSetValues.put(str, presetParamsValue.get(str));
        }
        return preSetValues;
    }

    @Override
    public void match(Map<String, String> preSetValues, Map<String, String> queryValues, List<String> placeholders, Map<String, String> cloudParams, Map<String, String> customParms, Context ctx) {
        for (int i = 0; i < placeholders.size(); ++i) {
            if (this.ifExistPresetVal && !StringUtils.isBlank((CharSequence)preSetValues.get(placeholders.get(i)))) {
                placeholders.set(i, preSetValues.get(placeholders.get(i)));
                continue;
            }
            if (this.ifExistQueryVal && !StringUtils.isBlank((CharSequence)queryValues.get(placeholders.get(i)))) {
                placeholders.set(i, queryValues.get(placeholders.get(i)));
                continue;
            }
            if (!StringUtils.isBlank((CharSequence)cloudParams.get(placeholders.get(i)))) {
                placeholders.set(i, cloudParams.get(placeholders.get(i)));
                continue;
            }
            String label41 = SHRServerResource.getString((String)"com.kingdee.shr.smsplatform.ShrSmsplatformResource", (String)"label41", (Context)ctx);
            placeholders.set(i, "[" + label41 + "]");
        }
    }

    @Override
    public void setQueryVal(boolean ifExistQueryVal) {
        this.ifExistQueryVal = ifExistQueryVal;
    }

    @Override
    public void setPresetVal(boolean ifExistPresetVal) {
        this.ifExistPresetVal = ifExistPresetVal;
    }
}

