/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.account.engine.interfaces.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.td.account.engine.interfaces.IAccountCalculator;
import com.kingdee.eas.tm.td.account.engine.interfaces.ISQLBuilder;
import com.kingdee.eas.tm.td.account.engine.model.AccountCalculatorParams;
import com.kingdee.eas.tm.td.account.engine.model.AccountCalculatorResult;
import com.kingdee.eas.tm.td.account.engine.thread.QueryDataSyncLock;
import com.kingdee.eas.tm.td.account.engine.thread.QueryDataTask;
import com.kingdee.eas.tm.td.account.engine.thread.ThreadPool;
import com.kingdee.eas.tm.td.account.engine.util.AccountEngineUtil;
import com.kingdee.eas.tm.td.account.engine.util.AccountUtil;
import com.kingdee.eas.tm.td.account.engine.util.KsqlUtil;
import com.kingdee.eas.tm.td.basedata.AccountConfigEntryInfo;
import com.kingdee.eas.tm.td.basedata.AccountConfigFactory;
import com.kingdee.eas.tm.td.basedata.AccountConfigInfo;
import com.kingdee.eas.tm.td.basedata.DataSourceToAccountCollection;
import com.kingdee.eas.tm.td.basedata.DataSourceToAccountFactory;
import com.kingdee.eas.tm.td.basedata.OrgToAccountRelationCollection;
import com.kingdee.eas.tm.td.basedata.OrgToAccountRelationFactory;
import com.kingdee.eas.tm.td.basedata.TakeDataContditionCollection;
import com.kingdee.eas.tm.td.basedata.TakeDataContditionFactory;
import com.kingdee.eas.tm.td.basedata.TakeDataContditionInfo;
import com.kingdee.util.LowTimer;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public abstract class AbstractAccountCalculator
implements IAccountCalculator {
    private static final String PROPER_NAME = "seq";
    protected Context ctx;
    protected LowTimer timer;
    protected String detailTempTable;
    protected AccountConfigInfo accountConfigInfo;
    protected TakeDataContditionCollection takeDataContditionColl;
    protected AccountCalculatorResult calculatorResult = new AccountCalculatorResult();
    protected AccountCalculatorParams params = null;
    protected Map<String, AccountConfigEntryInfo> fieldMap = new HashMap<String, AccountConfigEntryInfo>();

    public AbstractAccountCalculator(Context ctx, AccountCalculatorParams params) throws BOSException, EASBizException {
        this.ctx = ctx;
        this.params = params;
        this.timer = new LowTimer();
    }

    protected void init() throws BOSException, EASBizException {
        String accountID = this.params.getAccountID();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entry.*"));
        this.accountConfigInfo = AccountConfigFactory.getLocalInstance(this.ctx).getAccountConfigInfo((IObjectPK)new ObjectUuidPK(accountID), sic);
        this.accountConfigInfo.getEntry().sort(PROPER_NAME);
        AccountConfigEntryInfo entryInfo = null;
        int size = this.accountConfigInfo.getEntry().size();
        for (int i = 0; i < size; ++i) {
            entryInfo = this.accountConfigInfo.getEntry().get(i);
            this.fieldMap.put(entryInfo.getName(), entryInfo);
        }
        this.takeDataContditionColl = this.getTakeDataContditionCollection();
    }

    @Override
    public String getAccountSQL() throws BOSException, EASBizException {
        this.init();
        List<ISQLBuilder> sqlBuilderList = this.getSQLBuilder();
        ISQLBuilder sqlBuilder = null;
        int size = sqlBuilderList.size();
        StringBuffer sSQL = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            sqlBuilder = sqlBuilderList.get(i);
            String selectSQL = sqlBuilder.getSQL();
            if (AccountUtil.isEmpty(selectSQL)) continue;
            sSQL.append(selectSQL);
            sSQL.append(";");
        }
        return sSQL.toString();
    }

    private TakeDataContditionCollection getTakeDataContditionCollection() throws EASBizException, BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("account.id", (Object)this.accountConfigInfo.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)this.params.getCompanyID(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)"2", CompareType.EQUALS));
        ev.setFilter(filter);
        OrgToAccountRelationCollection relationColl = OrgToAccountRelationFactory.getLocalInstance(this.ctx).getOrgToAccountRelationCollection(ev);
        if (relationColl == null || relationColl.size() == 0) {
            return null;
        }
        EntityViewInfo dsView = new EntityViewInfo();
        FilterInfo dsFilter = new FilterInfo();
        dsFilter.getFilterItems().add(new FilterItemInfo("accountConfig.id", (Object)this.accountConfigInfo.getId().toString(), CompareType.EQUALS));
        dsFilter.getFilterItems().add(new FilterItemInfo("companyOrgUnitID", (Object)this.params.getCompanyID(), CompareType.EQUALS));
        dsFilter.getFilterItems().add(new FilterItemInfo("dataSource.state", (Object)"2", CompareType.EQUALS));
        dsView.setFilter(dsFilter);
        SelectorItemCollection dsSic = new SelectorItemCollection();
        dsSic.add(new SelectorItemInfo("dataSource.id"));
        dsView.setSelector(dsSic);
        DataSourceToAccountCollection dsColl = DataSourceToAccountFactory.getLocalInstance(this.ctx).getDataSourceToAccountCollection(dsView);
        HashSet<String> dataSourceIds = new HashSet<String>();
        int size = dsColl.size();
        for (int i = 0; i < size; ++i) {
            dataSourceIds.add(dsColl.get(i).getDataSource().getId().toString());
        }
        if (dataSourceIds.size() == 0) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("dataSource.id", dataSourceIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)"1", CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("dataSource.*"));
        sic.add(new SelectorItemInfo("dataSource.entry.*"));
        view.setSelector(sic);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("dataSource.number"));
        view.setSorter(sorter);
        TakeDataContditionCollection coll = TakeDataContditionFactory.getLocalInstance(this.ctx).getTakeDataContditionCollection(view);
        return coll;
    }

    protected void createTempTable() throws BOSException, EASBizException {
        this.timer.reset();
        String createSQL = AccountEngineUtil.getCreateTempTableSQL(this.ctx, this.accountConfigInfo);
        this.detailTempTable = KsqlUtil.createTempTableWithNewTx(this.ctx, createSQL);
    }

    public void releaseTempTable() throws BOSException {
        KsqlUtil.releaseTempTable(this.ctx, this.detailTempTable);
    }

    protected String getInsertSQL(String tableName) {
        StringBuffer insertSQL = new StringBuffer();
        insertSQL.append("Insert Into ").append(tableName).append("(");
        insertSQL.append(AccountEngineUtil.getAccountConfigFieldStr(this.accountConfigInfo, null));
        insertSQL.append(")");
        return insertSQL.toString();
    }

    @Override
    public void calculate() throws BOSException, EASBizException {
        this.init();
        this.createTempTable();
        try {
            this.beforeCalculate();
            this.calculateStep();
            this.afterCalculate();
        }
        finally {
            this.releaseTempTable();
        }
    }

    protected void beforeCalculate() throws BOSException, EASBizException {
    }

    protected void afterCalculate() throws BOSException, EASBizException {
    }

    protected abstract void calculateStep() throws BOSException, EASBizException;

    protected void takeBillData() throws BOSException, EASBizException {
        ISQLBuilder sqlBuilder = null;
        List<ISQLBuilder> sqlBuilderList = this.getSQLBuilder();
        Connection conn = null;
        QueryDataSyncLock lock = new QueryDataSyncLock();
        ThreadPool threadPool = ThreadPool.getInstance();
        int size = sqlBuilderList.size();
        try {
            conn = EJBFactory.getConnection((Context)this.ctx);
            String insertSQL = this.getInsertSQL(this.detailTempTable);
            StringBuffer sSQL = new StringBuffer();
            for (int i = 0; i < size; ++i) {
                sqlBuilder = sqlBuilderList.get(i);
                String selectSQL = sqlBuilder.getSQL();
                if (AccountUtil.isEmpty(selectSQL)) continue;
                sSQL.setLength(0);
                sSQL.append(insertSQL).append("\r\n").append(selectSQL);
                QueryDataTask thread = new QueryDataTask(lock, sqlBuilder.getExecuteLockName(), conn, sSQL.toString());
                lock.addLock(sqlBuilder.getExecuteLockName());
                threadPool.addTask(thread);
            }
            lock.waitFinish();
        }
        catch (BOSException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    protected List<ISQLBuilder> getSQLBuilder() {
        ISQLBuilder sqlBuilder = null;
        ArrayList<ISQLBuilder> sqlBuilderList = new ArrayList<ISQLBuilder>();
        if (this.takeDataContditionColl == null) {
            return sqlBuilderList;
        }
        int size = this.takeDataContditionColl.size();
        for (int i = 0; i < size; ++i) {
            sqlBuilder = this.createSQLBuilder(this.takeDataContditionColl.get(i));
            sqlBuilderList.add(sqlBuilder);
        }
        return sqlBuilderList;
    }

    @Override
    public AccountCalculatorResult getResult() throws BOSException, EASBizException {
        return this.calculatorResult;
    }

    protected abstract ISQLBuilder createSQLBuilder(TakeDataContditionInfo var1);
}

