/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.account.engine.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.td.account.engine.util.AccountUtil;
import com.kingdee.eas.tm.td.basedata.AccountConfigEntryCollection;
import com.kingdee.eas.tm.td.basedata.AccountConfigEntryInfo;
import com.kingdee.eas.tm.td.basedata.AccountConfigInfo;
import com.kingdee.eas.tm.td.basedata.DataTypeEnum;
import java.util.List;
import java.util.Map;

public class AccountEngineUtil {
    public static String getCreateTempTableSQL(Context ctx, AccountConfigInfo configInfo) throws EASBizException {
        StringBuffer createSQL = new StringBuffer();
        createSQL.append("Create Table ").append("AccountTempTable").append("(").append("\r\n");
        AccountConfigEntryCollection coll = configInfo.getEntry();
        AccountConfigEntryInfo entryInfo = null;
        for (int i = 0; i < coll.size(); ++i) {
            entryInfo = coll.get(i);
            String fieldName = entryInfo.getName();
            String dataType = AccountUtil.getDataTypeStr(ctx, entryInfo);
            String defaultValue = AccountUtil.getDefaultValueSQL(entryInfo, true);
            String constraint = !entryInfo.isIsNullable() ? "Not Null" : "";
            if (i > 0) {
                createSQL.append(",").append("\r\n");
            }
            createSQL.append("  ").append(fieldName).append(" ").append(dataType).append(" ").append(defaultValue).append(" ").append(constraint);
        }
        createSQL.append("\r\n").append(")");
        return createSQL.toString();
    }

    public static String getAccountConfigFieldStr(AccountConfigInfo accountConfigInfo, String prefix) {
        StringBuffer str = new StringBuffer();
        AccountConfigEntryCollection coll = accountConfigInfo.getEntry();
        AccountConfigEntryInfo fieldInfo = null;
        String tmpPrefix = "";
        if (!AccountUtil.isEmpty(prefix)) {
            tmpPrefix = prefix + ".";
        }
        for (int i = 0; i < coll.size(); ++i) {
            fieldInfo = coll.get(i);
            if (i > 0) {
                str.append(",");
            }
            str.append(tmpPrefix).append(fieldInfo.getName());
        }
        return str.toString();
    }

    public static String getDimFieldStr(AccountConfigInfo accountConfigInfo) {
        StringBuffer str = new StringBuffer();
        AccountConfigEntryCollection coll = accountConfigInfo.getEntry();
        AccountConfigEntryInfo fieldInfo = null;
        for (int i = 0; i < coll.size(); ++i) {
            fieldInfo = coll.get(i);
            if (str.length() > 0) {
                str.append(",");
            }
            str.append(fieldInfo.getName());
        }
        return str.toString();
    }

    public static String getFieldFromList(List list) {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            if (str.length() > 0) {
                str.append(",");
            }
            str.append(list.get(i));
        }
        return str.toString();
    }

    public static String getFieldFromSumList(List list) {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            if (str.length() > 0) {
                str.append(",");
            }
            str.append("Sum(").append(list.get(i)).append(") as ").append(list.get(i));
        }
        return str.toString();
    }

    public static String getFieldFromList(List list, Map fieldMap) {
        StringBuffer str = new StringBuffer();
        String field = null;
        AccountConfigEntryInfo entryInfo = null;
        for (int i = 0; i < list.size(); ++i) {
            field = (String)list.get(i);
            entryInfo = (AccountConfigEntryInfo)fieldMap.get(field);
            if (str.length() > 0) {
                str.append(",");
            }
            if (DataTypeEnum.Date.equals((Object)entryInfo.getDataType())) {
                str.append(" TO_CHAR(" + field + ", 'YYYY-MM-DD') as " + field);
                continue;
            }
            if (DataTypeEnum.Timestamp.equals((Object)entryInfo.getDataType())) {
                str.append(" TO_CHAR(" + field + ", 'YYYY-MM-DD HH24:MI:SS') as " + field);
                continue;
            }
            str.append(list.get(i));
        }
        return str.toString();
    }

    public static String getFieldGroupList(List list, Map fieldMap) {
        StringBuffer str = new StringBuffer();
        String field = null;
        AccountConfigEntryInfo entryInfo = null;
        for (int i = 0; i < list.size(); ++i) {
            field = (String)list.get(i);
            entryInfo = (AccountConfigEntryInfo)fieldMap.get(field);
            if (str.length() > 0) {
                str.append(",");
            }
            if (DataTypeEnum.Date.equals((Object)entryInfo.getDataType())) {
                str.append(" TO_CHAR(" + field + ", 'YYYY-MM-DD') ");
                continue;
            }
            if (DataTypeEnum.Timestamp.equals((Object)entryInfo.getDataType())) {
                str.append(" TO_CHAR(" + field + ", 'YYYY-MM-DD HH24:MI:SS') ");
                continue;
            }
            str.append(list.get(i));
        }
        return str.toString();
    }

    public static String getOrderSQL(AccountConfigInfo accountConfigInfo, boolean isSum) throws EASBizException, BOSException {
        StringBuffer orderSQL = new StringBuffer();
        AccountConfigEntryCollection fieldColl = accountConfigInfo.getEntry();
        AccountConfigEntryInfo fieldModel = null;
        boolean hasOrderField = false;
        orderSQL.append(" ORDER BY ");
        for (int i = 0; i < fieldColl.size(); ++i) {
            fieldModel = fieldColl.get(i);
            if (isSum && !fieldModel.isIsSum() && !fieldModel.isIsGroup() || !fieldModel.isIsSort()) continue;
            orderSQL.append(fieldModel.getName()).append(",");
            hasOrderField = true;
        }
        String result = "";
        if (hasOrderField) {
            result = orderSQL.substring(0, orderSQL.length() - 1) + "\r\n";
        }
        return result;
    }
}

