/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.account.formula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.InsertType;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.tm.td.FormulaFacadeFactory;
import com.kingdee.eas.tm.td.FormulaTypeEnum;
import com.kingdee.eas.tm.td.IFormulaFacade;
import com.kingdee.eas.tm.td.account.formula.AccountFormulaColumnParams;
import com.kingdee.eas.tm.td.account.formula.AccountFormulaParams;
import com.kingdee.eas.tm.td.account.formula.FormulaHelper;
import com.kingdee.eas.tm.td.utils.Location;
import java.awt.Point;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AccountFormulaCalculateService {
    private static Logger logger = CoreUIObject.getLogger(AccountFormulaCalculateService.class);
    private Context ctx = null;

    public AccountFormulaCalculateService(Context ctx) {
        this.ctx = ctx;
    }

    public void calculateReport(ReportBaseInfo reportInfo, Book book) throws EASBizException, BOSException {
        Sheet sheet = null;
        for (int i = 0; i < book.getSheetCount(); ++i) {
            sheet = book.getSheet(i);
            this.calculateSheet(reportInfo, sheet);
        }
    }

    public void calculateSheet(ReportBaseInfo reportInfo, Sheet sheet) throws EASBizException, BOSException {
        Point basePoint = null;
        AccountFormulaParams formulaParams = null;
        for (int i = 0; i < sheet.getRows().getMaxIntMark() + 1; ++i) {
            for (int j = 0; j < sheet.getCols().getMaxIntMark() + 1; ++j) {
                if (!FormulaHelper.isBasePointCell(sheet, i, j)) continue;
                basePoint = new Point(j, i);
                formulaParams = FormulaHelper.getParametersFromCell(sheet, basePoint.y, basePoint.x);
                if (formulaParams == null) continue;
                this.calculateCell(reportInfo, sheet, basePoint, formulaParams);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculateCell(ReportBaseInfo reportInfo, Sheet sheet, Point basePoint, AccountFormulaParams formulaParams) throws EASBizException, BOSException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("formulaType", (Object)FormulaTypeEnum.AccountFormula);
        params.put("formulaParams", formulaParams);
        params.put("reportInfo", reportInfo);
        Map ret = this.getFormulaFacade().execute(params);
        Object[][] data = (Object[][])ret.get("data");
        try {
            sheet.getBook().getUndoManager().startGroup();
            sheet.getBook().getUndoManager().enable(false);
            sheet.getBook().setSkipListeners(true);
            this.fillSheet(sheet, basePoint, data, formulaParams);
        }
        finally {
            sheet.getBook().getUndoManager().endGroup();
            sheet.getBook().getUndoManager().enable(true);
            sheet.getBook().setSkipListeners(false);
        }
    }

    private void fillSheet(Sheet sheet, Point basePoint, Object[][] data, AccountFormulaParams formulaParams) {
        if (data == null) {
            logger.error((Object)"[fillSheet] data is null");
            return;
        }
        this.doClearCell(sheet, basePoint, formulaParams);
        int insertLength = data.length;
        if (formulaParams.isColumnMatch()) {
            insertLength = formulaParams.getDefaultCounter();
        }
        this.fillData(sheet, basePoint, data, formulaParams, insertLength);
        formulaParams.setRowCounter(insertLength > formulaParams.getDefaultCounter() ? insertLength : formulaParams.getDefaultCounter());
        formulaParams.setColCounter(FormulaHelper.getHeadSize(formulaParams));
        this.saveBasePoint(sheet, basePoint, formulaParams);
    }

    private void doClearCell(Sheet sheet, Point basePoint, AccountFormulaParams formulaParams) {
        int dataRow = this.getRow(formulaParams);
        int dataCol = this.getCol(formulaParams);
        int row = basePoint.y;
        int row2 = row + dataRow - 1;
        int col = basePoint.x;
        int col2 = col + dataCol - 1;
        if (row2 > formulaParams.getDefaultCounter() + basePoint.y - 1) {
            sheet.getRange(row, col, row2, col2).delete(true);
        }
    }

    private int getRow(AccountFormulaParams formulaParams) {
        return formulaParams.getRowCounter() > formulaParams.getDefaultCounter() ? formulaParams.getRowCounter() : formulaParams.getDefaultCounter();
    }

    private int getCol(AccountFormulaParams formulaParams) {
        return formulaParams.getColCounter() > FormulaHelper.getHeadSize(formulaParams) ? formulaParams.getColCounter() : FormulaHelper.getHeadSize(formulaParams);
    }

    private void fillData(Sheet sheet, Point basePoint, Object[][] data, AccountFormulaParams formulaParams, int insertLength) {
        if (insertLength > formulaParams.getDefaultCounter()) {
            Range range = null;
            int spanRow = 0;
            int spanColumn = 0;
            for (int i = formulaParams.getDefaultCounter() + 1; i <= insertLength; ++i) {
                spanRow = 0;
                spanColumn = 0;
                for (int j = 0; j < FormulaHelper.getHeadSize(formulaParams); ++j) {
                    range = sheet.getRange(basePoint.y + 1 + spanRow, basePoint.x + j + spanColumn);
                    if (1 == formulaParams.getInsertMode()) {
                        range.getBlock(0).setCol2(16383);
                    }
                    range.insert(true, InsertType.FLLOW_UP_STYLE);
                    CellBlock cellBlock = sheet.getMergeBlock(basePoint.y + spanRow, basePoint.x + j + spanColumn);
                    if (cellBlock == null) continue;
                    int row = basePoint.y + 1 + spanRow;
                    int col = basePoint.x + j + spanColumn;
                    int row2 = row + cellBlock.getHeight() - 1;
                    int col2 = col + cellBlock.getWidth() - 1;
                    sheet.getRange(row, col, row2, col2).merge();
                    spanRow += cellBlock.getHeight() - 1;
                    spanColumn += cellBlock.getWidth() - 1;
                }
            }
        }
        Object[] rowData = null;
        List<AccountFormulaColumnParams> hideColumns = FormulaHelper.getHideColumns(formulaParams);
        if (formulaParams.isColumnMatch()) {
            List<AccountFormulaColumnParams> matchColumns = FormulaHelper.getMatchColumns(formulaParams.getColumnParams());
            Map<String, Object[]> dataMap = FormulaHelper.buildMatchDataMap(data, matchColumns, formulaParams);
            int row = -1;
            String key = null;
            int length = insertLength;
            for (int i = 0; i < length; ++i) {
                row = basePoint.y + i;
                key = this.getMatchFieldDim(sheet, matchColumns, row);
                if (!dataMap.containsKey(key)) continue;
                rowData = dataMap.get(key);
                this.insertRow(sheet, basePoint, rowData, i, formulaParams, hideColumns);
            }
        } else {
            int length = insertLength;
            for (int i = 0; i < length; ++i) {
                rowData = data[i];
                this.insertRow(sheet, basePoint, rowData, i, formulaParams, hideColumns);
            }
        }
    }

    private void insertRow(Sheet sheet, Point basePoint, Object[] rowData, int i, AccountFormulaParams formulaParams, List<AccountFormulaColumnParams> hideColumns) {
        Cell cell = null;
        int colIndex = basePoint.x;
        int spanColumn = 0;
        if (formulaParams.isInsertSeq()) {
            CellBlock cellBlock = sheet.getMergeBlock(basePoint.y + i, colIndex);
            if (cellBlock != null) {
                spanColumn += cellBlock.getWidth() - 1;
            }
            cell = sheet.getCell(basePoint.y + i, colIndex, true);
            cell.setValue(new Variant(i + 1));
            ++colIndex;
        }
        int dataLength = rowData.length;
        if (hideColumns.size() > 0) {
            dataLength -= hideColumns.size();
        }
        for (int j = 0; j < dataLength; ++j) {
            Object cellData = rowData[j];
            cell = sheet.getCell(basePoint.y + i, colIndex + j + spanColumn, true);
            CellBlock cellBlock = sheet.getMergeBlock(basePoint.y + i, colIndex + j + spanColumn);
            if (cellBlock != null) {
                spanColumn += cellBlock.getWidth() - 1;
            }
            if (cellData != null) {
                cell.setValue(new Variant(cellData));
                continue;
            }
            cell.setValue(Variant.nullVariant);
        }
    }

    private String getMatchFieldDim(Sheet sheet, List<AccountFormulaColumnParams> matchColumns, int row) {
        String dim = null;
        int size = matchColumns.size();
        for (int j = 0; j < size; ++j) {
            dim = "";
            AccountFormulaColumnParams column = matchColumns.get(j);
            int[] cellPos = Location.getCellRowAndColumn(column.getMatchField().trim() + (row + 1));
            Object value = sheet.getRange(cellPos[0], cellPos[1]).getValue().getValue();
            if (j != 0) {
                dim = dim + "_$$_";
            }
            dim = dim + FormulaHelper.getFieldDimValue(value, column.getDataType());
        }
        return dim;
    }

    private void saveBasePoint(Sheet sheet, Point basePoint, AccountFormulaParams formulaParams) {
        FormulaHelper.saveBasePointCell(sheet, basePoint, formulaParams);
    }

    private IFormulaFacade getFormulaFacade() throws BOSException {
        return this.ctx == null ? FormulaFacadeFactory.getRemoteInstance() : FormulaFacadeFactory.getLocalInstance(this.ctx);
    }
}

