/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.td.TDFacadeFactory;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.AccountConfigEntryCollection;
import com.kingdee.eas.tm.td.basedata.AccountConfigEntryInfo;
import com.kingdee.eas.tm.td.basedata.AccountConfigFactory;
import com.kingdee.eas.tm.td.basedata.AccountConfigInfo;
import com.kingdee.eas.tm.td.basedata.AccountConfigStatusEnum;
import com.kingdee.eas.tm.td.basedata.AccountTypeInfo;
import com.kingdee.eas.tm.td.basedata.DataTypeEnum;
import com.kingdee.eas.tm.td.basedata.IAccountConfig;
import com.kingdee.eas.tm.td.basedata.OrgToAccountRelationCollection;
import com.kingdee.eas.tm.td.basedata.OrgToAccountRelationFactory;
import com.kingdee.eas.tm.td.basedata.OrgToAccountRelationInfo;
import com.kingdee.eas.tm.td.basedata.client.AbstractAccountConfigEditUI;
import com.kingdee.eas.tm.td.basedata.client.AccountConfigEntryEditUI;
import com.kingdee.eas.tm.td.common.uihelper.EditUIHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AccountConfigEditUI
extends AbstractAccountConfigEditUI {
    private static final Logger logger = CoreUIObject.getLogger(AccountConfigEditUI.class);
    public static final String COL_ID = "id";
    public static final String COL_SEQ = "seq";
    public static final String COL_NAME = "name";
    public static final String COL_ALIAS = "alias";
    public static final String COL_DATATYPE = "dataType";
    public static final String COL_ISSCHEDULED = "isScheduled";
    public static final String COL_ISNULLABLE = "isNullable";
    public static final String COL_BASEDATABOSTYPE = "baseDataBOSType";
    public static final String COL_BASEDATAALIAS = "baseDataAlias";
    public static final String COL_DEFAULTVALUE = "defaultValue";
    public static final String COL_DEFAULTVALUEALIAS = "defaultValueAlias";
    public static final String COL_FORMULA = "formula";
    public static final String COL_TXTVOLIDSCOPE = "txtVolidScope";
    public static final String COL_ISREFRESHDATA = "isRefreshData";
    public static final String COL_LENGTH = "length";
    public static final String COL_ISSORT = "isSort";
    public static final String COL_ISGROUP = "isGroup";
    public static final String COL_ISSUM = "isSum";
    private CtrlUnitInfo baseCtrlUnit = null;
    private CompanyOrgUnitInfo companyInfo = null;
    private OrgToAccountRelationInfo relationInfo = null;
    private String selectedAccountConfigId = null;
    private EditUIHelper uiHelper = new EditUIHelper(this);
    private Map btnMap = new HashMap();

    public AccountConfigEditUI() throws Exception {
        this.btnMap.put("actionRemove", this.actionRemove);
        this.btnMap.put("actionCancel", this.actionCancel);
        this.btnMap.put("actionCancelCancel", this.actionCancelCancel);
        this.btnMap.put("actionEdit", this.actionEdit);
        this.btnMap.put("actionSave", this.actionSubmit);
        this.btnMap.put("actionCopy", this.actionCopy);
        this.getDetailTable().checkParsed();
        this.getDetailTable().setEditable(false);
        this.getDetailTable().getSelectManager().setSelectMode(10);
        this.getDetailTable().addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (("ADDNEW".equals(AccountConfigEditUI.this.getOprtState()) || "EDIT".equals(AccountConfigEditUI.this.getOprtState())) && e.getClickCount() == 2) {
                    AccountConfigEditUI.this.doEditField();
                }
            }
        });
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData != null) {
            this.selectedAccountConfigId = this.editData.getId().toString();
            if (this.companyInfo == null) {
                this.companyInfo = (CompanyOrgUnitInfo)this.getUIContext().get("companyInfo");
            }
        }
        this.checkPermission("add");
        super.actionCopy_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission("add");
        super.actionAddNew_actionPerformed(e);
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        uiContext.put((Object)"companyInfo", (Object)this.companyInfo);
        uiContext.put((Object)"unitInfo", (Object)this.baseCtrlUnit);
    }

    protected abstract AccountTypeInfo getAccountTypeInfo();

    public void onLoad() throws Exception {
        this.beforeLoad();
        super.onLoad();
        this.txtName.setMaxLength(80);
        this.txtNumber.setMaxLength(80);
        this.prmtAccountType.setEnabled(false);
        this.chkMenuItemSubmitAndAddNew.setSelected(false);
        this.initDataStatus();
        this.txt_fillRow.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (new BigDecimal(eventObj.getNewValue().toString()).compareTo(new BigDecimal(0)) == 0) {
                    AccountConfigEditUI.this.txt_fillRow.setValue(eventObj.getOldValue() == new BigDecimal(0) ? new BigDecimal(1) : eventObj.getOldValue());
                }
            }
        });
        this.txt_fillColumn.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (new BigDecimal(eventObj.getNewValue().toString()).compareTo(new BigDecimal(0)) == 0) {
                    AccountConfigEditUI.this.txt_fillColumn.setValue(eventObj.getOldValue() == new BigDecimal(0) ? new BigDecimal(1) : eventObj.getOldValue());
                }
            }
        });
        if (this.getOprtState().endsWith("ADDNEW")) {
            this.txt_fillRow.setValue((Object)1);
            this.txt_fillColumn.setValue((Object)1);
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkBeforeSubmit();
        this.editData.put("relation", this.relationInfo);
        this.initOldData((IObjectValue)this.editData);
        super.actionSubmit_actionPerformed(e);
        OrgToAccountRelationInfo relation = null;
        if (this.relationInfo != null) {
            relation = OrgToAccountRelationFactory.getRemoteInstance().getOrgToAccountRelationInfo((IObjectPK)new ObjectUuidPK(this.relationInfo.getId()));
        }
        if (!this.getOprtState().equals(OprtState.ADDNEW)) {
            if (relation != null && AccountConfigStatusEnum.ACTIVE.equals((Object)relation.getState())) {
                this.setOprtState("VIEW");
            } else {
                this.setOprtState("EDIT");
            }
        }
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
    }

    private void checkBeforeSubmit() {
        if (this.kdtEntry.getRowCount() == 0) {
            MsgBox.showWarning((String)TDUtils.getString("com.kingdee.eas.tm.td.TDCommonResource", "Entries_NOTNULL", TDUtils.getLocale()));
            SysUtil.abort();
        }
    }

    private void checkPermission(String actionType) throws BOSException, EASBizException {
        String orgId = null;
        orgId = this.companyInfo != null && this.companyInfo.getId() != null ? this.companyInfo.getId().toString() : this.baseCtrlUnit.getId().toString();
        String permissionItem = this.getPermissionItem(actionType);
        TDFacadeFactory.getRemoteInstance().checkFunctionPermission(orgId, permissionItem);
    }

    protected abstract String getPermissionItem(String var1);

    protected void initFieldsVisible() {
    }

    protected void loadRelationInfo() throws EASBizException, BOSException {
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("account.id", (Object)this.editData.getId().toString(), CompareType.EQUALS));
        if (this.companyInfo != null && this.companyInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)this.companyInfo.getId().toString(), CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.baseCtrlUnit.getId().toString(), CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("accountType.id", (Object)this.getAccountTypeInfo().getId().toString(), CompareType.EQUALS));
        ev.setFilter(filter);
        OrgToAccountRelationCollection coll = OrgToAccountRelationFactory.getRemoteInstance().getOrgToAccountRelationCollection(ev);
        if (coll != null && coll.size() > 0) {
            this.relationInfo = coll.get(0);
            this.comboState.setSelectedItem((Object)this.relationInfo.getState());
        }
        this.initDataStatus();
        this.initBtnStatus(this.relationInfo);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("accountType.*"));
        sic.add(new SelectorItemInfo("accountType.taxTypeItem.*"));
        sic.add(new SelectorItemInfo("entry.*"));
        return sic;
    }

    private void beforeLoad() {
        if (this.getOprtState() == null) {
            this.setOprtState("ADDNEW");
        }
        this.companyInfo = (CompanyOrgUnitInfo)this.getUIContext().get("companyInfo");
        OrgUnitInfo unitInfo = (OrgUnitInfo)this.getUIContext().get("unitInfo");
        if (unitInfo != null) {
            this.baseCtrlUnit = new CtrlUnitInfo();
            this.baseCtrlUnit.setId(BOSUuid.read((String)unitInfo.getId().toString()));
        }
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission("cancelcancel");
        if (this.relationInfo == null) {
            return;
        }
        if (!this.uiHelper.modifySaveOrExit((ItemAction)this.actionSubmit, this.btnSubmit, (ItemAction)this.actionSave, this.btnSave, this.isModifySave())) {
            return;
        }
        AccountConfigFactory.getRemoteInstance().active(this.editData.getId().toString(), this.relationInfo.getId().toString());
        this.setDataObject(this.getValue((IObjectPK)new ObjectUuidPK(this.editData.getId().toString())));
        OrgToAccountRelationInfo relation = OrgToAccountRelationFactory.getRemoteInstance().getOrgToAccountRelationInfo((IObjectPK)new ObjectUuidPK(this.relationInfo.getId()));
        if (relation != null && AccountConfigStatusEnum.ACTIVE.equals((Object)relation.getState())) {
            this.setOprtState("VIEW");
        } else {
            this.setOprtState("EDIT");
        }
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission("cancel");
        if (this.relationInfo == null) {
            return;
        }
        AccountConfigFactory.getRemoteInstance().inActive(this.editData.getId().toString(), this.relationInfo.getId().toString());
        this.setDataObject(this.getValue((IObjectPK)new ObjectUuidPK(this.editData.getId().toString())));
        this.loadFields();
        this.initOldData((IObjectValue)this.editData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission("remove");
        this.checkStateEnableRemove();
        if (this.editData == null || this.relationInfo == null) {
            return;
        }
        String accountID = this.editData.getId().toString();
        String tempState = this.getOprtState();
        if (this.confirmRemove()) {
            try {
                this.setOprtState("REMOVE");
                this.pubFireVOChangeListener(accountID);
                AccountConfigFactory.getRemoteInstance().remove(this.editData.getId().toString(), this.relationInfo.getId().toString());
                this.destroyWindow();
                this.setSave(true);
                this.setSaved(true);
            }
            catch (Throwable ex) {
                this.setOprtState(tempState);
                this.handUIException(ex);
                this.abort();
            }
            finally {
                try {
                    this.setOprtState("RELEASEALL");
                    this.pubFireVOChangeListener(accountID);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    protected void initDataStatus() {
        super.initDataStatus();
        if ("ADDNEW".equals(this.getOprtState()) || this.relationInfo != null && "EDIT".equals(this.getOprtState()) && !AccountConfigStatusEnum.ACTIVE.equals((Object)this.relationInfo.getState())) {
            this.btnAddLine.setEnabled(true);
            this.btnRemoveLine.setEnabled(true);
            this.btnUpLine.setEnabled(true);
            this.btnDownLine.setEnabled(true);
            this.btnTopLine.setEnabled(true);
            this.btnBottomLine.setEnabled(true);
        } else {
            this.btnAddLine.setEnabled(false);
            this.btnRemoveLine.setEnabled(false);
            this.btnUpLine.setEnabled(false);
            this.btnDownLine.setEnabled(false);
            this.btnTopLine.setEnabled(false);
            this.btnBottomLine.setEnabled(false);
        }
        try {
            boolean isUsing;
            if (this.editData != null && this.editData.getId() != null && (isUsing = AccountConfigFactory.getRemoteInstance().isUsing(this.editData.getId().toString()))) {
                this.txt_fillRow.setEnabled(false);
                this.txt_fillColumn.setEnabled(false);
            }
            this.initBtnStatus(this.relationInfo);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        String message = null;
        IAccountConfig iFactory = (IAccountConfig)this.getBizInterface();
        boolean isCompany = false;
        if (this.companyInfo != null && this.companyInfo.getId() != null) {
            isCompany = true;
            this.editData.setString("companyId", this.companyInfo.getId().toString());
        }
        this.editData.setBoolean("isCompany", isCompany);
        if (this.txtNumber.getText() == null || this.txtNumber.getText().trim().length() == 0) {
            message = this.getResource("NumberBlank");
            this.txtNumber.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)message);
            SysUtil.abort();
        } else {
            this.editData.setNumber(this.txtNumber.getText().trim());
            this.txtNumber.requestFocus();
            iFactory.checkNumberDup((DataBaseInfo)this.editData);
        }
        if (this.txtName.getText() == null || this.txtName.getText().trim().length() == 0) {
            message = this.getResource("NameNotNull");
            this.txtName.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)message);
            SysUtil.abort();
        } else {
            this.editData.setName(this.txtName.getText().toString().trim());
            this.txtName.requestFocus();
            iFactory.checkNameDup((DataBaseInfo)this.editData);
        }
        if (this.prmtAccountType.getValue() == null) {
            message = this.getResource("AccountTypeNotNull");
            MsgBox.showInfo((String)message);
            this.prmtAccountType.requestFocus();
            SysUtil.abort();
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.innerLoadFields();
        this.initFieldsVisible();
        try {
            this.loadRelationInfo();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void initBtnStatus(OrgToAccountRelationInfo relation) throws BOSException {
        boolean isLight = false;
        if (relation != null && (AccountConfigStatusEnum.INACTIVE.equals((Object)relation.getState()) || AccountConfigStatusEnum.SAVE.equals((Object)relation.getState()))) {
            isLight = true;
        }
        this.uiHelper.initBtnStatus(this.btnMap, isLight);
        if (relation != null && AccountConfigStatusEnum.SAVE.equals((Object)relation.getState()) && !this.getOprtState().equals(OprtState.ADDNEW)) {
            this.actionCancelCancel.setEnabled(true);
            this.actionCancel.setEnabled(true);
        }
    }

    protected void doAfterSubmit(IObjectPK pk) throws Exception {
        this.addOrgToAccountRelation(pk);
        if (this.getOprtState().equals(OprtState.ADDNEW) && !StringUtils.isEmpty((String)this.selectedAccountConfigId)) {
            OrgUnitInfo unitInfo = null;
            if (this.editData != null) {
                if (this.companyInfo == null) {
                    this.companyInfo = (CompanyOrgUnitInfo)this.getUIContext().get("companyInfo");
                }
                if ((unitInfo = (OrgUnitInfo)this.getUIContext().get("unitInfo")) != null) {
                    this.baseCtrlUnit = new CtrlUnitInfo();
                    this.baseCtrlUnit.setId(BOSUuid.read((String)unitInfo.getId().toString()));
                }
            }
            String companyId = this.companyInfo == null ? null : this.companyInfo.getId().toString();
            String unitId = unitInfo == null ? null : unitInfo.getId().toString();
            AccountConfigFactory.getRemoteInstance().copyDataSourceAndTakeDataCondition(this.selectedAccountConfigId, pk.toString(), companyId, unitId);
            this.selectedAccountConfigId = null;
        }
        super.doAfterSubmit(pk);
    }

    private void addOrgToAccountRelation(IObjectPK pk) {
        try {
            if (!this.getOprtState().equals(OprtState.ADDNEW)) {
                return;
            }
            OrgToAccountRelationInfo relationInfo = new OrgToAccountRelationInfo();
            AccountConfigInfo account = new AccountConfigInfo();
            account.setId(BOSUuid.read((String)pk.toString()));
            relationInfo.setAccount(account);
            relationInfo.setAccountType(this.getAccountTypeInfo());
            relationInfo.setState(AccountConfigStatusEnum.SAVE);
            if (this.companyInfo != null && this.companyInfo.getId() != null) {
                relationInfo.setCompanyOrgUnit(this.companyInfo);
                relationInfo.setIsCompanyAdd(true);
            } else {
                relationInfo.setOrgUnit(this.baseCtrlUnit);
                relationInfo.setIsCompanyAdd(false);
            }
            OrgToAccountRelationFactory.getRemoteInstance().addnew(relationInfo);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission("edit");
        this.checkStateEnableEdit();
        super.actionEdit_actionPerformed(e);
        this.initBtnStatus(this.relationInfo);
    }

    protected void checkStateEnableEdit() throws Exception {
        if (this.relationInfo != null && this.relationInfo.getState().equals((Object)AccountConfigStatusEnum.ACTIVE)) {
            MsgBox.showInfo((String)this.getResource("ActiveNotEdit"));
            SysUtil.abort();
        }
        if (this.relationInfo != null && this.relationInfo.getCompanyOrgUnit() != null && !this.relationInfo.isIsCompanyAdd()) {
            MsgBox.showInfo((String)this.getResource("MSG_EDIT_ERROR"));
            SysUtil.abort();
        }
    }

    protected void checkStateEnableRemove() throws Exception {
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            return;
        }
    }

    private void doEditField() {
        this.kdtEntry.checkParsed();
        this.checkSelected();
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.getDetailTable());
        AccountConfigEntryInfo oldField = (AccountConfigEntryInfo)row.getUserObject();
        if (!AccountConfigStatusEnum.SAVE.equals((Object)this.editData.getState()) && oldField.isIsScheduled()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"103_BalanceModelEditUI"));
            return;
        }
        AccountConfigEntryInfo newField = oldField;
        UIContext uiContext = new UIContext();
        uiContext.put("accountconfig", this.editData);
        uiContext.put("accountconfigentry", newField);
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getAccountConifgEntryEditUI(), (Map)uiContext, null, OprtState.EDIT);
            uiWindow.show();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        AccountConfigEntryEditUI entryEditUI = (AccountConfigEntryEditUI)uiWindow.getUIObject();
        if (entryEditUI.isConfirm()) {
            this.innerLoadFields();
        }
    }

    protected void innerLoadFields() {
        this.getDetailTable().removeRows();
        AccountConfigEntryInfo entryInfo = null;
        AccountConfigEntryCollection coll = this.editData.getEntry();
        coll.sort(COL_SEQ);
        for (int i = 0; i < coll.size(); ++i) {
            entryInfo = coll.get(i);
            this.appendNewLine(entryInfo);
        }
    }

    private void appendNewLine(AccountConfigEntryInfo entryInfo) {
        if (entryInfo == null) {
            return;
        }
        IRow row = this.getDetailTable().addRow();
        this.updateLineData(entryInfo, row);
    }

    private void updateLineData(AccountConfigEntryInfo entryInfo, IRow row) {
        if (entryInfo == null || row == null) {
            return;
        }
        row.getCell(COL_ID).setValue((Object)entryInfo.getId());
        row.getCell(COL_SEQ).setValue((Object)entryInfo.getSeq());
        row.getCell(COL_NAME).setValue((Object)entryInfo.getName());
        row.getCell(COL_ALIAS).setValue((Object)entryInfo.getAlias());
        row.getCell(COL_DATATYPE).setValue((Object)entryInfo.getDataType());
        row.getCell(COL_ISSCHEDULED).setValue((Object)entryInfo.isIsScheduled());
        row.getCell(COL_ISNULLABLE).setValue((Object)entryInfo.isIsNullable());
        row.getCell(COL_BASEDATABOSTYPE).setValue((Object)entryInfo.getBaseDataBOSType());
        row.getCell(COL_BASEDATAALIAS).setValue((Object)entryInfo.getBaseDataAlias());
        row.getCell(COL_DEFAULTVALUE).setValue((Object)entryInfo.getDefaultValue());
        row.getCell(COL_DEFAULTVALUEALIAS).setValue((Object)entryInfo.getDefaultValueAlias());
        row.getCell(COL_FORMULA).setValue((Object)entryInfo.getFormulaValue());
        row.getCell(COL_TXTVOLIDSCOPE).setValue((Object)entryInfo.getTxtVolidScope());
        row.getCell(COL_ISREFRESHDATA).setValue((Object)entryInfo.isIsRefreshData());
        row.getCell(COL_LENGTH).setValue((Object)entryInfo.getLength());
        row.getCell(COL_ISSORT).setValue((Object)entryInfo.isIsSort());
        row.getCell(COL_ISGROUP).setValue((Object)entryInfo.isIsGroup());
        row.getCell(COL_ISSUM).setValue((Object)entryInfo.isIsSum());
        row.setUserObject((Object)entryInfo);
        if (entryInfo.isIsScheduled()) {
            row.getStyleAttributes().setBackground(new Color(192, 192, 192));
        }
    }

    @Override
    public void addLineAction_actionPerformed(ActionEvent e) throws Exception {
        AccountConfigEntryInfo entryInfo = (AccountConfigEntryInfo)this.createNewDetailData();
        UIContext uiContext = new UIContext();
        uiContext.put("accountconfig", this.editData);
        uiContext.put("accountconfigentry", entryInfo);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getAccountConifgEntryEditUI(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        AccountConfigEntryEditUI entryEditUI = (AccountConfigEntryEditUI)uiWindow.getUIObject();
        if (entryEditUI.isConfirm()) {
            this.innerLoadFields();
        }
    }

    @Override
    public void removeLineAction_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.getDetailTable());
        if (this.confirmRemove()) {
            for (int i = rows.length - 1; i >= 0; --i) {
                int rowIndex = rows[i];
                IRow row = this.kdtEntry.getRow(rowIndex);
                AccountConfigEntryInfo entryInfo = (AccountConfigEntryInfo)row.getUserObject();
                if (entryInfo.isIsScheduled()) {
                    MsgBox.showInfo((String)this.getResource("IsScheduledNotDelete"));
                    return;
                }
                if (row.getRowIndex() == this.getDetailTable().getRowCount() - 1) {
                    this.getDetailTable().removeRow(row.getRowIndex());
                    this.editData.getEntry().remove(entryInfo);
                    continue;
                }
                this.editData.getEntry().remove(entryInfo);
                this.adjustEntrySeq(entryInfo.getSeq());
                this.innerLoadFields();
            }
        }
    }

    @Override
    public void upLineAction_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowIndex = this.getDetailTable().getSelectManager().get(0).getTop();
        if (rowIndex == 0) {
            return;
        }
        int toRowIndex = rowIndex - 1;
        this.getDetailTable().moveRow(rowIndex, toRowIndex);
        this.getDetailTable().getSelectManager().set(toRowIndex, toRowIndex);
        this.setSeq();
        this.storeFields();
    }

    @Override
    public void downLineAction_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowIndex = this.getDetailTable().getSelectManager().get(0).getTop();
        if (rowIndex == this.getDetailTable().getRowCount() - 1) {
            return;
        }
        int toRowIndex = rowIndex + 1;
        this.getDetailTable().moveRow(rowIndex, toRowIndex);
        this.getDetailTable().getSelectManager().set(toRowIndex, toRowIndex);
        this.setSeq();
        this.storeFields();
    }

    @Override
    public void topLineAction_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowIndex = this.getDetailTable().getSelectManager().get(0).getTop();
        if (rowIndex == 0) {
            return;
        }
        int toRowIndex = 0;
        this.getDetailTable().moveRow(rowIndex, toRowIndex);
        this.getDetailTable().getSelectManager().set(toRowIndex, toRowIndex);
        this.setSeq();
        this.storeFields();
    }

    @Override
    public void bottomLineAction_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowIndex = this.getDetailTable().getSelectManager().get(0).getTop();
        if (rowIndex == this.getDetailTable().getRowCount() - 1) {
            return;
        }
        int toRowIndex = this.getDetailTable().getRowCount() - 1;
        this.getDetailTable().moveRow(rowIndex, toRowIndex);
        this.getDetailTable().getSelectManager().set(toRowIndex, toRowIndex);
        this.setSeq();
        this.storeFields();
    }

    private void setSeq() {
        for (int i = 0; i < this.kdtEntry.getRowCount(); ++i) {
            this.kdtEntry.getCell(i, COL_SEQ).setValue((Object)(i + 1));
        }
    }

    private void adjustEntrySeq(int beginIndex) {
        AccountConfigEntryInfo fieldInfo = null;
        AccountConfigEntryCollection coll = this.editData.getEntry();
        for (int i = beginIndex - 1; i < coll.size(); ++i) {
            fieldInfo = coll.get(i);
            fieldInfo.setSeq(i + 1);
        }
    }

    protected String getAccountConifgEntryEditUI() {
        return "com.kingdee.eas.tm.td.basedata.client.AccountConfigEntryEditUI";
    }

    public void checkSelected() {
        if (this.getDetailTable().getRowCount() == 0 || this.getDetailTable().getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    protected KDTable getDetailTable() {
        return this.kdtEntry;
    }

    protected IObjectValue createNewData() {
        AccountConfigInfo accountConfigInfo = new AccountConfigInfo();
        accountConfigInfo.setState(AccountConfigStatusEnum.SAVE);
        accountConfigInfo.setAccountType(this.getAccountTypeInfo());
        accountConfigInfo.setCU(this.baseCtrlUnit);
        accountConfigInfo.setIsTotal(false);
        return accountConfigInfo;
    }

    protected IObjectValue createNewDetailData() {
        AccountConfigEntryInfo info = new AccountConfigEntryInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        int seq = this.editData.getEntry().size() + 1;
        info.setSeq(seq);
        info.setName(this.getFieldName(seq));
        info.setAlias("Field" + info.getSeq());
        info.setDataType(DataTypeEnum.String);
        info.setIsScheduled(false);
        info.setIsNullable(true);
        info.setParent(this.editData);
        info.setIsRefreshData(true);
        return info;
    }

    private String getFieldName(int seq) {
        AccountConfigEntryCollection entry = this.editData.getEntry();
        String name = "Field" + seq;
        for (int i = 0; i < entry.size(); ++i) {
            if (!name.equals(entry.get(i).getName())) continue;
            return this.getFieldName(++seq);
        }
        return name;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AccountConfigFactory.getRemoteInstance();
    }

    private String getResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.AccountConfigResource", (String)key);
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        AccountConfigInfo info = (AccountConfigInfo)newData;
        info.setNumber(null);
        info.setName(null);
        info.setState(AccountConfigStatusEnum.SAVE);
        AccountConfigEntryInfo entryInfo = null;
        int size = info.getEntry().size();
        for (int i = 0; i < size; ++i) {
            entryInfo = info.getEntry().get(i);
            if (entryInfo.getId() != null) continue;
            entryInfo.setId(BOSUuid.create((BOSObjectType)entryInfo.getBOSType()));
        }
    }

    public boolean isModify() {
        if ("VIEW".equals(this.getOprtState())) {
            return false;
        }
        if (!"ADDNEW".equals(this.getOprtState()) && this.editData.compareNewToOld()) {
            return false;
        }
        return super.isModify();
    }

    protected boolean confirmRemove() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
    }
}

