/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.basedata.client;

import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.BooleanEnum;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.rpt.client.FormulaPickerUI;
import com.kingdee.eas.fi.rpt.client.IFormulaPickerListener;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.AccountConfigEntryCollection;
import com.kingdee.eas.tm.td.basedata.AccountConfigEntryInfo;
import com.kingdee.eas.tm.td.basedata.AccountConfigInfo;
import com.kingdee.eas.tm.td.basedata.DataTypeEnum;
import com.kingdee.eas.tm.td.basedata.client.AbstractAccountConfigEntryEditUI;
import com.kingdee.eas.tm.td.basedata.util.AccountConfigUtil;
import com.kingdee.eas.tm.td.basedata.util.EntitySelector;
import com.kingdee.eas.tm.td.basedata.util.EntitySelectorType;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.EnumUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class AccountConfigEntryEditUI
extends AbstractAccountConfigEntryEditUI
implements IFormulaPickerListener {
    private static final Logger logger = CoreUIObject.getLogger(AccountConfigEntryEditUI.class);
    private AccountConfigInfo parent;
    private AccountConfigEntryInfo editData;
    private boolean isConfirm = false;
    private SelectorListener baseDataSelectorListener = new SelectorListener(){

        public void willShow(SelectorEvent e) {
            AccountConfigEntryEditUI.this.initBaseDataSelector(e);
        }
    };
    private PreChangeListener baseDataPreChangeListener = new PreChangeListener(){

        public void preChange(PreChangeEvent e) {
            AccountConfigEntryEditUI.this.transBaseDataResult(e);
        }
    };
    private DataChangeListener baseDataDataChangeListener = new DataChangeListener(){

        public void dataChanged(DataChangeEvent eventObj) {
            AccountConfigEntryEditUI.this.baseDataDataChanged(eventObj);
        }
    };

    private void dataTypeChanged(ItemEvent e) {
        this.kDScrollPane1.setEnabled(true);
        if (DataTypeEnum.Enum.equals(this.comboDataType.getSelectedItem())) {
            this.prmtBaseData.setEnabled(true);
            this.prmtBaseData.setRequired(true);
            this.contBaseData.setBoundLabelText(this.getResource("EnumObject"));
        } else {
            this.prmtBaseData.setEnabled(false);
        }
        if (DataTypeEnum.String.equals(this.comboDataType.getSelectedItem())) {
            this.txtLength.setEnabled(true);
        } else {
            this.txtLength.setEnabled(false);
            this.txtLength.setValue((Object)0);
        }
        if (DataTypeEnum.Qty.equals(this.comboDataType.getSelectedItem()) || DataTypeEnum.Amount.equals(this.comboDataType.getSelectedItem()) || DataTypeEnum.Price.equals(this.comboDataType.getSelectedItem()) || DataTypeEnum.Integer.equals(this.comboDataType.getSelectedItem())) {
            this.cbxIsSum.setEnabled(true);
        } else {
            this.cbxIsSum.setEnabled(false);
            this.cbxIsSum.setSelected(false);
        }
        this.initDefaultValueControl(this.defaultValueContainer, (DataTypeEnum)((Object)this.comboDataType.getSelectedItem()));
        if (this.cbxEnable.isSelected()) {
            this.defaultValueContainer.getBoundEditor().setEnabled(true);
        }
    }

    private void initBaseDataSelector(SelectorEvent e) {
        KDPromptBox f7Box = (KDPromptBox)e.getSource();
        if (f7Box.getSelector() == null || !(f7Box.getSelector() instanceof EntitySelector)) {
            DataTypeEnum dataItem = (DataTypeEnum)((Object)this.comboDataType.getSelectedItem());
            EntitySelector selector = null;
            if (DataTypeEnum.Enum.equals((Object)dataItem)) {
                selector = new EntitySelector(this.getUIWindow(), this.getResource("EnumObjectSelector"), EntitySelectorType.BizEnum);
            }
            f7Box.setSelector(selector);
        }
    }

    private void transBaseDataResult(PreChangeEvent e) {
        KDPromptBox f7Box = (KDPromptBox)e.getSource();
        if (e.getData() != null) {
            if (e.getData() instanceof EntityObjectInfo) {
                EntityObjectInfo entity = (EntityObjectInfo)e.getData();
                e.setData((Object)entity.getDisplayName());
                f7Box.setUserObject((Object)entity);
            } else if (e.getData() instanceof BizEnumInfo) {
                BizEnumInfo bizInfo = (BizEnumInfo)e.getData();
                e.setData((Object)bizInfo.getAlias());
                f7Box.setUserObject((Object)bizInfo);
            }
        } else {
            e.setData(null);
            f7Box.setUserObject(null);
        }
    }

    private void baseDataDataChanged(DataChangeEvent eventObj) {
        if (eventObj.getNewValue() == null) {
            this.editData.setBaseDataBOSType(null);
            this.editData.setBaseDataAlias(null);
            return;
        }
        if (eventObj.getNewValue().equals(eventObj.getOldValue())) {
            return;
        }
        DataTypeEnum dataItem = (DataTypeEnum)((Object)this.comboDataType.getSelectedItem());
        if (DataTypeEnum.Enum.equals((Object)dataItem)) {
            BizEnumInfo bizInfo = (BizEnumInfo)this.prmtBaseData.getUserObject();
            this.editData.setBaseDataBOSType(bizInfo.getFullName());
            this.editData.setBaseDataAlias(bizInfo.getAlias());
            this.initDefaultValueControl(this.defaultValueContainer, (DataTypeEnum)((Object)this.comboDataType.getSelectedItem()));
        }
        if (this.cbxEnable.isSelected()) {
            this.defaultValueContainer.getBoundEditor().setEnabled(true);
        }
    }

    public void onLoad() throws Exception {
        this.parent = (AccountConfigInfo)this.getUIContext().get("accountconfig");
        this.editData = (AccountConfigEntryInfo)this.getUIContext().get("accountconfigentry");
        super.onLoad();
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
        if (DataTypeEnum.Amount.equals((Object)this.editData.getDataType()) || DataTypeEnum.Qty.equals((Object)this.editData.getDataType()) || DataTypeEnum.Integer.equals((Object)this.editData.getDataType())) {
            this.cbxIsTotal.setVisible(true);
        } else {
            this.cbxIsTotal.setVisible(false);
        }
        this.comboDataType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AccountConfigEntryEditUI.this.dataTypeChanged(e);
            }
        });
        this.cbxEnable.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (AccountConfigEntryEditUI.this.cbxEnable.isSelected()) {
                    AccountConfigEntryEditUI.this.defaultValueContainer.getBoundEditor().setEnabled(true);
                } else {
                    AccountConfigEntryEditUI.this.defaultValueContainer.getBoundEditor().setEnabled(false);
                }
            }
        });
        this.dataTypeChanged(null);
        this.prmtBaseData.setEditable(false);
        this.cbxIsTotal.setVisible(false);
    }

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        this.addListener();
        this.txtName.setEnabled(false);
        if (DataTypeEnum.Qty.equals(this.comboDataType.getSelectedItem()) || DataTypeEnum.Amount.equals(this.comboDataType.getSelectedItem())) {
            this.cbxIsSum.setEnabled(true);
        } else {
            this.cbxIsSum.setEnabled(false);
        }
        this.initDefaultValueControl(this.defaultValueContainer, this.editData.getDataType());
        this.setDefaultValue(this.defaultValueContainer, this.editData.getDataType(), this.editData.getDefaultValue());
    }

    private void initDefaultValueControl(KDLabelContainer container, DataTypeEnum dataType) {
        KDTextField editor = new KDTextField();
        if (DataTypeEnum.Integer.equals((Object)dataType)) {
            editor = new KDFormattedTextField();
            ((KDFormattedTextField)editor).setPrecision(0);
        } else if (DataTypeEnum.Date.equals((Object)dataType)) {
            editor = new KDDatePicker();
            ((KDDatePicker)editor).setTimeEnabled(false);
            ((KDDatePicker)editor).setValue(null);
        } else if (DataTypeEnum.Enum.equals((Object)dataType)) {
            editor = new KDComboBox();
            if (this.editData.getBaseDataBOSType() != null) {
                List enumList = EnumUtils.getEnumList((String)this.editData.getBaseDataBOSType());
                for (int i = 0; i < enumList.size(); ++i) {
                    Enum enumData = (Enum)enumList.get(i);
                    ((KDComboBox)editor).addItem((Object)enumData);
                }
            }
        } else if (DataTypeEnum.Qty.equals((Object)dataType) || DataTypeEnum.Amount.equals((Object)dataType) || DataTypeEnum.Price.equals((Object)dataType)) {
            editor = new KDFormattedTextField();
            ((KDFormattedTextField)editor).setPrecision(8);
        } else if (DataTypeEnum.Boolean.equals((Object)dataType)) {
            editor = new KDComboBox();
            ((KDComboBox)editor).removeAllItems();
            ((KDComboBox)editor).addItem((Object)BooleanEnum.TRUE);
            ((KDComboBox)editor).addItem((Object)BooleanEnum.FALSE);
        } else if (DataTypeEnum.BOSUuid.equals((Object)dataType)) {
            editor = new KDTextField();
        } else if (DataTypeEnum.Timestamp.equals((Object)dataType)) {
            editor = new KDDatePicker();
            ((KDDatePicker)editor).setTimeEnabled(true);
            ((KDDatePicker)editor).setValue(null);
        }
        container.setBoundEditor((JComponent)editor);
        editor.setEnabled(false);
    }

    private void setDefaultValue(KDLabelContainer container, DataTypeEnum dataType, String value) {
        if (value == null || StringUtils.isEmpty((String)value)) {
            this.cbxEnable.setSelected(false);
            this.defaultValueContainer.getBoundEditor().setEnabled(false);
            return;
        }
        this.cbxEnable.setSelected(true);
        this.defaultValueContainer.getBoundEditor().setEnabled(true);
        JComponent editor = container.getBoundEditor();
        SimpleDateFormat formatter = null;
        if (DataTypeEnum.String.equals((Object)dataType)) {
            ((KDTextField)editor).setText(value);
        } else if (DataTypeEnum.Integer.equals((Object)dataType)) {
            ((KDFormattedTextField)editor).setValue((Object)new BigDecimal(value));
        } else if (DataTypeEnum.Date.equals((Object)dataType)) {
            formatter = new SimpleDateFormat("yyyy-MM-dd");
            Date valueObject = null;
            try {
                valueObject = formatter.parse(value);
            }
            catch (ParseException e) {
                logger.info((Object)"value is error!");
            }
            ((KDDatePicker)editor).setValue((Object)valueObject);
        } else if (DataTypeEnum.Enum.equals((Object)dataType)) {
            this.setSelectedItem((KDComboBox)editor, value);
        } else if (DataTypeEnum.Qty.equals((Object)dataType) || DataTypeEnum.Amount.equals((Object)dataType) || DataTypeEnum.Price.equals((Object)dataType)) {
            ((KDFormattedTextField)editor).setValue((Object)new BigDecimal(value));
            ((KDFormattedTextField)editor).setPrecision(8);
        } else if (DataTypeEnum.Boolean.equals((Object)dataType)) {
            this.setSelectedItem((KDComboBox)editor, value);
        }
    }

    private void setSelectedItem(KDComboBox editor, String value) {
        int count = editor.getItemCount();
        for (int i = 0; i < count; ++i) {
            String item = TDUtils.getEnumValue((Enum)editor.getItemAt(i)) + "";
            if (!value.equals(item)) continue;
            editor.setSelectedIndex(i);
            break;
        }
    }

    private Map getDefaultValue(KDLabelContainer container, DataTypeEnum dataType) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        Object value = null;
        SimpleDateFormat formatter = null;
        JComponent editor = container.getBoundEditor();
        if (DataTypeEnum.String.equals((Object)dataType)) {
            value = ((KDTextField)editor).getText();
            ret.put("value", value);
        } else if (DataTypeEnum.Integer.equals((Object)dataType)) {
            if (((KDFormattedTextField)editor).getValue() != null) {
                value = ((KDFormattedTextField)editor).getValue().toString();
            }
            ret.put("value", value);
        } else if (DataTypeEnum.Date.equals((Object)dataType)) {
            Date date = (Date)((KDDatePicker)editor).getValue();
            String valueObject = null;
            if (date != null) {
                formatter = new SimpleDateFormat("yyyy-MM-dd");
                valueObject = formatter.format(date);
            }
            ret.put("value", valueObject);
        } else if (DataTypeEnum.Enum.equals((Object)dataType)) {
            value = ((KDComboBox)editor).getSelectedItem();
            ret.put("value", TDUtils.getEnumValue((Enum)value) + "");
            ret.put("valueAlias", ((Enum)value).getAlias());
        } else if (DataTypeEnum.Qty.equals((Object)dataType) || DataTypeEnum.Amount.equals((Object)dataType) || DataTypeEnum.Price.equals((Object)dataType)) {
            if (((KDFormattedTextField)editor).getValue() != null) {
                value = ((KDFormattedTextField)editor).getValue().toString();
            }
            value = new BigDecimal((String)value).toPlainString();
            ret.put("value", value);
        } else if (DataTypeEnum.Boolean.equals((Object)dataType)) {
            value = ((KDComboBox)editor).getSelectedItem();
            ret.put("value", TDUtils.getEnumValue((Enum)value) + "");
            ret.put("valueAlias", ((Enum)value).getAlias());
        }
        return ret;
    }

    private void addListener() {
        this.prmtBaseData.addSelectorListener(this.baseDataSelectorListener);
        this.prmtBaseData.addPreChangeListener(this.baseDataPreChangeListener);
        this.prmtBaseData.addDataChangeListener(this.baseDataDataChangeListener);
    }

    private void removeListener() {
        this.prmtBaseData.removeSelectorListener(this.baseDataSelectorListener);
        this.prmtBaseData.removePreChangeListener(this.baseDataPreChangeListener);
        this.prmtBaseData.removeDataChangeListener(this.baseDataDataChangeListener);
    }

    @Override
    public void storeFields() {
        this.beforeStoreFields();
        super.storeFields();
        this.editData = (AccountConfigEntryInfo)this.getDataObject();
    }

    protected void beforeStoreFields() {
        if (AccountConfigUtil.isEmpty(this.txtName.getText())) {
            MsgBox.showInfo((String)this.getResource("FieldNameNotNull"));
            this.txtName.requestFocus();
            SysUtil.abort();
        }
        this.checkFieldNameDup();
        if (this.txtAlias.getEditor().getItem() == null || this.txtAlias.getEditor().getItem().toString().trim().length() == 0) {
            this.txtName.requestFocus();
            MsgBox.showInfo((String)this.getResource("FieldAliasNotNull"));
            SysUtil.abort();
        }
        if (DataTypeEnum.Enum.equals(this.comboDataType.getSelectedItem()) && this.prmtBaseData.getData() == null) {
            this.prmtBaseData.requestFocus();
            MsgBox.showInfo((String)this.getResource("EnumObjectNotNull"));
            SysUtil.abort();
        }
        if (this.comboDataType.getSelectedItem().equals((Object)DataTypeEnum.String) && this.txtLength.getIntegerValue() < 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"87_BalanceFieldModelEditUI"));
            this.txtLength.requestFocus();
            SysUtil.abort();
        }
        if (this.cbxEnable.isSelected()) {
            Map defaultValueMap = this.getDefaultValue(this.defaultValueContainer, (DataTypeEnum)((Object)this.comboDataType.getSelectedItem()));
            this.editData.setDefaultValue((String)defaultValueMap.get("value"));
            this.editData.setDefaultValueAlias((String)defaultValueMap.get("valueAlias"));
        } else {
            this.editData.setDefaultValue(null);
            this.editData.setDefaultValueAlias(null);
        }
    }

    private void checkFieldNameDup() {
        AccountConfigEntryInfo fieldInfo = null;
        AccountConfigEntryCollection coll = this.parent.getEntry();
        for (int i = 0; i < coll.size(); ++i) {
            fieldInfo = coll.get(i);
            if (fieldInfo.getId() == null || fieldInfo.getId().equals((Object)this.editData.getId()) || !fieldInfo.getName().equals(this.txtName.getText())) continue;
            MsgBox.showInfo((String)this.getResource("NameDup"));
            this.txtName.requestFocus();
            SysUtil.abort();
        }
    }

    @Override
    public void actionNew_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        this.parent.getEntry().add(this.editData);
        this.isConfirm = true;
        this.editData = (AccountConfigEntryInfo)this.createNewData();
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
    }

    @Override
    public void actionFormula_actionPerformed(ActionEvent e) throws Exception {
        this.openFormula();
    }

    protected void openFormula() throws Exception {
        DataTypeEnum dataType = (DataTypeEnum)((Object)this.comboDataType.getSelectedItem());
        if (this.getOprtState().equals(OprtState.VIEW)) {
            return;
        }
        FormulaPickerUI picker = FormulaPickerUI.creatFormulaPicker((CoreUIObject)this);
        picker.addFormulaPickerListener((IFormulaPickerListener)this);
        picker.open();
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        this.parent.getEntry().add(this.editData);
        this.isConfirm = true;
        this.getUIWindow().close();
    }

    @Override
    public void actionExit_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    public boolean isConfirm() {
        return this.isConfirm;
    }

    protected IObjectValue createNewData() {
        AccountConfigEntryInfo info = new AccountConfigEntryInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setSeq(this.parent.getEntry().size() + 1);
        info.setName(this.getFieldName(info.getSeq()));
        info.setAlias(this.getFieldAlias(info.getSeq()));
        info.setDataType(DataTypeEnum.String);
        info.setIsScheduled(false);
        info.setIsNullable(true);
        info.setParent(this.parent);
        info.setIsRefreshData(true);
        info.setIsSort(false);
        return info;
    }

    private String getFieldName(int seq) {
        AccountConfigEntryCollection entry = this.parent.getEntry();
        String name = "Field" + seq;
        for (int i = 0; i < entry.size(); ++i) {
            if (!name.equals(entry.get(i).getName())) continue;
            return this.getFieldName(++seq);
        }
        return name;
    }

    private String getFieldAlias(int seq) {
        AccountConfigEntryCollection entry = this.parent.getEntry();
        String name = "Field" + seq;
        for (int i = 0; i < entry.size(); ++i) {
            if (!name.equals(entry.get(i).getAlias())) continue;
            return this.getFieldAlias(++seq);
        }
        return name;
    }

    private String getResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.AccountConfigResource", (String)key);
    }

    public void pickerSetout(FormulaPickerUI picker) {
    }

    public void pickerReturnee(FormulaPickerUI picker, String formulaLine, boolean isOk) {
        if (isOk) {
            this.txtFormula.setText(this.txtFormula.getText() + formulaLine);
        }
    }
}

