/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.FrameWorkClientUtils;
import com.kingdee.eas.framework.client.TreePathUtil;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.tm.td.TDFacadeFactory;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.AccountConfigFactory;
import com.kingdee.eas.tm.td.basedata.AccountConfigInfo;
import com.kingdee.eas.tm.td.basedata.AccountConfigStatusEnum;
import com.kingdee.eas.tm.td.basedata.AccountTypeInfo;
import com.kingdee.eas.tm.td.basedata.DSTypeEnum;
import com.kingdee.eas.tm.td.basedata.DataSourceToAccountFactory;
import com.kingdee.eas.tm.td.basedata.OrgToAccountRelationCollection;
import com.kingdee.eas.tm.td.basedata.OrgToAccountRelationFactory;
import com.kingdee.eas.tm.td.basedata.OrgToAccountRelationInfo;
import com.kingdee.eas.tm.td.basedata.client.AbstractAccountConfigTreeListUI;
import com.kingdee.eas.tm.td.basedata.client.AccountConfigEditUI;
import com.kingdee.eas.tm.td.basedata.client.wizard.AccountConfigWizard;
import com.kingdee.eas.tm.td.basedata.client.wizard.AccountConfigWizardModel;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public abstract class AccountConfigTreeListUI
extends AbstractAccountConfigTreeListUI
implements DataChangeListener {
    private static final Logger logger = CoreUIObject.getLogger(AccountConfigTreeListUI.class);
    private FullOrgUnitInfo selectedOrgUnit = null;
    public static final String TBL_STATE = "state";
    public static final String TBL_RELATIONID = "relation.id";
    public static final String TBL_ID = "id";
    private Map selectRelationIdsMap = new HashMap();

    public void onLoad() throws Exception {
        this.beforeLoad();
        super.onLoad();
        this.addListener();
    }

    private void beforeLoad() {
        try {
            UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
            FullOrgUnitCollection orgCollection = AccountConfigTreeListUI.getAuthOrgByPermItem((IObjectPK)new ObjectUuidPK(userInfo.getId()), OrgType.ControlUnit, this.getPermissionItem("view"));
            if (orgCollection != null && orgCollection.size() > 0) {
                this.prmtChangeUnit.setValue((Object)orgCollection.get(0));
                this.selectedOrgUnit = orgCollection.get(0);
            } else {
                FullOrgUnitInfo baseUnit = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-000000000000CCE7AED4"));
                this.prmtChangeUnit.setValue((Object)baseUnit);
                this.selectedOrgUnit = baseUnit;
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.setOrgUnitF7filter();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnCancel.setEnabled(true);
        this.btnCancelCancel.setEnabled(true);
        this.btnCancel.setVisible(true);
        this.btnCancelCancel.setVisible(true);
    }

    private void setOrgUnitF7filter() {
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        FullOrgUnitCollection orgCollection = null;
        try {
            orgCollection = AccountConfigTreeListUI.getAuthOrgByPermItem((IObjectPK)new ObjectUuidPK(userInfo.getId()), OrgType.ControlUnit, this.getPermissionItem("view"));
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        HashSet<String> idSet = new HashSet<String>();
        FullOrgUnitInfo unitInfo = new FullOrgUnitInfo();
        if (orgCollection != null) {
            for (int i = 0; i < orgCollection.size(); ++i) {
                unitInfo = orgCollection.get(i);
                idSet.add(unitInfo.getId().toString());
            }
        } else {
            idSet.add("1111111111111111111");
        }
        EntityViewInfo entity = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(TBL_ID, idSet, CompareType.INCLUDE));
        entity.setFilter(filter);
        this.prmtChangeUnit.setEntityViewInfo(entity);
    }

    public static FullOrgUnitCollection getAuthOrgByPermItem(IObjectPK user, OrgType orgType, String permItem) throws BOSException, EASBizException {
        FullOrgUnitCollection result = null;
        IPermission permission = PermissionFactory.getRemoteInstance();
        result = permission.getAuthorizedOrg(user, orgType, null, permItem);
        return result;
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        FullOrgUnitInfo unitInfo = (FullOrgUnitInfo)this.prmtChangeUnit.getValue();
        uiContext.put((Object)"unitInfo", (Object)unitInfo);
    }

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        this.addListener();
    }

    private void addListener() {
        this.prmtChangeUnit.addDataChangeListener((DataChangeListener)this);
    }

    private void removeListener() {
        this.prmtChangeUnit.removeDataChangeListener((DataChangeListener)this);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return AccountConfigFactory.getRemoteInstance();
    }

    protected abstract String getPermissionItem(String var1);

    protected abstract AccountTypeInfo getAccountTypeInfo();

    public void dataChanged(DataChangeEvent eventObj) {
        if (this.prmtChangeUnit.equals(eventObj.getSource())) {
            this.selectedOrgUnit = (FullOrgUnitInfo)this.prmtChangeUnit.getValue();
            try {
                this.initTree();
                this.tblMainRefresh();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    protected void initTree() throws Exception {
        if (this.getRootName() != null) {
            KDTreeNode rootNode = new KDTreeNode(this.getRootObject());
            ((DefaultTreeModel)this.treeMain.getModel()).setRoot((TreeNode)rootNode);
        }
        super.initTree();
    }

    protected String getRootName() {
        return EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.AccountConfigResource", (String)"rootName");
    }

    protected String getEditUIName() {
        return AccountConfigEditUI.class.getName();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission("add");
        super.actionAddNew_actionPerformed(e);
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        this.tblMainRefresh();
    }

    private void tblMainRefresh() {
        FilterInfo filterInfo = new FilterInfo();
        HashSet<String> orgSet = new HashSet<String>();
        if (this.prmtChangeUnit.getValue() != null) {
            FullOrgUnitInfo orgUnit = (FullOrgUnitInfo)this.prmtChangeUnit.getValue();
            orgSet.add(orgUnit.getId().toString());
        }
        if (orgSet.size() == 0) {
            orgSet.add("111111111111111111111111111=");
        }
        if (this.getSelectedTreeNode() != null && this.getSelectedTreeNode().getUserObject() != null) {
            if (this.getSelectedTreeNode().getText().equals(EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.AccountConfigResource", (String)"rootName"))) {
                filterInfo.getFilterItems().add(new FilterItemInfo("unit.id", orgSet, CompareType.INCLUDE));
            } else if (this.getSelectedTreeNode() != null) {
                AccountConfigInfo info = (AccountConfigInfo)this.getSelectedTreeNode().getUserObject();
                filterInfo.appendFilterItem(TBL_ID, (Object)info.getId().toString());
            }
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("unit.id", orgSet, CompareType.INCLUDE));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("accountType.id", (Object)this.getAccountTypeInfo().getId().toString(), CompareType.EQUALS));
        try {
            EntityViewInfo dialogView;
            if (this.getDialog().getEntityViewInfoResult() != null && (dialogView = this.getEntityViewInfo((EntityViewInfo)this.getDialog().getEntityViewInfoResult().clone())) != null && dialogView.getFilter() != null) {
                filterInfo.mergeFilter(dialogView.getFilter(), "AND");
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.mainQuery.setFilter(filterInfo);
        this.mainQuery.setSelector(this.getSelectors());
        this.setTheFirstFillData(true);
        this.tblMain.repaint();
        this.tblMain.removeRows();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfo = new FilterInfo();
        String orgId = "111111111111111111111111111=";
        if (this.prmtChangeUnit.getValue() != null) {
            FullOrgUnitInfo orgUnit = (FullOrgUnitInfo)this.prmtChangeUnit.getValue();
            orgId = orgUnit.getId().toString();
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("unit.id", (Object)orgId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("accountType.id", (Object)this.getAccountTypeInfo().getId().toString(), CompareType.EQUALS));
        return filterInfo;
    }

    private EntityViewInfo getMainQueryEntityViewInfo() {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        String orgId = "111111111111111111111111111=";
        if (this.prmtChangeUnit.getValue() != null) {
            FullOrgUnitInfo orgUnit = (FullOrgUnitInfo)this.prmtChangeUnit.getValue();
            orgId = orgUnit.getId().toString();
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("unit.id", (Object)orgId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("accountType.id", (Object)this.getAccountTypeInfo().getId().toString(), CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        return entityViewInfo;
    }

    protected FilterInfo getDefaultFilterForTree() {
        FilterInfo filter = new FilterInfo();
        if (this.prmtChangeUnit.getValue() == null) {
            HashSet<String> idSet = new HashSet<String>();
            idSet.add("111111111111111111111111111=");
            filter.getFilterItems().add(new FilterItemInfo(TBL_ID, idSet, CompareType.INCLUDE));
            return filter;
        }
        Set<String> idSet = new HashSet();
        HashSet<String> orgSet = new HashSet<String>();
        FullOrgUnitInfo orgUnit = (FullOrgUnitInfo)this.prmtChangeUnit.getValue();
        String cuId = orgUnit.getId().toString();
        orgSet.add(cuId);
        idSet = this.getAccountIdsByParams(orgSet);
        if (idSet.size() == 0) {
            idSet.add("111111111111111111111111111=");
        }
        filter.getFilterItems().add(new FilterItemInfo(TBL_ID, idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("accountType.id", (Object)this.getAccountTypeInfo().getId().toString(), CompareType.EQUALS));
        return filter;
    }

    private Set getAccountIdsByParams(Set orgSet) {
        HashSet<String> idSet = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("accountType.id", (Object)this.getAccountTypeInfo().getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("account.*"));
        view.setSelector(selector);
        OrgToAccountRelationCollection coll = null;
        OrgToAccountRelationInfo relationInfo = null;
        try {
            coll = OrgToAccountRelationFactory.getRemoteInstance().getOrgToAccountRelationCollection(view);
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                relationInfo = coll.get(i);
                idSet.add(relationInfo.getAccount().getId().toString());
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return idSet;
    }

    private String getCurrentUnitId() {
        String unitId = "";
        if (this.prmtChangeUnit.getValue() != null) {
            FullOrgUnitInfo orgUnit = (FullOrgUnitInfo)this.prmtChangeUnit.getValue();
            unitId = orgUnit.getId().toString();
        }
        return unitId;
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkPermission("cancelcancel");
        this.prepare4CancelOrCancelCancel();
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_CancelCancel");
        if (this.confirmDialog(cancelMsg)) {
            if (UtilRequest.isPrepare((String)"ActionCancelCancel", (CoreUIObject)this)) {
                this.prepareCancelCancel(null).callHandler();
            }
            this.cancelCancel();
            this.refresh(e);
        }
    }

    private void prepare4CancelOrCancelCancel() {
        this.checkSelected();
        String[] ids = com.kingdee.eas.basedata.framework.util.KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)TBL_ID);
        String[] relationIds = com.kingdee.eas.basedata.framework.util.KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)TBL_RELATIONID);
        this.selectRelationIdsMap = new HashMap();
        for (int i = 0; i < ids.length; ++i) {
            this.selectRelationIdsMap.put(ids[i], relationIds[i]);
        }
    }

    protected void runCancelCancel(IObjectPK pk) throws Exception {
        String billId = pk.toString();
        AccountConfigFactory.getRemoteInstance().active(pk.toString(), this.selectRelationIdsMap.get(billId).toString());
    }

    protected void runCancel(IObjectPK pk) throws Exception {
        String billId = pk.toString();
        AccountConfigFactory.getRemoteInstance().inActive(pk.toString(), this.selectRelationIdsMap.get(billId).toString());
    }

    protected void refresh(ActionEvent e) throws Exception {
        TreePath oldPath = this.treeMain.getSelectionPath();
        this.tblMain.refresh();
        this.initTree();
        TreePath path = TreePathUtil.getNewTreePath((JTree)this.treeMain, (TreeModel)this.treeMain.getModel(), (TreePath)oldPath);
        if (path != null) {
            this.treeMain.setSelectionPath(path);
        } else {
            this.treeMain.setSelectionRow(0);
        }
        this.tblMain.refresh();
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkPermission("cancel");
        this.prepare4CancelOrCancelCancel();
        super.actionCancel_actionPerformed(e);
        this.refresh(e);
    }

    @Override
    public void actionDataSourceSet_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkPermission("datasource");
        String accountId = this.getSelectedKeyValue();
        Set dataSourceIds = DataSourceToAccountFactory.getRemoteInstance().getDataSourceByAccount(accountId, null, this.selectedOrgUnit.getId().toString());
        UIContext uiContext = new UIContext();
        uiContext.put("dataSourceIds", dataSourceIds);
        uiContext.put("accountId", accountId);
        uiContext.put("orgUnitId", this.selectedOrgUnit.getId().toString());
        uiContext.put("companyOrgUnitID", null);
        uiContext.put("dsType", DSTypeEnum.Account);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getDataSourceListUI(), (Map)uiContext);
        uiWindow.show();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkPermission("edit");
        this.checkStateEnableEdit();
        super.actionEdit_actionPerformed(e);
    }

    protected void checkStateEnableEdit() throws Exception {
        this.checkSelected();
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.getDetailTable());
        String relationId = (String)row.getCell(TBL_RELATIONID).getValue();
        OrgToAccountRelationInfo relationInfo = OrgToAccountRelationFactory.getRemoteInstance().getOrgToAccountRelationInfo((IObjectPK)new ObjectUuidPK(relationId));
        if (relationInfo.getState().equals((Object)AccountConfigStatusEnum.ACTIVE)) {
            MsgBox.showInfo((String)this.getResource("ActiveNotEdit"));
            SysUtil.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkPermission("remove");
        if (this.confirmRemove()) {
            String[] ids = com.kingdee.eas.basedata.framework.util.KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)TBL_ID);
            String[] relationIds = com.kingdee.eas.basedata.framework.util.KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)TBL_RELATIONID);
            HashMap<String, String[]> params = new HashMap<String, String[]>();
            params.put("billIds", ids);
            params.put("relationIds", relationIds);
            ArrayList idList = this.getSelectedIdValues();
            ArrayList errorList = new ArrayList();
            IMutexServiceControl mutexServiceControl = FrameWorkClientUtils.createMutexServiceControl();
            try {
                Map map = mutexServiceControl.batchRequestObjIDForUpdate((List)idList);
                boolean isReqError = TDUtils.isLocked(map);
                if (isReqError) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"LOCK_ERROR"));
                    return;
                }
                errorList = AccountConfigFactory.getRemoteInstance().remove(params);
            }
            finally {
                mutexServiceControl.batchReleaseObjIDForUpdate((List)idList);
            }
            String deleteError = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_DeleteError");
            if (errorList.size() > 0) {
                StringBuffer errorDetailMSG = new StringBuffer();
                for (int i = 0; i < errorList.size(); ++i) {
                    errorDetailMSG.append(errorList.get(i)).append("\n");
                }
                MsgBox.showDetailAndOK((Component)((Object)this), (String)deleteError, (String)errorDetailMSG.toString(), (int)8188);
            }
            this.refresh(null);
        }
    }

    private String getResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.AccountConfigResource", (String)key);
    }

    private void checkPermission(String actionType) throws BOSException, EASBizException {
        FullOrgUnitInfo unitInfo = (FullOrgUnitInfo)this.prmtChangeUnit.getValue();
        if (unitInfo == null) {
            return;
        }
        String orgId = unitInfo.getId().toString();
        String permissionItem = this.getPermissionItem(actionType);
        TDFacadeFactory.getRemoteInstance().checkFunctionPermission(orgId, permissionItem);
    }

    @Override
    public void actionDataModelSet_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkPermission("getdata");
        String accountId = this.getSelectedKeyValue();
        Set dataSourceIds = DataSourceToAccountFactory.getRemoteInstance().getDataSourceByAccount(accountId, this.selectedOrgUnit.getId().toString(), null);
        if (dataSourceIds.size() == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.TDResource", (String)"NEED_ADD_DATASOURCE"));
            return;
        }
        UIContext uiContext = new UIContext();
        uiContext.put("dataSourceSet", dataSourceIds);
        uiContext.put("accountId", accountId);
        uiContext.put("orgUnitId", this.selectedOrgUnit.getId().toString());
        uiContext.put("dsType", DSTypeEnum.Account);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getTakeDataContditionListUI(), (Map)uiContext);
        uiWindow.show();
    }

    public void checkSelected() {
        if (this.getDetailTable().getRowCount() == 0 || this.getDetailTable().getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    protected KDTable getDetailTable() {
        return this.tblMain;
    }

    protected String getKeyFieldName() {
        return TBL_ID;
    }

    protected String getDataSourceListUI() {
        return "com.kingdee.eas.tm.td.basedata.client.DataSourceListUI";
    }

    protected String getTakeDataContditionListUI() {
        return "com.kingdee.eas.tm.td.basedata.client.TakeDataContditionListUI";
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
    }

    @Override
    public void actionAddWizard_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission("add");
        AccountConfigWizardModel model = new AccountConfigWizardModel();
        model.setUiClassName(this.getEditUIName());
        model.setOrgUnit((FullOrgUnitInfo)this.prmtChangeUnit.getValue());
        new AccountConfigWizard((CoreUI)this, model);
        this.refresh(null);
    }
}

