/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.CompareSignEnum;
import com.kingdee.eas.base.commonquery.RowObject;
import com.kingdee.eas.base.commonquery.client.CommonFilterUtil;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.tm.td.basedata.DataSourceInfo;
import com.kingdee.eas.tm.td.basedata.client.BaseCommonFilterPanel;
import com.kingdee.eas.tm.td.basedata.client.SelectQueryFieldSelector;
import com.kingdee.eas.tm.td.basedata.util.CommonFilterPanelUtil;
import com.kingdee.eas.tm.td.basedata.util.DataTypeEnum;
import com.kingdee.eas.tm.td.basedata.util.PropertyMeta;
import com.kingdee.eas.tm.td.basedata.util.PropertyMetaUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CommonDataSourceFilterPanel
extends BaseCommonFilterPanel {
    private static final long serialVersionUID = 1L;
    private DataSourceInfo dataQuery;

    public CommonDataSourceFilterPanel(DataSourceInfo dataQuery, FilterInfo filterInfo, int width, int height, int defaultRows) throws Exception {
        super(filterInfo, width, height, defaultRows);
        this.dataQuery = dataQuery;
        this.jbInit();
    }

    @Override
    protected void loadCondition(int rowIndex, RowObject rowObject) throws Exception {
        this.setConditionCell(rowIndex);
        String conditon = rowObject.getCondition();
        if (conditon != null) {
            String strCondition = conditon.toString();
            this.kdtTable.getRow(rowIndex).getCell(1).setValue((Object)PropertyMetaUtil.getPropertyMeta(this.dataQuery, strCondition));
        }
    }

    @Override
    protected void loadCompareValue(int rowIndex, RowObject rowObject) throws Exception {
        Object compareValue = rowObject.getCompareValue();
        ICell compareValueCell = this.kdtTable.getRow(rowIndex).getCell(3);
        Object signValue = this.kdtTable.getRow(rowIndex).getCell(2).getValue();
        if (CompareSignEnum.LIKESIGN.equals(signValue)) {
            compareValue = compareValue.toString().startsWith("%") && compareValue.toString().endsWith("%") ? compareValue.toString().substring(1, compareValue.toString().length() - 1) : (compareValue.toString().startsWith("%") ? compareValue.toString().substring(1, compareValue.toString().length()) : compareValue.toString().substring(0, compareValue.toString().length() - 1));
        } else if (CompareSignEnum.LEFTLIKESIGN.equals(signValue)) {
            if (compareValue.toString().endsWith("%")) {
                compareValue = compareValue.toString().substring(0, compareValue.toString().length() - 1);
            }
        } else if (CompareSignEnum.RIGHTLIKESIGN.equals(signValue)) {
            if (compareValue.toString().startsWith("%")) {
                compareValue = compareValue.toString().substring(1, compareValue.toString().length());
            }
        } else if (CompareSignEnum.NOTLIKESIGN.equals(signValue)) {
            if (compareValue.toString().startsWith("%") && compareValue.toString().endsWith("%")) {
                compareValue = compareValue.toString().substring(1, compareValue.toString().length() - 1);
            }
        } else if (CompareSignEnum.NOTLEFTLIKESIGN.equals(signValue)) {
            if (compareValue.toString().endsWith("%")) {
                compareValue = compareValue.toString().substring(0, compareValue.toString().length() - 1);
            }
        } else if (CommonFilterPanelUtil.isNullJudge(signValue)) {
            this.kdtTable.getRow(rowIndex).getCell(3).setValue(null);
            this.kdtTable.getRow(rowIndex).getCell(3).getStyleAttributes().setLocked(true);
            return;
        }
        PropertyMeta field = (PropertyMeta)this.kdtTable.getRow(rowIndex).getCell(1).getValue();
        if (field != null) {
            this.setFieldCompareValue(field, rowIndex, compareValueCell, compareValue.toString());
        }
    }

    private void setFieldCompareValue(PropertyMeta field, int rowIndex, ICell compareValueCell, String compareValue) throws Exception {
        String dataType = field.getDataType();
        if (CommonFilterUtil.isBooleanType((String)dataType)) {
            CommonFilterPanelUtil.setBooleanComboBox(compareValueCell, compareValue == null ? -1 : Integer.valueOf(compareValue));
        } else if (CommonFilterUtil.isEnumType((String)dataType)) {
            CommonFilterPanelUtil.setEnumComboBoxField(compareValueCell, field.getEnumClassName(), compareValue);
        } else if (CommonFilterUtil.isF7Type((String)dataType)) {
            this.setF7CtrlField(compareValueCell, field.getRelationBosType(), compareValue);
        } else if (CommonFilterUtil.isDateType((String)dataType)) {
            Date initDate = new Date();
            if (compareValue != null) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                initDate = sdf.parse(compareValue);
            }
            CommonFilterPanelUtil.setDateCtrlField(compareValueCell, initDate);
            String format = "%{" + CtrlFormatUtilities.getDateFormatString() + "}t";
            compareValueCell.getStyleAttributes().setNumberFormat(format);
            compareValueCell.getStyleAttributes().setLocked(false);
            if (compareValue != null) {
                compareValueCell.setValue((Object)initDate);
            } else {
                compareValueCell.setValue(null);
            }
        } else {
            CommonFilterPanelUtil.setTextFieldCell(compareValueCell, compareValue);
        }
    }

    private void setF7CtrlField(ICell iCell, String bosType, String value) throws BOSException {
        KDBizPromptBox f7 = CommonFilterPanelUtil.createF7WithBosType(bosType);
        if (f7 == null) {
            CommonFilterPanelUtil.setTextFieldCell(iCell, null);
            return;
        }
        f7.setEditable(false);
        String f7Data = value;
        if (f7Data != null && (f7Data = DynamicObjectFactory.getRemoteInstance().getValue(BOSObjectType.create((String)bosType), (IObjectPK)new ObjectUuidPK(value))) == null) {
            f7Data = value;
        }
        f7.setData((Object)f7Data);
        KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((IKDEditor)f7);
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat(f7.getDisplayFormatter().toString()));
        iCell.setRenderer((IBasicRender)avr);
        iCell.setEditor((ICellEditor)kdtDefaultCellEditor);
        iCell.getStyleAttributes().setNumberFormat("");
        iCell.getStyleAttributes().setLocked(false);
        iCell.setValue((Object)f7Data);
    }

    @Override
    protected void setConditionCell(int rowIndex) throws Exception {
        KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((IKDEditor)this.getDataQueryTreePromptBox());
        this.kdtTable.getRow(rowIndex).getCell(1).setEditor((ICellEditor)kdtDefaultCellEditor);
    }

    private KDPromptBox getDataQueryTreePromptBox() {
        KDPromptBox dataQueryTreePromptBox = new KDPromptBox();
        SelectQueryFieldSelector selector = new SelectQueryFieldSelector(this.dataQuery);
        dataQueryTreePromptBox.setSelector((KDPromptSelector)selector);
        dataQueryTreePromptBox.setEditable(false);
        dataQueryTreePromptBox.setHistoryRecordEnabled(false);
        return dataQueryTreePromptBox;
    }

    @Override
    protected void editedCondtionCellAfter(KDTEditEvent e) throws Exception {
        super.editedCondtionCellAfter(e);
        int rowIndex = e.getRowIndex();
        IRow row = this.kdtTable.getRow(rowIndex);
        if (row.getCell(1).getValue() != null) {
            ICell compareValueCell = row.getCell(3);
            if (row.getCell(1).getValue().getClass().getName().equals("java.lang.String")) {
                return;
            }
            PropertyMeta field = (PropertyMeta)row.getCell(1).getValue();
            if (!ToolUtils.equalObject((Object)e.getValue(), (Object)e.getOldValue())) {
                this.setFieldCompareValue(field, rowIndex, compareValueCell, null);
            }
        }
    }

    @Override
    protected void editedCompareValueCellAfter(KDTEditEvent e) throws Exception {
        IRow row = this.kdtTable.getRow(e.getRowIndex());
        ICell conditionCell = row.getCell(1);
        ICell compareValueCell = row.getCell(3);
        if (compareValueCell.getValue() == null) {
            return;
        }
        PropertyMeta field = (PropertyMeta)conditionCell.getValue();
        if ((DataTypeEnum.Amount.equals(field.getDataType()) || DataTypeEnum.Qty.equals(field.getDataType()) || DataTypeEnum.Price.equals(field.getDataType()) || DataTypeEnum.Integer.equals(field.getDataType())) && this.checkIsNumberValid(compareValueCell.getValue(), field.getDataType())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.base.commonquery.client.CommonFilterPanel", (String)"compareValueWarning"));
            compareValueCell.setValue(null);
        }
    }

    private boolean checkIsNumberValid(Object compareValue, String dataType) {
        boolean flag = false;
        if (compareValue == null) {
            return flag;
        }
        String value = compareValue.toString();
        try {
            if (dataType.equalsIgnoreCase(DataType.SHORT.getName())) {
                new Short(value);
            } else if (dataType.equalsIgnoreCase(DataType.INTEGER.getName())) {
                new Integer(value);
            } else if (dataType.equalsIgnoreCase(DataType.LONG.getName())) {
                new Long(value);
            } else if (dataType.equalsIgnoreCase(DataType.FLOAT.getName())) {
                new Float(value);
            } else if (dataType.equalsIgnoreCase(DataType.DOUBLE.getName())) {
                new Double(value);
            } else if (dataType.equalsIgnoreCase(DataType.DECIMAL.getName())) {
                NumberFormat nf = CtrlFormatUtilities.getDecimalFormat();
                String formatValue = "";
                try {
                    formatValue = nf.parse(value).toString();
                    new BigDecimal(formatValue);
                }
                catch (ParseException e) {
                    flag = true;
                }
            }
        }
        catch (NumberFormatException e) {
            flag = true;
        }
        return flag;
    }

    @Override
    protected String getConditionString(IRow iRow) {
        PropertyMeta condition = (PropertyMeta)iRow.getCell(1).getValue();
        return condition.getFullSQLFieldName(SysContext.getSysContext().getOriginLocale());
    }

    @Override
    protected Object getCompareValue(IRow iRow) throws Exception {
        Object compareValue = iRow.getCell(3).getValue();
        Object compareSign = iRow.getCell(2).getValue();
        PropertyMeta condition = (PropertyMeta)iRow.getCell(1).getValue();
        String dataType = condition.getDataType();
        if (compareValue instanceof IObjectValue) {
            compareValue = ((IObjectValue)compareValue).get("id");
        } else if (dataType.equalsIgnoreCase(DataType.SHORT.getName())) {
            compareValue = new Short(compareValue.toString());
        } else if (dataType.equalsIgnoreCase(DataType.INTEGER.getName())) {
            new Integer(compareValue.toString());
        } else if (dataType.equalsIgnoreCase(DataType.LONG.getName())) {
            new Long(compareValue.toString());
        } else if (dataType.equalsIgnoreCase(DataType.FLOAT.getName())) {
            new Float(compareValue.toString());
        } else if (dataType.equalsIgnoreCase(DataType.DOUBLE.getName())) {
            new Double(compareValue.toString());
        } else if (dataType.equalsIgnoreCase(DataType.DECIMAL.getName())) {
            NumberFormat nf = CtrlFormatUtilities.getDecimalFormat();
            String formatValue = "";
            formatValue = nf.parse(compareValue.toString()).toString();
            new BigDecimal(formatValue);
        } else {
            compareValue = Util.getValue((Object)compareValue);
        }
        if (CommonFilterUtil.isLikeSign((Object)compareSign) && compareValue instanceof String) {
            compareValue = CommonFilterUtil.getLikeCompareValue((Object)compareValue, (Object)compareSign);
        }
        return compareValue;
    }

    public DataSourceInfo getDataQuery() {
        return this.dataQuery;
    }

    public void setDataQuery(DataSourceInfo dataQuery) {
        this.dataQuery = dataQuery;
    }
}

