/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.tm.td.basedata.DSTypeEnum;
import com.kingdee.eas.tm.td.basedata.DataSourceFactory;
import com.kingdee.eas.tm.td.basedata.DataSourceInfo;
import com.kingdee.eas.tm.td.basedata.DataSourceStastusEnum;
import com.kingdee.eas.tm.td.basedata.DataSourceToAccountFactory;
import com.kingdee.eas.tm.td.basedata.DataSourceToCalcFormulaFactory;
import com.kingdee.eas.tm.td.basedata.DraftItemToDataSourceFactory;
import com.kingdee.eas.tm.td.basedata.client.AbstractDataSourceListUI;
import com.kingdee.eas.tm.td.cloud.datamodel.DataFetchFactory;
import com.kingdee.eas.tm.td.rpt.TaxAnalysisFacadeFactory;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class DataSourceListUI
extends AbstractDataSourceListUI {
    private static final Logger logger = CoreUIObject.getLogger(DataSourceListUI.class);
    private Set dataSourceIds;
    private String orgUnitId;
    private String companyOrgUnitID;
    private String draftItemId;
    private DSTypeEnum dsType;
    private String accountId;
    private String taxAnlsItemID;
    private String dataFetchId;
    private boolean isCanModify = true;
    private static final String COL_STATE = "state";

    protected KDTable getDetailTable() {
        return this.tblMain;
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"dataSourceIds", (Object)this.dataSourceIds);
        uiContext.put((Object)"draftItemId", (Object)this.draftItemId);
        uiContext.put((Object)"orgUnitId", (Object)this.orgUnitId);
        uiContext.put((Object)"dsType", (Object)this.dsType);
        uiContext.put((Object)"accountId", (Object)this.accountId);
        uiContext.put((Object)"companyOrgUnitID", (Object)this.companyOrgUnitID);
        uiContext.put((Object)"taxAnlsItemID", (Object)this.taxAnlsItemID);
        uiContext.put((Object)"dataFetchId", (Object)this.dataFetchId);
        uiContext.put((Object)"isCanModify", (Object)this.isCanModify);
    }

    public void onLoad() throws Exception {
        this.dataSourceIds = new HashSet();
        this.orgUnitId = (String)this.getUIContext().get("orgUnitId");
        this.companyOrgUnitID = (String)this.getUIContext().get("companyOrgUnitID");
        this.draftItemId = (String)this.getUIContext().get("draftItemId");
        this.dsType = (DSTypeEnum)((Object)this.getUIContext().get("dsType"));
        this.accountId = (String)this.getUIContext().get("accountId");
        this.taxAnlsItemID = (String)this.getUIContext().get("taxAnlsItemID");
        this.dataFetchId = (String)this.getUIContext().get("dataFetchId");
        this.isCanModify = this.getUIContext().get("isCanModify") == null ? true : (Boolean)this.getUIContext().get("isCanModify");
        super.onLoad();
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnCancel.setVisible(true);
        this.btnCancelCancel.setVisible(true);
        if (!this.isCanModify) {
            this.actionAddNew.setEnabled(false);
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
        }
    }

    protected String getEditUIName() {
        return "com.kingdee.eas.tm.td.basedata.client.DataSourceEditUI";
    }

    protected ICoreBase getBizInterface() throws Exception {
        return DataSourceFactory.getRemoteInstance();
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected void execQuery() {
        try {
            this.mainQuery.clearExtendedProperties();
            this.mainQuery.setFilter(this.getDefaultFilterForQuery());
            this.mainQuery.getFilter().mergeFilter(this.getDialogViewFilterForQuery(), "AND");
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        super.execQuery();
    }

    protected FilterInfo getDialogViewFilterForQuery() throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        if (this.getDialog().getEntityViewInfoResult() != null) {
            filterInfo = this.getDialog().getCommonFilter();
        }
        return filterInfo;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        try {
            this.dataSourceIds = DSTypeEnum.Account.equals((Object)this.dsType) ? DataSourceToAccountFactory.getRemoteInstance().getDataSourceByAccount(this.accountId, this.orgUnitId, this.companyOrgUnitID) : (DSTypeEnum.DataAnalysis.equals((Object)this.dsType) ? TaxAnalysisFacadeFactory.getRemoteInstance().getDataSourceByID(this.taxAnlsItemID) : (DSTypeEnum.DataFetch.equals((Object)this.dsType) ? DataFetchFactory.getRemoteInstance().getDataSourceByID(this.dataFetchId) : (DSTypeEnum.Formula.equals((Object)this.dsType) ? DataSourceToCalcFormulaFactory.getRemoteInstance().getDataSourceByCalcFormula(null, this.orgUnitId, this.companyOrgUnitID) : DraftItemToDataSourceFactory.getRemoteInstance().getDataSourceByParam(this.orgUnitId, this.draftItemId, this.companyOrgUnitID))));
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        FilterInfo filter = new FilterInfo();
        if (this.dataSourceIds != null && this.dataSourceIds.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.dataSourceIds, CompareType.INCLUDE));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)"1111111111111", CompareType.EQUALS));
        }
        return filter;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.getUIContext().put("draftItemId", this.draftItemId);
        this.getUIContext().put("accountId", this.accountId);
        this.getUIContext().put("orgUnitId", this.orgUnitId);
        this.getUIContext().put("taxAnlsItemID", this.taxAnlsItemID);
        this.getUIContext().put("dataFetchId", this.dataFetchId);
        this.getUIContext().put("dsType", this.dsType);
        super.actionAddNew_actionPerformed(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_CancelCancel");
        if (this.confirmDialog(cancelMsg)) {
            if (UtilRequest.isPrepare((String)"ActionCancelCancel", (CoreUIObject)this)) {
                this.prepareCancelCancel(null).callHandler();
            }
            this.cancelCancel();
            this.refresh(e);
        }
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.refresh(e);
    }

    public void checkSelected() {
        if (this.getDetailTable().getRowCount() == 0 || this.getDetailTable().getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        String getRowId = this.getSelectedKeyValue();
        if (getRowId == null || getRowId.length() <= 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.DraftItemResource", (String)"select_oneRow"));
            SysUtil.abort();
        }
        DataSourceInfo info = new DataSourceInfo();
        info = DataSourceFactory.getRemoteInstance().getDataSourceInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)getRowId)));
        if (info.getState().equals((Object)DataSourceStastusEnum.ACTIVE)) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.DraftItemResource", (String)"state_saveBanEdit"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkStateEnableRemove();
        super.actionRemove_actionPerformed(e);
    }

    protected void checkStateEnableRemove() {
        this.checkSelected();
        int[] rowsIndex = KDTableUtil.getSelectedRows((KDTable)this.getDetailTable());
        IRow row = null;
        int length = rowsIndex.length;
        for (int i = 0; i < length; ++i) {
            row = this.getDetailTable().getRow(rowsIndex[i]);
            BizEnumValueDTO state = (BizEnumValueDTO)row.getCell(COL_STATE).getValue();
            if (!state.getString().equals("2")) continue;
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.DraftItemResource", (String)"select_activeDelete"));
            SysUtil.abort();
        }
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }
}

