/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.basedata.client;

import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.metadata.entity.EntityObjectCollection;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.service.formula.builder.TableVarInfo;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.eas.tm.td.basedata.client.formula.EntityFormulaTransfer;
import com.kingdee.eas.tm.td.basedata.util.EntityPropertyMetaUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class EntityFormula {
    private List<EntityObjectInfo> entityList = new ArrayList<EntityObjectInfo>();
    private String formulaExpr;

    public EntityFormula(EntityObjectInfo entity) {
        this(entity, null);
    }

    public EntityFormula(EntityObjectInfo entity, String formulaExpr) {
        this.entityList.add(entity);
        this.formulaExpr = formulaExpr;
    }

    public EntityFormula(List<EntityObjectInfo> entityList, String formulaExpr) {
        this.entityList = entityList;
        this.formulaExpr = formulaExpr;
    }

    public String getFormualExprByAlias(String formulaAlias) throws ParserException {
        EntityFormulaTransfer transfrmer = new EntityFormulaTransfer(this.getEntityVarInfo());
        EntityObjectCollection coll = new EntityObjectCollection();
        for (int i = 0; i < this.entityList.size(); ++i) {
            coll.add(this.entityList.get(i));
            Map<String, EntityObjectInfo> entryName = EntityPropertyMetaUtil.getEntryName(this.entityList.get(i));
            for (EntityObjectInfo info : entryName.values()) {
                coll.add(info);
            }
        }
        transfrmer.addBOSObjects(coll);
        this.formulaExpr = transfrmer.transforme(formulaAlias);
        return this.formulaExpr;
    }

    public String getFormualAlias() throws ParserException {
        if (StringUtil.isEmpty((String)this.formulaExpr)) {
            return null;
        }
        EntityFormulaTransfer transfrmer = new EntityFormulaTransfer(this.getEntityVarInfo());
        EntityObjectCollection coll = new EntityObjectCollection();
        for (int i = 0; i < this.entityList.size(); ++i) {
            coll.add(this.entityList.get(i));
            Map<String, EntityObjectInfo> entryName = EntityPropertyMetaUtil.getEntryName(this.entityList.get(i));
            for (EntityObjectInfo info : entryName.values()) {
                coll.add(info);
            }
        }
        transfrmer.addBOSObjects(coll);
        String formulaAlias = transfrmer.reverseTransform(this.formulaExpr);
        return formulaAlias;
    }

    private Vector getEntityVarInfo() {
        Vector<TableVarInfo> result = new Vector<TableVarInfo>();
        for (int i = 0; i < this.entityList.size(); ++i) {
            EntityObjectInfo entity = this.entityList.get(i);
            TableVarInfo entityVar = new TableVarInfo(entity.getName(), entity.getAlias(), entity.getBOSType().toString(), null, null, null, -1);
            result.add(entityVar);
            Map<String, EntityObjectInfo> entryName = EntityPropertyMetaUtil.getEntryName(entity);
            for (EntityObjectInfo info : entryName.values()) {
                TableVarInfo entryVar = new TableVarInfo(info.getName(), info.getAlias(), info.getBOSType().toString(), null, null, null, -1);
                result.add(entryVar);
            }
        }
        return result;
    }

    public List<EntityObjectInfo> getEntityList() {
        return this.entityList;
    }

    public String getFormulaExpr() {
        return this.formulaExpr;
    }

    public void setFormulaExpr(String formulaExpr) {
        this.formulaExpr = formulaExpr;
    }
}

