/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.td.basedata.AccountConfigFactory;
import com.kingdee.eas.tm.td.basedata.AccountConfigInfo;
import com.kingdee.eas.tm.td.basedata.DSTypeEnum;
import com.kingdee.eas.tm.td.basedata.OrgToAccountCollection;
import com.kingdee.eas.tm.td.basedata.OrgToAccountFactory;
import com.kingdee.eas.tm.td.basedata.OrgToAccountInfo;
import com.kingdee.eas.tm.td.basedata.client.AbstractOrgToAccountUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class OrgToAccountUI
extends AbstractOrgToAccountUI {
    private static final Logger logger = CoreUIObject.getLogger(OrgToAccountUI.class);
    private DSTypeEnum dsType;
    private String accountId;
    private AccountConfigInfo accountConfigInfo;
    private static final String COL_ID = "id";
    private static final String COL_ORGNUMBER = "orgNumber";
    private static final String COL_ORGNAME = "orgName";
    private KDTEditAdapter tblMainKDTEditAdapter = new KDTEditAdapter(){

        public void editStopped(KDTEditEvent e) {
            try {
                OrgToAccountUI.this.tblMain_Changed(e.getRowIndex(), e.getColIndex());
            }
            catch (Exception exc) {
                OrgToAccountUI.this.handUIException(exc);
            }
        }
    };

    public OrgToAccountUI() throws Exception {
        this.tblMain.addKDTEditListener((KDTEditListener)this.tblMainKDTEditAdapter);
    }

    public void onLoad() throws Exception {
        this.dsType = (DSTypeEnum)((Object)this.getUIContext().get("dsType"));
        this.accountId = (String)this.getUIContext().get("accountId");
        if (DSTypeEnum.Account.equals((Object)this.dsType)) {
            this.accountConfigInfo = AccountConfigFactory.getRemoteInstance().getAccountConfigInfo((IObjectPK)new ObjectUuidPK(this.accountId));
        }
        super.onLoad();
        this.initControl();
        this.innerLoadFields();
    }

    protected void initControl() {
        this.initOrgF7();
    }

    private void initOrgF7() {
        this.tblMain.checkParsed();
        final KDBizPromptBox orgF7 = new KDBizPromptBox();
        orgF7.setEditable(true);
        orgF7.setQueryInfo("com.kingdee.eas.basedata.org.app.FullOrgUnitQuery");
        orgF7.setDisplayFormat("$number$");
        orgF7.setEditFormat("$number$");
        orgF7.setCommitFormat("$number$");
        KDTDefaultCellEditor orgF7Editor = new KDTDefaultCellEditor((IKDEditor)orgF7);
        this.tblMain.getColumn(COL_ORGNUMBER).setEditor((ICellEditor)orgF7Editor);
        ObjectValueRender orgRender = new ObjectValueRender();
        this.tblMain.getColumn(COL_ORGNUMBER).setRenderer((IBasicRender)orgRender);
        KDTextField orgName = new KDTextField();
        orgName.setEditable(false);
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JTextField)orgName);
        this.tblMain.getColumn(COL_ORGNAME).setEditor((ICellEditor)cellEditor);
        orgF7.setEnabledMultiSelection(true);
        orgF7.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Object o = orgF7.getValue();
                if (!(o instanceof FullOrgUnitInfo[]) && !(o instanceof Object[])) {
                    return;
                }
                KDTSelectBlock ksb = OrgToAccountUI.this.tblMain.getSelectManager().get();
                int beginRow = ksb.getBeginRow();
                FullOrgUnitInfo[] orgInfos = null;
                if (o instanceof FullOrgUnitInfo[]) {
                    orgInfos = (FullOrgUnitInfo[])o;
                } else if (o instanceof Object[]) {
                    Object[] objects = (Object[])o;
                    if (objects.length == 0) {
                        return;
                    }
                    orgInfos = new FullOrgUnitInfo[objects.length];
                    System.arraycopy(objects, 0, orgInfos, 0, objects.length);
                } else {
                    return;
                }
                HashMap<String, Object> orgMap = new HashMap<String, Object>();
                FullOrgUnitInfo selectData = (FullOrgUnitInfo)OrgToAccountUI.this.tblMain.getCell(0, 0).getValue();
                for (int i = 0; i < OrgToAccountUI.this.tblMain.getRowCount(); ++i) {
                    ICell cell = OrgToAccountUI.this.tblMain.getCell(i, 0);
                    Object data = cell.getValue();
                    if (data == null || data instanceof Object[]) continue;
                    orgMap.put(((FullOrgUnitInfo)data).getId().toString(), data);
                }
                orgF7.removeChangeListener((ChangeListener)this);
                int length = orgInfos.length;
                ArrayList<FullOrgUnitInfo> orgs = new ArrayList<FullOrgUnitInfo>();
                for (int i = 0; i < length; ++i) {
                    Object value = orgMap.get(orgInfos[i].getId().toString());
                    if (value != null) continue;
                    orgs.add(orgInfos[i]);
                }
                IRow curRow2 = null;
                if (orgs != null && orgs.size() > 0) {
                    for (int i = 0; i < orgs.size(); ++i) {
                        if (orgs.get(i) == null) continue;
                        curRow2 = OrgToAccountUI.this.tblMain.getRow(beginRow + i);
                        int curCol = 0;
                        curRow2.getCell(curCol).setValue(null);
                        curRow2.getCell(curCol).setValue(orgs.get(i));
                        curRow2.getCell(curCol).setUserObject(orgs.get(i));
                        OrgToAccountUI.this.tblMain_Changed(beginRow + i, 0);
                        if (i >= orgs.size() - 1) continue;
                        OrgToAccountUI.this.insertLine((FullOrgUnitInfo)orgs.get(i), beginRow + i + 1);
                    }
                } else {
                    try {
                        curRow2 = OrgToAccountUI.this.tblMain.getRow(beginRow);
                        curRow2.getCell(0).setValue(null);
                        curRow2.getCell(0).setValue((Object)selectData);
                        curRow2.getCell(0).setUserObject((Object)selectData);
                        OrgToAccountUI.this.tblMain_Changed(beginRow, 0);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                orgF7.addChangeListener((ChangeListener)this);
            }
        });
    }

    protected void insertLine(FullOrgUnitInfo unitInfo, int row) {
        IObjectValue editData = this.createNewData(unitInfo);
        IRow irow = null;
        irow = this.tblMain.addRow(row);
        this.tblMain.getCell(row, COL_ORGNUMBER).setValue((Object)unitInfo.getName());
        irow.getCell(0).setValue((Object)unitInfo.getName());
        irow.getCell(0).setUserObject((Object)unitInfo);
        irow.setUserObject((Object)editData);
    }

    protected IObjectValue createNewData(FullOrgUnitInfo unitInfo) {
        OrgToAccountInfo orgToAccountInfo = new OrgToAccountInfo();
        orgToAccountInfo.setId(BOSUuid.create((BOSObjectType)orgToAccountInfo.getBOSType()));
        orgToAccountInfo.setOrgUnit(unitInfo);
        return orgToAccountInfo;
    }

    protected void tblMain_Changed(int rowIndex, int colIndex) {
        String fieldName = this.tblMain.getColumnKey(colIndex);
        if (COL_ORGNUMBER.equalsIgnoreCase(fieldName)) {
            Object value = this.tblMain.getCell(rowIndex, fieldName).getValue();
            if (value != null && value instanceof FullOrgUnitInfo) {
                this.tblMain.getCell(rowIndex, COL_ORGNAME).setValue((Object)((FullOrgUnitInfo)value).getName());
            } else {
                this.tblMain.getCell(rowIndex, COL_ORGNUMBER).setValue(null);
                this.tblMain.getCell(rowIndex, COL_ORGNAME).setValue(null);
            }
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.innerLoadFields();
    }

    protected void innerLoadFields() {
        if (this.accountId != null) {
            this.tblMain.removeRows();
            this.tblMain.checkParsed();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("accountConfig.id", (Object)this.accountId, CompareType.EQUALS));
            view.setFilter(filter);
            view.setSelector(this.getSelectors());
            OrgToAccountCollection coll = null;
            try {
                coll = OrgToAccountFactory.getRemoteInstance().getOrgToAccountCollection(view);
            }
            catch (BOSException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
            if (coll != null && coll.size() > 0) {
                int size = coll.size();
                for (int i = 0; i < size; ++i) {
                    this.addRow(coll.get(i));
                }
            }
        }
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("accountConfig.*"));
        sic.add(new SelectorItemInfo("orgUnit.*"));
        return sic;
    }

    protected void addRow(OrgToAccountInfo accountInfo) {
        if (accountInfo == null) {
            return;
        }
        IRow row = this.tblMain.addRow();
        row.getCell(COL_ID).setValue((Object)accountInfo.getId());
        row.getCell(COL_ORGNUMBER).setValue((Object)accountInfo.getOrgUnit());
        row.getCell(COL_ORGNUMBER).setUserObject((Object)accountInfo.getOrgUnit());
        row.getCell(COL_ORGNAME).setValue((Object)accountInfo.getOrgUnit().getName());
        row.setUserObject((Object)accountInfo);
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.addRow();
    }

    @Override
    public void actionDeleteLine_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.getDetailTable());
        if (this.confirmRemove()) {
            this.getDetailTable().removeRow(row.getRowIndex());
        }
    }

    public void checkSelected() {
        if (this.getDetailTable().getRowCount() == 0 || this.getDetailTable().getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    protected KDTable getDetailTable() {
        return this.tblMain;
    }

    protected boolean confirmRemove() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
    }

    protected void beforeSave() {
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.beforeSave();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("accountConfig.id", (Object)this.accountId, CompareType.EQUALS));
        OrgToAccountFactory.getRemoteInstance().delete(filter);
        IRow row = null;
        CoreBaseCollection coll = new CoreBaseCollection();
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = this.tblMain.getRow(i);
            if (row.getUserObject() == null) continue;
            coll.add((CoreBaseInfo)row.getUserObject());
        }
        if (coll.size() > 0) {
            OrgToAccountFactory.getRemoteInstance().saveBatchData(coll);
        }
    }
}

