/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.tm.td.FilterCommonStatusEnum;
import com.kingdee.eas.tm.td.RecordTypeEnum;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.DraftItemStatus;
import com.kingdee.eas.tm.td.basedata.RptBillRangeEntryInfo;
import com.kingdee.eas.tm.td.basedata.RptBillRangeFactory;
import com.kingdee.eas.tm.td.basedata.RptBillRangeInfo;
import com.kingdee.eas.tm.td.basedata.client.AbstractRptBillRangeEditUI;
import com.kingdee.eas.tm.td.basedata.util.EntitySelector;
import com.kingdee.eas.tm.td.basedata.util.EntitySelectorType;
import com.kingdee.eas.tm.td.common.permsupport.IPermSupport4EditUI;
import com.kingdee.eas.tm.td.common.uihelper.EditUIHelper;
import com.kingdee.eas.tm.td.structure.utils.StructureUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RptBillRangeEditUI
extends AbstractRptBillRangeEditUI
implements IPermSupport4EditUI {
    private static final Logger logger = CoreUIObject.getLogger(RptBillRangeEditUI.class);
    private KDTEditListener tblListener = null;
    private EditUIHelper uiHelper = new EditUIHelper((EditUI)this);
    private String currentCUID;
    private Map btnMap = new HashMap();

    public RptBillRangeEditUI() throws Exception {
        this.btnMap.put("actionRemove", this.actionRemove);
        this.btnMap.put("actionCancel", this.actionCancel);
        this.btnMap.put("actionCancelCancel", this.actionCancelCancel);
        this.btnMap.put("actionEdit", this.actionEdit);
        this.btnMap.put("actionSave", this.actionSubmit);
        this.btnMap.put("actionCopy", this.actionCopy);
        this.btnMap.put("actionAddLine", this.actionAddLine);
        this.btnMap.put("actionInsertLine", this.actionInsertLine);
        this.btnMap.put("actionRemoveLine", this.actionRemoveLine);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initBtnStatus();
        this.initQueryBillF7();
        this.initTaxTypeF7();
    }

    private void initNumber() {
        if (!this.oprtState.equals("ADDNEW") || !StringUtils.isEmpty((String)this.editData.getNumber())) {
            return;
        }
        OrgUnitInfo currentMainOrg = SysContext.getSysContext().getCurrentOrgUnit(this.getMainBizOrgType());
        BOSUuid orgId = currentMainOrg.getId();
        try {
            ICodingRuleManager rule = CodingRuleManagerFactory.getRemoteInstance();
            CodingRuleInfo codingRule = rule.getCodingRule((IObjectValue)this.editData, this.currentCUID);
            String number = "";
            if (codingRule != null && codingRule.isIsAddView()) {
                number = rule.getNumber((IObjectValue)this.editData, orgId.toString());
                this.txtNumber.setText(number);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected void initBtnStatus() {
        this.btnSubmit.setVisible(false);
        this.btnFirst.setVisible(false);
        this.btnPre.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnTraceUp.setVisible(false);
        this.btnCreateFrom.setVisible(false);
        this.btnTraceDown.setVisible(false);
        this.btnWorkFlowG.setVisible(false);
        this.btnAuditResult.setVisible(false);
        this.btnMultiapprove.setVisible(false);
        this.btnNextPerson.setVisible(false);
        this.actionCopyFrom.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.MenuItemAttachment.setVisible(false);
        this.btnCancel.setVisible(true);
        this.btnCancelCancel.setVisible(true);
        this.menuItemCancelCancel.setVisible(true);
        this.menuItemCancel.setVisible(true);
        DraftItemStatus status = this.editData.getStatus();
        boolean isLight = false;
        if (DraftItemStatus.NOAWAKEN.equals((Object)status) || DraftItemStatus.SAVING.equals((Object)status)) {
            isLight = true;
        }
        this.uiHelper.initBtnStatus(this.btnMap, isLight);
        if (DraftItemStatus.SAVING.equals((Object)status) && !this.getOprtState().equals(OprtState.ADDNEW)) {
            this.actionCancel.setEnabled(true);
        }
    }

    @Override
    public void loadFields() {
        this.removeListener();
        this.loadStatus();
        super.loadFields();
        this.initBtnStatus();
        this.addListener();
        this.currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        this.initNumber();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (FilterCommonStatusEnum.NULL.equals(this.comboRecordType.getSelectedItem())) {
            this.editData.put("recordType", -1);
        }
    }

    private void tableValueChanged(KDTEditEvent e) {
        if (e.getColIndex() == this.kdtEntrys.getColumnIndex("billName") && e.getValue() != null && this.isBillNameChanged(e)) {
            HashSet<String> billNameSet = new HashSet<String>();
            Object billName = null;
            int size = this.kdtEntrys.getRowCount();
            for (int i = 0; i < size; ++i) {
                billName = this.kdtEntrys.getRow(i).getCell("billName").getValue();
                if (billName == null) continue;
                billNameSet.add(billName.toString());
            }
            int colIndex = e.getColIndex();
            int rowIndex = e.getRowIndex();
            EntityObjectInfo metaData = (EntityObjectInfo)e.getValue();
            if (billNameSet.contains(metaData.getAlias())) {
                this.kdtEntrys.getCell(rowIndex, colIndex).setValue(null);
                MsgBox.showWarning((String)TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "Data_NotRepeat", TDUtils.getLocale()));
            } else {
                this.kdtEntrys.getCell(rowIndex, colIndex).setValue((Object)metaData.getAlias());
                this.kdtEntrys.getCell(rowIndex, "billBosType").setValue((Object)metaData.getType().toString());
            }
        }
    }

    private boolean isBillNameChanged(KDTEditEvent e) {
        if (e.getValue() instanceof EntityObjectInfo) {
            EntityObjectInfo newData = (EntityObjectInfo)e.getValue();
            if (newData.getAlias().equals(e.getOldValue())) {
                this.kdtEntrys.getCell(e.getRowIndex(), e.getColIndex()).setValue((Object)newData.getAlias());
                return false;
            }
            return true;
        }
        return !e.getValue().equals(e.getOldValue());
    }

    private void initQueryBillF7() {
        KDBizPromptBox f7Box = new KDBizPromptBox();
        if (f7Box.getSelector() == null || !(f7Box.getSelector() instanceof EntitySelector)) {
            EntitySelector selector = new EntitySelector(this.getUIWindow(), EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"120_DataQueryEditUI"), EntitySelectorType.FullEntity);
            f7Box.setDisplayFormat("$name$");
            f7Box.setSelector((KDPromptSelector)selector);
            f7Box.setEditable(false);
        }
        this.kdtEntrys.getColumn(this.kdtEntrys.getColumnIndex("billName")).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)f7Box));
    }

    private void initTaxTypeF7() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("description"));
        if (this.prmtTaxType.getSelectorCollection() == null) {
            this.prmtTaxType.setSelectorCollection(sic);
        }
        StructureUtils.setTaxTypeFilter(this.prmtTaxType);
    }

    private void loadStatus() {
        this.comboRecordType.removeAllItems();
        this.comboRecordType.addItem((Object)FilterCommonStatusEnum.NULL);
        this.comboRecordType.addItems(RecordTypeEnum.getEnumList().toArray());
    }

    private Set<String> transferTaxTypeNumToSet(String[] taxTypeNum) {
        HashSet<String> taxTypeNumSet = new HashSet<String>(Arrays.asList(taxTypeNum));
        return taxTypeNumSet;
    }

    private void addListener() {
        if (this.tblListener == null) {
            this.tblListener = new KDTEditAdapter(){

                public void editStopped(KDTEditEvent e) {
                    RptBillRangeEditUI.this.tableValueChanged(e);
                }
            };
        }
        this.kdtEntrys.addKDTEditListener(this.tblListener);
    }

    private void removeListener() {
        this.kdtEntrys.removeKDTEditListener(this.tblListener);
    }

    protected IObjectValue createNewData() {
        RptBillRangeInfo info = new RptBillRangeInfo();
        info.setStatus(DraftItemStatus.SAVING);
        info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        info.setIsPreseted(false);
        info.getEntrys().add((RptBillRangeEntryInfo)this.createNewDetailData(this.getDetailTable()));
        return info;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        RptBillRangeEntryInfo entryInfo = new RptBillRangeEntryInfo();
        entryInfo.setIsExported(false);
        return entryInfo;
    }

    protected KDTable getDetailTable() {
        return this.kdtEntrys;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RptBillRangeFactory.getRemoteInstance();
    }

    private void refresh(IObjectPK pk) throws Exception {
        this.setDataObject(this.getValue(pk));
        this.loadFields();
        this.initOldData((IObjectValue)this.editData);
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        RptBillRangeInfo editData = (RptBillRangeInfo)newData;
        editData.setNumber(null);
        editData.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        editData.setStatus(DraftItemStatus.SAVING);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.inputCheck();
        super.actionSave_actionPerformed(e);
        if (!this.getOprtState().equals(OprtState.ADDNEW)) {
            if (this.editData.getStatus() != null && DraftItemStatus.AWAKEN.equals((Object)this.editData.getStatus())) {
                this.setOprtState("VIEW");
            } else {
                this.setOprtState("EDIT");
            }
        }
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
    }

    private void inputCheck() {
        StringBuffer sb = new StringBuffer();
        this.txtNumber.setText(this.txtNumber.getText().trim());
        this.txtName.setText(this.txtName.getText().trim());
        if (this.txtName.getText().isEmpty()) {
            sb.append(",").append(TDUtils.getString("com.kingdee.eas.tm.td.basedata.RptBillRangeResource", "RptBillRangeName", TDUtils.getLocale()));
        }
        int rowCount = this.kdtEntrys.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            if (this.kdtEntrys.getCell(i, "billName").getValue() != null) continue;
            sb.append(",").append(TDUtils.getString("com.kingdee.eas.tm.td.basedata.RptBillRangeResource", "BillNameInEntry", TDUtils.getLocale()));
            break;
        }
        if (sb.length() > 0) {
            sb.append(TDUtils.getString("com.kingdee.eas.tm.td.basedata.RptBillRangeResource", "NOTNULL", TDUtils.getLocale())).append("\r\n");
            MsgBox.showWarning((String)sb.substring(1));
            SysUtil.abort();
        }
        TDUtils.removeNullRow(this.kdtEntrys, new String[]{"billName"}, false);
        if (this.kdtEntrys.getRowCount() == 0) {
            sb.setLength(0);
            sb.append(TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "Error_EmptyEntry", TDUtils.getLocale())).append("\r\n");
            MsgBox.showWarning((String)sb.toString());
            SysUtil.abort();
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanAddnew(this.currentCUID);
        super.actionAddNew_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.confirmRemove()) {
            if (this.editData.isIsPreseted()) {
                MsgBox.showWarning((String)TDUtils.getString("com.kingdee.eas.tm.td.basedata.RptBillRangeResource", "ISPRESETED_CANNOT_REMOVE", TDUtils.getLocale()));
                SysUtil.abort();
            }
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(this.editData.getId().toString());
            this.uiHelper.checkCanRemove(this.currentCUID, ids);
            super.actionRemove_actionPerformed(e);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanEdit(this.currentCUID, this.editData.getId().toString());
        super.actionEdit_actionPerformed(e);
        this.initBtnStatus();
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        String billId = this.editData.getId().toString();
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(billId);
        this.uiHelper.checkBaseDataPermission(this.currentCUID, ids);
        if (!this.uiHelper.modifySaveOrExit((ItemAction)this.actionSubmit, this.btnSubmit, (ItemAction)this.actionSave, this.btnSave, this.isModifySave())) {
            return;
        }
        ArrayList errors = RptBillRangeFactory.getRemoteInstance().cancelCancel(new HashSet(ids));
        if (errors.size() > 0) {
            MsgBox.showWarning((Component)((Object)this), (String)((String)errors.get(0)));
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Startup_OK"));
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)billId));
            this.setDataObject(this.getValue((IObjectPK)pk));
            if (this.editData.getStatus() != null && DraftItemStatus.AWAKEN.equals((Object)this.editData.getStatus())) {
                this.setOprtState("VIEW");
            } else {
                this.setOprtState("EDIT");
            }
            this.setDataObject((IObjectValue)this.editData);
            this.loadFields();
        }
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        String billId = this.editData.getId().toString();
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(billId);
        this.uiHelper.checkBaseDataPermission(this.currentCUID, ids);
        ArrayList errors = RptBillRangeFactory.getRemoteInstance().cancel(new HashSet(ids));
        if (errors.size() > 0) {
            MsgBox.showWarning((Component)((Object)this), (String)((String)errors.get(0)));
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Forbid _OK"));
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)billId));
            this.refresh((IObjectPK)pk);
        }
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }

    @Override
    public String getBizOrgProperty(OrgType orgType) throws BOSException, EASBizException {
        return "CU";
    }

    @Override
    public String getPermItem(String status) {
        return null;
    }

    @Override
    public KDBizPromptBox getPermMainBizOrg() {
        return null;
    }

    @Override
    public IObjectValue getValueObject() {
        return this.editData;
    }

    @Override
    public ICoreBase getPermInterface() throws Exception {
        return this.getBizInterface();
    }
}

