/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutor;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CountryInfo;
import com.kingdee.eas.basedata.assistant.ProvinceInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCostCenterF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.td.PeriodTypeEnum;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.TaxBaseEntryCollection;
import com.kingdee.eas.tm.td.basedata.TaxBaseEntryInfo;
import com.kingdee.eas.tm.td.basedata.TaxBaseFactory;
import com.kingdee.eas.tm.td.basedata.TaxBaseInfo;
import com.kingdee.eas.tm.td.basedata.TaxInfoState;
import com.kingdee.eas.tm.td.basedata.client.AbstractTaxBaseEditUI;
import com.kingdee.eas.tm.td.common.permsupport.IPermSupport4EditUI;
import com.kingdee.eas.tm.td.common.uihelper.EditUIHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class TaxBaseEditUI
extends AbstractTaxBaseEditUI
implements IPermSupport4EditUI {
    private static final Logger logger = CoreUIObject.getLogger(TaxBaseEditUI.class);
    private static final int RAET_PRECISION = 6;
    private static final int INCOMERATIO_PRECISION = 2;
    private static final int MAINRATE_PRECISION = 6;
    private static final BigDecimal ONE_HUNDRED = new BigDecimal(100);
    private static final String TB_TAXITEMTYPE = "taxItemType";
    private static final String TB_TAXPERIOD = "taxPeriod";
    private static final String TB_TAXRATE = "taxRate";
    private static final String TB_INCOMERATIONONE = "incomeRatioOne";
    private static final String TB_INCOMERATIONTWO = "incomeRatioTwo";
    private static final String[] RATE_FIELD = new String[]{"incomeRatioOne", "incomeRatioTwo"};
    private static final String TAXITEMTYPE_QUERY = "com.kingdee.eas.tm.td.basedata.app.TaxItemTypeQuery";
    private DataChangeListener prmtCompanyListener = null;
    private DataChangeListener prmtRegistCountryListener = null;
    private DataChangeListener prmtOperateCountryListener = null;
    private DataChangeListener prmtRegistProvinceListener = null;
    private DataChangeListener prmtOperateProvinceListener = null;
    private DataChangeListener txtMainRateListener = null;
    private SelectorListener prmtSelectorCompanyListener = null;
    private EditUIHelper uiHelper = new EditUIHelper(this);
    private Map btnMap = new HashMap();

    public TaxBaseEditUI() throws Exception {
        this.btnMap.put("actionRemove", this.actionRemove);
        this.btnMap.put("actionCancel", this.actionCancel);
        this.btnMap.put("actionCancelCancel", this.actionCancelCancel);
        this.btnMap.put("actionEdit", this.actionEdit);
        this.btnMap.put("actionSave", this.actionSubmit);
        this.btnMap.put("actionCopy", this.actionCopy);
        this.btnMap.put("actionAddLine", this.actionAddRow);
        this.btnMap.put("actionInsertLine", this.actionInstertRow);
        this.btnMap.put("actionRemoveLine", this.actionDelRow);
    }

    public void onLoad() throws Exception {
        this.kdtTaxBaseEntry.checkParsed();
        super.onLoad();
        this.setCompanyFilter();
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
        if (company != null) {
            this.initCostCenterFilter(company.getId().toString());
        } else {
            this.initCostCenterFilter(null);
        }
        this.chkMenuItemSubmitAndAddNew.setSelected(false);
        this.addDateEditor("taxTypeCheckDate");
        this.addTaxRateEditor(TB_TAXRATE);
        this.addNumberEditor(RATE_FIELD);
        this.addEnumEditor(TB_TAXPERIOD);
        this.addF7Editor(TB_TAXITEMTYPE);
        this.setPrecision();
        TDUtils.setPersonAllCU((IUIObject)this, this.kDBizPromptBoxfinancer, false, true);
        TDUtils.setPersonAllCU((IUIObject)this, this.kDBizPromptBoxTaxer, false, true);
        TDUtils.setPersonAllCU((IUIObject)this, this.kDBizPromptBoxlegaler, false, true);
    }

    private void setPrecision() {
        this.txtRegistCapital.setPrecision(4);
        this.txtTotalInvest.setPrecision(4);
    }

    private void initCostCenterFilter(String companyID) throws EASBizException, BOSException {
        NewCostCenterF7 costCenterF7 = new NewCostCenterF7();
        costCenterF7.setNeedAddOrgRange(false);
        costCenterF7.setIsCUFilter(true);
        costCenterF7.setMultiSelect(false);
        costCenterF7.setContainSealUp(false);
        costCenterF7.setNeedConsiderFaultTree(false);
        CompanyOrgUnitInfo company = null;
        if (companyID != null) {
            company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID));
        }
        if (company != null && company.getCU() != null) {
            costCenterF7.setCurrentCUID(company.getCU().getId().toString());
        } else {
            costCenterF7.setCurrentCUID(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        }
        costCenterF7.showCheckBoxOfShowingAllOUs();
        this.prmtCostCenterUnit.setSelector((KDPromptSelector)costCenterF7);
    }

    private void setMenuVisble() {
        this.btnSave.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnCancelCancel.setEnabled(true);
        this.btnCancel.setEnabled(true);
        this.menuItemCancelCancel.setEnabled(true);
        this.menuItemCancel.setEnabled(true);
        this.btnDelRow.setEnabled(true);
        this.btnInsertRow.setEnabled(true);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.btnSave.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
    }

    private void addF7Editor(String tbTaxitemtype) {
        KDTable table = this.kdtTaxBaseEntry;
        KDBizPromptBox taxItemType = new KDBizPromptBox();
        taxItemType.setQueryInfo(TAXITEMTYPE_QUERY);
        taxItemType.setEditFormat("$name$");
        taxItemType.setDisplayFormat("$name$");
        taxItemType.setCommitFormat("$name$");
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$name$"));
        table.getColumn(tbTaxitemtype).setRenderer((IBasicRender)avr);
        table.getColumn(tbTaxitemtype).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)taxItemType));
    }

    private void addDateEditor(String colName) {
        KDTable table = this.kdtTaxBaseEntry;
        table.getColumn(colName).setEditor((ICellEditor)new KDTDefaultCellEditor(new KDDatePicker()));
        String strDateFormat = "%{yyyy-MM-dd}t";
        table.getColumn(colName).getStyleAttributes().setNumberFormat(strDateFormat);
    }

    private void addIntEditor(String tbTaxrate) {
        KDTable table = this.kdtTaxBaseEntry;
        KDFormattedTextField ftf = new KDFormattedTextField();
        ftf.setDataType(0);
        ftf.setSupportedEmpty(true);
        ftf.setNegatived(false);
        ftf.setMaximumValue((Comparable)new Integer(100));
        ftf.setHorizontalAlignment(4);
        table.getColumn(tbTaxrate).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)ftf));
    }

    private void addNumberEditor(String[] colNames) {
        KDTable table = this.kdtTaxBaseEntry;
        KDFormattedTextField ftf = new KDFormattedTextField();
        ftf.setDataType(1);
        ftf.setSupportedEmpty(true);
        ftf.setPrecision(2);
        ftf.setNegatived(false);
        ftf.setRemoveingZeroInDispaly(false);
        ftf.setHorizontalAlignment(4);
        for (int i = 0; i < colNames.length; ++i) {
            table.getColumn(colNames[i]).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)ftf));
        }
    }

    private void addTaxRateEditor(String tbTaxrate) {
        KDTable table = this.kdtTaxBaseEntry;
        KDFormattedTextField ftf = new KDFormattedTextField();
        ftf.setDataType(1);
        ftf.setSupportedEmpty(true);
        ftf.setPrecision(6);
        ftf.setNegatived(false);
        ftf.setRemoveingZeroInDispaly(false);
        ftf.setHorizontalAlignment(4);
        table.getColumn(tbTaxrate).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)ftf));
    }

    private void addEnumEditor(String colName) {
        KDComboBox comboBox = new KDComboBox();
        comboBox.addItems(PeriodTypeEnum.getEnumList().toArray());
        this.kdtTaxBaseEntry.getColumn(colName).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)comboBox));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void loadFields() {
        if (this.editData == null) {
            this.getUIWindow().close();
            return;
        }
        this.removeListeners();
        this.formateRateFields();
        this.setTitle();
        if (this.editData != null) {
            this.editData.getTaxBaseEntry().sort("seq");
        }
        super.loadFields();
        this.initBtnStatus();
        this.initListeners();
        this.initOldData((IObjectValue)this.editData);
    }

    private void setTitle() {
        if (this.editData == null) {
            return;
        }
        String title = TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "TaxBaseTitle", TDUtils.getLocale());
        if (!this.getOprtState().equals("ADDNEW")) {
            if (this.editData.getCompany() == null) {
                return;
            }
            if (this.editData.getCompany().getNumber() != null && !"".equals(this.editData.getCompany().getNumber())) {
                title = title + " " + TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "CompanyNumber", TDUtils.getLocale()) + "\uff1a" + this.editData.getCompany().getNumber();
            }
            if (this.editData.getCompany().getName() != null && !"".equals(this.editData.getCompany().getName())) {
                title = title + " " + TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "CompanyName", TDUtils.getLocale()) + "\uff1a" + this.editData.getCompany().getName();
            }
        }
        this.setUITitle(title);
    }

    private void unFormateRateFields() {
        if (this.editData.getMainRate() != null) {
            BigDecimal mainRate = this.editData.getMainRate().divide(ONE_HUNDRED).setScale(8, 4);
            this.editData.setMainRate(mainRate);
        }
        TaxBaseEntryCollection entrys = this.editData.getTaxBaseEntry();
        for (int i = 0; i < entrys.size(); ++i) {
            TaxBaseEntryInfo entry = entrys.get(i);
            if (entry.getTaxRate() != null) {
                entry.setTaxRate(entry.getTaxRate().divide(ONE_HUNDRED).setScale(8, 4));
            }
            if (entry.getIncomeRatioOne() != null) {
                entry.setIncomeRatioOne(entry.getIncomeRatioOne().divide(ONE_HUNDRED).setScale(4, 4));
            }
            if (entry.getIncomeRatioTwo() == null) continue;
            entry.setIncomeRatioTwo(entry.getIncomeRatioTwo().divide(ONE_HUNDRED).setScale(4, 4));
        }
    }

    private void formateRateFields() {
        if (this.editData == null) {
            return;
        }
        if (this.editData.getMainRate() != null) {
            BigDecimal mainRate = this.editData.getMainRate().multiply(ONE_HUNDRED).setScale(6);
            this.editData.setMainRate(mainRate);
        }
        TaxBaseEntryCollection entrys = this.editData.getTaxBaseEntry();
        for (int i = 0; i < entrys.size(); ++i) {
            TaxBaseEntryInfo entry = entrys.get(i);
            if (entry.getTaxRate() != null) {
                entry.setTaxRate(entry.getTaxRate().multiply(ONE_HUNDRED).setScale(6));
            }
            if (entry.getIncomeRatioOne() != null) {
                entry.setIncomeRatioOne(entry.getIncomeRatioOne().multiply(ONE_HUNDRED).setScale(2));
            }
            if (entry.getIncomeRatioTwo() == null) continue;
            entry.setIncomeRatioTwo(entry.getIncomeRatioTwo().multiply(ONE_HUNDRED).setScale(2));
        }
    }

    private void initBtnStatus() {
        if (this.editData == null || this.editData.getId() == null) {
            this.upLineAction.setEnabled(true);
            this.downLineAction.setEnabled(true);
            this.topLineAction.setEnabled(true);
            this.bottomLineAction.setEnabled(true);
            return;
        }
        TaxInfoState state = this.editData.getState();
        boolean isLight = false;
        if (TaxInfoState.DISABLE.equals((Object)state)) {
            isLight = true;
        }
        this.uiHelper.initBtnStatus(this.btnMap, isLight);
        if (state.equals((Object)TaxInfoState.ABLE)) {
            this.upLineAction.setEnabled(false);
            this.downLineAction.setEnabled(false);
            this.topLineAction.setEnabled(false);
            this.bottomLineAction.setEnabled(false);
        } else if ("EDIT".equals(this.getOprtState())) {
            this.upLineAction.setEnabled(true);
            this.downLineAction.setEnabled(true);
            this.topLineAction.setEnabled(true);
            this.bottomLineAction.setEnabled(true);
        } else if ("VIEW".equals(this.getOprtState())) {
            this.upLineAction.setEnabled(false);
            this.downLineAction.setEnabled(false);
            this.topLineAction.setEnabled(false);
            this.bottomLineAction.setEnabled(false);
        }
    }

    private void removeListeners() {
        this.prmtCompany.removeSelectorListener(this.prmtSelectorCompanyListener);
        this.prmtCompany.removeDataChangeListener(this.prmtCompanyListener);
        this.prmtRegistCountry.removeDataChangeListener(this.prmtRegistCountryListener);
        this.prmtOperateCountry.removeDataChangeListener(this.prmtOperateCountryListener);
        this.prmtRegistProvince.removeDataChangeListener(this.prmtRegistProvinceListener);
        this.prmtOperateProvince.removeDataChangeListener(this.prmtOperateProvinceListener);
        this.txtMainRate.removeDataChangeListener(this.txtMainRateListener);
    }

    private void initListeners() {
        if (this.prmtSelectorCompanyListener == null) {
            this.prmtSelectorCompanyListener = new SelectorListener(){

                public void willShow(SelectorEvent e) {
                    try {
                        TaxBaseEditUI.this.setCompanyFilter();
                    }
                    catch (EASBizException e1) {
                        TaxBaseEditUI.this.handUIException(e1);
                    }
                    catch (BOSException e1) {
                        TaxBaseEditUI.this.handUIException(e1);
                    }
                }
            };
        }
        this.prmtCompany.addSelectorListener(this.prmtSelectorCompanyListener);
        if (this.prmtCompanyListener == null) {
            this.prmtCompanyListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        TaxBaseEditUI.this.prmtCompanyOrgUnit_dataChanged(e);
                    }
                    catch (Exception exc) {
                        TaxBaseEditUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.prmtCompany.addDataChangeListener(this.prmtCompanyListener);
        if (this.prmtRegistCountryListener == null) {
            this.prmtRegistCountryListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        TaxBaseEditUI.this.prmtRegistCountry_dataChanged(e);
                    }
                    catch (Exception exc) {
                        TaxBaseEditUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.prmtRegistCountry.addDataChangeListener(this.prmtRegistCountryListener);
        if (this.prmtOperateCountryListener == null) {
            this.prmtOperateCountryListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        TaxBaseEditUI.this.prmtOperateCountry_dataChanged(e);
                    }
                    catch (Exception exc) {
                        TaxBaseEditUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.prmtOperateCountry.addDataChangeListener(this.prmtOperateCountryListener);
        if (this.prmtRegistProvinceListener == null) {
            this.prmtRegistProvinceListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        TaxBaseEditUI.this.prmtRegistProvince_dataChanged(e);
                    }
                    catch (Exception exc) {
                        TaxBaseEditUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.prmtRegistProvince.addDataChangeListener(this.prmtRegistProvinceListener);
        if (this.prmtOperateProvinceListener == null) {
            this.prmtOperateProvinceListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        TaxBaseEditUI.this.prmtOperateProvince_dataChanged(e);
                    }
                    catch (Exception exc) {
                        TaxBaseEditUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.prmtOperateProvince.addDataChangeListener(this.prmtOperateProvinceListener);
        if (this.txtMainRateListener == null) {
            this.txtMainRateListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        TaxBaseEditUI.this.txtMainRate_dataChanged(e);
                    }
                    catch (Exception exc) {
                        TaxBaseEditUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.txtMainRate.addDataChangeListener(this.txtMainRateListener);
    }

    protected void setCompanyFilter() throws EASBizException, BOSException {
        this.uiHelper.setMainBizOrgFilter();
        FilterInfo orgFilter = this.prmtCompany.getEntityViewInfo().getFilter();
        FilterInfo filter = new FilterInfo();
        SQLExecutor sqlExeutor = new SQLExecutor("select FCompanyId as id from T_TM_TaxBase where FSTATE = '1' ");
        IRowSet rs = sqlExeutor.executeSQL();
        HashSet<String> orgIDs = new HashSet<String>();
        try {
            while (rs.next()) {
                orgIDs.add(rs.getString("id"));
            }
        }
        catch (SQLException e) {
            this.handUIException(e);
        }
        if (orgIDs.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("id", orgIDs, CompareType.NOTINCLUDE));
            orgFilter.mergeFilter(filter, "and");
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(orgFilter);
        this.prmtCompany.setEntityViewInfo(view);
        this.prmtCompany.getQueryAgent().resetRuntimeEntityView();
    }

    protected void txtMainRate_dataChanged(DataChangeEvent e) {
        BigDecimal newMainRate = (BigDecimal)e.getNewValue();
        if (newMainRate.compareTo(new BigDecimal(100)) > 0) {
            MsgBox.showConfirm2((String)(this.txtMainRate.getBoundLabelText() + TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "Rate_tooLarger", TDUtils.getLocale())));
            this.txtMainRate.setValue(e.getOldValue(), false);
        } else if (newMainRate.compareTo(new BigDecimal(0)) < 0) {
            MsgBox.showConfirm2((String)(this.txtMainRate.getBoundLabelText() + TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "Rate_tooSmall", TDUtils.getLocale())));
            this.txtMainRate.setValue(e.getOldValue(), false);
        }
    }

    protected void prmtOperateProvince_dataChanged(DataChangeEvent e) {
        this.initCityFilter(2);
    }

    protected void prmtRegistProvince_dataChanged(DataChangeEvent e) {
        this.initCityFilter(1);
    }

    private void initCityFilter(int province) {
        ProvinceInfo provinceInfo = null;
        if (province == 1) {
            if (this.prmtRegistProvince.getValue() == null) {
                this.prmtRegistCity.setValue(null);
                return;
            }
            this.prmtRegistCity.setValue(null);
            provinceInfo = (ProvinceInfo)this.prmtRegistProvince.getValue();
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("PROVINCE.NUMBER", (Object)provinceInfo.getNumber(), CompareType.EQUALS));
            entityViewInfo.setFilter(filter);
            this.prmtRegistCity.setEntityViewInfo(entityViewInfo);
        } else {
            if (this.prmtOperateProvince.getValue() == null) {
                this.prmtOperateCity.setValue(null);
                return;
            }
            this.prmtOperateCity.setValue(null);
            provinceInfo = (ProvinceInfo)this.prmtOperateProvince.getValue();
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("PROVINCE.NUMBER", (Object)provinceInfo.getNumber(), CompareType.EQUALS));
            entityViewInfo.setFilter(filter);
            this.prmtOperateCity.setEntityViewInfo(entityViewInfo);
        }
    }

    protected void prmtOperateCountry_dataChanged(DataChangeEvent e) {
        this.initProvinceFilter(2);
    }

    protected void prmtRegistCountry_dataChanged(DataChangeEvent e) {
        this.initProvinceFilter(1);
    }

    private void initProvinceFilter(int country) {
        CountryInfo countryInfo = null;
        if (country == 1) {
            if (this.prmtRegistCountry.getValue() == null) {
                this.prmtRegistProvince.setValue(null);
                this.prmtRegistCity.setValue(null);
                return;
            }
            this.prmtRegistProvince.setValue(null);
            this.prmtRegistCity.setValue(null);
            countryInfo = (CountryInfo)this.prmtRegistCountry.getValue();
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("COUNTRY.NUMBER", (Object)countryInfo.getNumber(), CompareType.EQUALS));
            entityViewInfo.setFilter(filter);
            this.prmtRegistProvince.setEntityViewInfo(entityViewInfo);
        } else {
            if (this.prmtOperateCountry.getValue() == null) {
                this.prmtOperateProvince.setValue(null);
                this.prmtOperateCity.setValue(null);
                return;
            }
            this.prmtOperateProvince.setValue(null);
            this.prmtOperateCity.setValue(null);
            countryInfo = (CountryInfo)this.prmtOperateCountry.getValue();
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("COUNTRY.NUMBER", (Object)countryInfo.getNumber(), CompareType.EQUALS));
            entityViewInfo.setFilter(filter);
            this.prmtOperateProvince.setEntityViewInfo(entityViewInfo);
        }
    }

    protected void prmtCompanyOrgUnit_dataChanged(DataChangeEvent e) throws EASBizException, BOSException {
        this.kDBizPromptBoxfinancer.setValue(null);
        this.kDBizPromptBoxTaxer.setValue(null);
        this.kDBizPromptBoxlegaler.setValue(null);
        this.prmtCostCenterUnit.setValue(null);
        if (this.prmtCompany.getValue() == null) {
            this.initCostCenterFilter(null);
            return;
        }
        CompanyOrgUnitInfo tempOrgUnit = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
        this.initCostCenterFilter(tempOrgUnit.getId().toString());
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        TaxBaseInfo editData = (TaxBaseInfo)newData;
        editData.setNumber(null);
        editData.setName(null);
        editData.setCompany(null);
        editData.setLastUpdateTime(null);
        editData.setLastUpdateUser(null);
        Timestamp time = new Timestamp(new Date().getTime());
        editData.setCreateTime(time);
        editData.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        this.unFormateRateFields();
    }

    @Override
    public void upLineAction_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowIndex = this.getDetailTable().getSelectManager().get(0).getTop();
        int colIndex = this.getDetailTable().getSelectManager().get(0).getLeft();
        if (rowIndex == 0) {
            return;
        }
        int toRowIndex = rowIndex - 1;
        this.getDetailTable().moveRow(rowIndex, toRowIndex);
        this.getDetailTable().getSelectManager().set(toRowIndex, colIndex);
    }

    @Override
    public void downLineAction_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowIndex = this.getDetailTable().getSelectManager().get(0).getTop();
        int colIndex = this.getDetailTable().getSelectManager().get(0).getLeft();
        if (rowIndex == this.getDetailTable().getRowCount() - 1) {
            return;
        }
        int toRowIndex = rowIndex + 1;
        this.getDetailTable().moveRow(rowIndex, toRowIndex);
        this.getDetailTable().getSelectManager().set(toRowIndex, colIndex);
    }

    @Override
    public void topLineAction_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowIndex = this.getDetailTable().getSelectManager().get(0).getTop();
        int colIndex = this.getDetailTable().getSelectManager().get(0).getLeft();
        if (rowIndex == 0) {
            return;
        }
        int toRowIndex = 0;
        this.getDetailTable().moveRow(rowIndex, toRowIndex);
        this.getDetailTable().getSelectManager().set(toRowIndex, colIndex);
    }

    @Override
    public void bottomLineAction_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowIndex = this.getDetailTable().getSelectManager().get(0).getTop();
        int colIndex = this.getDetailTable().getSelectManager().get(0).getLeft();
        if (rowIndex == this.getDetailTable().getRowCount() - 1) {
            return;
        }
        int toRowIndex = this.getDetailTable().getRowCount() - 1;
        this.getDetailTable().moveRow(rowIndex, toRowIndex);
        this.getDetailTable().getSelectManager().set(toRowIndex, colIndex);
    }

    public void checkSelected() {
        if (this.getDetailTable().getRowCount() == 0 || this.getDetailTable().getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionAddRow_actionPerformed(ActionEvent e) throws Exception {
        this.kdtTaxBaseEntry.addRow();
        if (this.kdtTaxBaseEntry.getRowCount() > 0) {
            this.btnDelRow.setEnabled(true);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.initBtnStatus();
    }

    @Override
    public void actionInstertRow_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdtTaxBaseEntry.getSelectManager().size() > 0) {
            int top = this.kdtTaxBaseEntry.getSelectManager().get().getTop();
            this.kdtTaxBaseEntry.addRow(top);
        } else {
            this.kdtTaxBaseEntry.addRow();
        }
        if (this.kdtTaxBaseEntry.getRowCount() > 0) {
            this.btnDelRow.setEnabled(true);
        }
    }

    @Override
    public void actionDelRow_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.kdtTaxBaseEntry);
        if (selectRows == null || selectRows.length == 0) {
            return;
        }
        for (int i = 0; i < selectRows.length; ++i) {
            this.kdtTaxBaseEntry.removeRow(selectRows[i]);
        }
        if (this.kdtTaxBaseEntry.getRowCount() == 0) {
            this.btnDelRow.setEnabled(false);
        }
    }

    protected KDTable getDetailTable() {
        return this.kdtTaxBaseEntry;
    }

    protected IObjectValue createNewData() {
        TaxBaseInfo info = new TaxBaseInfo();
        info.setState(TaxInfoState.ABLE);
        Date date = new Date();
        info.setCreateTime(new Timestamp(date.getTime()));
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.getTaxBaseEntry().add(this.createNewDetailData());
        return info;
    }

    protected TaxBaseEntryInfo createNewDetailData() {
        return new TaxBaseEntryInfo();
    }

    private void refresh(IObjectPK pk) throws Exception {
        this.setDataObject(this.getValue(pk));
        this.loadFields();
        this.initOldData((IObjectValue)this.editData);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        TDUtils.removeNullRow(this.kdtTaxBaseEntry, new String[]{TB_TAXITEMTYPE}, true);
        this.inputCheck();
        super.actionSave_actionPerformed(e);
        if (!this.getOprtState().equals(OprtState.ADDNEW)) {
            if (this.editData.getState() != null && TaxInfoState.ABLE.equals((Object)this.editData.getState())) {
                this.setOprtState("VIEW");
            } else {
                this.setOprtState("EDIT");
            }
        }
        this.setDataObject((IObjectValue)this.editData);
        this.unFormateRateFields();
        this.loadFields();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        this.unFormateRateFields();
    }

    private void inputCheck() {
        StringBuffer sb = new StringBuffer();
        if (this.txtNumber.getText().isEmpty()) {
            sb.append("\u3001" + this.txtNumber.getBoundLabelText());
        }
        if (this.txtName.getText().isEmpty()) {
            sb.append("\u3001" + this.contName.getBoundLabelText());
        }
        if (this.prmtCompany.getValue() == null) {
            sb.append("\u3001" + this.contCompany.getBoundLabelText());
        }
        if (sb.length() > 0) {
            sb.append(TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "Data_NotNull", TDUtils.getLocale())).append("\r\n");
            MsgBox.showWarning((String)sb.substring(1));
            SysUtil.abort();
        }
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        String billId = this.editData.getId().toString();
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(billId);
        if (!this.uiHelper.modifySaveOrExit((ItemAction)this.actionSubmit, this.btnSubmit, (ItemAction)this.actionSave, this.btnSave, this.isModifySave())) {
            return;
        }
        ArrayList errors = TaxBaseFactory.getRemoteInstance().cancelCancel(new HashSet(ids));
        if (errors.size() > 0) {
            MsgBox.showWarning((Component)((Object)this), (String)((String)errors.get(0)));
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Startup_OK"));
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)billId));
            this.setDataObject(this.getValue((IObjectPK)pk));
            if (this.editData.getState() != null && TaxInfoState.ABLE.equals((Object)this.editData.getState())) {
                this.setOprtState("VIEW");
            } else {
                this.setOprtState("EDIT");
            }
            this.setDataObject((IObjectValue)this.editData);
            this.loadFields();
        }
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        String billId = this.editData.getId().toString();
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(billId);
        ArrayList errors = TaxBaseFactory.getRemoteInstance().cancel(new HashSet(ids));
        if (errors.size() > 0) {
            MsgBox.showWarning((Component)((Object)this), (String)((String)errors.get(0)));
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Forbid _OK"));
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)billId));
            this.refresh((IObjectPK)pk);
        }
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        IObjectPK pk = null;
        try {
            pk = this.uiHelper.getOrgPK();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (pk != null) {
            return pk;
        }
        if (this.getMainOrgContext() != null && this.getMainOrgContext().get((Object)this.getMainBizOrgType()) != null) {
            pk = new ObjectUuidPK(((OrgUnitInfo)this.getMainOrgContext().get((Object)this.getMainBizOrgType())).getId().toString());
            return pk;
        }
        return super.getOrgPK(action);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TaxBaseFactory.getRemoteInstance();
    }

    protected String getPermissionItem(String status) {
        if ("ADDNEW".equals(status)) {
            return "im_makeInvoice_new";
        }
        return null;
    }

    @Override
    public String getBizOrgProperty(OrgType orgType) throws BOSException, EASBizException {
        return "company";
    }

    @Override
    public ICoreBase getPermInterface() throws Exception {
        return this.getBizInterface();
    }

    @Override
    public String getPermItem(String status) {
        return "taxbase_new";
    }

    @Override
    public KDBizPromptBox getPermMainBizOrg() {
        return this.prmtCompany;
    }

    @Override
    public IObjectValue getValueObject() {
        return this.editData;
    }
}

