/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.basedata.client;

import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeFactory;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeSignEnum;
import com.kingdee.eas.tm.td.basedata.client.AbstractTaxItemTypeEditUI;
import com.kingdee.eas.tm.td.common.uihelper.EditUIHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import org.apache.log4j.Logger;

public class TaxItemTypeEditUI
extends AbstractTaxItemTypeEditUI {
    private static final Logger logger = CoreUIObject.getLogger(TaxItemTypeEditUI.class);
    private String currentCUID;
    private EditUIHelper uiHelper = new EditUIHelper(this);

    public void onLoad() throws Exception {
        super.onLoad();
        this.initBtnStatus();
    }

    protected void initBtnStatus() {
        if (this.editData != null && TaxItemTypeSignEnum.Menu.equals((Object)this.editData.getSign())) {
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
        } else {
            this.actionEdit.setEnabled(true);
            this.actionRemove.setEnabled(true);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.initBtnStatus();
        this.currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
    }

    @Override
    public void storeFields() {
        this.txtSimpleName.setText(this.txtSimName.getText());
        super.storeFields();
    }

    protected IObjectValue createNewData() {
        TaxItemTypeInfo info = new TaxItemTypeInfo();
        info.setSign(TaxItemTypeSignEnum.NULL);
        info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        Date now = new Date();
        info.setCreateTime(new Timestamp(now.getTime()));
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TaxItemTypeFactory.getRemoteInstance();
    }

    private void refresh(IObjectPK pk) throws Exception {
        this.setDataObject(this.getValue(pk));
        this.loadFields();
        this.initOldData((IObjectValue)this.editData);
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        TaxItemTypeInfo info = (TaxItemTypeInfo)newData;
        info.setNumber(null);
        info.setName(null);
        info.setSimName(null);
        info.setSimpleName(null);
        info.setSign(TaxItemTypeSignEnum.NULL);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkRequiredFields();
        super.actionSubmit_actionPerformed(e);
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
    }

    protected void checkRequiredFields() {
        StringBuffer sb = new StringBuffer();
        if (this.txtNumber.getText().isEmpty()) {
            sb.append(TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxItemTypeResource", "NUMBER", TDUtils.getLocale()));
        }
        if (this.txtName.getText().isEmpty()) {
            sb.append(TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxItemTypeResource", "NAME", TDUtils.getLocale()));
        }
        if (this.txtSimName.getText().isEmpty()) {
            sb.append(TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxItemTypeResource", "SIMNAME", TDUtils.getLocale()));
        }
        if (this.comboSign.getSelectedItem() == null) {
            sb.append(TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxItemTypeResource", "SIGN", TDUtils.getLocale()));
        }
        if (sb.length() > 0) {
            sb.append(TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxItemTypeResource", "NOTNULL", TDUtils.getLocale())).append("\r\n");
            MsgBox.showWarning((String)sb.substring(1));
            SysUtil.abort();
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanAddnew(this.currentCUID);
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanEdit(this.currentCUID, this.editData.getId().toString());
        super.actionEdit_actionPerformed(e);
        this.loadFields();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.editData.getId().toString());
        this.uiHelper.checkCanRemove(this.currentCUID, ids);
        super.actionRemove_actionPerformed(e);
        this.initDataStatus();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }
}

