/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.TaxReportTypeFactory;
import com.kingdee.eas.tm.td.basedata.TaxReportTypeInfo;
import com.kingdee.eas.tm.td.basedata.client.AbstractTaxReportTypeEditUI;
import com.kingdee.eas.tm.td.cloud.EnableStateEnum;
import com.kingdee.eas.tm.td.common.permsupport.IPermSupport4EditUI;
import com.kingdee.eas.tm.td.common.uihelper.EditUIHelper;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class TaxReportTypeEditUI
extends AbstractTaxReportTypeEditUI
implements IPermSupport4EditUI {
    private static final Logger logger = CoreUIObject.getLogger(TaxReportTypeEditUI.class);
    private static final String RES = "com.kingdee.eas.tm.td.basedata.TaxBaseResource";
    private EditUIHelper uiHelper = new EditUIHelper(this);
    private String currentCUid = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initCtr();
    }

    private void initCtr() {
        if (this.editData.getId() == null) {
            this.btnCancel.setEnabled(false);
            this.btnCancelCancel.setEnabled(false);
        }
        if (EnableStateEnum.DISABLE.equals((Object)this.editData.getStatus())) {
            this.btnCancel.setEnabled(false);
            this.btnCancelCancel.setEnabled(true);
            this.btnEdit.setEnabled(true);
        } else if (EnableStateEnum.ENABLE.equals((Object)this.editData.getStatus())) {
            this.btnCancel.setEnabled(true);
            this.btnCancelCancel.setEnabled(false);
            this.btnEdit.setEnabled(false);
        }
        this.prmtCU.setEditable(false);
        this.comboStatus.setEditable(false);
        this.btnSubmit.setVisible(false);
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.initCtr();
        this.currentCUid = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }

    private void initNumber() {
        OrgUnitInfo info = SysContext.getSysContext().getCurrentOrgUnit(this.getMainBizOrgType());
        BOSUuid id = info.getId();
        try {
            ICodingRuleManager rule = CodingRuleManagerFactory.getRemoteInstance();
            String number = "";
            if (rule != null) {
                number = rule.getNumber((IObjectValue)this.editData, id.toString());
            }
            if (this.oprtState.equals("ADDNEW") && this.editData.getNumber() == null) {
                this.txtNumber.setText(number);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void refresh(IObjectPK pk) throws Exception {
        this.setDataObject(this.getValue(pk));
        this.loadFields();
        this.initOldData((IObjectValue)this.editData);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanEdit(this.currentCUid, this.editData.getId().toString());
        super.actionEdit_actionPerformed(e);
        this.initCtr();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanAddnew(this.currentCUid);
        super.actionAddNew_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.editData.getId().toString());
        this.uiHelper.checkCanRemove(this.currentCUid, ids);
        super.actionRemove_actionPerformed(e);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        this.setOprtState("VIEW");
        if (this.editData != null && this.editData.getId() != null) {
            String billId = this.editData.getId().toString();
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)billId));
            this.refresh((IObjectPK)pk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionCancel_actionPerformed(ActionEvent e) {
        ArrayList<String> ids = new ArrayList<String>();
        try {
            if (this.editData != null && this.editData.getId() != null) {
                String billId = this.editData.getId().toString();
                ids.add(billId);
                this.uiHelper.checkBaseDataPermission(this.currentCUid, ids);
                TDUtils.tryLock(ids);
                this.comboStatus.setSelectedIndex(1);
                super.actionCancel_actionPerformed(e);
                ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)billId));
                this.refresh((IObjectPK)pk);
            }
        }
        catch (Exception e2) {
            this.handUIException(e2);
        }
        finally {
            TDUtils.releaseLock(ids);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionCancelCancel_actionPerformed(ActionEvent e) {
        ArrayList<String> ids = new ArrayList<String>();
        try {
            if (this.editData != null && this.editData.getId() != null) {
                String billId = this.editData.getId().toString();
                ids.add(billId);
                this.uiHelper.checkBaseDataPermission(this.currentCUid, ids);
                TDUtils.tryLock(ids);
                this.comboStatus.setSelectedIndex(0);
                super.actionCancelCancel_actionPerformed(e);
                ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)billId));
                this.refresh((IObjectPK)pk);
            }
        }
        catch (Exception e2) {
            this.handUIException(e2);
        }
        finally {
            TDUtils.releaseLock(ids);
        }
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        if (newData instanceof TaxReportTypeInfo) {
            TaxReportTypeInfo info = (TaxReportTypeInfo)newData;
            info.setNumber(info.getNumber() + "_copy");
            info.setName(info.getName() + "_copy");
            info.setDescription(null);
        }
    }

    protected KDTable getDetailTable() {
        return null;
    }

    protected IObjectValue createNewData() {
        TaxReportTypeInfo info = new TaxReportTypeInfo();
        info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        info.setStatus(EnableStateEnum.ENABLE);
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TaxReportTypeFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    public String getBizOrgProperty(OrgType orgType) throws BOSException, EASBizException {
        return "CU";
    }

    @Override
    public ICoreBase getPermInterface() throws Exception {
        return this.getBizInterface();
    }

    @Override
    public String getPermItem(String status) {
        return null;
    }

    @Override
    public KDBizPromptBox getPermMainBizOrg() {
        return null;
    }

    @Override
    public IObjectValue getValueObject() {
        return this.editData;
    }
}

