/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.basedata.client.formula;

import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.kscript.parser.Lexer;
import com.kingdee.bos.kscript.parser.Token;
import com.kingdee.bos.kscript.parser.TokenList;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.service.formula.api.IVarInfo;
import com.kingdee.bos.service.formula.engine.AliasTransformer;
import com.kingdee.eas.tm.td.basedata.client.formula.EntityTransformerHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class EntityAliasTransformerHelper {
    public static String TYPE_VARINFO = "varinfo";
    public static String TYPE_PROPERTY = "property";
    public static String TYPE_METHOD = "method";
    public static String TYPE_OTHER = "other";
    public static String TYPE_CONSTANT = "constant";
    private TokenList tokenlist;
    private List<IVarInfo> varList;
    private Map<String, EntityObjectInfo> tableMap;
    private List analyseList = new ArrayList();

    public EntityAliasTransformerHelper(Map<String, EntityObjectInfo> tableMap, List<IVarInfo> varList, TokenList tokens) {
        this.tableMap = tableMap;
        this.varList = varList;
        this.tokenlist = tokens;
        try {
            this.analyse();
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
    }

    private void analyse() throws ParserException {
        Token token;
        if (this.tokenlist == null) {
            return;
        }
        this.analyseList.clear();
        int index = 0;
        while ((token = this.tokenlist.lookup(index)) != null && token.type != 12) {
            if (this.isVarinfo(token)) {
                this.analyseList.add(TYPE_VARINFO);
            } else if (this.isProperty(index)) {
                this.analyseList.add(TYPE_PROPERTY);
            } else if (this.isMethod(index)) {
                this.analyseList.add(TYPE_METHOD);
            } else if (this.isConstant(index)) {
                this.analyseList.add(TYPE_CONSTANT);
            } else {
                this.analyseList.add(TYPE_OTHER);
            }
            ++index;
        }
    }

    private boolean isVarinfo(Token token) {
        if (this.varList != null && token != null) {
            for (IVarInfo varinfo : this.varList) {
                String name = varinfo.getVarName();
                if (!name.equalsIgnoreCase(token.value)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isProperty(int index) throws ParserException {
        if (this.tokenlist != null && index > 0) {
            Token self = this.tokenlist.lookup(index);
            if (self != null && self.type != 1) {
                return false;
            }
            Token token = this.tokenlist.lookup(index + 1);
            if (token == null || token.type == 12 || Token.PeriodToken.equals(token) || 4 == token.type || token.value.equals(";") || 5 == token.type && !Token.OpenBraceToken.equals(token) || token.value.equalsIgnoreCase("CASE") || token.value.equalsIgnoreCase("WHEN") || token.value.equalsIgnoreCase("THEN") || token.value.equalsIgnoreCase("ELSE") || token.value.equalsIgnoreCase("END") || token.value.equalsIgnoreCase("NULL")) {
                return true;
            }
        }
        return false;
    }

    private boolean isMethod(int index) throws ParserException {
        if (this.tokenlist != null && index > 0) {
            Token self = this.tokenlist.lookup(index);
            Token token = this.tokenlist.lookup(index + 1);
            Token bToken = this.tokenlist.lookup(index - 1);
            if (1 == self.type && 5 == token.type && Token.OpenBraceToken.equals(token) && bToken.value != null && bToken.value.equals(".")) {
                return true;
            }
        }
        return false;
    }

    private boolean isConstant(int index) throws ParserException {
        if (index < 1) {
            return false;
        }
        Token token = this.tokenlist.lookup(index);
        return 6 == token.type;
    }

    private boolean isCaseWord(int index) throws ParserException {
        if (index < 0) {
            return false;
        }
        Token token = this.tokenlist.lookup(index);
        return 1 == token.type && (token.value.equalsIgnoreCase("CASE") || token.value.equalsIgnoreCase("WHEN") || token.value.equalsIgnoreCase("THEN") || token.value.equalsIgnoreCase("ELSE") || token.value.equalsIgnoreCase("END") || token.value.equalsIgnoreCase("NULL"));
    }

    private EntityObjectInfo getPropertyOrMethodBO(int index) throws ParserException {
        if (index < 2) {
            return null;
        }
        Token beforToken = this.tokenlist.lookup(index - 2);
        String type = (String)this.analyseList.get(index - 2);
        while (!TYPE_VARINFO.equals(type) && !TYPE_PROPERTY.equals(type) && TYPE_METHOD.equals(type) && --index >= 0) {
            beforToken = this.tokenlist.lookup(index);
            type = (String)this.analyseList.get(index);
        }
        if (TYPE_VARINFO.equals(type)) {
            IVarInfo var = this.getVarinfoByName(beforToken.value);
            return this.tableMap.get(var.getVarName());
        }
        return null;
    }

    private IVarInfo getVarinfoByName(String varName) {
        if (this.varList != null) {
            for (IVarInfo varinfo : this.varList) {
                String name = varinfo.getVarName();
                if (!name.equalsIgnoreCase(varName)) continue;
                return varinfo;
            }
        }
        return null;
    }

    public TokenList getAliasTokenList() throws ParserException {
        Token token;
        StringBuffer aliassb = new StringBuffer();
        int index = 0;
        String fieldName = null;
        while ((token = this.tokenlist.lookup(index)) != null && token.type != 12) {
            int i;
            int j;
            boolean find;
            EntityObjectInfo bo;
            if (this.isVarinfo(token)) {
                IVarInfo var = this.getVarinfoByName(token.value);
                aliassb.append(var.getVarAlias());
            } else if (this.isCaseWord(index)) {
                aliassb.append(" ");
                aliassb.append(token.value);
                aliassb.append(" ");
            } else if (this.isProperty(index)) {
                bo = this.getPropertyOrMethodBO(index);
                find = false;
                if (bo != null) {
                    PropertyCollection pc = bo.getInheritedNoDuplicatedProperties();
                    j = pc.size();
                    for (i = 0; i < j; ++i) {
                        PropertyInfo pro = pc.get(i);
                        if (pro.getMappingField() == null || (fieldName = EntityTransformerHelper.getPropertyName(pro)) == null || !fieldName.equalsIgnoreCase(token.value)) continue;
                        aliassb.append(AliasTransformer.propTransform((String)pro.getAlias()));
                        find = true;
                        break;
                    }
                }
                if (!find) {
                    aliassb.append(token.value);
                }
            } else if (this.isMethod(index)) {
                bo = this.getPropertyOrMethodBO(index);
                find = false;
                if (bo != null) {
                    MethodCollection mc = bo.getAllMethods();
                    j = mc.size();
                    for (i = 0; i < j; ++i) {
                        MethodInfo method = mc.get(i);
                        if (method.getName() == null || !method.getName().equals(token.value)) continue;
                        aliassb.append(AliasTransformer.propTransform((String)method.getAlias()));
                        find = true;
                        break;
                    }
                }
                if (!find) {
                    aliassb.append(token.value);
                }
            } else if (this.isConstant(index)) {
                aliassb.append("\"");
                aliassb.append(token.value);
                aliassb.append("\"");
            } else {
                aliassb.append(token.value);
            }
            ++index;
        }
        Lexer _lexer = new Lexer(aliassb.toString());
        TokenList _tokenList = new TokenList(_lexer);
        return _tokenList;
    }
}

