/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.basedata.dataImport.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.td.basedata.dataImport.impl.IDataImport;
import com.kingdee.eas.tm.td.basedata.dataImport.model.DataImportParams;
import com.kingdee.eas.tm.td.basedata.dataImport.model.DataImportResult;
import com.kingdee.eas.tm.td.basedata.dataImport.model.DataImportTypeEnum;
import com.kingdee.eas.tm.td.utils.CollectionUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractDataImport
implements IDataImport {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.basedata.dataImport.impl.AbstractDataImport");
    public static final String rootCUID = "00000000-0000-0000-0000-000000000000CCE7AED4";
    protected Context ctx = null;
    protected DataImportParams params = null;
    protected String importCuId = null;
    protected String dsTempTableName = null;
    protected String dsEntryTempTableName = null;
    protected String dsTakeDataTableName = null;
    protected String orgAccountTempTableName = null;
    protected String fieldMappingTempTableName = null;
    protected String relationIds = null;
    protected String dataSourceID = null;
    protected int successCount = 0;
    protected int failCount = 0;
    protected CompanyOrgUnitInfo company = null;
    protected DataImportResult result = new DataImportResult();

    public AbstractDataImport(Context ctx, DataImportParams params) {
        this.ctx = ctx;
        this.params = params;
    }

    @Override
    public DataImportResult dataImport() throws BOSException, EASBizException {
        try {
            this.beforeDataImport();
            this.doDataImport();
            this.afterDataImport();
            this.result.setSuccessCount(this.successCount);
            this.result.setFailCount(this.failCount);
        }
        catch (Throwable e) {
            logger.error((Object)e);
            this.result.setDetailMsg(e.getMessage());
        }
        return this.result;
    }

    protected void beforeDataImport() throws BOSException, EASBizException {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)this.ctx);
        ObjectUuidPK userPk = new ObjectUuidPK(BOSUuid.read((String)userInfo.getId().toString()));
        ObjectUuidPK orgPk = new ObjectUuidPK(BOSUuid.read((String)this.params.getCompanyId()));
        if (DataImportTypeEnum.ACCOUNT.equals((Object)this.params.getImportType())) {
            PermissionFactory.getLocalInstance((Context)this.ctx).checkFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, this.params.getImportPermItem());
        } else if (DataImportTypeEnum.DRAFTITEM.equals((Object)this.params.getImportType())) {
            PermissionFactory.getLocalInstance((Context)this.ctx).checkFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, this.params.getImportPermItem());
        }
        this.company = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.params.getCompanyId()));
        this.delOldRecords();
        this.importCuId = this.params.getImportCuId() == null ? this.getImportCuId() : this.params.getImportCuId();
    }

    protected abstract String getImportCuId() throws BOSException, EASBizException;

    protected void doDataImport() throws BOSException, EASBizException {
        this.insertNewRecords();
    }

    protected void afterDataImport() throws BOSException, EASBizException {
        this.checkNumberDup();
    }

    protected void checkNameDup() throws BOSException, EASBizException {
        this.checkNumberOrNameDup("name");
    }

    protected abstract void checkNumberOrNameDup(String var1) throws BOSException, EASBizException;

    protected void checkNumberDup() throws BOSException, EASBizException {
        this.checkNumberOrNameDup("number");
    }

    protected void delOldRecords() throws BOSException, EASBizException {
        this.delDataSourceRelationRecords();
        this.delDataSourceConfigRelationRecords();
        this.delOrgConfigRelationRecords();
    }

    protected void delDataSourceRelationRecords() throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" delete from  T_TM_OrgToAccount where FConditionID  in (");
        sql.append(this.getSelectSql("takeContdition")).append(" )");
        DbUtil.execute((Context)this.ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" delete from  T_TM_FieldsMapping where FConditionID  in (");
        sql.append(this.getSelectSql("takeContdition")).append(" )");
        DbUtil.execute((Context)this.ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" delete from  T_TM_TakeDataContdition where fid  in (");
        sql.append(this.getSelectSql("takeContdition")).append(" )");
        DbUtil.execute((Context)this.ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" delete from  T_TM_DataSourceEntry where fid  in (");
        sql.append(this.getSelectSql("dsEntry")).append(" )");
        DbUtil.execute((Context)this.ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" delete from  T_TM_DataSource where fid  in (");
        sql.append(this.getSelectSql("dataSource")).append(" )");
        DbUtil.execute((Context)this.ctx, (String)sql.toString());
    }

    protected abstract void delDataSourceConfigRelationRecords() throws BOSException, EASBizException;

    protected abstract void delOrgConfigRelationRecords() throws BOSException, EASBizException;

    protected abstract String getSelectSql(String var1) throws BOSException, EASBizException;

    protected void insertNewRecords() throws BOSException, EASBizException {
        this.insertOrgConfigRelationRecords();
        this.insertDataSourceRelationRecords();
    }

    protected abstract void insertOrgConfigRelationRecords() throws BOSException, EASBizException;

    protected void insertDataSourceRelationRecords() throws BOSException, EASBizException {
        HashSet<String> relationID = new HashSet<String>();
        HashSet<String> dsid = new HashSet<String>();
        Map<String, String> dsMap = this.getCUDataSourceMap();
        if (dsMap == null) {
            return;
        }
        for (Map.Entry<String, String> item : dsMap.entrySet()) {
            relationID.add(item.getValue());
            dsid.add(item.getKey());
        }
        this.relationIds = CollectionUtil.convertSet2String(relationID, ",", true);
        this.dataSourceID = CollectionUtil.convertSet2String(dsid, ",", true);
        try {
            this.dsTempTableName = TempTablePool.getInstance((Context)this.ctx).createTempTableName();
            this.dsEntryTempTableName = TempTablePool.getInstance((Context)this.ctx).createTempTableName();
            this.dsTakeDataTableName = TempTablePool.getInstance((Context)this.ctx).createTempTableName();
            this.orgAccountTempTableName = TempTablePool.getInstance((Context)this.ctx).createTempTableName();
            this.fieldMappingTempTableName = TempTablePool.getInstance((Context)this.ctx).createTempTableName();
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
        StringBuffer insertDSSql = new StringBuffer();
        insertDSSql.append(" select * into " + this.dsTempTableName + " from T_TM_DataSource where fid in (" + this.dataSourceID + ")");
        StringBuffer insertDSEntrySql = new StringBuffer();
        insertDSEntrySql.append("select * into " + this.dsEntryTempTableName + " from T_TM_DataSourceEntry where FParentID in ");
        insertDSEntrySql.append(" ( select fid from " + this.dsTempTableName + " )");
        StringBuffer insertDSGetDataSql = new StringBuffer();
        insertDSGetDataSql.append("select * into " + this.dsTakeDataTableName + " from T_TM_TakeDataContdition where FDataSourceID in ");
        insertDSGetDataSql.append(" ( select fid from " + this.dsTempTableName + " )");
        StringBuffer insertOrgAccountSql = new StringBuffer();
        insertOrgAccountSql.append("select * into " + this.orgAccountTempTableName + " from T_TM_OrgToAccount where FConditionID in ");
        insertOrgAccountSql.append(" ( select fid from " + this.dsTakeDataTableName + " )");
        StringBuffer insertFieldMappingSql = new StringBuffer();
        insertFieldMappingSql.append("select * into " + this.fieldMappingTempTableName + " from T_TM_FieldsMapping where FConditionID in ");
        insertFieldMappingSql.append(" ( select fid from " + this.dsTakeDataTableName + " )");
        DbUtil.execute((Context)this.ctx, (String)insertDSSql.toString());
        DbUtil.execute((Context)this.ctx, (String)insertDSEntrySql.toString());
        DbUtil.execute((Context)this.ctx, (String)insertDSGetDataSql.toString());
        DbUtil.execute((Context)this.ctx, (String)insertOrgAccountSql.toString());
        DbUtil.execute((Context)this.ctx, (String)insertFieldMappingSql.toString());
        String sql = " alter table " + this.dsTempTableName + " add fnewid varchar(44)";
        String sql1 = " alter table " + this.dsEntryTempTableName + " add fnewId varchar(44)";
        String sql2 = " alter table " + this.dsEntryTempTableName + " add fnewParentId varchar(44)";
        String sql3 = " alter table " + this.dsEntryTempTableName + " add fnewParentTableId varchar(44)";
        String sql10 = " alter table " + this.dsTakeDataTableName + " add fnewid varchar(44)";
        DbUtil.execute((Context)this.ctx, (String)sql);
        DbUtil.execute((Context)this.ctx, (String)sql1);
        DbUtil.execute((Context)this.ctx, (String)sql2);
        DbUtil.execute((Context)this.ctx, (String)sql3);
        DbUtil.execute((Context)this.ctx, (String)sql10);
        String sql4 = " update " + this.dsEntryTempTableName + " set fnewid = newbosid('910BFDFB') ";
        DbUtil.execute((Context)this.ctx, (String)sql4);
        StringBuffer sql5 = new StringBuffer();
        sql5.append(" update " + this.dsEntryTempTableName + " t10 set (fnewParentTableId,fparenttableId) =  ( ");
        sql5.append(" select t1.fnewid ,t1.fnewid from  " + this.dsEntryTempTableName + " t1 inner join " + this.dsEntryTempTableName + " t2  ");
        sql5.append(" on t1.fid = t2.fparenttableId where  t10.fid = t2.fid ");
        sql5.append(" ) ");
        DbUtil.execute((Context)this.ctx, (String)sql5.toString());
        String sql6 = " update " + this.dsTempTableName + " set fnewid = newbosid('AF4374B7') ";
        DbUtil.execute((Context)this.ctx, (String)sql6);
        StringBuffer sql7 = new StringBuffer();
        sql7.append(" update " + this.dsEntryTempTableName + " t10 set (fnewParentId)=( ");
        sql7.append(" select t1.fnewid from " + this.dsTempTableName + " t1 inner join " + this.dsEntryTempTableName + " t2 on t1.fid = t2.fparentid ");
        sql7.append(" where t2.fid = t10.fid ");
        sql7.append(" ) ");
        DbUtil.execute((Context)this.ctx, (String)sql7.toString());
        StringBuffer sql8 = new StringBuffer();
        sql8.append(" update " + this.dsTakeDataTableName + " t10 set (FDataSourceID,fnewid) = ( ");
        sql8.append(" select t2.fnewid,newbosid('D91004CE') from " + this.dsTakeDataTableName + " t1 inner join " + this.dsTempTableName + " t2 on t1.FDataSourceID = t2.fid ");
        sql8.append(" where t10.fid = t1.fid  ");
        sql8.append(" ) ");
        DbUtil.execute((Context)this.ctx, (String)sql8.toString());
        StringBuffer sql11 = new StringBuffer();
        sql11.append(" update " + this.orgAccountTempTableName + " t10 set (FConditionID)=( ");
        sql11.append(" select t1.fnewid from " + this.dsTakeDataTableName + " t1 inner join " + this.orgAccountTempTableName + " t2 on t1.fid = t2.FConditionID ");
        sql11.append(" where t2.fid = t10.fid ");
        sql11.append(" ) ");
        DbUtil.execute((Context)this.ctx, (String)sql11.toString());
        StringBuffer sql12 = new StringBuffer();
        sql12.append(" update " + this.fieldMappingTempTableName + " t10 set (FConditionID)=( ");
        sql12.append(" select t1.fnewid from " + this.dsTakeDataTableName + " t1 inner join " + this.fieldMappingTempTableName + " t2 on t1.fid = t2.FConditionID ");
        sql12.append(" where t2.fid = t10.fid ");
        sql12.append(" ) ");
        DbUtil.execute((Context)this.ctx, (String)sql12.toString());
        this.insertDataSourceConfigRelationRecords();
        StringBuffer updateSql = new StringBuffer();
        updateSql.append(" update  ").append(this.dsEntryTempTableName).append(" set fid = fnewId, FParentTableID = fnewParentTableId,FParentID=fnewParentId ");
        DbUtil.execute((Context)this.ctx, (String)updateSql.toString());
        updateSql.setLength(0);
        updateSql.append(" update  ").append(this.dsTempTableName).append(" set fid = fnewId ");
        DbUtil.execute((Context)this.ctx, (String)updateSql.toString());
        updateSql.setLength(0);
        updateSql.append(" update  ").append(this.dsTakeDataTableName).append(" set fid = fnewId ");
        DbUtil.execute((Context)this.ctx, (String)updateSql.toString());
        DbUtil.execute((Context)this.ctx, (String)this.insertDataSource(this.dsTempTableName));
        DbUtil.execute((Context)this.ctx, (String)this.insertDSEntry(this.dsEntryTempTableName));
        DbUtil.execute((Context)this.ctx, (String)this.insertDSGetData(this.dsTakeDataTableName));
        DbUtil.execute((Context)this.ctx, (String)this.insertOrgAccountData(this.orgAccountTempTableName));
        DbUtil.execute((Context)this.ctx, (String)this.insertFieldMappingData(this.fieldMappingTempTableName));
        TempTablePool.getInstance((Context)this.ctx).releaseTable(this.dsTempTableName);
        TempTablePool.getInstance((Context)this.ctx).releaseTable(this.dsEntryTempTableName);
        TempTablePool.getInstance((Context)this.ctx).releaseTable(this.dsTakeDataTableName);
        TempTablePool.getInstance((Context)this.ctx).releaseTable(this.orgAccountTempTableName);
        TempTablePool.getInstance((Context)this.ctx).releaseTable(this.fieldMappingTempTableName);
    }

    protected abstract Map<String, String> getCUDataSourceMap() throws BOSException, EASBizException;

    protected abstract void insertDataSourceConfigRelationRecords() throws BOSException, EASBizException;

    private String insertDataSource(String tempTableName) {
        StringBuffer insertSql = new StringBuffer();
        insertSql.append(" insert into T_TM_DataSource");
        insertSql.append(" (fid,FFilterString,FBillBosType,FState,FIsScheduled,");
        insertSql.append(" FName_l2,FNumber,FDescription_l2,FCreatorID,FCreateTime,FLastUpdateTime,FControlUnitID,FDataDirection)");
        insertSql.append(" select fid,FFilterString,FBillBosType,FState,FIsScheduled,FName_l2,");
        insertSql.append(" FNumber,FDescription_l2,FCreatorID,FCreateTime,FLastUpdateTime,FControlUnitID,FDataDirection from ").append(tempTableName);
        return insertSql.toString();
    }

    private String insertDSEntry(String tempTableName) {
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into T_TM_DataSourceEntry");
        insertSql.append("(Fid,FName_l2,FSeq,FBosType,FTableName,FTableAlias,FJoinType,FjoinCondition,FIsMainTable,FParentTableId,FParentId)");
        insertSql.append("select Fid,FName_l2,FSeq,FBosType,FTableName,FTableAlias,FJoinType,FjoinCondition,FIsMainTable,FParentTableId, FParentId ");
        insertSql.append("from ").append(tempTableName);
        return insertSql.toString();
    }

    private String insertDSGetData(String tempTableName) {
        StringBuffer insertSql = new StringBuffer();
        insertSql.append(" insert into T_TM_TakeDataContdition");
        insertSql.append(" (fid,FDataSourceID,FSTATUS,FINSTRUCTION,FDATAFILTERTYPE,FPERIODYEAR,FPERIODMONTH,FGETDATAFORM,");
        insertSql.append(" FORGFIELD,FDATAFILTER,FBIZDATEFIELD,FPERIODIDFIELD,FGETDATAFORMALIAS,FNAME_L1,FNAME_L2,FNAME_L3,FNUMBER,FDESCRIPTION_L1,FDESCRIPTION_L2,FDESCRIPTION_L3");
        insertSql.append(" ,FSIMPLENAME,FCREATORID,FCREATETIME,FLASTUPDATEUSERID,FLASTUPDATETIME,FCONTROLUNITID,FDataFilterMask,FQueryDataFilter,FGroupOrgField)");
        insertSql.append(" select fid,FDataSourceID,FSTATUS,FINSTRUCTION,FDATAFILTERTYPE,FPERIODYEAR,FPERIODMONTH,FGETDATAFORM,");
        insertSql.append(" FORGFIELD,FDATAFILTER,FBIZDATEFIELD,FPERIODIDFIELD,FGETDATAFORMALIAS,FNAME_L1,FNAME_L2,FNAME_L3,FNUMBER,FDESCRIPTION_L1,FDESCRIPTION_L2,FDESCRIPTION_L3,");
        insertSql.append(" FSIMPLENAME,FCREATORID,FCREATETIME,FLASTUPDATEUSERID,FLASTUPDATETIME,FCONTROLUNITID,FDataFilterMask,FQueryDataFilter,FGroupOrgField from  ").append(tempTableName);
        return insertSql.toString();
    }

    private String insertOrgAccountData(String tempTableName) {
        StringBuffer insertSql = new StringBuffer();
        insertSql.append(" insert into T_TM_OrgToAccount");
        insertSql.append(" (FID ,FOrgUnitID ,FConditionID )");
        insertSql.append(" select newbosid('F0942080') ,FOrgUnitID ,FConditionID");
        insertSql.append(" from  ").append(tempTableName);
        return insertSql.toString();
    }

    private String insertFieldMappingData(String tempTableName) {
        StringBuffer insertSql = new StringBuffer();
        insertSql.append(" insert into T_TM_FieldsMapping");
        insertSql.append(" (FConditionID ,FAccountConfigEntryID ,FValueExpression ,FExpressionAlias ,FSeq ,FID )");
        insertSql.append(" select FConditionID ,FAccountConfigEntryID ,FValueExpression ,FExpressionAlias ,FSeq ,newbosid('93120E43') ");
        insertSql.append(" from  ").append(tempTableName);
        return insertSql.toString();
    }
}

