/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.basedata.util;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.tm.td.basedata.AccountConfigEntryInfo;
import com.kingdee.eas.tm.td.basedata.util.EntityPropertyMeta;
import com.kingdee.eas.tm.td.basedata.util.EntityPropertyMetaUtil;
import com.kingdee.eas.tm.td.basedata.util.PropertyMeta;
import java.util.List;
import java.util.Map;
import javax.swing.tree.MutableTreeNode;

public class EntityTreeUtil {
    public static DefaultKingdeeTreeNode getDataQueryRoot(EntityObjectInfo entity) throws Exception {
        if (entity == null) {
            return null;
        }
        DefaultKingdeeTreeNode root = EntityTreeUtil.createRoot(entity);
        EntityTreeUtil.addTableNode(root, entity);
        Map<String, EntityObjectInfo> entryName = EntityPropertyMetaUtil.getEntryName(entity);
        for (EntityObjectInfo info : entryName.values()) {
            EntityTreeUtil.addTableNode(root, info);
        }
        return root;
    }

    public static DefaultKingdeeTreeNode getDataQueryRoot(List<EntityObjectInfo> entityList) throws Exception {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)"\u5b9e\u4f53");
        for (int i = 0; i < entityList.size(); ++i) {
            EntityTreeUtil.addTableNode(root, entityList.get(i));
            Map<String, EntityObjectInfo> entryName = EntityPropertyMetaUtil.getEntryName(entityList.get(i));
            for (EntityObjectInfo info : entryName.values()) {
                EntityTreeUtil.addTableNode(root, info);
            }
        }
        return root;
    }

    private static DefaultKingdeeTreeNode createRoot(EntityObjectInfo entity) {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)entity);
        root.setText(entity.getAlias());
        return root;
    }

    private static DefaultKingdeeTreeNode addTableNode(DefaultKingdeeTreeNode parent, EntityObjectInfo entity) {
        if (entity == null) {
            return null;
        }
        DefaultKingdeeTreeNode treeNode = EntityTreeUtil.createRoot(entity);
        if (parent != null) {
            parent.add((MutableTreeNode)treeNode);
        }
        EntityTreeUtil.addFieldNode(treeNode, entity);
        return treeNode;
    }

    private static void addFieldNode(DefaultKingdeeTreeNode parent, EntityObjectInfo entity) {
        try {
            EntityPropertyMeta property = null;
            List<EntityPropertyMeta> propertyList = EntityPropertyMetaUtil.getEntityProperty(entity);
            for (int i = 0; i < propertyList.size(); ++i) {
                property = propertyList.get(i);
                EntityTreeUtil.addOneFieldNode(parent, property);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void addOneFieldNode(DefaultKingdeeTreeNode parent, EntityPropertyMeta property) {
        DefaultKingdeeTreeNode treeNode = new DefaultKingdeeTreeNode((Object)property);
        treeNode.setText(property.getAlias());
        parent.add((MutableTreeNode)treeNode);
    }

    private static boolean isSameDataType(CompanyOrgUnitInfo fieldModel, String propertyName, PropertyMeta property, AccountConfigEntryInfo configEntry, FullOrgUnitInfo fullOrgUnitInfo) {
        if (fieldModel != null) {
            if (propertyName == null) {
                return true;
            }
            String propertyDataType = property.getDataType();
            String fieldDataType = propertyName;
            if ("Date".equals(fieldDataType) && ("Date".equals(propertyDataType) || "TimeStamp".equals(propertyDataType) || "Time".equals(propertyDataType))) {
                return true;
            }
            if ("Integer".equals(fieldDataType) && ("Integer".equals(propertyDataType) || "Short".equals(propertyDataType) || "Long".equals(propertyDataType))) {
                return true;
            }
            if (propertyDataType.equalsIgnoreCase(fieldDataType)) {
                if (fieldDataType.equals("Enum") && fieldModel.getBOSType() != null) {
                    return property.getEnumClassName().equals(fieldModel.getBOSType());
                }
                return true;
            }
            if ((fieldDataType.equals("Amount") || fieldDataType.equals("Qty") || fieldDataType.equals("Price")) && propertyDataType.equals("BigDecimal")) {
                return true;
            }
            if ("F7".equals(propertyDataType) && fieldDataType.equals("BOSUuid")) {
                if (fieldModel.getBOSType() != null && property.getRelationBosType().equals(fieldModel.getBOSType())) {
                    return true;
                }
                if (fieldModel.getBOSType() == null) {
                    return true;
                }
            }
        } else if (configEntry != null) {
            String fieldDataType;
            String propertyDataType = property.getDataType();
            if (propertyDataType.equalsIgnoreCase(fieldDataType = configEntry.getDataType().getName())) {
                if (fieldDataType.equals("Enum") && configEntry.getBaseDataBOSType() != null) {
                    return property.getEnumClassName().equals(configEntry.getBaseDataBOSType());
                }
                return true;
            }
            if ((fieldDataType.equals("Amount") || fieldDataType.equals("Qty") || fieldDataType.equals("Price")) && propertyDataType.equals("BigDecimal")) {
                return true;
            }
            if ("F7".equals(propertyDataType) && fieldDataType.equals("BOSUuid")) {
                if (configEntry.getBaseDataBOSType() != null && property.getRelationBosType().equals(configEntry.getBaseDataBOSType())) {
                    return true;
                }
                if (configEntry.getBaseDataBOSType() == null) {
                    return true;
                }
            }
        } else {
            if (propertyName == null) {
                return true;
            }
            String propertyDataType = property.getDataType();
            String fieldDataType = propertyName;
            if ("Date".equals(fieldDataType) && ("Date".equals(propertyDataType) || "TimeStamp".equals(propertyDataType))) {
                return true;
            }
            if ("Integer".equals(fieldDataType) && ("Integer".equals(propertyDataType) || "Short".equals(propertyDataType) || "Long".equals(propertyDataType))) {
                return true;
            }
            if (propertyDataType.equalsIgnoreCase(fieldDataType)) {
                if (fieldDataType.equals("Enum") && fullOrgUnitInfo.getBOSType() != null) {
                    return property.getEnumClassName().equals(fullOrgUnitInfo.getBOSType());
                }
                return true;
            }
            if ((fieldDataType.equals("Amount") || fieldDataType.equals("Qty") || fieldDataType.equals("Price")) && propertyDataType.equals("BigDecimal")) {
                return true;
            }
            if ("F7".equals(propertyDataType) && fieldDataType.equals("BOSUuid")) {
                if (fullOrgUnitInfo.getBOSType() != null && property.getRelationBosType().equals(fullOrgUnitInfo.getBOSType())) {
                    return true;
                }
                if (fullOrgUnitInfo.getBOSType() == null) {
                    return true;
                }
            }
        }
        return false;
    }
}

