/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.impl.facade.rangesel.RangeSelector;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.newrpt.client.designer.SpreadManager;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.tm.td.FormulaFacadeFactory;
import com.kingdee.eas.tm.td.FormulaTypeEnum;
import com.kingdee.eas.tm.td.SortTypeEnum;
import com.kingdee.eas.tm.td.TaxDraftRecordInfo;
import com.kingdee.eas.tm.td.TaxOtherReportInfo;
import com.kingdee.eas.tm.td.account.formula.AccountFormulaCalculateService;
import com.kingdee.eas.tm.td.account.formula.AccountFormulaColumnParams;
import com.kingdee.eas.tm.td.account.formula.AccountFormulaParams;
import com.kingdee.eas.tm.td.account.formula.FormulaHelper;
import com.kingdee.eas.tm.td.basedata.AccountConfigEntryInfo;
import com.kingdee.eas.tm.td.basedata.AccountConfigFactory;
import com.kingdee.eas.tm.td.basedata.AccountConfigInfo;
import com.kingdee.eas.tm.td.basedata.AccountTypeFactory;
import com.kingdee.eas.tm.td.basedata.AccountTypeInfo;
import com.kingdee.eas.tm.td.basedata.DataTypeEnum;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeFactory;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.client.AbstractAccountFormulaUI;
import com.kingdee.eas.tm.td.client.AccountFieldSelectUI;
import com.kingdee.eas.tm.td.client.AccountFormulaDataPreviewUI;
import com.kingdee.eas.tm.td.client.AccountFormulaUIHelper;
import com.kingdee.eas.tm.td.cloud.datamodel.client.FormulaWizardUI;
import com.kingdee.eas.tm.td.cloud.utils.TDCloudUtil;
import com.kingdee.eas.tm.td.est.RealEstateGroupFactory;
import com.kingdee.eas.tm.td.est.RealEstateGroupInfo;
import com.kingdee.eas.tm.td.structure.TaxOtherReportTemplateInfo;
import com.kingdee.eas.tm.td.structure.TaxReportTemplateInfo;
import com.kingdee.eas.tm.td.utils.Location;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class AccountFormulaUI
extends AbstractAccountFormulaUI {
    private static final Logger logger = CoreUIObject.getLogger(AccountFormulaUI.class);
    private Sheet rptSheet = null;
    private SpreadManager spreadManager = null;
    private IObjectValue editData = null;
    private String templateType = null;
    private String formula = null;
    private String formulaMask = null;
    private Point basePoint = null;
    private boolean isModify = false;
    private AccountFormulaParams formulaParams = new AccountFormulaParams();
    private ArrayList basePointList = new ArrayList();
    private List<AccountConfigEntryInfo> entryList = new ArrayList<AccountConfigEntryInfo>();
    private ChangeListener isSumForumlaChange = null;
    private ChangeListener isColumnMatchChange = null;
    private KDTEditAdapter tblMainTableChange = null;
    private DataChangeListener prmtAccountListener = null;
    private DataChangeListener prmtTaxTypeListener = null;
    private ItemListener isGroupListener = null;
    private ItemListener isSumListener = null;
    private RangeSelector rangeChooser = null;
    private AccountConfigInfo tempAccount = null;
    private TaxItemTypeInfo tempTaxType = null;

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        this.initListeners();
        this.initFilter();
    }

    private void initFilter() {
        this.initAccountFilter();
    }

    private void removeListener() {
        if (this.isSumForumlaChange != null) {
            this.cbxIsSumFormula.removeChangeListener(this.isSumForumlaChange);
        }
        if (this.isColumnMatchChange != null) {
            this.cbxColumnMatch.removeChangeListener(this.isColumnMatchChange);
        }
        if (this.tblMainTableChange != null) {
            this.tblMain.removeKDTEditListener((KDTEditListener)this.tblMainTableChange);
        }
        if (this.prmtAccountListener == null) {
            this.prmtAccount.removeDataChangeListener(this.prmtAccountListener);
        }
        if (this.prmtTaxTypeListener == null) {
            this.prmtTaxType.removeDataChangeListener(this.prmtTaxTypeListener);
        }
    }

    private void initListeners() {
        if (this.isSumForumlaChange == null) {
            this.isSumForumlaChange = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent arg0) {
                    AccountFormulaUI.this.sumForumlaChange();
                }
            };
        }
        this.cbxIsSumFormula.addChangeListener(this.isSumForumlaChange);
        if (this.isColumnMatchChange == null) {
            this.isColumnMatchChange = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent arg0) {
                    AccountFormulaUI.this.columnMatchChange();
                }
            };
        }
        this.cbxColumnMatch.addChangeListener(this.isColumnMatchChange);
        if (this.tblMainTableChange == null) {
            this.tblMainTableChange = new KDTEditAdapter(){

                public void editStopped(KDTEditEvent e) {
                    try {
                        AccountFormulaUI.this.tblMain_editStopped(e);
                    }
                    catch (Exception ex) {
                        AccountFormulaUI.this.handUIException(ex);
                    }
                }
            };
        }
        this.tblMain.addKDTEditListener((KDTEditListener)this.tblMainTableChange);
        if (this.prmtAccountListener == null) {
            this.prmtAccountListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    AccountFormulaUI.this.account_dataChanged(eventObj);
                }
            };
        }
        this.prmtAccount.addDataChangeListener(this.prmtAccountListener);
        if (this.prmtTaxTypeListener == null) {
            this.prmtTaxTypeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    AccountFormulaUI.this.taxType_dataChanged(eventObj);
                }
            };
        }
        this.prmtTaxType.addDataChangeListener(this.prmtTaxTypeListener);
    }

    private void account_dataChanged(DataChangeEvent e) {
        if (this.prmtAccount.getValue() == null) {
            return;
        }
        if (TDCloudUtil.isEqual(e.getNewValue(), e.getOldValue())) {
            return;
        }
        AccountConfigInfo account = (AccountConfigInfo)this.prmtAccount.getValue();
        if (this.tempAccount != null && !this.tempAccount.getId().equals((Object)account.getId()) && this.hasVolidEntry()) {
            int flag = MsgBox.showConfirm2((Component)((Object)this), (String)"\u5207\u6362\u53f0\u8d26\u914d\u7f6e\uff0c\u914d\u7f6e\u5185\u5bb9\u5c06\u4f1a\u88ab\u6e05\u7a7a\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362");
            if (flag == 0) {
                this.prmtTaxType.setValue(null);
                this.clearEntry();
            } else {
                this.prmtAccount.setValue(e.getOldValue());
                SysUtil.abort();
            }
        }
        this.tempAccount = (AccountConfigInfo)this.prmtAccount.getValue();
    }

    private void taxType_dataChanged(DataChangeEvent e) {
        if (this.prmtTaxType.getValue() == null) {
            this.initAccountFilter();
            return;
        }
        if (TDCloudUtil.isEqual(e.getNewValue(), e.getOldValue())) {
            return;
        }
        TaxItemTypeInfo taxType = (TaxItemTypeInfo)this.prmtTaxType.getValue();
        if (this.tempTaxType != null && !this.tempTaxType.getId().equals((Object)taxType.getId()) && (this.hasVolidEntry() || this.prmtAccount.getValue() != null)) {
            int flag = MsgBox.showConfirm2((Component)((Object)this), (String)"\u7a0e\u79cd\u6539\u53d8\uff0c\u914d\u7f6e\u5185\u5bb9\u5c06\u4f1a\u88ab\u6e05\u7a7a\uff0c\u662f\u5426\u786e\u8ba4\u6539\u53d8");
            if (flag == 0) {
                this.clearEntry();
                this.prmtAccount.setDataNoNotify(null);
                this.initAccountFilter();
            } else {
                this.prmtTaxType.setDataNoNotify(e.getOldValue());
                SysUtil.abort();
            }
        }
        this.initAccountFilter();
        this.tempTaxType = (TaxItemTypeInfo)this.prmtTaxType.getValue();
    }

    private void initAccountFilter() {
        try {
            TaxItemTypeInfo taxType = (TaxItemTypeInfo)this.prmtTaxType.getValue();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            if (taxType != null) {
                AccountTypeInfo accountType = (AccountTypeInfo)AccountTypeFactory.getRemoteInstance().getValue(" where taxTypeItem = '" + taxType.getId().toString() + "'");
                filter.getFilterItems().add(new FilterItemInfo("accountType.id", (Object)accountType.getId().toString(), CompareType.EQUALS));
            }
            view.setFilter(filter);
            this.prmtAccount.setEntityViewInfo(view);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private boolean hasVolidEntry() {
        if (!StringUtils.isEmpty((String)this.txtCheckContent.getText())) {
            return true;
        }
        return this.entryList.size() > 0;
    }

    private void clearEntry() {
        this.txtCheckContent.setText(null);
        this.entryList.clear();
        this.tblMain.removeRows();
    }

    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
    }

    public void sumForumlaChange() {
        this.tblMain.getColumn("isGroup").getStyleAttributes().setHided(!this.cbxIsSumFormula.isSelected());
        this.tblMain.getColumn("isSum").getStyleAttributes().setHided(!this.cbxIsSumFormula.isSelected());
        this.entryList = AccountFormulaUIHelper.getEntryListFromTable(this.tblMain);
        if (!this.cbxIsSumFormula.isSelected()) {
            AccountConfigEntryInfo entryInfo = null;
            int size = this.entryList.size();
            for (int i = 0; i < size; ++i) {
                entryInfo = this.entryList.get(i);
                entryInfo.setIsGroup(false);
                entryInfo.setIsSum(false);
            }
        }
        this.loadEntryData(this.entryList);
    }

    public void columnMatchChange() {
        this.tblMain.getColumn("matchField").getStyleAttributes().setHided(!this.cbxColumnMatch.isSelected());
        this.tblMain.getColumn("sortType").getStyleAttributes().setHided(this.cbxColumnMatch.isSelected());
        this.entryList = AccountFormulaUIHelper.getEntryListFromTable(this.tblMain);
        if (this.cbxColumnMatch.isSelected()) {
            AccountConfigEntryInfo entryInfo = null;
            int size = this.entryList.size();
            for (int i = 0; i < size; ++i) {
                entryInfo = this.entryList.get(i);
                entryInfo.setSortType(SortTypeEnum.NORMAL);
            }
        } else {
            AccountConfigEntryInfo entryInfo = null;
            int size = this.entryList.size();
            for (int i = 0; i < size; ++i) {
                entryInfo = this.entryList.get(i);
                entryInfo.setMatchField(null);
            }
        }
        this.btnReview.setEnabled(!this.cbxColumnMatch.isSelected());
        this.loadEntryData(this.entryList);
    }

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        super.onLoad();
        this.initContext();
        this.initBasePointList();
        this.initParameters();
        this.initControl();
        this.loadFields();
    }

    private void initContext() {
        this.rptSheet = (Sheet)this.getUIContext().get("rptSheet");
        this.spreadManager = (SpreadManager)this.getUIContext().get("spreadManager");
        this.editData = (IObjectValue)this.getUIContext().get("editData");
        this.templateType = (String)this.getUIContext().get("templateType");
    }

    private void initBasePointList() {
        this.basePointList = FormulaHelper.getBasePointList(this.rptSheet);
    }

    private void initControl() throws EASBizException, BOSException {
        this.prmtCompany.setHistoryRecordEnabled(false);
        this.prmtAccount.setHistoryRecordEnabled(false);
        this.prmtTaxType.setHistoryRecordEnabled(false);
        KDComboBox enumEditor = new KDComboBox();
        enumEditor.addItem((Object)SortTypeEnum.NORMAL);
        enumEditor.addItem((Object)SortTypeEnum.ASC);
        enumEditor.addItem((Object)SortTypeEnum.DESC);
        this.tblMain.getColumn("sortType").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)enumEditor));
        this.initSelectedRange();
        this.initIsGroupControl();
        this.initIsSumControl();
        this.rangeChooser.setText(this.spreadManager.getSpreadContainer().getRangeManager().getActiveCellRange().getName());
        if (this.isModify()) {
            this.loadData(this.formulaParams);
        }
        this.sumForumlaChange();
        this.columnMatchChange();
        this.txtPeriodOffset.setNegatived(false);
        if (this.isModify) {
            this.setUITitle("\u53f0\u8d26\u7f57\u5217\u53d6\u6570\u516c\u5f0f\u7f16\u8f91");
        } else {
            this.setUITitle("\u53f0\u8d26\u7f57\u5217\u53d6\u6570\u516c\u5f0f\u65b0\u589e");
        }
        if (this.templateType != null && "OtherTemplate".equals(this.templateType)) {
            this.prmtTaxType.setRequired(true);
        }
        if (this.isModify() && this.editData instanceof ReportBaseInfo) {
            this.cbxInsertMode.setEnabled(false);
        }
    }

    private void initIsGroupControl() {
        KDCheckBox check = new KDCheckBox();
        this.isGroupListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AccountFormulaUI.this.isGroupChanged(e.getStateChange() == 1);
            }
        };
        check.addItemListener(this.isGroupListener);
        this.tblMain.getColumn("isGroup").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)check));
    }

    private void initIsSumControl() {
        KDCheckBox check = new KDCheckBox();
        this.isSumListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AccountFormulaUI.this.isSumChanged(e.getStateChange() == 1);
            }
        };
        check.addItemListener(this.isSumListener);
        this.tblMain.getColumn("isSum").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)check));
    }

    private void isGroupChanged(boolean selected) {
        int rowIndex = this.tblMain.getEditManager().getEditRowIndex();
        IRow row = this.tblMain.getRow(rowIndex);
        AccountFormulaUIHelper.tableCheckBoxValueChange(row, "isGroup", selected, this.cbxIsSumFormula.isSelected());
    }

    private void isSumChanged(boolean selected) {
        int rowIndex = this.tblMain.getEditManager().getEditRowIndex();
        IRow row = this.tblMain.getRow(rowIndex);
        AccountFormulaUIHelper.tableCheckBoxValueChange(row, "isSum", selected, this.cbxIsSumFormula.isSelected());
    }

    private void loadData(AccountFormulaParams formulaParams) throws EASBizException, BOSException {
        if (!StringUtils.isEmpty((String)formulaParams.getCompanyID())) {
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(formulaParams.getCompanyID()));
            this.prmtCompany.setValue((Object)company);
        }
        if (!StringUtils.isEmpty((String)formulaParams.getTaxTypeID())) {
            TaxItemTypeInfo taxType = TaxItemTypeFactory.getRemoteInstance().getTaxItemTypeInfo((IObjectPK)new ObjectUuidPK(formulaParams.getTaxTypeID()));
            this.prmtTaxType.setValue((Object)taxType);
            this.tempTaxType = taxType;
        }
        if (!StringUtils.isEmpty((String)formulaParams.getAccountID())) {
            try {
                AccountConfigInfo configInfo = AccountConfigFactory.getRemoteInstance().getAccountConfigInfo((IObjectPK)new ObjectUuidPK(formulaParams.getAccountID()));
                this.prmtAccount.setValue((Object)configInfo);
                this.tempAccount = configInfo;
            }
            catch (ObjectNotFoundException e) {
                logger.error((Object)e);
            }
        }
        if (!StringUtils.isEmpty((String)formulaParams.getGroupID())) {
            RealEstateGroupInfo groupInfo = RealEstateGroupFactory.getRemoteInstance().getRealEstateGroupInfo((IObjectPK)new ObjectUuidPK(formulaParams.getGroupID()));
            this.prmtGroup.setValue((Object)groupInfo);
        }
        this.txtPeriodOffset.setValue((Object)formulaParams.getPeriodOffset());
        this.formula = formulaParams.getFormula();
        this.formulaMask = formulaParams.getFormulaMask();
        if (!StringUtils.isEmpty((String)formulaParams.getFormulaAlias())) {
            this.txtCheckContent.setText(formulaParams.getFormulaAlias());
        }
        if (!StringUtils.isEmpty((String)formulaParams.getAnalysisRange())) {
            this.rangeChooser.setText(formulaParams.getAnalysisRange());
        }
        this.cbxSheetName.setSelectedItem((Object)formulaParams.getSheetName());
        this.cbxIsSumFormula.setSelected(formulaParams.isSumFormula());
        this.cbxColumnMatch.setSelected(formulaParams.isColumnMatch());
        this.cbxIsInsertSeq.setSelected(formulaParams.isInsertSeq());
        this.cbxInsertMode.setSelectedIndex(formulaParams.getInsertMode());
        this.entryList = new ArrayList<AccountConfigEntryInfo>();
        List<AccountFormulaColumnParams> columnParams = formulaParams.getColumnParams();
        AccountFormulaColumnParams columnParam2 = null;
        AccountConfigEntryInfo entryInfo = null;
        for (AccountFormulaColumnParams columnParam2 : columnParams) {
            entryInfo = new AccountConfigEntryInfo();
            entryInfo.setName(columnParam2.getName());
            entryInfo.setSeq(columnParam2.getSeq());
            entryInfo.setAlias(columnParam2.getAlias());
            entryInfo.setDataType(DataTypeEnum.getEnum(columnParam2.getDataType()));
            entryInfo.setIsGroup(columnParam2.isGroup());
            entryInfo.setIsSum(columnParam2.isSum());
            entryInfo.setId(BOSUuid.read((String)columnParam2.getId()));
            entryInfo.setMatchField(columnParam2.getMatchField());
            entryInfo.setSortType(SortTypeEnum.getEnum(columnParam2.getSortType()));
            entryInfo.setIsVisible(columnParam2.getIsVisible());
            this.entryList.add(entryInfo);
        }
        this.loadEntryData(this.entryList);
    }

    private void initParameters() {
        Point point = new Point(0, 0);
        point.y = this.rptSheet.getActiveRow();
        point.x = this.rptSheet.getActiveCol();
        this.basePoint = FormulaHelper.getBasePoint(this.rptSheet, point, this.basePointList);
        if (this.basePoint != null) {
            this.isModify = true;
            this.formulaParams = FormulaHelper.getParametersFromCell(this.rptSheet, this.basePoint.y, this.basePoint.x);
        } else {
            this.formulaParams = new AccountFormulaParams();
            this.isModify = false;
            this.basePoint = point;
        }
    }

    private void initSelectedRange() {
        this.rangeChooser = this.spreadManager.createRangeSelector(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"79_RptDynaItemAnalysisFilterUI"));
        this.selectAreaContainer.setBoundEditor((JComponent)this.rangeChooser);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void checkAccountIsNull() {
        if (this.prmtAccount.getValue() == null || !(this.prmtAccount.getValue() instanceof AccountConfigInfo)) {
            this.prmtAccount.requestFocus(true);
            MsgBox.showInfo((String)"\u8bf7\u5148\u5f55\u5165\u53f0\u8d26\u914d\u7f6e");
            SysUtil.abort();
        }
    }

    @Override
    public void actionCheckContent_actionPerformed(ActionEvent e) throws Exception {
        this.checkAccountIsNull();
        UIContext uiContext = new UIContext();
        uiContext.put("panelName", "\u67e5\u627e\u5185\u5bb9\u7f16\u8f91");
        uiContext.put("configInfo", this.prmtAccount.getValue());
        uiContext.put("filterInfo", FormulaHelper.getFilterInfo(this.formula, this.formulaMask));
        IUIWindow uiWindow = null;
        FormulaWizardUI formulaUI = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(FormulaWizardUI.class.getName(), (Map)uiContext);
        formulaUI = (FormulaWizardUI)uiWindow.getUIObject();
        uiWindow.show();
        if (!formulaUI.isCanceled()) {
            Map ret = (Map)formulaUI.getData();
            FilterInfo filterInfo = (FilterInfo)ret.get("filterInfo");
            String filterInfoDesc = (String)ret.get("filterInfoDesc");
            this.txtCheckContent.setText(filterInfoDesc);
            this.formula = filterInfo.toSql();
            this.formulaMask = filterInfo.getMaskString();
        }
    }

    @Override
    public void actionCheckReturn_actionPerformed(ActionEvent e) throws Exception {
        this.checkAccountIsNull();
        UIContext uiContext = new UIContext();
        uiContext.put("configInfo", this.prmtAccount.getValue());
        uiContext.put("entryList", AccountFormulaUIHelper.getEntryListFromTable(this.tblMain));
        uiContext.put("isSumFormula", this.cbxIsSumFormula.isSelected());
        uiContext.put("isColumnMatch", this.cbxColumnMatch.isSelected());
        IUIWindow uiWindow = null;
        AccountFieldSelectUI selectUI = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(AccountFieldSelectUI.class.getName(), (Map)uiContext);
        selectUI = (AccountFieldSelectUI)uiWindow.getUIObject();
        uiWindow.show();
        if (!selectUI.isCanceled()) {
            this.entryList = selectUI.getRptArrSelected();
            this.loadEntryData(this.entryList);
        }
    }

    protected void loadEntryData(List entryList) {
        this.tblMain.checkParsed();
        this.tblMain.removeRows();
        this.tblMain.getStyleAttributes().setLocked(true);
        AccountConfigEntryInfo entryInfo = null;
        for (int i = 0; i < entryList.size(); ++i) {
            entryInfo = (AccountConfigEntryInfo)entryList.get(i);
            this.appendNewLine(entryInfo);
        }
    }

    private void appendNewLine(AccountConfigEntryInfo entryInfo) {
        if (entryInfo == null) {
            return;
        }
        IRow row = this.tblMain.addRow();
        AccountFormulaUIHelper.updateLineData(row, entryInfo, this.cbxIsSumFormula.isSelected(), this.cbxColumnMatch.isSelected());
    }

    @Override
    public void actionReview_actionPerformed(ActionEvent e) throws Exception {
        AccountFormulaParams formulaParams;
        if (this.editData instanceof TaxReportTemplateInfo || this.editData instanceof TaxOtherReportTemplateInfo) {
            MsgBox.showInfo((String)"\u62a5\u8868\u6a21\u7248\u4e0d\u652f\u6301\u9884\u89c8");
            SysUtil.abort();
        }
        if ((formulaParams = this.buildFormulaParams()).isColumnMatch()) {
            MsgBox.showInfo((String)"\u9010\u884c\u5339\u914d\u4e0d\u652f\u6301\u9884\u89c8");
            SysUtil.abort();
        }
        this.checkRequiredFields(false);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("formulaType", (Object)FormulaTypeEnum.AccountFormula);
        params.put("formulaParams", formulaParams);
        params.put("reportInfo", this.editData);
        Map ret = FormulaFacadeFactory.getRemoteInstance().execute(params);
        UIContext uiContext = new UIContext();
        uiContext.put("ret", ret);
        IUIWindow uiWindow = null;
        AccountFormulaDataPreviewUI dataPreviewUI = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(AccountFormulaDataPreviewUI.class.getName(), (Map)uiContext);
        dataPreviewUI = (AccountFormulaDataPreviewUI)uiWindow.getUIObject();
        uiWindow.show();
    }

    protected AccountFormulaParams buildFormulaParams() {
        this.formulaParams.setCompanyID(this.getValueObjectID(this.prmtCompany.getValue()));
        this.formulaParams.setTaxTypeID(this.getValueObjectID(this.prmtTaxType.getValue()));
        this.formulaParams.setAccountID(this.getValueObjectID(this.prmtAccount.getValue()));
        this.formulaParams.setPeriodOffset(this.txtPeriodOffset.getNumberValue() == null ? 0 : this.txtPeriodOffset.getNumberValue().intValue());
        this.formulaParams.setSheetName(this.cbxSheetName.getSelectedItem().toString());
        this.formulaParams.setFormula(this.formula);
        this.formulaParams.setFormulaMask(this.formulaMask);
        this.formulaParams.setFormulaAlias(this.txtCheckContent.getText());
        this.formulaParams.setSumFormula(this.cbxIsSumFormula.isSelected());
        this.formulaParams.setAnalysisRange(this.rangeChooser.getText());
        this.formulaParams.setDefaultCounter(this.getDefaultCounter(this.formulaParams.getAnalysisRange()));
        this.formulaParams.setColumnMatch(this.cbxColumnMatch.isSelected());
        this.formulaParams.setInsertSeq(this.cbxIsInsertSeq.isSelected());
        this.formulaParams.setColumnParams(this.buildFormulaColumnParamsList());
        this.formulaParams.setInsertMode(this.cbxInsertMode.getSelectedIndex());
        this.formulaParams.setGroupID(this.getValueObjectID(this.prmtGroup.getValue()));
        if (!this.isModify()) {
            this.formulaParams.setRowCounter(this.formulaParams.getDefaultCounter());
            this.formulaParams.setColCounter(FormulaHelper.getHeadSize(this.formulaParams));
        }
        return this.formulaParams;
    }

    private int getDefaultCounter(String analysisRange) {
        if (!StringUtils.isEmpty((String)analysisRange)) {
            String[] str = analysisRange.split("!");
            String[] cells = null;
            int[] point1 = null;
            int[] point2 = null;
            if (str.length > 1) {
                cells = str[1].split(":");
                if (cells.length > 1) {
                    point1 = Location.getCellRowAndColumn(cells[0]);
                    point2 = Location.getCellRowAndColumn(cells[1]);
                    return point2[0] - point1[0] + 1;
                }
                return 1;
            }
        }
        return 0;
    }

    private String getValueObjectID(Object obj) {
        if (obj == null || !(obj instanceof IObjectValue)) {
            return null;
        }
        IObjectValue value = (IObjectValue)obj;
        if (value != null) {
            return value.get("id").toString();
        }
        return null;
    }

    protected List<AccountFormulaColumnParams> buildFormulaColumnParamsList() {
        ArrayList<AccountFormulaColumnParams> columnParamsList = new ArrayList<AccountFormulaColumnParams>();
        IRow row = null;
        AccountConfigEntryInfo entryInfo = null;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            row = this.tblMain.getRow(i);
            entryInfo = AccountFormulaUIHelper.buildEntryInfo(row);
            columnParamsList.add(this.buildFormulaColumnParams(entryInfo));
        }
        return columnParamsList;
    }

    protected AccountFormulaColumnParams buildFormulaColumnParams(AccountConfigEntryInfo entryInfo) {
        AccountFormulaColumnParams columnParams = new AccountFormulaColumnParams();
        columnParams.setSeq(entryInfo.getSeq());
        columnParams.setName(entryInfo.getName());
        columnParams.setAlias(entryInfo.getAlias());
        columnParams.setDataType(entryInfo.getDataType().getValue());
        columnParams.setId(entryInfo.getId().toString());
        columnParams.setGroup(entryInfo.isIsGroup());
        columnParams.setSum(entryInfo.isIsSum());
        columnParams.setMatchField(entryInfo.getMatchField());
        columnParams.setSortType(entryInfo.getSortType() != null ? entryInfo.getSortType().getValue() : 0);
        columnParams.setIsVisible(entryInfo.getIsVisible());
        return columnParams;
    }

    private void checkRequiredFields(boolean isOk) {
        StringBuffer sb = new StringBuffer();
        if (this.templateType != null) {
            sb.append("\u3001\u7a0e\u79cd");
        }
        if (this.prmtAccount.getValue() == null || !(this.prmtAccount.getValue() instanceof AccountConfigInfo)) {
            sb.append("\u3001\u53f0\u8d26\u914d\u7f6e");
        }
        if (isOk && StringUtils.isEmpty((String)this.rangeChooser.getText())) {
            sb.append("\u3001\u5206\u6790\u533a\u57df");
        }
        if (sb.length() > 0) {
            sb.append("\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.tblMain.getRowCount() == 0) {
            sb.append("\u3001\u5206\u5f55\u81f3\u5c11\u6709\u4e00\u884c");
        }
        if (sb.length() > 0) {
            MsgBox.showWarning((String)sb.substring(1));
            SysUtil.abort();
        }
        if (!this.hasVisibleFields()) {
            MsgBox.showInfo((String)"\u663e\u793a\u5217\u4e0d\u80fd\u4e3a\u7a7a!");
            SysUtil.abort();
        }
        if (isOk && this.cbxColumnMatch.isSelected() && !this.hasColumnMatchFields()) {
            MsgBox.showInfo((String)"\u9010\u884c\u5339\u914d\u6a21\u5f0f\uff0c\u5339\u914d\u5217\u4e0d\u80fd\u4e3a\u7a7a!");
            SysUtil.abort();
        }
    }

    private boolean hasColumnMatchFields() {
        IRow row = null;
        Object value = null;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            row = this.tblMain.getRow(i);
            value = row.getCell("matchField").getValue();
            if (value == null || StringUtils.isEmpty((String)value.toString().trim())) continue;
            return true;
        }
        return false;
    }

    private boolean hasBasePointIntersects() {
        int headWidth = FormulaHelper.getHeadSize(this.formulaParams);
        int bodyHeight = this.formulaParams.getDefaultCounter() > this.formulaParams.getRowCounter() ? this.formulaParams.getDefaultCounter() : this.formulaParams.getRowCounter();
        Rectangle r = new Rectangle(this.basePoint.x, this.basePoint.y, headWidth, bodyHeight);
        for (int i = this.basePointList.size() - 1; i >= 0; --i) {
            Point element = (Point)this.basePointList.get(i);
            if (element.equals(this.basePoint) || !FormulaHelper.getRectangle(this.rptSheet, element).intersects(r)) continue;
            return true;
        }
        return false;
    }

    private boolean hasVisibleFields() {
        IRow row = null;
        Boolean value = null;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            row = this.tblMain.getRow(i);
            value = AccountFormulaUIHelper.getBooleanValue(row.getCell("isVisible").getValue());
            if (!value.booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void actionOk_actionPerformed(ActionEvent e) throws Exception {
        this.checkRequiredFields(true);
        this.formulaParams = this.buildFormulaParams();
        if (this.hasBasePointIntersects()) {
            MsgBox.showInfo((String)"\u6821\u9a8c\u516c\u5f0f\u533a\u57df\u4e0e\u5176\u4ed6\u516c\u5f0f\u533a\u57df\u6709\u91cd\u5408\u90e8\u5206,\u8bf7\u91cd\u65b0\u914d\u7f6e");
            SysUtil.abort();
        }
        if (this.editData instanceof TaxReportTemplateInfo || this.editData instanceof TaxOtherReportTemplateInfo) {
            FormulaHelper.saveBasePointCell(this.rptSheet, this.basePoint, this.formulaParams);
        } else if (this.editData instanceof TaxDraftRecordInfo || this.editData instanceof TaxOtherReportInfo) {
            AccountFormulaCalculateService calculateService = new AccountFormulaCalculateService(null);
            calculateService.calculateCell((ReportBaseInfo)this.editData, this.rptSheet, this.basePoint, this.formulaParams);
        }
        this.destroyWindow();
    }

    public boolean isModify() {
        return this.isModify;
    }

    public void setModify(boolean isModify) {
        this.isModify = isModify;
    }

    private ArrayList getBasePointList() {
        return this.basePointList;
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.destroyWindow();
    }
}

