/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.tm.td.SortTypeEnum;
import com.kingdee.eas.tm.td.basedata.AccountConfigEntryInfo;
import com.kingdee.eas.tm.td.basedata.DataTypeEnum;
import java.awt.Color;
import java.util.ArrayList;

public class AccountFormulaUIHelper {
    public static final String COL_NAME = "name";
    public static final String COL_DATATYPE = "dataType";
    public static final String COL_ISGROUP = "isGroup";
    public static final String COL_ISSUM = "isSum";
    public static final String COL_MATCHFIELD = "matchField";
    public static final String COL_SORTTYPE = "sortType";
    public static final String COL_ISVISIBLE = "isVisible";
    public static final String COL_ID = "ID";
    public static final String COL_OBJECT = "OBJECT";

    public static void updateLineData(IRow row, AccountConfigEntryInfo entryInfo, boolean isSumFormula, boolean isColumnMatch) {
        if (entryInfo == null || row == null) {
            return;
        }
        row.getCell(COL_ID).getStyleAttributes().setLocked(true);
        row.getCell(COL_OBJECT).getStyleAttributes().setLocked(true);
        row.getCell(COL_ID).setValue((Object)entryInfo.getId().toString());
        row.getCell(COL_OBJECT).setValue((Object)entryInfo);
        row.getCell(COL_NAME).setValue((Object)entryInfo.getAlias());
        row.getCell(COL_DATATYPE).setValue((Object)entryInfo.getDataType().getAlias());
        if (isSumFormula) {
            row.getCell(COL_ISGROUP).setValue((Object)new Boolean(entryInfo.isIsGroup()));
            AccountFormulaUIHelper.lockCell(row, COL_ISGROUP, false);
            if (DataTypeEnum.Amount.equals((Object)entryInfo.getDataType()) || DataTypeEnum.Price.equals((Object)entryInfo.getDataType()) || DataTypeEnum.Qty.equals((Object)entryInfo.getDataType())) {
                AccountFormulaUIHelper.lockCell(row, COL_ISSUM, false);
                row.getCell(COL_ISSUM).setValue((Object)new Boolean(entryInfo.isIsSum()));
            } else {
                AccountFormulaUIHelper.lockCell(row, COL_ISSUM, true);
                row.getCell(COL_ISSUM).setValue(null);
            }
            if (entryInfo.isIsGroup()) {
                row.getCell(COL_MATCHFIELD).setValue((Object)entryInfo.getMatchField());
                AccountFormulaUIHelper.lockCell(row, COL_MATCHFIELD, false);
            } else {
                row.getCell(COL_MATCHFIELD).setValue(null);
                AccountFormulaUIHelper.lockCell(row, COL_MATCHFIELD, true);
            }
            if (entryInfo.isIsGroup() || entryInfo.isIsSum()) {
                row.getCell(COL_ISVISIBLE).setValue((Object)new Boolean(entryInfo.getIsVisible()));
                AccountFormulaUIHelper.lockCell(row, COL_ISVISIBLE, false);
                row.getCell(COL_SORTTYPE).setValue((Object)entryInfo.getSortType());
                AccountFormulaUIHelper.lockCell(row, COL_SORTTYPE, false);
            } else {
                row.getCell(COL_ISVISIBLE).setValue(null);
                AccountFormulaUIHelper.lockCell(row, COL_ISVISIBLE, true);
                row.getCell(COL_SORTTYPE).setValue((Object)SortTypeEnum.NORMAL);
                AccountFormulaUIHelper.lockCell(row, COL_SORTTYPE, true);
            }
        } else {
            row.getCell(COL_ISGROUP).setValue(null);
            AccountFormulaUIHelper.lockCell(row, COL_SORTTYPE, true);
            row.getCell(COL_ISSUM).setValue(null);
            AccountFormulaUIHelper.lockCell(row, COL_ISSUM, true);
            row.getCell(COL_MATCHFIELD).setValue((Object)entryInfo.getMatchField());
            AccountFormulaUIHelper.lockCell(row, COL_MATCHFIELD, false);
            row.getCell(COL_SORTTYPE).setValue((Object)entryInfo.getSortType());
            AccountFormulaUIHelper.lockCell(row, COL_SORTTYPE, false);
            row.getCell(COL_ISVISIBLE).setValue((Object)new Boolean(entryInfo.getIsVisible()));
            AccountFormulaUIHelper.lockCell(row, COL_ISVISIBLE, false);
        }
        row.setUserObject((Object)entryInfo);
    }

    public static void lockCell(IRow row, String cellName, boolean isLock) {
        ICell cell = row.getCell(cellName);
        Color color = new Color(255, 255, 255);
        if (isLock) {
            color = new Color(192, 192, 192);
        }
        cell.getStyleAttributes().setLocked(isLock);
        if (cellName.equals(COL_SORTTYPE) || cellName.equals(COL_MATCHFIELD)) {
            cell.getStyleAttributes().setBackground(color);
        }
    }

    public static void tableCheckBoxValueChange(IRow row, String fieldName, Boolean value, boolean isSumFormula) {
        if (COL_ISGROUP.equalsIgnoreCase(fieldName)) {
            Boolean isGroup = value;
            Boolean isSum = AccountFormulaUIHelper.getBooleanValue(row.getCell(COL_ISSUM).getValue());
            if (isGroup.booleanValue()) {
                AccountFormulaUIHelper.lockCell(row, COL_MATCHFIELD, false);
            } else {
                row.getCell(COL_MATCHFIELD).setValue(null);
                AccountFormulaUIHelper.lockCell(row, COL_MATCHFIELD, true);
            }
            if (isSumFormula) {
                AccountFormulaUIHelper.setFieldSumCell(row, isGroup, isSum);
            }
        } else if (COL_ISSUM.equalsIgnoreCase(fieldName)) {
            Boolean isSum = value;
            Boolean isGroup = AccountFormulaUIHelper.getBooleanValue(row.getCell(COL_ISGROUP).getValue());
            if (isSumFormula) {
                AccountFormulaUIHelper.setFieldSumCell(row, isGroup, isSum);
            } else {
                AccountFormulaUIHelper.lockCell(row, COL_ISVISIBLE, false);
            }
        }
    }

    public static void setFieldSumCell(IRow row, Boolean isGroup, Boolean isSum) {
        if (isSum.booleanValue() || isGroup.booleanValue()) {
            Object value = row.getCell(COL_ISVISIBLE).getValue();
            if (value == null) {
                row.getCell(COL_ISVISIBLE).setValue((Object)new Boolean(isSum));
            }
            AccountFormulaUIHelper.lockCell(row, COL_ISVISIBLE, false);
            row.getCell(COL_SORTTYPE).setValue((Object)SortTypeEnum.NORMAL);
            AccountFormulaUIHelper.lockCell(row, COL_SORTTYPE, false);
        } else {
            row.getCell(COL_ISVISIBLE).setValue(null);
            AccountFormulaUIHelper.lockCell(row, COL_ISVISIBLE, true);
            row.getCell(COL_SORTTYPE).setValue((Object)SortTypeEnum.NORMAL);
            AccountFormulaUIHelper.lockCell(row, COL_SORTTYPE, true);
        }
    }

    public static AccountConfigEntryInfo buildEntryInfo(IRow row) {
        AccountConfigEntryInfo entryInfo = (AccountConfigEntryInfo)row.getCell(COL_OBJECT).getValue();
        entryInfo.setIsGroup(AccountFormulaUIHelper.getBooleanValue(row.getCell(COL_ISGROUP).getValue()));
        entryInfo.setIsSum(AccountFormulaUIHelper.getBooleanValue(row.getCell(COL_ISSUM).getValue()));
        entryInfo.setMatchField((String)row.getCell(COL_MATCHFIELD).getValue());
        entryInfo.setSortType((SortTypeEnum)((Object)row.getCell(COL_SORTTYPE).getValue()));
        entryInfo.setIsVisible(AccountFormulaUIHelper.getBooleanValue(row.getCell(COL_ISVISIBLE).getValue()));
        return entryInfo;
    }

    public static AccountConfigEntryInfo entrySetFieldNull(AccountConfigEntryInfo entryInfo) {
        entryInfo.setIsGroup(false);
        entryInfo.setIsSum(false);
        entryInfo.setMatchField(null);
        entryInfo.setSortType(SortTypeEnum.NORMAL);
        entryInfo.setIsVisible(true);
        return entryInfo;
    }

    public static boolean getBooleanValue(Object value) {
        if (value != null) {
            return (Boolean)value;
        }
        return false;
    }

    public static ArrayList<AccountConfigEntryInfo> getEntryListFromTable(KDTable table) {
        ArrayList<AccountConfigEntryInfo> entryList = new ArrayList<AccountConfigEntryInfo>();
        for (int i = 0; i < table.getRowCount(); ++i) {
            entryList.add(AccountFormulaUIHelper.buildEntryInfo(table.getRow(i)));
        }
        return entryList;
    }
}

