/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.tm.td.TDFacadeFactory;
import com.kingdee.eas.tm.td.TaxDraftRecordInfo;
import com.kingdee.eas.tm.td.account.engine.model.AccountCalculatorParams;
import com.kingdee.eas.tm.td.client.AbstractAccountSQLView;
import org.apache.log4j.Logger;

public class AccountSQLView
extends AbstractAccountSQLView {
    private static final Logger logger = CoreUIObject.getLogger(AccountSQLView.class);
    private TaxDraftRecordInfo recordInfo = null;
    private String accountId = null;

    public void onLoad() throws Exception {
        this.beforeLoad();
        super.onLoad();
        this.afterLoad();
    }

    private void beforeLoad() {
        this.recordInfo = (TaxDraftRecordInfo)this.getUIContext().get("recordInfo");
        this.accountId = (String)this.getUIContext().get("accountId");
    }

    private void afterLoad() {
        this.txtSQL.setText(this.getAccountSQL());
    }

    private String getAccountSQL() {
        String accountSQL = "";
        if (this.recordInfo == null) {
            return accountSQL;
        }
        Object calculatorResult = null;
        AccountCalculatorParams params = new AccountCalculatorParams();
        params.setAccountID(this.accountId);
        params.setCompanyID(this.recordInfo.getCompanyOrgUnit().getId().toString());
        params.setStartDate(this.recordInfo.getStartDate());
        params.setEndDate(this.recordInfo.getEndDate());
        if (this.recordInfo.getRptPeriod() != null) {
            params.setPeriodID(this.recordInfo.getRptPeriod().getId().toString());
        }
        params.setYear(this.recordInfo.getYear());
        params.setPeriod(this.recordInfo.getPeriod());
        if (this.recordInfo.getRptPeriodFrom() != null) {
            params.put("periodFromID", this.recordInfo.getRptPeriodFrom().getId().toString());
        }
        if (this.recordInfo.getRptPeriodTo() != null) {
            params.put("periodToID", this.recordInfo.getRptPeriodTo().getId().toString());
        }
        if (this.recordInfo.getOrgTree() != null) {
            params.put("orgTreeID", this.recordInfo.getOrgTree().getId().toString());
        }
        if (this.recordInfo.getBuildingTaxesGroup() != null) {
            params.setGroupID(this.recordInfo.getBuildingTaxesGroup().getId().toString());
        }
        try {
            accountSQL = TDFacadeFactory.getRemoteInstance().getAccountSQL(params);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return accountSQL;
    }
}

