/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.attachment.client.AttachmentUIContextInfo;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.core.util.PrecisionUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.tm.td.DeclaredTypeEnum;
import com.kingdee.eas.tm.td.DraftStatusEnum;
import com.kingdee.eas.tm.td.RecordTypeEnum;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.TaxDraftRecordCollection;
import com.kingdee.eas.tm.td.TaxDraftRecordFactory;
import com.kingdee.eas.tm.td.TaxDraftRecordInfo;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.client.AbstractConfirmDeclareBatchUI;
import com.kingdee.eas.tm.td.structure.TaxReportSheetInfo;
import com.kingdee.eas.tm.td.structure.TaxStructureFacadeFactory;
import com.kingdee.eas.tm.td.structure.utils.StructureUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class ConfirmDeclareBatchUI
extends AbstractConfirmDeclareBatchUI {
    private static final Logger logger = CoreUIObject.getLogger(ConfirmDeclareBatchUI.class);
    private static final String COL_ID = "id";
    private static final String COL_NUMBER = "number";
    private static final String COL_NAME = "name";
    private static final String COL_PERIOD = "period";
    private static final String COL_DECLARETYPE = "declareType";
    private static final String COL_DECLAREAMT = "declareAmt";
    private static final String COL_DECLAREDATE = "declareDate";
    private static final String COL_ATTACHMENT = "attachment";
    private static final String[] LOCK_COLUMNS = new String[]{"number", "name", "period"};
    private boolean isCanceled = true;
    private List<String> billIds = null;
    private TaxItemTypeInfo taxType = null;
    private RecordTypeEnum recordType = null;
    private List<TaxDraftRecordInfo> reports = null;
    private static final int AMT_PRECISION = 2;
    private KDTEditAdapter entryTableChange = null;
    private String declareAmtDataDefinition = "";

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        super.onLoad();
        this.initContext();
        this.initParams();
        this.initControl();
        this.loadFields();
    }

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        this.initListeners();
        this.innerLoadFields();
    }

    private void removeListener() {
        if (this.entryTableChange != null) {
            this.tblMain.removeKDTEditListener((KDTEditListener)this.entryTableChange);
        }
    }

    private void initListeners() {
        if (this.entryTableChange == null) {
            this.entryTableChange = new KDTEditAdapter(){

                public void editStarting(KDTEditEvent e) {
                    try {
                        ConfirmDeclareBatchUI.this.tblMain_editStarting(e);
                    }
                    catch (Exception exc) {
                        ConfirmDeclareBatchUI.this.handUIException(exc);
                    }
                }

                public void editStopped(KDTEditEvent e) {
                    try {
                        ConfirmDeclareBatchUI.this.tblMain_editStopped(e);
                    }
                    catch (Exception exc) {
                        ConfirmDeclareBatchUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.tblMain.addKDTEditListener((KDTEditListener)this.entryTableChange);
    }

    protected void tblMain_editStarting(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        String fieldName = this.tblMain.getColumnKey(colIndex);
        if (COL_ATTACHMENT.equalsIgnoreCase(fieldName)) {
            String billId = (String)this.tblMain.getCell(rowIndex, COL_ID).getValue();
            this.openAttachmentUI(billId);
            e.setCancel(true);
        }
    }

    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
    }

    protected void innerLoadFields() {
        if (this.reports == null || this.reports.size() == 0) {
            return;
        }
        this.addArrayListToTable(this.reports, this.tblMain);
    }

    private void addArrayListToTable(List rptArr, KDTable table) {
        table.removeRows();
        int count = rptArr.size();
        TaxDraftRecordInfo info = null;
        IRow row = null;
        for (int i = 0; i < count; ++i) {
            info = (TaxDraftRecordInfo)rptArr.get(i);
            row = table.addRow();
            row.getCell(COL_ID).setValue((Object)info.getId().toString());
            row.getCell(COL_ID).setUserObject((Object)info);
            row.getCell(COL_NUMBER).setValue((Object)info.getNumber());
            row.getCell(COL_NAME).setValue((Object)info.getName());
            row.getCell(COL_PERIOD).setValue((Object)info.getRptPeriod());
            row.getCell(COL_DECLARETYPE).setValue((Object)DeclaredTypeEnum.revenueDeclared);
            row.getCell(COL_DECLAREDATE).setValue((Object)Calendar.getInstance().getTime());
            row.getCell(COL_DECLAREAMT).setValue((Object)info.getPayAmount());
            row.getCell(COL_ATTACHMENT).setValue((Object)TDUtils.getString("com.kingdee.eas.tm.td.TaxDraftResource", COL_ATTACHMENT, null));
        }
    }

    protected void initContext() {
        this.billIds = (ArrayList)this.getUIContext().get("billIds");
        this.taxType = (TaxItemTypeInfo)this.getUIContext().get("taxType");
        this.recordType = (RecordTypeEnum)((Object)this.getUIContext().get("recordType"));
        this.declareAmtDataDefinition = (String)this.getUIContext().get("declareAmtDataDefinition");
    }

    protected void initParams() throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(COL_ID, new HashSet<String>(this.billIds), CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("rptPeriod.*"));
        view.setSelector(sic);
        TaxDraftRecordCollection coll = TaxDraftRecordFactory.getRemoteInstance().getTaxDraftRecordCollection(view);
        TaxDraftRecordInfo info = null;
        HashMap<String, TaxDraftRecordInfo> reportMap = new HashMap<String, TaxDraftRecordInfo>();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            reportMap.put(info.getId().toString(), info);
        }
        String declareAmtDataDefinitionValue = TDUtils.getTDParamsValue(null, this.declareAmtDataDefinition);
        String key = this.getFitKey(declareAmtDataDefinitionValue);
        Map reportItemValueMap = null;
        if (!StringUtils.isEmpty((String)key)) {
            reportItemValueMap = TaxStructureFacadeFactory.getRemoteInstance().getItemDataByDim(this.billIds, key);
        }
        this.reports = new ArrayList<TaxDraftRecordInfo>();
        String billId2 = null;
        Object value = null;
        TaxDraftRecordInfo reportInfo = null;
        for (String billId2 : this.billIds) {
            reportInfo = (TaxDraftRecordInfo)reportMap.get(billId2);
            if (reportItemValueMap != null && (value = reportItemValueMap.get(billId2)) != null) {
                if (value instanceof String) {
                    reportInfo.setPayAmount(new BigDecimal(value));
                } else if (value instanceof BigDecimal) {
                    reportInfo.setPayAmount(value);
                }
            }
            this.reports.add(reportInfo);
        }
    }

    private String getFitKey(String declareAmtDataDefinitionValue) throws BOSException {
        if (StringUtils.isEmpty((String)declareAmtDataDefinitionValue)) {
            return null;
        }
        String[] values = declareAmtDataDefinitionValue.split(";");
        String value2 = null;
        String[] items = null;
        String sheetNumber = null;
        HashMap<String, String> sheetNumberMap = new HashMap<String, String>();
        HashSet<String> numbers = new HashSet<String>();
        for (String value2 : values) {
            items = value2.split("_");
            if (items.length < 3) continue;
            sheetNumber = items[0];
            numbers.add(sheetNumber);
            sheetNumberMap.put(sheetNumber, value2);
        }
        TaxReportSheetInfo sheetInfo = StructureUtils.getTaxReportSheetByNumber(null, numbers, this.taxType, this.recordType);
        if (sheetInfo == null) {
            return null;
        }
        return (String)sheetNumberMap.get(sheetInfo.getNumber());
    }

    protected void initControl() {
        this.tblMain.getViewManager().setFreezeView(0, 4);
        for (int i = 0; i < LOCK_COLUMNS.length; ++i) {
            this.tblMain.getColumn(LOCK_COLUMNS[i]).getStyleAttributes().setLocked(true);
        }
        KDComboBox enumEditor = new KDComboBox();
        enumEditor.addItems(EnumUtils.getEnumList((String)DeclaredTypeEnum.class.getName()).toArray());
        this.tblMain.getColumn(COL_DECLARETYPE).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)enumEditor));
        KDDatePicker datePickerEditor = new KDDatePicker();
        this.tblMain.getColumn(COL_DECLAREDATE).setEditor((ICellEditor)new KDTDefaultCellEditor(datePickerEditor));
        KDFormattedTextField amt = new KDFormattedTextField();
        amt.setDataType(1);
        amt.setPrecision(2);
        amt.setSupportedEmpty(true);
        amt.setRemoveingZeroInDispaly(false);
        amt.setNegatived(false);
        amt.setHorizontalAlignment(4);
        KDTDefaultCellEditor amtEditor = new KDTDefaultCellEditor((JTextField)amt);
        this.tblMain.getColumn(COL_DECLAREAMT).setEditor((ICellEditor)amtEditor);
        this.tblMain.getColumn(COL_DECLAREAMT).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)2));
        this.tblMain.getColumn(COL_ATTACHMENT).getStyleAttributes().setFontColor(Color.BLUE);
    }

    public void openAttachmentUI(String boID) throws Exception {
        AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();
        if (boID == null) {
            return;
        }
        AttachmentUIContextInfo info = new AttachmentUIContextInfo();
        info.setBoID(boID);
        info.setCode("");
        info.setEdit(true);
        acm.showAttachmentListUIByBoID((Object)this, info);
    }

    protected void checkRequiredFields() {
        int rowCount = this.tblMain.getRowCount();
        StringBuffer sb = new StringBuffer();
        Object value = null;
        for (int i = 0; i < rowCount; ++i) {
            value = this.tblMain.getCell(i, COL_DECLARETYPE).getValue();
            if (value == null) {
                sb.append(TDUtils.getString("com.kingdee.eas.tm.td.TaxDraftResource", "DECLARETYPE_IsNull", null, new Object[]{i + 1})).append("\n");
            }
            if ((value = this.tblMain.getCell(i, COL_DECLAREAMT).getValue()) == null) {
                sb.append(TDUtils.getString("com.kingdee.eas.tm.td.TaxDraftResource", "DECLAREAMT_isNull", null, new Object[]{i + 1})).append("\n");
            }
            if ((value = this.tblMain.getCell(i, COL_DECLAREDATE).getValue()) != null) continue;
            sb.append(TDUtils.getString("com.kingdee.eas.tm.td.TaxDraftResource", "DECLAREDATE_isNull", null, new Object[]{i + 1})).append("\n");
        }
        if (sb.length() > 0) {
            MsgBox.showInfo((String)sb.toString());
            SysUtil.abort();
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.innerStoreFields();
    }

    protected void innerStoreFields() {
        int rowCount = this.tblMain.getRowCount();
        Object value = null;
        TaxDraftRecordInfo reportInfo = null;
        for (int i = 0; i < rowCount; ++i) {
            reportInfo = (TaxDraftRecordInfo)this.tblMain.getCell(i, COL_ID).getUserObject();
            value = this.tblMain.getCell(i, COL_DECLARETYPE).getValue();
            if (value != null) {
                reportInfo.setDeclaredType((DeclaredTypeEnum)((Object)value));
            }
            if ((value = this.tblMain.getCell(i, COL_DECLAREAMT).getValue()) != null) {
                reportInfo.setPayAmount((BigDecimal)value);
            }
            if ((value = this.tblMain.getCell(i, COL_DECLAREDATE).getValue()) != null) {
                reportInfo.setDraftDate((Date)value);
            }
            reportInfo.setDraftStatus(DraftStatusEnum.DECLARED);
            reportInfo.setDraftUser(SysContext.getSysContext().getCurrentUserInfo().getName());
        }
    }

    @Override
    public void actionOk_actionPerformed(ActionEvent e) throws Exception {
        this.checkRequiredFields();
        this.storeFields();
        this.isCanceled = false;
        this.getUIWindow().close();
    }

    public List<TaxDraftRecordInfo> getReports() {
        return this.reports;
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceled = true;
        this.getUIWindow().close();
    }

    public boolean isIsCanceled() {
        return this.isCanceled;
    }
}

