/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.client;

import com.kingdee.bos.ctrl.excel.io.kds.BookToKDSBook;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.excel.AbstractDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.BookDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.ui.Excel2007ExportController;
import com.kingdee.bos.ctrl.kdf.excel.ui.ExportEvent;
import com.kingdee.bos.ctrl.kdf.excel.ui.ExportListener;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.export.ExporterParameter;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.util.printout.PrintableBook;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.newrpt.SpreadHelper;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.RptBillRangeEntryCollection;
import com.kingdee.eas.tm.td.basedata.RptBillRangeEntryInfo;
import com.kingdee.eas.tm.td.basedata.RptBillRangeInfo;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class ExportAction {
    boolean iscomplete = false;

    public Map saveToFile(Map exportParam) {
        boolean isMkSuccess;
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("isSuccess", false);
        StringBuffer errorMsg = new StringBuffer();
        String exportPath = (String)exportParam.get("exportPath");
        String fileName = this.getFileName(exportParam);
        File file = new File(fileName);
        File path = new File(file.getParent());
        if (!path.exists() && !(isMkSuccess = path.mkdirs())) {
            errorMsg.append(TDUtils.getString("com.kingdee.eas.tm.td.TaxDraftExportResource", "MkDirError", TDUtils.getLocale())).append("\n");
            ret.put("isSuccess", false);
            ret.put("errorMsg", errorMsg.toString());
            return ret;
        }
        boolean is_success = false;
        int exportFormat = (Integer)exportParam.get("exportFormat");
        if (exportFormat == 0) {
            is_success = this.exportToExcel2007(fileName, exportParam, errorMsg);
        } else if (exportFormat == 1) {
            is_success = this.exportToXls(fileName, exportParam, errorMsg);
        } else if (exportFormat == 2) {
            is_success = this.exportToXml(fileName, exportParam, errorMsg);
        } else if (exportFormat == 3) {
            is_success = this.exportToPdf(fileName, exportParam, errorMsg);
        } else if (exportFormat == 4) {
            is_success = this.exportToHtml(fileName, exportParam, errorMsg);
        }
        ret.put("isSuccess", is_success);
        ret.put("errorMsg", errorMsg.toString());
        return ret;
    }

    private String getFileName(Map exportParam) {
        String name = (String)exportParam.get("fileName");
        String exportPath = (String)exportParam.get("exportPath");
        int exportFormat = (Integer)exportParam.get("exportFormat");
        String fileName = exportPath + File.separator + name;
        if (exportFormat == 0) {
            fileName = fileName + ".xlsx";
        } else if (exportFormat == 1) {
            fileName = fileName + ".xls";
        } else if (exportFormat == 2) {
            fileName = fileName + ".xml";
        } else if (exportFormat == 3) {
            fileName = fileName + ".pdf";
        } else if (exportFormat == 4) {
            fileName = fileName + ".html";
        }
        return fileName;
    }

    private void removeIsNotExportExcel(ReportBaseInfo reportInfo, Book book) {
        if (reportInfo.get("billRange") == null) {
            return;
        }
        RptBillRangeInfo billRange = (RptBillRangeInfo)reportInfo.get("billRange");
        RptBillRangeEntryCollection entrys = billRange.getEntrys();
        RptBillRangeEntryInfo entryInfo = null;
        int size = entrys.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = entrys.get(i);
            if (entryInfo.isIsExported()) continue;
            book.removeSheet(entryInfo.getBillName());
        }
    }

    private boolean exportToExcel2007(String fileName, Map exportParam, StringBuffer errorMsg) {
        ReportBaseInfo reportInfo = (ReportBaseInfo)exportParam.get("reportInfo");
        try {
            Book book = reportInfo.getBook();
            String[] sns = this.getBookSheetNames(book);
            if (sns.length == 0) {
                errorMsg.append(TDUtils.getString("com.kingdee.eas.tm.td.TaxDraftExportResource", "SheetNotExist", TDUtils.getLocale(), new Object[]{((CompanyOrgUnitInfo)reportInfo.get("companyOrgUnit")).getName(), reportInfo.getName()})).append("\n");
                return false;
            }
            Book tempBook = SpreadHelper.copyBook((Book)book);
            this.removeIsNotExportExcel(reportInfo, tempBook);
            BookDataWrapper bookDataWrapper = new BookDataWrapper(tempBook);
            int exportOption = (Integer)exportParam.get("exportOption");
            if (exportOption == 1) {
                bookDataWrapper.setExportFormula(true);
                bookDataWrapper.setExportCustomerFomulas(false);
            } else if (exportOption == 0) {
                bookDataWrapper.setExportFormula(true);
                bookDataWrapper.setExportCustomerFomulas(true);
            } else {
                bookDataWrapper.setExportFormula(false);
                bookDataWrapper.setExportCustomerFomulas(true);
                bookDataWrapper.setShowValue(true);
            }
            bookDataWrapper.setExportHideCols(true);
            bookDataWrapper.setExportHideRows(true);
            Excel2007ExportController.export((String)fileName, (AbstractDataWrapper)bookDataWrapper, (boolean)false, (ExportListener[])new ExportListener[]{new ExportListener2007()});
            return true;
        }
        catch (Exception e) {
            errorMsg.append(TDUtils.getString("com.kingdee.eas.tm.td.TaxDraftExportResource", "ExportError", TDUtils.getLocale(), new Object[]{((CompanyOrgUnitInfo)reportInfo.get("companyOrgUnit")).getName(), reportInfo.getNumber()})).append(",").append(e.getMessage()).append("\n");
            return false;
        }
    }

    private boolean exportToXls(String fileName, Map exportParam, StringBuffer errorMsg) {
        ReportBaseInfo reportInfo = (ReportBaseInfo)exportParam.get("reportInfo");
        try {
            Book book = reportInfo.getBook();
            String[] sns = this.getBookSheetNames(book);
            if (sns.length == 0) {
                errorMsg.append(TDUtils.getString("com.kingdee.eas.tm.td.TaxDraftExportResource", "SheetNotExist", TDUtils.getLocale(), new Object[]{((CompanyOrgUnitInfo)reportInfo.get("companyOrgUnit")).getName(), reportInfo.getName()})).append("\n");
                return false;
            }
            Book tempBook = SpreadHelper.copyBook((Book)book);
            this.removeIsNotExportExcel(reportInfo, tempBook);
            for (int i = 0; i < tempBook.getSheetCount(); ++i) {
                Sheet sheet = tempBook.getSheet(i);
                if (sheet.getMaxColIndex() <= 255 && sheet.getMaxRowIndex() <= 65535) continue;
                try {
                    if (tempBook == book) {
                        tempBook = SpreadHelper.copyBook((Book)book);
                        sheet = tempBook.getSheet(i);
                    }
                    if (sheet.getMaxColIndex() > 255) {
                        sheet.getColRange(256, sheet.getMaxColIndex()).delete();
                    }
                    if (sheet.getMaxRowIndex() <= 65535) continue;
                    sheet.getRowRange(65536, sheet.getMaxRowIndex()).delete();
                    continue;
                }
                catch (Exception e) {
                    errorMsg.append(TDUtils.getString("com.kingdee.eas.tm.td.TaxDraftExportResource", "ExportError", TDUtils.getLocale(), new Object[]{((CompanyOrgUnitInfo)reportInfo.get("companyOrgUnit")).getName(), reportInfo.getNumber()})).append(",").append(e.getMessage()).append("\n");
                    return false;
                }
            }
            KDSBook kdsbook = BookToKDSBook.traslate((Book)tempBook, (String[])sns);
            ExportManager em = new ExportManager();
            em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_TRUE, (Object)"TRUE");
            em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_FALSE, (Object)"FALSE");
            int exportOption = (Integer)exportParam.get("exportOption");
            if (exportOption == 1) {
                em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"true");
                em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"true");
                em.setExporterParmeter(ExporterParameter.EXPORT_CUSTOM_FORMULA, (Object)"false");
            } else if (exportOption == 0) {
                em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"true");
                em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"true");
            } else {
                em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"false");
            }
            em.exportToExcel(kdsbook, fileName);
        }
        catch (Exception e) {
            errorMsg.append(TDUtils.getString("com.kingdee.eas.tm.td.TaxDraftExportResource", "ExportError", TDUtils.getLocale(), new Object[]{((CompanyOrgUnitInfo)reportInfo.get("companyOrgUnit")).getName(), reportInfo.getName()})).append(",").append(e.getMessage()).append("\n");
            return false;
        }
        return true;
    }

    private boolean exportToXml(String fileName, Map exportParam, StringBuffer errorMsg) {
        ReportBaseInfo reportInfo = (ReportBaseInfo)exportParam.get("reportInfo");
        try {
            Book book = reportInfo.getBook();
            String[] sns = this.getBookSheetNames(book);
            if (sns.length == 0) {
                errorMsg.append(TDUtils.getString("com.kingdee.eas.tm.td.TaxDraftExportResource", "SheetNotExist", TDUtils.getLocale(), new Object[]{((CompanyOrgUnitInfo)reportInfo.get("companyOrgUnit")).getName(), reportInfo.getName()})).append("\n");
                return false;
            }
            Book tempBook = SpreadHelper.copyBook((Book)book);
            this.removeIsNotExportExcel(reportInfo, tempBook);
            IOHelper.saveToFile((Book)tempBook, (String)fileName, (String[])sns);
            return true;
        }
        catch (Exception e) {
            errorMsg.append(TDUtils.getString("com.kingdee.eas.tm.td.TaxDraftExportResource", "ExportError", TDUtils.getLocale(), new Object[]{((CompanyOrgUnitInfo)reportInfo.get("companyOrgUnit")).getName(), reportInfo.getNumber()})).append(",").append(e.getMessage()).append("\n");
            return false;
        }
    }

    private boolean exportToPdf(String fileName, Map exportParam, StringBuffer errorMsg) {
        ReportBaseInfo reportInfo = (ReportBaseInfo)exportParam.get("reportInfo");
        try {
            Book book = reportInfo.getBook();
            String[] sns = this.getBookSheetNames(book);
            if (sns.length == 0) {
                errorMsg.append(TDUtils.getString("com.kingdee.eas.tm.td.TaxDraftExportResource", "SheetNotExist", TDUtils.getLocale(), new Object[]{((CompanyOrgUnitInfo)reportInfo.get("companyOrgUnit")).getName(), reportInfo.getName()})).append("\n");
                return false;
            }
            Book tempBook = SpreadHelper.copyBook((Book)book);
            this.removeIsNotExportExcel(reportInfo, tempBook);
            KDSBook kdsbook = BookToKDSBook.traslate((Book)tempBook, (String[])sns);
            PrintableBook prtbook = new PrintableBook(kdsbook);
            new ExportManager().exportToPdfFile(prtbook, fileName);
        }
        catch (Exception e) {
            errorMsg.append(TDUtils.getString("com.kingdee.eas.tm.td.TaxDraftExportResource", "ExportError", TDUtils.getLocale(), new Object[]{((CompanyOrgUnitInfo)reportInfo.get("companyOrgUnit")).getName(), reportInfo.getNumber()})).append(",").append(e.getMessage()).append("\n");
        }
        return true;
    }

    private boolean exportToHtml(String fileName, Map exportParam, StringBuffer errorMsg) {
        ReportBaseInfo reportInfo = (ReportBaseInfo)exportParam.get("reportInfo");
        try {
            Book book = reportInfo.getBook();
            String[] sns = this.getBookSheetNames(book);
            if (sns.length == 0) {
                errorMsg.append(TDUtils.getString("com.kingdee.eas.tm.td.TaxDraftExportResource", "SheetNotExist", TDUtils.getLocale(), new Object[]{((CompanyOrgUnitInfo)reportInfo.get("companyOrgUnit")).getName(), reportInfo.getName()})).append("\n");
                return false;
            }
            Book tempBook = SpreadHelper.copyBook((Book)book);
            this.removeIsNotExportExcel(reportInfo, tempBook);
            KDSBook kdsbook = BookToKDSBook.traslate((Book)tempBook, (String[])sns);
            PrintableBook prtbook = new PrintableBook(kdsbook);
            new ExportManager().exportToHtmlFile(prtbook, fileName);
            return true;
        }
        catch (Exception e) {
            errorMsg.append(TDUtils.getString("com.kingdee.eas.tm.td.TaxDraftExportResource", "ExportError", TDUtils.getLocale(), new Object[]{((CompanyOrgUnitInfo)reportInfo.get("companyOrgUnit")).getName(), reportInfo.getNumber()})).append(",").append(e.getMessage()).append("\n");
            return false;
        }
    }

    private String[] getBookSheetNames(Book book) {
        String[] sns = new String[book.getSheetCount()];
        for (int i = 0; i < book.getSheetCount(); ++i) {
            sns[i] = book.getSheetName(i);
        }
        return sns;
    }

    class ExportListener2007
    implements ExportListener {
        ExportListener2007() {
        }

        public void complete(ExportEvent e) {
            ExportAction.this.iscomplete = true;
        }

        public void delEvent(ExportEvent e) {
        }
    }
}

