/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.client;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.io.kds.KDSBookToBook;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Comment;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.kdf.read.POIXlsxReader;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.eas.fi.newrpt.designer.comment.CommentUtil;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.tm.td.ReportImportType;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.TaxDraftRecordInfo;
import com.kingdee.util.StringUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;

public class ImportAction {
    public static final String KDF = "kdf";
    public static final String XLS = "xls";
    public static final String XLSX = "xlsx";
    public static final String XML = "xml";
    public static final String PDF = "pdf";
    public static final String HTM = "htm";
    public static final String HTML = "html";

    public Map importToReport(Map importParam) throws Exception {
        ReportImportType importTypeEnum = (ReportImportType)((Object)importParam.get("importType"));
        int importType = importTypeEnum.getValue();
        String fileName = (String)importParam.get("fileName");
        boolean isSuccess = false;
        HashMap<String, Object> ret = new HashMap<String, Object>();
        StringBuffer errorMsg = new StringBuffer();
        ret.put("errorMsg", errorMsg);
        ret.put("isSuccess", isSuccess);
        Book importBook = this.fileTransBook(fileName, errorMsg);
        if (importBook == null) {
            return ret;
        }
        if (importBook.getSheetCount() == 0) {
            errorMsg.append(TDUtils.getString("com.kingdee.eas.tm.td.TaxDraftExportResource", "FILE_SHEET_NOTEXIST", TDUtils.getLocale(), new Object[]{this.getFileName(fileName)})).append("\n");
            return ret;
        }
        if (importType == 0) {
            this.overWriteImport(importParam, importBook, errorMsg);
        } else if (importType == 1) {
            this.appendImport(importParam, importBook, errorMsg);
        }
        if (errorMsg.length() == 0) {
            isSuccess = true;
        }
        ret.put("errorMsg", errorMsg.toString());
        ret.put("isSuccess", isSuccess);
        return ret;
    }

    protected void appendImport(Map importParam, Book importBook, StringBuffer errorMsg) throws Exception {
        int i;
        int importOption = (Integer)importParam.get("importOption");
        ReportBaseInfo reportInfo = (ReportBaseInfo)importParam.get("reportInfo");
        Book book = reportInfo.getBook();
        int cellDisplayMode = book.getActiveSheet().getSheetOption().getCellDisplayMode();
        BookProperties bpSrc = BookProperties.loadFromBook((Book)importBook);
        BookProperties bpDest = BookProperties.loadFromBook((Book)book);
        byte[] data = bpDest.toByteData();
        boolean b = book.getUndoManager().isEnable();
        book.getUndoManager().discardAllEdits();
        book.getUndoManager().enable(false);
        book.startGroup();
        HashSet<String> names = new HashSet<String>(importBook.getSheetCount());
        for (i = 0; i < importBook.getSheetCount(); ++i) {
            String name = importBook.getSheet(i).getSheetName();
            names.add(name);
        }
        for (i = 0; i < importBook.getSheetCount(); ++i) {
            String srcName = importBook.getSheetName(i);
            Sheet sheet = importBook.getSheet(i);
            sheet.getSheetOption().setCellDisplayMode(cellDisplayMode);
            String destName = this.getSheetName(srcName, book);
            if (!srcName.equals(destName)) {
                sheet.setName(destName);
                bpSrc.notifyRenameSheet(srcName, destName);
            }
            book.addSheet(sheet, false);
            this.croppSheet(sheet, importOption);
            sheet.updateUnknownMethod(book.getDeps().getUnknownMethodManager());
        }
        bpDest = bpDest.loadFromByteData(data);
        bpDest.merge(bpSrc);
        bpDest.restoreToBook(book);
        book.endGroup();
        book.getUndoManager().enable(b);
        reportInfo.setBook(book);
    }

    private String[] getSelectedSheets(Book book) {
        String[] sns = new String[book.getSheetCount()];
        for (int i = 0; i < book.getSheetCount(); ++i) {
            sns[i] = book.getSheetName(i);
        }
        return sns;
    }

    private String getSheetName(String name, Book book) {
        String src = name;
        int count = 1;
        while (book.getSheet(src) != null) {
            src = name + "(" + count + ")";
            ++count;
        }
        return src;
    }

    private Book fileTransBook(String fileName, StringBuffer errorMsg) {
        Book book = null;
        if (StringUtils.isEmpty((String)fileName)) {
            return null;
        }
        if (this.acceptExtension(fileName, XLS)) {
            book = this.openSheetListFromXls(fileName, errorMsg);
        } else if (this.acceptExtension(fileName, XLSX)) {
            book = this.openSheetListFromXlsx(fileName, errorMsg);
        } else if (this.acceptExtension(fileName, XML)) {
            book = this.openSheetListFromXml(fileName, errorMsg);
        }
        return book;
    }

    private Book openSheetListFromXls(String fileName, StringBuffer errorMsg) {
        KDSBook kdsbook = null;
        try {
            kdsbook = POIXlsReader.parse2((String)fileName);
        }
        catch (FileNotFoundException e) {
            errorMsg.append(TDUtils.getString("com.kingdee.eas.tm.td.TaxDraftExportResource", "FILE_OPEN_ERORR", TDUtils.getLocale(), new Object[]{this.getFileName(fileName)})).append("\n");
            return null;
        }
        catch (IOException e) {
            errorMsg.append(TDUtils.getString("com.kingdee.eas.tm.td.TaxDraftExportResource", "FILE_OPEN_ERORR", TDUtils.getLocale(), new Object[]{this.getFileName(fileName)})).append("\n");
            return null;
        }
        catch (Exception e) {
            errorMsg.append(TDUtils.getString("com.kingdee.eas.tm.td.TaxDraftExportResource", "FILE_OPEN_ERORR", TDUtils.getLocale(), new Object[]{this.getFileName(fileName)})).append("\n");
            return null;
        }
        if (kdsbook != null) {
            return KDSBookToBook.traslate((KDSBook)kdsbook);
        }
        errorMsg.append(TDUtils.getString("com.kingdee.eas.tm.td.TaxDraftExportResource", "FILE_PARSE_ERROR", TDUtils.getLocale(), new Object[]{this.getFileName(fileName)})).append("\n");
        return null;
    }

    private Book openSheetListFromXlsx(String fileName, StringBuffer errorMsg) {
        KDSBook kdsbook = null;
        try {
            new POIXlsxReader();
            kdsbook = POIXlsxReader.parse2((String)fileName);
        }
        catch (FileNotFoundException e) {
            errorMsg.append(TDUtils.getString("com.kingdee.eas.tm.td.TaxDraftExportResource", "FILE_OPEN_ERORR", TDUtils.getLocale(), new Object[]{this.getFileName(fileName)})).append("\n");
            return null;
        }
        catch (IOException e) {
            errorMsg.append(TDUtils.getString("com.kingdee.eas.tm.td.TaxDraftExportResource", "FILE_OPEN_ERORR", TDUtils.getLocale(), new Object[]{this.getFileName(fileName)})).append("\n");
            return null;
        }
        catch (Exception e) {
            errorMsg.append(TDUtils.getString("com.kingdee.eas.tm.td.TaxDraftExportResource", "FILE_OPEN_ERORR", TDUtils.getLocale(), new Object[]{this.getFileName(fileName)})).append("\n");
            return null;
        }
        if (kdsbook != null) {
            return KDSBookToBook.traslate((KDSBook)kdsbook);
        }
        errorMsg.append(TDUtils.getString("com.kingdee.eas.tm.td.TaxDraftExportResource", "FILE_PARSE_ERROR", TDUtils.getLocale(), new Object[]{this.getFileName(fileName)})).append("\n");
        return null;
    }

    private Book openSheetListFromXml(String fileName, StringBuffer errorMsg) {
        try {
            return IOHelper.loadFile((String)fileName);
        }
        catch (Exception e) {
            errorMsg.append(TDUtils.getString("com.kingdee.eas.tm.td.TaxDraftExportResource", "FILE_OPEN_ERORR", TDUtils.getLocale(), new Object[]{this.getFileName(fileName)})).append("\n");
        }
        catch (Throwable e1) {
            errorMsg.append(TDUtils.getString("com.kingdee.eas.tm.td.TaxDraftExportResource", "FILE_OPEN_ERORR", TDUtils.getLocale(), new Object[]{this.getFileName(fileName)})).append("\n");
        }
        return null;
    }

    private boolean acceptExtension(String fileName, String extension) {
        return fileName.toLowerCase(Locale.ENGLISH).endsWith(extension.toLowerCase(Locale.ENGLISH));
    }

    protected void overWriteImport(Map importParam, Book importBook, StringBuffer errorMsg) throws Exception {
        int importOption = (Integer)importParam.get("importOption");
        String fileName = (String)importParam.get("fileName");
        TaxDraftRecordInfo reportInfo = (TaxDraftRecordInfo)importParam.get("reportInfo");
        Book book = reportInfo.getBook();
        if (book.getProtection().isProtected()) {
            errorMsg.append(TDUtils.getString("com.kingdee.eas.tm.td.TaxDraftExportResource", "WORKBOOK_PROTECT", TDUtils.getLocale(), new Object[]{this.getFileName(fileName)})).append("\n");
            return;
        }
        boolean b = book.getUndoManager().isEnable();
        book.getUndoManager().discardAllEdits();
        book.getUndoManager().enable(false);
        book.startGroup();
        int cellDisplayMode = book.getActiveSheet().getSheetOption().getCellDisplayMode();
        LinkedList<String> snsNameList = new LinkedList<String>();
        for (int i = 0; i < importBook.getSheetCount(); ++i) {
            snsNameList.add(importBook.getSheetName(i));
        }
        int count = book.getSheetCount();
        ArrayList<String> deleteSheetNameList = new ArrayList<String>();
        block1: for (int i = 0; i < count; ++i) {
            Sheet sheet = book.getSheet(i);
            boolean isExistSheet = false;
            for (String sheetName : snsNameList) {
                if (!sheetName.equalsIgnoreCase(sheet.getSheetName())) continue;
                isExistSheet = true;
                break;
            }
            if (!isExistSheet) continue;
            if (sheet.getSheetOption().getProtection(true).isProtected()) {
                if (this.hasLockedCell(sheet)) {
                    this.overWriterImportWithProtection(sheet, importBook.getSheet(sheet.getSheetName()), importOption);
                    Iterator iterator = snsNameList.iterator();
                    while (iterator.hasNext()) {
                        String sheetName;
                        sheetName = (String)iterator.next();
                        if (!sheetName.equalsIgnoreCase(sheet.getSheetName())) continue;
                        iterator.remove();
                        continue block1;
                    }
                    continue;
                }
                deleteSheetNameList.add(sheet.getSheetName());
                continue;
            }
            deleteSheetNameList.add(sheet.getSheetName());
        }
        HashMap<String, String> ids = new HashMap<String, String>();
        for (String sheetName : deleteSheetNameList) {
            ids.put(sheetName, book.getSheet(sheetName).getID());
            book.removeSheet(sheetName);
        }
        BookProperties bpsrc = BookProperties.loadFromBook((Book)book);
        int i = 0;
        String firstImportSheetName = null;
        for (String sheetName : snsNameList) {
            Sheet sheet = importBook.getSheet(sheetName);
            sheet.getSheetOption().setCellDisplayMode(cellDisplayMode);
            if (i == 0) {
                firstImportSheetName = sheetName;
            }
            book.addSheet(sheet, false);
            if (ids.get(sheetName) != null) {
                sheet.setID((String)ids.get(sheetName));
            }
            this.croppSheet(sheet, importOption);
            sheet.updateUnknownMethod(book.getDeps().getUnknownMethodManager());
            ++i;
        }
        BookProperties bp = BookProperties.loadFromBook((Book)importBook);
        bp.merge(bpsrc);
        bp.restoreToBook(book);
        if (firstImportSheetName != null) {
            if (book.getActiveSheet() != null) {
                book.getActiveSheet().setSelected(false);
            }
            book.setActiveSheet(firstImportSheetName);
        }
        book.endGroup();
        book.getUndoManager().enable(b);
        reportInfo.setBook(book);
    }

    private boolean hasLockedCell(Sheet sheet) {
        if (!sheet.getSheetOption().getProtection(true).isProtected()) {
            return false;
        }
        Sheet.ICellsIterator iterator = sheet.getCellsIterator(sheet.getSheetRange().getBlock(0), false, false);
        while (iterator.hasNext()) {
            Cell cell = iterator.next();
            if (!cell.isLocked()) continue;
            return true;
        }
        return false;
    }

    protected void overWriterImportWithProtection(Sheet sourceSheet, Sheet targetSheet, int importOption) {
        int targetRowIndex = targetSheet.getMaxRowIndex();
        int targetColIndex = targetSheet.getMaxColIndex();
        int sourceRowIndex = sourceSheet.getMaxRowIndex();
        int sourceColIndex = sourceSheet.getMaxColIndex();
        int rowCount = Math.max(targetRowIndex, sourceRowIndex);
        int colCount = Math.max(targetColIndex, sourceColIndex);
        int option = importOption;
        for (int row = 0; row <= rowCount; ++row) {
            for (int col = 0; col <= colCount; ++col) {
                Cell targetCell = targetSheet.getCell(row, col, true);
                Cell sourceCell = sourceSheet.getCell(row, col, true);
                if (sourceCell.isLocked()) continue;
                if (option == 2) {
                    sourceCell.setValue(Variant.nullVariant);
                    sourceCell.setFormula(targetCell.getFormula());
                } else if (option == 1) {
                    sourceCell.setFormula(null);
                    sourceCell.setValue(targetCell.getValue());
                } else {
                    sourceCell.setValue(targetCell.getValue());
                    sourceCell.setFormula(targetCell.getFormula());
                }
                sourceCell.setComment((Comment)CommentUtil.getReportComment((Cell)targetCell));
                if (!targetCell.isLocked()) continue;
                StyleAttributes sa = Styles.getEmptySA();
                sa.setLocked(true);
                sourceSheet.getRange(sourceCell).setStyle(sa, Styles.getEmptySA());
            }
        }
        if (targetSheet.getUserObjects() != null && targetSheet.getUserObjects().size() > 0) {
            if (sourceSheet.getUserObjects() != null) {
                sourceSheet.getUserObjects().clear();
            }
            for (int i = 0; i < targetSheet.getUserObjects().size(); ++i) {
                sourceSheet.setUserObject(targetSheet.getUserObjects().getUserObject(i).getKey(), targetSheet.getUserObjects().getUserObject(i).getValue());
            }
        } else if (sourceSheet.getUserObjects() != null) {
            sourceSheet.getUserObjects().clear();
        }
    }

    private void croppSheet(Sheet sheet, int importOption) {
        int option = importOption;
        if (option == 0) {
            return;
        }
        Sheet.ICellsIterator it = sheet.getCellsIterator(null, false, false);
        while (it.hasNext()) {
            Cell cell = it.next();
            String formula = cell.getFormula();
            if (formula == null || formula.length() <= 0 || formula.charAt(0) != '=') continue;
            if (option == 1) {
                cell.setValue(Variant.nullVariant);
                cell.setFormula(formula);
                continue;
            }
            if (option != 2) continue;
            Variant value = cell.getValue();
            cell.setFormula(null);
            cell.setValue(value);
        }
    }

    public String getFileName(String fileAllName) {
        String fName = fileAllName.trim();
        String[] temp = fName.split("\\\\");
        String fileName = temp[temp.length - 1];
        return fileName;
    }
}

