/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.client.designer.SpreadManager;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.tm.td.DraftBillBuildCenter;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.TaxBaseBillInfo;
import com.kingdee.eas.tm.td.TaxDraftRecordInfo;
import com.kingdee.eas.tm.td.TaxOtherReportInfo;
import com.kingdee.eas.tm.td.basedata.RptBillRangeEntryCollection;
import com.kingdee.eas.tm.td.basedata.RptBillRangeEntryInfo;
import com.kingdee.eas.tm.td.structure.utils.StructureUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Point;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.GregorianCalendar;
import java.util.List;

public class ReportUIHelper {
    public static void addDraftConfirmSheet(ReportBaseInfo reportInfo, Book book, SpreadManager spreadManager, boolean isActive) {
        RptBillRangeEntryCollection billRangeEntrys = DraftBillBuildCenter.getBillRangeEntry(reportInfo);
        if (billRangeEntrys == null) {
            MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.TDResource", "INSERT_ERROR_NOBILLS", TDUtils.getLocale()));
            return;
        }
        for (int k = 0; k < billRangeEntrys.size(); ++k) {
            RptBillRangeEntryInfo entry = billRangeEntrys.get(k);
            String bosType = entry.getBillBosType();
            String billName = entry.getBillName();
            Sheet exists = book.getSheet(billName);
            if (exists != null) continue;
            Sheet rptSheet = new Sheet(book, billName);
            rptSheet.setUserObject("bosType", (Object)bosType);
            book.addSheet(rptSheet);
            rptSheet.setSelected(false);
            if (isActive) {
                book.setActiveSheet(rptSheet);
            }
            rptSheet.getRange(0, 0, rptSheet.getMaxRowIndex(), rptSheet.getMaxColIndex()).clear(true, true, false, true, new String[0]);
            int top = rptSheet.getActiveRow();
            int left = rptSheet.getActiveCol();
            DraftBillBuildCenter.initDraftBillInfos(null, bosType);
            List<DraftBillBuildCenter> fieldList = DraftBillBuildCenter.getFieldsList(bosType);
            int index = 0;
            for (int i = 0; i < fieldList.size(); ++i) {
                DraftBillBuildCenter info = fieldList.get(i);
                int valueRangeTop = top;
                if (info.getFieldName().equals("companyOrgUnit") && bosType.equals("ED4D060A")) continue;
                rptSheet.getRange(valueRangeTop, left + index).setValue(new Variant((Object)info.getFieldDisplayName()));
                rptSheet.getRange(valueRangeTop, left + index).setUserObject("fieldKey", (Object)info.getFieldName());
                if (info.getProperty() instanceof LinkPropertyInfo) {
                    StyleAttributes sa = Styles.getEmptySA();
                    sa.setNumberFormat("@");
                    rptSheet.getColRange(left + index, left + index).setStyle(sa, sa);
                }
                StructureUtils.autoSetColWidth(spreadManager, rptSheet, valueRangeTop, left + index);
                ++index;
            }
            Range range = rptSheet.getRange(top, left);
            range.setUserObject("fieldsCount", (Object)fieldList.size());
        }
    }

    public static void saveDraftBill(ReportBaseInfo reportInfo, Book book) throws BOSException {
        RptBillRangeEntryCollection entrys;
        if (TDUtils.isAuditBill(reportInfo)) {
            MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.TDResource", "NOT_AUDIT", TDUtils.getLocale()));
            SysUtil.abort();
        }
        if ((entrys = DraftBillBuildCenter.getBillRangeEntry(reportInfo)) == null) {
            MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.TDResource", "SAVE_ERROR_NOBILLS", TDUtils.getLocale()));
            SysUtil.abort();
        }
        boolean isError = false;
        StringBuffer errorDetail = new StringBuffer();
        for (int k = 0; k < entrys.size(); ++k) {
            RptBillRangeEntryInfo entry = entrys.get(k);
            String billName = entry.getBillName();
            String billBosType = entry.getBillBosType();
            Sheet activeSheet = book.getSheet(billName);
            if (activeSheet == null) {
                errorDetail.append(TDUtils.getString("com.kingdee.eas.tm.td.TDResource", "NOT_EXISTS_SHEET", TDUtils.getLocale(), new Object[]{billName})).append("\r\n");
                isError = true;
                continue;
            }
            int rowCount = activeSheet.getRows().getMaxIntMark() + 1;
            int colCount = activeSheet.getCols().getMaxIntMark() + 1;
            Point point = new Point(0, 0);
            int fieldsCount = 0;
            block3: for (int i = 0; i < rowCount; ++i) {
                for (int j = 0; j < colCount; ++j) {
                    Object userObject = activeSheet.getRange(i, j).getUserObject("fieldsCount");
                    if (userObject == null) continue;
                    point = new Point(j, i);
                    fieldsCount = (Integer)userObject;
                    break block3;
                }
            }
            CoreBaseCollection taxBills = new CoreBaseCollection();
            int rowIndex = point.y + 1;
            int colIndex = point.x;
            String fieldKey = null;
            Object fieldValue = null;
            DraftBillBuildCenter fieldsInfo = null;
            EntityObjectInfo entityInfo = DraftBillBuildCenter.getDrafteBillEntity(null, billBosType);
            for (int i = rowIndex; i < rowCount; ++i) {
                isError = false;
                TaxBaseBillInfo info = DraftBillBuildCenter.getTaxBillInfo(entityInfo);
                if (reportInfo instanceof TaxDraftRecordInfo) {
                    TaxDraftRecordInfo value = (TaxDraftRecordInfo)reportInfo;
                    info.setRptId(value.getId().toString());
                    info.setTaxItemType(value.getTaxType());
                    info.setReport(value);
                } else if (reportInfo instanceof TaxOtherReportInfo) {
                    TaxOtherReportInfo value = (TaxOtherReportInfo)reportInfo;
                    info.setRptId(value.getId().toString());
                    info.setOtherReport(value);
                }
                for (int j = colIndex; j < colIndex + fieldsCount; ++j) {
                    if (activeSheet.getRange(point.y, j).getUserObject("fieldKey") == null) continue;
                    fieldKey = activeSheet.getRange(point.y, j).getUserObject("fieldKey").toString();
                    fieldValue = null;
                    Object value = activeSheet.getRange(i, j).getValue().getValue();
                    fieldsInfo = (DraftBillBuildCenter)DraftBillBuildCenter.getFieldsMap(billBosType).get(fieldKey);
                    if (fieldsInfo == null) continue;
                    try {
                        if (value instanceof String) {
                            fieldValue = value.toString();
                        } else if (value instanceof GregorianCalendar) {
                            GregorianCalendar time = (GregorianCalendar)value;
                            fieldValue = time.getTime();
                        } else if (value instanceof Date) {
                            Date date = (Date)value;
                            fieldValue = date;
                        } else if (value instanceof BigDecimal) {
                            fieldValue = new BigDecimal(value.toString());
                        }
                        if ("companyOrgUnit".equals(fieldKey) && (fieldValue == null || fieldValue.toString().isEmpty())) {
                            isError = true;
                            break;
                        }
                        DraftBillBuildCenter.buildDraftBillInfo(fieldKey, fieldValue, (IObjectValue)info, fieldsInfo);
                        continue;
                    }
                    catch (Exception ex) {
                        isError = true;
                        errorDetail.append(DraftBillBuildCenter.buildErrorResult(i, fieldKey, fieldValue, fieldsInfo)).append("\r\n");
                    }
                }
                if (isError) continue;
                taxBills.add((CoreBaseInfo)info);
            }
            if (taxBills.size() <= 0) continue;
            ReportUIHelper.saveTaxBills(billBosType, entityInfo, taxBills, errorDetail);
        }
        if (errorDetail.length() > 0) {
            String error = TDUtils.getString("com.kingdee.eas.tm.td.TDResource", "draftSaveError", TDUtils.getLocale());
            MsgBox.showDetailAndOK(null, (String)error, (String)errorDetail.toString(), (int)0);
            SysUtil.abort();
        } else {
            MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.TDResource", "SAVE_SUCESS", TDUtils.getLocale()));
        }
    }

    private static boolean saveTaxBills(String bosType, EntityObjectInfo entityInfo, CoreBaseCollection taxBills, StringBuffer errorDetail) {
        try {
            String bizInterface = entityInfo.getBusinessInterface();
            ICoreBillBase iBillBase = (ICoreBillBase)BOSObjectFactory.createRemoteBOSObject((BOSObjectType)new BOSObjectType(bosType), Class.forName(bizInterface));
            iBillBase.save(taxBills);
        }
        catch (Exception e) {
            errorDetail.append(e.getMessage()).append("\r\n");
        }
        return true;
    }

    public static void deleteDraftBill(ReportBaseInfo reportInfo) throws BOSException, EASBizException {
        RptBillRangeEntryCollection entrys;
        if (TDUtils.isAuditBill(reportInfo)) {
            MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.TDResource", "DEL_ERROR_ISAUDIT", TDUtils.getLocale()));
            SysUtil.abort();
        }
        if ((entrys = DraftBillBuildCenter.getBillRangeEntry(reportInfo)) == null) {
            MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.TDResource", "DEL_ERROR_NOBILLS", TDUtils.getLocale()));
            return;
        }
        for (int i = 0; i < entrys.size(); ++i) {
            RptBillRangeEntryInfo entry = entrys.get(i);
            String billBosType = entry.getBillBosType();
            EntityObjectInfo entityInfo = DraftBillBuildCenter.getDrafteBillEntity(null, billBosType);
            String bizInterface = entityInfo.getBusinessInterface();
            try {
                FilterInfo filter = new FilterInfo();
                filter.appendFilterItem("rptId", (Object)reportInfo.getId().toString());
                ICoreBillBase iBillBase = (ICoreBillBase)BOSObjectFactory.createRemoteBOSObject((BOSObjectType)new BOSObjectType(billBosType), Class.forName(bizInterface));
                iBillBase.delete(filter);
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new BOSException((Throwable)e);
            }
        }
        MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.TDResource", "DEL_SUCESS", TDUtils.getLocale()));
    }

    public static void initSheetSelected(Book book) {
        for (int i = 0; i < book.getSheetCount(); ++i) {
            book.getSheet(i).setSelected(false);
        }
        book.getActiveSheet().setSelected(true);
    }
}

