/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.syncUI.MonitorInfo;
import com.kingdee.bos.appframework.syncUI.SwingWorker;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.TaxDraftRecordCollection;
import com.kingdee.eas.tm.td.TaxDraftRecordFactory;
import com.kingdee.eas.tm.td.TaxDraftRecordInfo;
import com.kingdee.eas.tm.td.TaxOtherReportCollection;
import com.kingdee.eas.tm.td.TaxOtherReportFactory;
import com.kingdee.eas.tm.td.TaxOtherReportInfo;
import com.kingdee.eas.tm.td.client.AbstractTaxDraftExportUI;
import com.kingdee.eas.tm.td.client.ExportAction;
import com.kingdee.eas.tm.td.client.MySwingWork;
import com.kingdee.eas.tm.td.client.MyThreadPool;
import com.kingdee.eas.tm.td.est.RealEstateGroupInfo;
import com.kingdee.eas.tm.td.utils.TDSelectorFactory;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TaxDraftExportUI
extends AbstractTaxDraftExportUI {
    private static final Logger logger = CoreUIObject.getLogger(TaxDraftExportUI.class);
    protected KDFileChooser _chsFilePath;
    private int invoicePercent = 0;
    private MonitorInfo info = null;
    private int reportType = 0;

    public void onLoad() throws Exception {
        super.onLoad();
        this._chsFilePath = this.createFileChooser();
        this.btnChooseFile.setEnabled(true);
        this.btnOK.setEnabled(true);
        this.btnCancel.setEnabled(true);
        this.reportType = (Integer)this.getUIContext().get("reportType");
    }

    private KDFileChooser createFileChooser() {
        KDFileChooser chsFilePath = new KDFileChooser();
        chsFilePath.setDialogTitle(TDUtils.getString("com.kingdee.eas.tm.td.TaxDraftExportResource", "SelectPath", TDUtils.getLocale()));
        chsFilePath.setFileSelectionMode(1);
        return chsFilePath;
    }

    @Override
    public void actionChooseFilePath_actionPerformed(ActionEvent e) throws Exception {
        int returnVal = this._chsFilePath.showOpenDialog((Component)((Object)this));
        if (returnVal == 0) {
            String selectPath = this._chsFilePath.getSelectedFile().getPath();
            this.txtExportPath.setText(selectPath);
        }
    }

    public Map getExportParam() {
        HashMap<String, Object> exportParam = new HashMap<String, Object>();
        exportParam.put("exportPath", this.txtExportPath.getText());
        exportParam.put("exportOption", this.exportOption.getValue());
        exportParam.put("exportFormat", this.exportFormat.getValue());
        return exportParam;
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        this.doExportBefore();
        this.doInDeamon();
    }

    private void doExportBefore() {
        if (StringUtils.isEmpty((String)this.txtExportPath.getText())) {
            MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.TaxDraftExportResource", "PathNotNull", TDUtils.getLocale()));
            SysUtil.abort();
        }
    }

    private List<ReportBaseInfo> parepareData(List<ReportBaseInfo> list, StringBuffer errorMsgs) throws EASBizException, BOSException {
        HashMap<String, Boolean> paramMap = new HashMap<String, Boolean>();
        boolean isSupportAuditBill = false;
        ArrayList<ReportBaseInfo> retColl = new ArrayList<ReportBaseInfo>();
        ReportBaseInfo reportInfo = null;
        for (int i = 0; i < list.size(); ++i) {
            reportInfo = list.get(i);
            Object value = paramMap.get(((CompanyOrgUnitInfo)reportInfo.get("companyOrgUnit")).getId().toString());
            if (value == null) {
                isSupportAuditBill = TDUtils.getBooleanParam(null, ((CompanyOrgUnitInfo)reportInfo.get("companyOrgUnit")).getId().toString(), "VATD002");
                paramMap.put(((CompanyOrgUnitInfo)reportInfo.get("companyOrgUnit")).getId().toString(), isSupportAuditBill);
            } else {
                isSupportAuditBill = (Boolean)value;
            }
            if (!isSupportAuditBill && TDUtils.isAuditBill(reportInfo)) {
                errorMsgs.append(TDUtils.getString("com.kingdee.eas.tm.td.TaxDraftExportResource", "ExportStatusError", TDUtils.getLocale(), new Object[]{((CompanyOrgUnitInfo)reportInfo.get("companyOrgUnit")).getName(), reportInfo.getName()})).append("\n");
                continue;
            }
            retColl.add(reportInfo);
        }
        return retColl;
    }

    private List<ReportBaseInfo> getValues() throws BOSException {
        ArrayList<ReportBaseInfo> list;
        block3: {
            EntityViewInfo view;
            block2: {
                list = new ArrayList<ReportBaseInfo>();
                ArrayList ids = (ArrayList)this.getUIContext().get("ids");
                view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
                view.setFilter(filter);
                if (this.reportType != 0) break block2;
                view.setSelector(TDSelectorFactory.getAllReportSelectors());
                TaxDraftRecordCollection coll = TaxDraftRecordFactory.getRemoteInstance().getTaxDraftRecordCollection(view);
                int size = coll.size();
                for (int i = 0; i < size; ++i) {
                    list.add(coll.get(i));
                }
                break block3;
            }
            if (this.reportType != 1) break block3;
            view.setSelector(TaxOtherReportInfo.getSelectors());
            TaxOtherReportCollection coll = TaxOtherReportFactory.getRemoteInstance().getTaxOtherReportCollection(view);
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                list.add(coll.get(i));
            }
        }
        return list;
    }

    private void doExport() throws BOSException, EASBizException {
        List<ReportBaseInfo> list = this.getValues();
        StringBuffer errorMsgs = new StringBuffer();
        String errorMsg = null;
        boolean isSuccess = false;
        int successCount = 0;
        int errorCount = 0;
        List<ReportBaseInfo> coll = this.parepareData(list, errorMsgs);
        errorCount = list.size() - coll.size();
        List fieldNames = this.getExportFileNames(coll);
        List<ReportBaseInfo> workList = coll;
        ReportBaseInfo reportInfo = null;
        ExportAction ea = new ExportAction();
        Map exportParam = this.getExportParam();
        Map ret = null;
        this.disposeUIWindow();
        BigDecimal a = new BigDecimal(90);
        BigDecimal b = new BigDecimal(workList.size());
        BigDecimal c = BigDecimal.ZERO;
        if (workList.size() > 0) {
            c = a.divide(b, 2, RoundingMode.HALF_UP);
        }
        int size = workList.size();
        for (int i = 0; i < size; ++i) {
            this.invoicePercent = 10 + c.multiply(new BigDecimal(i)).intValue();
            reportInfo = workList.get(i);
            exportParam.put("reportInfo", reportInfo);
            exportParam.put("fileName", fieldNames.get(i));
            ret = ea.saveToFile(exportParam);
            isSuccess = (Boolean)ret.get("isSuccess");
            errorMsg = (String)ret.get("errorMsg");
            if (isSuccess) {
                ++successCount;
                continue;
            }
            errorMsgs.append(errorMsg);
            ++errorCount;
        }
        MyThreadPool.destroyMonitor(this.info);
        MyThreadPool.destroyPorgressDialog();
        String msg = "";
        if (errorCount == 0) {
            msg = TDUtils.getString("com.kingdee.eas.tm.td.TaxDraftExportResource", "ReportExportSuccess", TDUtils.getLocale());
            MsgBox.showInfo((String)msg);
        } else if (successCount == 0) {
            msg = TDUtils.getString("com.kingdee.eas.tm.td.TaxDraftExportResource", "ReportExportFailure", TDUtils.getLocale());
            MsgBox.showDetailAndOK((Component)((Object)this), (String)msg, (String)errorMsgs.toString(), (int)1);
        } else {
            msg = TDUtils.getString("com.kingdee.eas.tm.td.TaxDraftExportResource", "ReportExportPartSuccess", TDUtils.getLocale(), new Object[]{successCount, errorCount});
            MsgBox.showDetailAndOK((Component)((Object)this), (String)msg, (String)errorMsgs.toString(), (int)1);
        }
    }

    private void doInDeamon() {
        this.invoicePercent = 0;
        String parentTxt = TDUtils.getString("com.kingdee.eas.tm.td.TaxDraftExportResource", "ReportExport", TDUtils.getLocale());
        this.info = new MonitorInfo(parentTxt, null, (Object)this, true);
        MySwingWork worker = new MySwingWork(){

            public Object construct() {
                try {
                    TaxDraftExportUI.this.doExport();
                    TaxDraftExportUI.this.doExportAfter();
                }
                catch (Exception ex) {
                    TaxDraftExportUI.this.handUIException(ex);
                }
                finally {
                    MyThreadPool.destroyMonitor(TaxDraftExportUI.this.info);
                    MyThreadPool.destroyPorgressDialog();
                }
                return null;
            }

            public void finished() {
                this.timerStop();
            }

            @Override
            public void refreshProgress() {
                MyThreadPool.refreshProgress(TaxDraftExportUI.this.invoicePercent);
            }
        };
        this.info.setWorker((SwingWorker)worker);
        MyThreadPool.getInstance();
        MyThreadPool.addActionThread(this.info);
        MyThreadPool.setBackgroundRunButtonEnabled(false);
    }

    private List getExportFileNames(List<ReportBaseInfo> coll) {
        ArrayList<String> ret = new ArrayList<String>();
        ArrayList<StringBuffer> names = null;
        HashMap namesMap = new HashMap();
        ReportBaseInfo reportInfo = null;
        String realEstateGroupName = "";
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            RealEstateGroupInfo realEstateGroupInfo;
            reportInfo = coll.get(i);
            realEstateGroupName = "";
            if (reportInfo instanceof TaxDraftRecordInfo && (realEstateGroupInfo = ((TaxDraftRecordInfo)reportInfo).getBuildingTaxesGroup()) != null) {
                realEstateGroupName = realEstateGroupInfo.getName();
            }
            StringBuffer name = new StringBuffer();
            name.append(reportInfo.getNumber()).append("#");
            name.append(((CompanyOrgUnitInfo)reportInfo.get("companyOrgUnit")).getName()).append("-");
            if (!StringUtils.isEmpty((String)reportInfo.getName())) {
                name.append(reportInfo.getName()).append("-");
            }
            if (!StringUtils.isEmpty((String)realEstateGroupName)) {
                name.append(realEstateGroupName).append("-");
            }
            name.append(reportInfo.getYear()).append(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"year"));
            name.append(reportInfo.getPeriod()).append(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"period"));
            if (reportInfo.getAuditor() != null) {
                name.append("-");
                name.append(reportInfo.getAuditor().getName());
            }
            if ((names = (ArrayList<StringBuffer>)namesMap.get(name.toString())) == null) {
                names = new ArrayList<StringBuffer>();
                names.add(name);
                namesMap.put(name.toString(), names);
                ret.add(name.toString());
                continue;
            }
            name = name.append("_0" + (names.size() + 1));
            names.add(name);
            ret.add(name.toString());
        }
        return ret;
    }

    private void doExportAfter() {
        this.clear();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.clear();
        this.disposeUIWindow();
    }

    protected void clear() {
        this.txtExportPath.setText("");
        this.exportOption.setValue(0);
        this.exportFormat.setValue(0);
    }
}

