/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.client;

import com.kingdee.bos.appframework.syncUI.MonitorInfo;
import com.kingdee.bos.appframework.syncUI.SwingWorker;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.TaxDraftRecordFactory;
import com.kingdee.eas.tm.td.TaxOtherReportFactory;
import com.kingdee.eas.tm.td.client.AbstractTaxDraftImportUI;
import com.kingdee.eas.tm.td.client.ImportAction;
import com.kingdee.eas.tm.td.client.MySwingWork;
import com.kingdee.eas.tm.td.client.MyThreadPool;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TaxDraftImportUI
extends AbstractTaxDraftImportUI {
    private static final Logger logger = CoreUIObject.getLogger(TaxDraftImportUI.class);
    protected KDFileChooser _chsFilePath;
    private int invoicePercent = 0;
    private MonitorInfo info = null;
    private int reportType = 0;

    public void onLoad() throws Exception {
        super.onLoad();
        this._chsFilePath = this.createFileChooser();
        this.btnChooseFile.setEnabled(true);
        this.btnOK.setEnabled(true);
        this.btnCancel.setEnabled(true);
        this.reportType = (Integer)this.getUIContext().get("reportType");
    }

    private KDFileChooser createFileChooser() {
        KDFileChooser chsFilePath = new KDFileChooser();
        chsFilePath.setDialogTitle(TDUtils.getString("com.kingdee.eas.tm.td.TaxDraftExportResource", "SelectPath", TDUtils.getLocale()));
        chsFilePath.setFileSelectionMode(1);
        return chsFilePath;
    }

    @Override
    public void actionChooseFilePath_actionPerformed(ActionEvent e) throws Exception {
        int returnVal = this._chsFilePath.showOpenDialog((Component)((Object)this));
        if (returnVal == 0) {
            String selectPath = this._chsFilePath.getSelectedFile().getPath();
            this.txtPath.setText(selectPath);
        }
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        this.doImportBefore();
        this.doInDeamon();
    }

    private void doImportBefore() {
        if (StringUtils.isEmpty((String)this.txtPath.getText())) {
            MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.TaxDraftExportResource", "PathNotNull", TDUtils.getLocale()));
            SysUtil.abort();
        }
    }

    private Map getImportParam() {
        HashMap<String, Object> importParam = new HashMap<String, Object>();
        importParam.put("importOption", this.importGroup.getValue());
        importParam.put("importType", this.cbImportType.getSelectedItem());
        return importParam;
    }

    private void doImport() throws Exception {
        String msg = "";
        StringBuffer errorMsgs = new StringBuffer();
        String errorMsg = null;
        int successCount = 0;
        int failCount = 0;
        String filePath = this.txtPath.getText();
        ArrayList<String> fileList = this.getFiles(filePath);
        if (fileList.size() == 0) {
            errorMsgs.append(TDUtils.getString("com.kingdee.eas.tm.td.TaxDraftExportResource", "FILE_NOT_EXIST", TDUtils.getLocale(), new Object[]{filePath})).append("\n");
            MsgBox.showInfo((String)errorMsgs.toString());
            this.invoicePercent = 100;
            MyThreadPool.destroyMonitor(this.info);
            MyThreadPool.destroyPorgressDialog();
            return;
        }
        Map importParam = this.getImportParam();
        String fileName = null;
        String number = null;
        HashMap<String, String> fileNumberMap = new HashMap<String, String>();
        HashSet<String> numberSet = new HashSet<String>();
        for (int i = 0; i < fileList.size(); ++i) {
            fileName = fileList.get(i);
            if (fileName.indexOf("#") > 0) {
                number = this.getFileName(fileName).split("#")[0];
                numberSet.add(number);
                fileNumberMap.put(number, fileName);
                continue;
            }
            errorMsgs.append(TDUtils.getString("com.kingdee.eas.tm.td.TaxDraftExportResource", "FILE_FORMAT_ERROR", TDUtils.getLocale(), new Object[]{this.getFileName(fileName)})).append("\n");
            ++failCount;
        }
        if (numberSet.size() == 0) {
            msg = TDUtils.getString("com.kingdee.eas.tm.td.TaxDraftExportResource", "ReportImportFailure", TDUtils.getLocale());
            MsgBox.showDetailAndOK((Component)((Object)this), (String)msg, (String)errorMsgs.toString(), (int)1);
            this.invoicePercent = 100;
            MyThreadPool.destroyMonitor(this.info);
            MyThreadPool.destroyPorgressDialog();
            return;
        }
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put("numberSet", numberSet);
        params.put("reportType", Integer.valueOf(this.reportType));
        Map map = TaxDraftRecordFactory.getRemoteInstance().getCollByNumberSet(params);
        List coll = (List)map.get("coll");
        int errorCount = (Integer)map.get("errorCount");
        failCount += errorCount;
        List notList = (List)map.get("notList");
        List auditList = (List)map.get("auditList");
        List declaredList = (List)map.get("declaredList");
        this.buildErrorMsg(errorMsgs, fileNumberMap, notList, "not");
        this.buildErrorMsg(errorMsgs, fileNumberMap, auditList, "audit");
        this.buildErrorMsg(errorMsgs, fileNumberMap, declaredList, "declared");
        if (coll == null || coll.size() == 0) {
            msg = TDUtils.getString("com.kingdee.eas.tm.td.TaxDraftExportResource", "ReportImportFailure", TDUtils.getLocale());
            MsgBox.showDetailAndOK((Component)((Object)this), (String)msg, (String)errorMsgs.toString(), (int)1);
            this.invoicePercent = 100;
            MyThreadPool.destroyMonitor(this.info);
            MyThreadPool.destroyPorgressDialog();
            return;
        }
        this.disposeUIWindow();
        BigDecimal a = new BigDecimal(90);
        BigDecimal b = new BigDecimal(coll.size());
        BigDecimal c = BigDecimal.ZERO;
        if (coll.size() > 0) {
            c = a.divide(b, 2, RoundingMode.HALF_UP);
        }
        Map ret = null;
        ReportBaseInfo reportInfo = null;
        CoreBaseCollection updateColl = new CoreBaseCollection();
        boolean isSuccess = false;
        ImportAction ia = new ImportAction();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            this.invoicePercent = 10 + c.multiply(new BigDecimal(i)).intValue();
            reportInfo = (ReportBaseInfo)coll.get(i);
            importParam.put("reportInfo", reportInfo);
            importParam.put("fileName", fileNumberMap.get(reportInfo.getNumber()));
            ret = ia.importToReport(importParam);
            isSuccess = (Boolean)ret.get("isSuccess");
            errorMsg = ret.get("errorMsg").toString();
            if (isSuccess) {
                ++successCount;
                updateColl.add((CoreBaseInfo)reportInfo);
                continue;
            }
            ++failCount;
            errorMsgs.append(errorMsg).append("\n");
        }
        if (updateColl.size() > 0) {
            if (this.reportType == 0) {
                TaxDraftRecordFactory.getRemoteInstance().updateBatchData(updateColl);
            } else if (this.reportType == 1) {
                TaxOtherReportFactory.getRemoteInstance().updateBatchData(updateColl);
            }
        }
        MyThreadPool.destroyMonitor(this.info);
        MyThreadPool.destroyPorgressDialog();
        msg = TDUtils.getString("com.kingdee.eas.tm.td.TaxDraftExportResource", "ReportImportSuccess", TDUtils.getLocale(), new Object[]{successCount, failCount});
        MsgBox.showDetailAndOK((Component)((Object)this), (String)msg, (String)errorMsgs.toString(), (int)1);
    }

    private void buildErrorMsg(StringBuffer errorMsgs, Map fileNumberMap, List notList, String flag) {
        String resKey = null;
        if ("not".equals(flag)) {
            resKey = "FILE_NOT_RECORD";
        } else if ("audit".equals(flag)) {
            resKey = "FILE_RECORD_AUDIT";
        } else if ("declared".equals(flag)) {
            resKey = "FILE_RECORD_DECLARED";
        }
        if (notList != null && notList.size() > 0) {
            for (int i = 0; i < notList.size(); ++i) {
                String number = (String)notList.get(i);
                String fileName = (String)fileNumberMap.get(number);
                errorMsgs.append(TDUtils.getString("com.kingdee.eas.tm.td.TaxDraftExportResource", resKey, TDUtils.getLocale(), new Object[]{this.getFileName(fileName)})).append("\n");
            }
        }
    }

    public ArrayList<String> getFiles(String path) {
        ArrayList<String> files = new ArrayList<String>();
        File file = new File(path);
        File[] tempList = file.listFiles();
        File tempFile = null;
        for (int i = 0; i < tempList.length; ++i) {
            tempFile = tempList[i];
            if (!tempFile.isFile() || !tempFile.getName().endsWith("xls") && !tempFile.getName().endsWith("xlsx") && !tempFile.getName().endsWith("xml")) continue;
            files.add(tempFile.toString());
        }
        return files;
    }

    public String getFileName(String fileAllName) {
        String fName = fileAllName.trim();
        String[] temp = fName.split("\\\\");
        String fileName = temp[temp.length - 1];
        return fileName;
    }

    private void doInDeamon() {
        this.invoicePercent = 0;
        String parentTxt = TDUtils.getString("com.kingdee.eas.tm.td.TaxDraftExportResource", "REPORTIMPORT", TDUtils.getLocale());
        this.info = new MonitorInfo(parentTxt, null, (Object)this, true);
        MySwingWork worker = new MySwingWork(){

            public Object construct() {
                try {
                    TaxDraftImportUI.this.doImport();
                    TaxDraftImportUI.this.doImportAfter();
                }
                catch (Exception ex) {
                    TaxDraftImportUI.this.handUIException(ex);
                }
                finally {
                    MyThreadPool.destroyMonitor(TaxDraftImportUI.this.info);
                    MyThreadPool.destroyPorgressDialog();
                }
                return null;
            }

            public void finished() {
                this.timerStop();
            }

            @Override
            public void refreshProgress() {
                MyThreadPool.refreshProgress(TaxDraftImportUI.this.invoicePercent);
            }
        };
        this.info.setWorker((SwingWorker)worker);
        MyThreadPool.getInstance();
        MyThreadPool.addActionThread(this.info);
        MyThreadPool.setBackgroundRunButtonEnabled(false);
    }

    private void doImportAfter() {
        this.clear();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.clear();
        this.disposeUIWindow();
    }

    protected void clear() {
        this.txtPath.setText("");
        this.importGroup.setValue(0);
    }
}

