/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.client;

import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.tm.td.DraftStatusEnum;
import com.kingdee.eas.tm.td.OwnerMenuEnum;
import com.kingdee.eas.tm.td.RecordTypeEnum;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.TaxDraftRecordFactory;
import com.kingdee.eas.tm.td.TaxDraftRecordInfo;
import com.kingdee.eas.tm.td.basedata.AccountTypeFactory;
import com.kingdee.eas.tm.td.basedata.AccountTypeInfo;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.client.AbstractTaxDraftWFEditUI;
import com.kingdee.eas.tm.td.utils.NullUtils;
import com.kingdee.eas.tm.td.utils.TDPermissionUtil;
import com.kingdee.eas.tm.td.utils.TDSelectorFactory;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class TaxDraftWFEditUI
extends AbstractTaxDraftWFEditUI {
    private static final Logger logger = CoreUIObject.getLogger(TaxDraftWFEditUI.class);
    String taxFlag = null;
    String recordFlag = null;
    AccountTypeInfo accountTypeInfo = null;
    TaxItemTypeInfo taxItemTypeInfo = null;
    RecordTypeEnum recordTypeEnum = null;
    OwnerMenuEnum ownerMenuEnum = null;
    String taxDraftRptUI = null;

    @Override
    public void onLoad() throws Exception {
        if (this.getOprtState() == null) {
            this.setOprtState(OprtState.EDIT);
        }
        super.onLoad();
    }

    @Override
    protected void afterLoad() {
        this.initVariable();
        super.afterLoad();
    }

    @Override
    protected void setF7Filter() {
    }

    @Override
    protected void initControl() {
        super.initControl();
        if (this.prmtCompanyOrgUnit.getValue() == null) {
            this.prmtCompanyOrgUnit.setValue((Object)this.editData.getCompanyOrgUnit());
        }
        this.number.setEnabled(false);
        this.name.setEnabled(false);
        this.prmtCompanyOrgUnit.setEnabled(false);
        this.prmtOrgTree.setEnabled(false);
        this.startDate.setEnabled(false);
        this.endDate.setEnabled(false);
        this.selectStates.setEnabled(false);
        this.prmtPeriod.setEnabled(false);
        this.selectDraftRecordType.setEnabled(false);
        this.prmtTaxType.setEnabled(false);
        this.prmtRelateAccount.setEnabled(false);
        this.prmtRelateNextAccount.setEnabled(false);
        this.prmtOrgTree.setEnabled(false);
        this.prmtPeriodTo.setEnabled(false);
        this.prmtPeriodFrom.setEnabled(false);
        this.discription.setEnabled(false);
        this.subPeriodType.setEnabled(false);
        this.prmtBillRange.setEnabled(false);
        this.btnAddNew.setVisible(false);
        this.btnSave.setVisible(false);
        this.btnCopy.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnSubmit.setVisible(false);
        this.menuItemEdit.setVisible(false);
        this.menuItemSubmit.setVisible(false);
        this.menuItemAddNew.setVisible(false);
        this.menuItemCopy.setVisible(false);
        this.menuItemRemove.setVisible(false);
        this.menuEdit.setVisible(false);
        if (this.getUIContext() != null && this.getUIContext().get("Owner") != null && this.getUIContext().get("Owner").toString().contains("com.kingdee.eas.tm.td.cloud.datamodel.client.ItemCheckResultListUI")) {
            this.btnAudit.setVisible(false);
            this.btnUnAudit.setVisible(false);
            this.menuBiz.setVisible(false);
        }
    }

    private void initVariable() {
        this.taxItemTypeInfo = this.editData.getTaxType();
        this.taxFlag = NullUtils.isNull2Empty(this.taxItemTypeInfo.getSimName());
        this.recordTypeEnum = this.editData.getRecordType();
        this.ownerMenuEnum = this.editData.getOwnerMenu();
        String recordType = NullUtils.isNull2Empty(this.recordTypeEnum.getName());
        this.recordFlag = "";
        if ("account".equalsIgnoreCase(recordType)) {
            this.recordFlag = "taxaccount";
            try {
                String pk = null;
                if (this.taxFlag.equalsIgnoreCase("vat")) {
                    pk = "lVIAAAB1FKk9mKD1";
                } else if (this.taxFlag.equalsIgnoreCase("ct")) {
                    pk = "lVIAAAB1FKo9mKD1";
                } else if (this.taxFlag.equalsIgnoreCase("eit")) {
                    pk = "lVIAAAB1FKs9mKD1";
                } else if (this.taxFlag.equalsIgnoreCase("st")) {
                    pk = "s4EWmCbvRA667dckoB/BWj2YoPU=";
                } else if (this.taxFlag.equalsIgnoreCase("at")) {
                    pk = "y0IwQQL/QU+khfcOuJESPj2YoPU=";
                } else if (this.taxFlag.equalsIgnoreCase("ert")) {
                    pk = "nJREYCMKQxixsNoL09ZUjT2YoPU=";
                } else if (this.taxFlag.equalsIgnoreCase("ot")) {
                    pk = "f+XgrM5ZRGiwQ+P5ab4WLj2YoPU=";
                } else if (this.taxFlag.equalsIgnoreCase("land")) {
                    pk = "km27JnkseY/gUzA/qMDnRj2YoPU=";
                }
                this.accountTypeInfo = AccountTypeFactory.getRemoteInstance().getAccountTypeInfo((IObjectPK)new ObjectUuidPK(pk));
            }
            catch (Exception e) {
                this.handleException(e);
            }
        } else if ("taxdeclare".equalsIgnoreCase(recordType)) {
            this.recordFlag = "taxdeclare";
        } else if ("taxdraftitem".equalsIgnoreCase(recordType) || "draftitem".equalsIgnoreCase(recordType)) {
            this.recordFlag = "taxdraftitem";
        } else if ("quarterlytaxdeclare".equalsIgnoreCase(recordType)) {
            this.recordFlag = "mouthtaxdeclare";
        } else if ("quarterlydraftitem".equalsIgnoreCase(recordType)) {
            this.recordFlag = "mouthdeclaredraft";
        } else if ("annualdraftitem".equalsIgnoreCase(recordType)) {
            this.recordFlag = "sumdeclaredraft";
        } else if ("annualtaxdeclare".equalsIgnoreCase(recordType)) {
            this.recordFlag = "sumtaxdeclare";
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.getOprtState().equals(OprtState.EDIT)) {
            this.btnSave.setEnabled(this.selectStates.getSelectedItem().equals((Object)DraftStatusEnum.SAVE));
            this.actionSave.setEnabled(this.selectStates.getSelectedItem().equals((Object)DraftStatusEnum.SAVE));
            this.actionEdit.setEnabled(this.selectStates.getSelectedItem().equals((Object)DraftStatusEnum.SUBMIT) || this.selectStates.getSelectedItem().equals((Object)DraftStatusEnum.SAVE));
        }
        this.actionSubmit.setEnabled(this.selectStates.getSelectedItem().equals((Object)DraftStatusEnum.SUBMIT));
        this.btnAudit.setVisible(true);
        this.actionAudit.setEnabled(this.selectStates.getSelectedItem().equals((Object)DraftStatusEnum.SUBMIT));
        this.btnUnAudit.setVisible(true);
        this.actionUnAudit.setEnabled(this.selectStates.getSelectedItem().equals((Object)DraftStatusEnum.AUDIT));
    }

    @Override
    protected String getPermissionItem(String actionType) {
        return TDPermissionUtil.getTaxDraftPermissionItem(actionType, NullUtils.isNull2Empty(this.taxItemTypeInfo.getSimName()), this.recordFlag);
    }

    @Override
    protected AccountTypeInfo getAccountTypeInfo() throws Exception {
        return this.accountTypeInfo;
    }

    @Override
    protected TaxItemTypeInfo getTaxTypeInfo() throws Exception {
        return this.taxItemTypeInfo;
    }

    @Override
    protected RecordTypeEnum getRecordType() {
        return this.recordTypeEnum;
    }

    @Override
    protected OwnerMenuEnum getOwnerMenu() {
        return this.ownerMenuEnum;
    }

    @Override
    protected String getTaxDraftRptUI() {
        String taxFlag = NullUtils.isNull2Empty(this.taxItemTypeInfo.getSimName());
        String recordType = NullUtils.isNull2Empty(this.recordTypeEnum.getName());
        return TDUtils.getTaxDraftRptUI(taxFlag, recordType);
    }

    @Override
    protected void initDataStatus() {
        super.initDataStatus();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("companyOrgUnit.*"));
        sic.add(new SelectorItemInfo("companyOrgUnit.accountPeriodType.*"));
        sic.add(new SelectorItemInfo("rptPeriod.*"));
        sic.add(new SelectorItemInfo("rptPeriodFrom.*"));
        sic.add(new SelectorItemInfo("rptPeriodTo.*"));
        sic.add(new SelectorItemInfo("relateRecord.*"));
        sic.add(new SelectorItemInfo("taxType.*"));
        sic.add(new SelectorItemInfo("relateAccount.*"));
        sic.add(new SelectorItemInfo("relateRecordAccount.*"));
        sic.add(new SelectorItemInfo("orgTree.*"));
        sic.add(new SelectorItemInfo("accountType.*"));
        sic.add(new SelectorItemInfo("entry.*"));
        return sic;
    }

    @Override
    public void actionViewReport_actionPerformed(ActionEvent e) throws Exception {
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId().toString());
        TaxDraftRecordInfo taxDraftRecordInfo = TaxDraftRecordFactory.getRemoteInstance().getTaxDraftRecordInfo((IObjectPK)pk, TDSelectorFactory.getTaxDraftRecordSelectors());
        UIContext uiContext = new UIContext(this.getUIContext().get("Owner"));
        uiContext.put((Object)"InitDataObject", (Object)taxDraftRecordInfo);
        final IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(this.getTaxDraftRptUI(), (Map)uiContext, null, this.oprtState);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                uiWindow.show();
            }
        });
    }

    @Override
    protected void afterSaveOrSubmit(IObjectPK pk, boolean isSubmit) throws Exception {
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        if (!this.selectStates.getSelectedItem().equals((Object)DraftStatusEnum.SUBMIT)) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"statesNoSubmit"));
            SysUtil.abort();
        }
        TaxDraftRecordFactory.getRemoteInstance().audit((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        this.refreshCurPage();
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        if (!this.selectStates.getSelectedItem().equals((Object)DraftStatusEnum.AUDIT)) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"statesNoAudit"));
            SysUtil.abort();
        }
        TaxDraftRecordFactory.getRemoteInstance().unAudit((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        this.setOprtState(OprtState.VIEW);
        this.refreshCurPage();
    }

    protected void refreshCurPage() throws Exception {
        if (this.editData.getId() != null) {
            this.setInnerLoadFields(true);
            Map allTableListeners = this.removeAllTableListener(KDTPropertyChangeListener.class);
            ObjectUuidPK iObjectPk = new ObjectUuidPK(this.editData.getId());
            IObjectValue iObjectValue = this.getValue((IObjectPK)iObjectPk);
            this.setDataObject(iObjectValue);
            this.loadFields();
            this.restoreAllTableListener(KDTPropertyChangeListener.class, allTableListeners);
            this.reSetDepTbListeners();
        }
    }
}

