/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.core.IExtRender;
import com.kingdee.bos.ctrl.excel.impl.ActionManager;
import com.kingdee.bos.ctrl.excel.impl.ToolBarManager;
import com.kingdee.bos.ctrl.excel.impl.action.SpreadAction;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.multiapprove.client.MultiApproveUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.newrpt.DesignerResource;
import com.kingdee.eas.fi.newrpt.client.designer.IBookProvider;
import com.kingdee.eas.fi.newrpt.client.designer.IMenuStrategy;
import com.kingdee.eas.fi.newrpt.client.designer.SpreadManager;
import com.kingdee.eas.fi.newrpt.client.designer.render.IRenderProvider;
import com.kingdee.eas.fi.newrpt.client.designer.render.SumRangeRender;
import com.kingdee.eas.fi.newrpt.designer.IReportVariableProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.tm.td.DraftBillBuildCenter;
import com.kingdee.eas.tm.td.TDFacadeFactory;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.TaxOtherReportFactory;
import com.kingdee.eas.tm.td.TaxOtherReportInfo;
import com.kingdee.eas.tm.td.TaxReportStatusEnum;
import com.kingdee.eas.tm.td.account.formula.AccountFormulaCalculateService;
import com.kingdee.eas.tm.td.client.AbstractTaxOtherReportRptUI;
import com.kingdee.eas.tm.td.client.AccountFormulaUI;
import com.kingdee.eas.tm.td.client.ReportUIHelper;
import com.kingdee.eas.tm.td.utils.LogUtils;
import com.kingdee.eas.tm.td.utils.TaxOtherReportMenu;
import com.kingdee.eas.tm.td.utils.TaxOtherReportPropertyAdapter;
import com.kingdee.eas.tm.td.utils.TaxOtherReportProvider;
import com.kingdee.eas.tm.td.utils.TaxOtherReportVariableProvider;
import com.kingdee.eas.tm.td.utils.render.DefaultRenderProvider;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.Action;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class TaxOtherReportRptUI
extends AbstractTaxOtherReportRptUI {
    private static final Logger logger = CoreUIObject.getLogger(TaxOtherReportRptUI.class);
    private TaxOtherReportInfo editData = null;

    public TaxOtherReportRptUI() throws Exception {
        this.setMenuStrategy(this.getDraftMenuStrategy());
        this.setBookProvider(this.getDraftBookProvider());
        this.setVariableProvider(this.getDraftVariableProvider());
        this.setPropertyAdapter(this.getDraftPropertyAdapter());
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initControl();
    }

    protected void initControl() throws EASBizException, BOSException {
        this.editData = (TaxOtherReportInfo)this.getReportAdapter().getReportProperty("editData");
        SpreadManager.registerRenderProvider((IRenderProvider)new DefaultRenderProvider());
        if (this.editData.getId() != null && !TaxOtherReportFactory.getRemoteInstance().exists((IObjectPK)new ObjectUuidPK(this.editData.getId().toString()))) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        DraftBillBuildCenter.init(this.editData);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            ReportUIHelper.addDraftConfirmSheet(this.editData, this.getBook(), this.getSpreadManager(), false);
            ReportUIHelper.initSheetSelected(this.getBook());
        }
    }

    protected void initToolbar() {
        ToolBarManager toolBarManager = this.getSpreadManager().getSpreadContainer().getToolBarManager();
        this.actionSubmit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_submit"));
        toolBarManager.addFirstGroupItem((Action)((Object)this.actionSubmit), "common");
        this.actionSave.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_save"));
        toolBarManager.addFirstGroupItem((Action)this.actionSave, "common");
        this.actionEdit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_edit"));
        toolBarManager.addFirstGroupItem((Action)((Object)this.actionEdit), "common");
        this.actionAddAccountFormula.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F6"));
        this.actionCalculateSelectedSheet.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_compute"));
        this.actionCalculate.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_autocount"));
        this.actionReportCheck.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_check"));
        ActionManager actions = this.getSpreadManager().getSpreadContainer().getActionManager();
        SpreadAction action = actions.getAction("SetCellDisplayMode");
        action.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_showformula"));
        this.actionReportRound.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_balancecheck"));
        this.actionSheetManager.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_reportparameter"));
        Component[] comps = this.toolBar.getToolBarComponents();
        for (int i = 0; i < comps.length; ++i) {
            toolBarManager.addLastGroupItem(comps[i], "common");
        }
        this.toolBar = toolBarManager.getToolBar("common");
        this.toolBar.setIsControlByParent(false);
        this.toolBar.setTextIconDisStyle((short)2);
        this.toolBar.setPopupMenuShowable(true);
        this.getSpreadManager().setUserExtRender((IExtRender)SumRangeRender.getInstance());
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.getMenuStrategy().enableVisibleMenu("menuStyle/menuItemStyleSheet/menuItemSheetLabelColor", true, true, true);
        this.getMenuStrategy().enableVisibleMenu("menuStyle/menuItemStyleSheet/menuItemRename", true, true, true);
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.actionSubmit.setEnabled(false);
            this.actionSave.setEnabled(false);
            this.actionEdit.setEnabled(true);
            this.actionImport.setEnabled(false);
        } else {
            this.actionSubmit.setEnabled(true);
            this.actionSave.setEnabled(true);
            this.actionEdit.setEnabled(false);
            this.actionImport.setEnabled(true);
        }
    }

    @Override
    public void actionInsertDraft_actionPerformed(ActionEvent e) throws Exception {
        ReportUIHelper.addDraftConfirmSheet(this.editData, this.getBook(), this.getSpreadManager(), true);
        ReportUIHelper.initSheetSelected(this.getBook());
    }

    @Override
    public void actionSaveDraftBill_actionPerformed(ActionEvent e) throws Exception {
        String orgId = this.editData.getCompanyOrgUnit().getId().toString();
        TDFacadeFactory.getRemoteInstance().checkFunctionPermission(orgId, "td_taxotherreport_comfire_save");
        String logDetailStr = this.editData.getNumber();
        IObjectPK logPk = LogUtils.beginLog(null, "saveConfirmBill", BOSObjectType.create((String)"2A607F02"), (IObjectPK)new ObjectUuidPK(this.editData.getId().toString()), logDetailStr, "taxotherreport_comfire_save", "");
        ReportUIHelper.saveDraftBill(this.editData, this.getBook());
        LogUtils.afterLog(null, logPk);
    }

    @Override
    public void actionDelDraftBill_actionPerformed(ActionEvent e) throws Exception {
        String orgId = this.editData.getCompanyOrgUnit().getId().toString();
        TDFacadeFactory.getRemoteInstance().checkFunctionPermission(orgId, "td_taxotherreport_comfire_delete");
        String logDetailStr = this.editData.getNumber();
        IObjectPK logPk = LogUtils.beginLog(null, "saveConfirmBill", BOSObjectType.create((String)"2A607F02"), (IObjectPK)new ObjectUuidPK(this.editData.getId().toString()), logDetailStr, "taxotherreport_comfire_delete", "");
        ReportUIHelper.deleteDraftBill(this.editData);
        LogUtils.afterLog(null, logPk);
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (TaxReportStatusEnum.AUDIT.equals((Object)this.editData.getState())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"NOT_EDIT"));
            return;
        }
        String tempOprState = this.getOprtState();
        this.setOprtState("EDIT");
        try {
            this.setDataObject((IObjectValue)this.editData);
        }
        catch (Exception ex) {
            this.setOprtState(tempOprState);
            throw ex;
        }
        this.initWorkButton();
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verify(e);
        this.beforeSave();
        this.getBookProvider().restoreBook(this.getBook());
        if (this.editData.getId() != null && SCMClientUtils.checkAllBizObjInWfProcess((String[])new String[]{this.editData.getId().toString()})) {
            this.actionMultiapprove_actionPerformed(null);
            return;
        }
        try {
            boolean isSubmit2Cacl = TDUtils.getBooleanParam(null, this.editData.getCompanyOrgUnit().getId().toString(), "VATD004");
            if (isSubmit2Cacl) {
                this.actionCalculate_actionPerformed(e);
            }
            try {
                this.getSpreadManager().getSpreadContainer().getStateManager().stopAll();
            }
            catch (Exception e1) {
                logger.error((Object)e1);
            }
            IObjectPK pk = this.getBookProvider().getBizInterface().submit((CoreBaseInfo)this.getBookProvider().getEditValue());
            this.getBookProvider().setEditValue(this.getBookProvider().queryEditData(pk));
            this.editData = (TaxOtherReportInfo)this.getBookProvider().getEditValue();
            this.setBook(this.editData.getBook());
            this.getBookProvider().getEditValue().setBOSUuid(this.getBookProvider().getEditValue().getPKField(), BOSUuid.read((String)pk.toString()));
            if (!this.getUIContext().containsKey("SumRptProcessUI_isSumGrade")) {
                this.showSuccessMsg(EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"submitSuccess"));
                if (isSubmit2Cacl) {
                    this.getSpreadManager().getSpreadContainer().repaint();
                    this.getSpreadManager().getSpreadContainer().getSpread().repaint();
                }
            }
            this.getSpreadManager().getModifyManager().discardAllEdits();
            this.getSpreadManager().getSpreadContainer().getToolBarManager().changed(new BookChangeEvent(this.getBook().getActiveSheet(), "Sheet_Hide"));
        }
        catch (EASBizException e1) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"submitFailure"), (String)e1.getMessage(), (int)8188);
            SysUtil.abort();
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.verify(e);
        this.beforeSave();
        this.getBookProvider().restoreBook(this.getBook());
        try {
            try {
                this.getSpreadManager().getSpreadContainer().getStateManager().stopAll();
            }
            catch (Exception e1) {
                logger.error((Object)e1);
            }
            IObjectPK pk = this.getBookProvider().getBizInterface().save((CoreBaseInfo)this.getBookProvider().getEditValue());
            this.getBookProvider().setEditValue(this.getBookProvider().queryEditData(pk));
            this.editData = (TaxOtherReportInfo)this.getBookProvider().getEditValue();
            this.getBookProvider().getEditValue().setBOSUuid(this.getBookProvider().getEditValue().getPKField(), BOSUuid.read((String)pk.toString()));
            if (!this.getUIContext().containsKey("SumRptProcessUI_isSumGrade")) {
                this.showSuccessMsg(DesignerResource.getString((String)"saveOK"));
            }
            this.getSpreadManager().getModifyManager().discardAllEdits();
            this.getSpreadManager().getSpreadContainer().getToolBarManager().changed(new BookChangeEvent(this.getBook().getActiveSheet(), "Sheet_Hide"));
        }
        catch (EASBizException e1) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)DesignerResource.getString((String)"saveFail").replaceAll("\uff0c", ""), (String)e1.getMessage(), (int)0);
            SysUtil.abort();
        }
    }

    public void actionCalculate_actionPerformed(ActionEvent e) throws Exception {
        boolean oldstate = this.getBook().isAutoCalculate();
        this.getBook().setCalculate(false);
        this.calculate(true);
        this.getSpreadManager().getSpreadContainer().repaint();
        this.getBook().setCalculate(oldstate);
        super.actionCalculate_actionPerformed(e);
    }

    private void calculate(boolean isAll) throws EASBizException, BOSException {
        AccountFormulaCalculateService calculateService = new AccountFormulaCalculateService(null);
        Book book = this.getBook();
        TaxOtherReportInfo reportInfo = this.editData;
        if (isAll) {
            calculateService.calculateReport(reportInfo, book);
        } else {
            calculateService.calculateSheet(reportInfo, book.getActiveSheet());
        }
    }

    public void actionCalculateSelectedSheet_actionPerformed(ActionEvent e) throws Exception {
        boolean oldstate = this.getBook().isAutoCalculate();
        this.getBook().setCalculate(false);
        this.calculate(false);
        this.getSpreadManager().getSpreadContainer().repaint();
        this.getBook().setCalculate(oldstate);
        super.actionCalculateSelectedSheet_actionPerformed(e);
    }

    public String getUITitle() {
        if (this.editData == null) {
            return super.getUITitle();
        }
        String reportTitle = this.editData.getName() + "-" + this.editData.getCompanyOrgUnit().getName() + "-" + this.editData.getReportType().getName() + "-" + this.editData.getRptPeriod().getNumber();
        return reportTitle;
    }

    @Override
    public void actionAddAccountFormula_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"rptSheet", (Object)this.getBook().getActiveSheet());
        uiContext.put((Object)"spreadManager", (Object)this.getSpreadManager());
        uiContext.put((Object)"editData", (Object)this.getBookProvider().getEditValue());
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create(AccountFormulaUI.class.getName(), (Map)uiContext, null, this.getOprtState());
        window.show();
    }

    public IMenuStrategy getDraftMenuStrategy() {
        return new TaxOtherReportMenu();
    }

    public IBookProvider getDraftBookProvider() {
        return new TaxOtherReportProvider();
    }

    public IReportVariableProvider getDraftVariableProvider() {
        return new TaxOtherReportVariableProvider();
    }

    private IReportPropertyAdapter getDraftPropertyAdapter() {
        return new TaxOtherReportPropertyAdapter();
    }

    public void actionMultiapprove_actionPerformed(ActionEvent e) throws Exception {
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        String[] boID = new String[]{this.getSelectBOID()};
        if (boID[0] == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_WFHasNotInstance"));
            this.abort();
        }
        MultiApproveUtil.multiapproveBills((CoreUIObject)this, (String)userID, (String[])boID);
    }

    protected final String getSelectBOID() {
        if (this.editData == null) {
            return null;
        }
        String boID = this.editData.getId() != null ? this.editData.getId().toString() : null;
        return boID;
    }
}

