/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.client;

import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.cloud.BackupDataTypeFactory;
import com.kingdee.eas.tm.td.cloud.BackupDataTypeInfo;
import com.kingdee.eas.tm.td.cloud.EnableStateEnum;
import com.kingdee.eas.tm.td.cloud.client.AbstractBackupDataTypeEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class BackupDataTypeEditUI
extends AbstractBackupDataTypeEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BackupDataTypeEditUI.class);
    private static final String TDRESOURCE = "com.kingdee.eas.tm.td.cloud.TDCloudResource";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected IObjectValue createNewData() {
        BackupDataTypeInfo info = new BackupDataTypeInfo();
        info.setState(EnableStateEnum.ENABLE);
        info.setIsPreinstall(false);
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BackupDataTypeFactory.getRemoteInstance();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.initDataStatus();
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        BackupDataTypeInfo editData = (BackupDataTypeInfo)newData;
        editData.setNumber(null);
    }

    private void inputCheck() {
        StringBuffer sb = new StringBuffer();
        if (this.txtNumber.getText().isEmpty()) {
            sb.append("\u3001" + this.txtNumber.getBoundLabelText());
        }
        if (this.txtName.getText().isEmpty()) {
            sb.append("\u3001" + this.txtName.getBoundLabelText());
        }
        if (sb.length() > 0) {
            sb.append(TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "Data_NotNull", TDUtils.getLocale())).append("\r\n");
            MsgBox.showWarning((String)sb.substring(1));
            SysUtil.abort();
        }
        try {
            if (this.txtDesription.getText().getBytes("utf8").length > 255) {
                sb.append(EASResource.getString((String)TDRESOURCE, (String)"DESCRIPTION"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (sb.length() > 0) {
            sb.append(EASResource.getString((String)TDRESOURCE, (String)"OVER_LENGTH"));
            MsgBox.showWarning((String)sb.substring(1));
            SysUtil.abort();
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.isIsPreinstall()) {
            MsgBox.showInfo((String)(this.editData.getNumber() + ":" + EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.TaxBaseResource", (String)"Preinstall_Not_Edit")));
            SysUtil.abort();
        }
        if (this.editData.getState().getValue() == 0) {
            MsgBox.showInfo((String)(this.editData.getNumber() + ":" + EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.TaxBaseResource", (String)"Active_NotEdit")));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.isIsPreinstall()) {
            MsgBox.showInfo((String)(this.editData.getNumber() + ":" + EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.TaxBaseResource", (String)"Preinstall_Not_Remove")));
            SysUtil.abort();
        }
        if (this.editData.getState().getValue() == 0) {
            MsgBox.showInfo((String)(this.editData.getNumber() + ":" + EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.TaxBaseResource", (String)"Active_NotDelete")));
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.inputCheck();
        super.actionSave_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.inputCheck();
        super.actionSubmit_actionPerformed(e);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.txtNumber.setEditable(false);
        }
        if (this.editData == null) {
            return;
        }
        if (this.editData.getId() != null && EnableStateEnum.ENABLE.equals((Object)this.editData.getState())) {
            this.setOprtState("VIEW");
        }
        if (this.editData.getId() == null) {
            this.btnCancel.setEnabled(false);
            this.btnCancelCancel.setEnabled(false);
            this.menuItemCancelCancel.setEnabled(false);
            this.menuItemCancel.setEnabled(false);
            return;
        }
        if (this.editData.getState().equals((Object)EnableStateEnum.ENABLE)) {
            this.btnRemove.setEnabled(false);
            this.btnCancel.setEnabled(true);
            this.btnCancelCancel.setEnabled(false);
            this.menuItemCancel.setEnabled(true);
            this.menuItemCancelCancel.setEnabled(false);
            this.btnEdit.setEnabled(false);
        } else {
            this.btnRemove.setEnabled(true);
            this.btnCancel.setEnabled(false);
            this.btnCancelCancel.setEnabled(true);
            this.menuItemCancel.setEnabled(false);
            this.menuItemCancelCancel.setEnabled(true);
            this.btnEdit.setEnabled(true);
        }
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        String billId = this.editData.getId().toString();
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(billId);
        ArrayList errors = BackupDataTypeFactory.getRemoteInstance().cancelCancel(new HashSet(ids));
        if (errors.size() > 0) {
            MsgBox.showWarning((Component)((Object)this), (String)((String)errors.get(0)));
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Startup_OK"));
            this.setOprtState("VIEW");
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)billId));
            this.refresh((IObjectPK)pk);
        }
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        String billId = this.editData.getId().toString();
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(billId);
        ArrayList errors = BackupDataTypeFactory.getRemoteInstance().cancel(new HashSet(ids));
        if (errors.size() > 0) {
            MsgBox.showWarning((Component)((Object)this), (String)((String)errors.get(0)));
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Forbid _OK"));
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)billId));
            this.refresh((IObjectPK)pk);
        }
    }

    private void refresh(IObjectPK pk) throws Exception {
        this.setDataObject(this.getValue(pk));
        this.loadFields();
        this.initOldData((IObjectValue)this.editData);
    }
}

