/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.client;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.td.cloud.BackupItemFactory;
import com.kingdee.eas.tm.td.cloud.BackupItemInfo;
import com.kingdee.eas.tm.td.cloud.EnableStateEnum;
import com.kingdee.eas.tm.td.cloud.client.AbstractBackupItemListUI;
import com.kingdee.eas.tm.td.cloud.client.BackupItemEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class BackupItemListUI
extends AbstractBackupItemListUI {
    private static final Logger logger = CoreUIObject.getLogger(BackupItemListUI.class);
    private static final String COL_STATE = "state";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected String getEditUIName() {
        return BackupItemEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BackupItemFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        this.setMergeColumn();
        super.onLoad();
    }

    private void setMergeColumn() {
        String[] mergeColumnKeys = this.getMergeColumnKeys();
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            this.tblMain.checkParsed();
            this.tblMain.getGroupManager().setGroup(true);
            IColumn col = null;
            for (int i = 0; i < mergeColumnKeys.length; ++i) {
                col = this.tblMain.getColumn(mergeColumnKeys[i]);
                if (col != null) {
                    col.setGroup(true);
                    col.setMergeable(true);
                    continue;
                }
                logger.info((Object)("mergeColumn no found:" + mergeColumnKeys[i]));
            }
        }
    }

    public String[] getMergeColumnKeys() {
        String[] columns = new String[]{"id", "number", "taxItemType.name", "backupDataType.name", "name", "desc", "policySummarize", "policyGist", "hasPreferentialTime", "applyCondition", COL_STATE, "remark", "creator.name", "createTime", "lastUpdateUser.name", "lastUpdateTime", "CU.name"};
        return columns;
    }

    public String getKeyFieldName() {
        return "id";
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnCancel.setEnabled(true);
        this.btnCancelCancel.setEnabled(true);
        this.btnCancel.setVisible(true);
        this.btnCancelCancel.setVisible(true);
    }

    protected void checkStateEnableEdit() throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        BackupItemInfo info = BackupItemFactory.getRemoteInstance().getBackupItemInfo((IObjectPK)new ObjectUuidPK(id));
        if (EnableStateEnum.ENABLE.equals((Object)info.getState())) {
            MsgBox.showWarning((String)"\u542f\u7528\u72b6\u6001\u4e0d\u5141\u8bb8\u7f16\u8f91");
            SysUtil.abort();
            return;
        }
    }

    protected void checkStateEnableRemove() throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        BackupItemInfo info = BackupItemFactory.getRemoteInstance().getBackupItemInfo((IObjectPK)new ObjectUuidPK(id));
        if (EnableStateEnum.ENABLE.equals((Object)info.getState())) {
            MsgBox.showWarning((String)"\u542f\u7528\u72b6\u6001\u4e0d\u5141\u8bb8\u5220\u9664");
            SysUtil.abort();
            return;
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkStateEnableEdit();
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList result = BackupItemFactory.getRemoteInstance().batchDelete(new HashSet(this.getSelectedIdValues()));
        String error = "";
        String errorDetail = "";
        if (result != null && !result.isEmpty()) {
            error = EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.TaxBaseResource", (String)"REMOVE_ERROR");
            errorDetail = this.buildErrorMsg(result);
            MsgBox.showDetailAndOK(null, (String)error, (String)errorDetail, (int)1);
        }
        this.refreshList();
    }

    public String buildErrorMsg(ArrayList msg) {
        StringBuffer retMsg = new StringBuffer();
        for (int i = 0; i < msg.size(); ++i) {
            retMsg.append(msg.get(i)).append("\r\n");
        }
        return retMsg.toString();
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Cancel");
        String cancelError = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_CancelError");
        if (this.confirmDialog(cancelMsg)) {
            ArrayList errorList = BackupItemFactory.getRemoteInstance().cancel(new HashSet(this.getSelectedIdValues()));
            if (errorList.size() > 0) {
                StringBuffer errorDetailMSG = new StringBuffer();
                for (int i = 0; i < errorList.size(); ++i) {
                    errorDetailMSG.append((String)errorList.get(i)).append("\n");
                }
                MsgBox.showDetailAndOK((Component)((Object)this), (String)cancelError, (String)errorDetailMSG.toString(), (int)8188);
            }
            this.actionRefresh_actionPerformed(e);
        }
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList errorList = BackupItemFactory.getRemoteInstance().cancelCancel(new HashSet(this.getSelectedIdValues()));
        String cancelCancelError = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_CancelCancelError");
        if (errorList.size() > 0) {
            StringBuffer errorDetailMSG = new StringBuffer();
            for (int i = 0; i < errorList.size(); ++i) {
                errorDetailMSG.append((String)errorList.get(i)).append("\n");
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)cancelCancelError, (String)errorDetailMSG.toString(), (int)8188);
        }
        this.actionRefresh_actionPerformed(e);
    }
}

