/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.SimpleTextRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.query.util.ConstDataType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fi.gl.client.ClientHelper;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.cloud.GroupCollection;
import com.kingdee.eas.tm.td.cloud.GroupFactory;
import com.kingdee.eas.tm.td.cloud.GroupInfo;
import com.kingdee.eas.tm.td.cloud.UserGroupFactory;
import com.kingdee.eas.tm.td.cloud.client.AbstractGroupAssignUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class GroupAssignUI
extends AbstractGroupAssignUI {
    private static final Logger logger = CoreUIObject.getLogger(GroupAssignUI.class);
    private ArrayList userAssignedIDList = new ArrayList();
    private ActionListener groupSearchListener = null;
    private ActionListener userSearchListener = null;
    private KDTEditAdapter groupForAssignedListener = null;
    private String oldUserSearchCondition = "";
    private String oldGroupSearchCondition = "";
    private GroupCollection groupCols = new GroupCollection();
    private UserCollection userCols = new UserCollection();
    private GroupTreeRender treeRender = null;
    private static final String TBL_SELECTED = "selected";
    private static final String TBL_NUMBER = "number";
    private static final String TBL_NAME = "name";
    private static final String TBL_ISDEFAULT = "isDefault";

    public void onLoad() throws Exception {
        super.onLoad();
        this.afterLoad();
    }

    @Override
    public void loadFields() {
        this.removeLiseners();
        super.loadFields();
        this.initLiseners();
    }

    private void initLiseners() {
        if (this.groupSearchListener == null) {
            this.groupSearchListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GroupAssignUI.this.onClickForBtnGroupSearch();
                }
            };
        }
        this.btnCompanySearch.addActionListener(this.groupSearchListener);
        if (this.userSearchListener == null) {
            this.userSearchListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GroupAssignUI.this.onClickForBtnUserSearch();
                }
            };
        }
        this.btnItemSearch.addActionListener(this.userSearchListener);
        if (this.groupForAssignedListener == null) {
            this.groupForAssignedListener = new KDTEditAdapter(){

                public void editValueChanged(KDTEditEvent e) {
                    GroupAssignUI.this.groupForAssigned_editValueChanged(e);
                }
            };
        }
        this.tblCompanyForAssigned.addKDTEditListener((KDTEditListener)this.groupForAssignedListener);
    }

    private void groupForAssigned_editValueChanged(KDTEditEvent e) {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        String fieldName = this.tblCompanyForAssigned.getColumnKey(colIndex);
        IRow row = this.tblCompanyForAssigned.getRow(e.getRowIndex());
        if (TBL_SELECTED.equals(fieldName)) {
            if (!((Boolean)row.getCell(TBL_SELECTED).getValue()).booleanValue()) {
                row.getCell(TBL_SELECTED).setValue((Object)Boolean.TRUE);
            } else {
                row.getCell(TBL_SELECTED).setValue((Object)Boolean.FALSE);
                row.getCell(TBL_ISDEFAULT).setValue((Object)Boolean.FALSE);
            }
            this.loadUserSelectedStatus();
            this.userFastQuery();
        } else if (TBL_ISDEFAULT.equals(fieldName)) {
            int rowCount = this.tblCompanyForAssigned.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                if (i != rowIndex) {
                    this.tblCompanyForAssigned.getRow(i).getCell(fieldName).setValue((Object)Boolean.FALSE);
                    continue;
                }
                this.tblCompanyForAssigned.getRow(i).getCell(fieldName).setValue((Object)Boolean.TRUE);
                this.tblCompanyForAssigned.getRow(i).getCell(TBL_SELECTED).setValue((Object)Boolean.TRUE);
            }
        }
    }

    private void removeLiseners() {
        this.btnCompanySearch.removeActionListener(this.groupSearchListener);
        this.btnItemSearch.removeActionListener(this.userSearchListener);
        this.tblCompanyForAssigned.removeKDTEditListener((KDTEditListener)this.groupForAssignedListener);
    }

    private void userFastQuery() {
        String text = StringUtils.trim((String)this.itemTextField.getText());
        String newCondition = this.itemSearchField.getSelectedItem().toString() + text;
        String filter = ((FilterFieldItem)this.itemSearchField.getSelectedItem()).getName();
        this.oldUserSearchCondition = newCondition;
        int count = this.tblAccountForAssigned.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow row = this.tblAccountForAssigned.getRow(i);
            UserInfo checkInfo = (UserInfo)row.getCell(TBL_NUMBER).getUserObject();
            if (TBL_NUMBER.equals(filter) && !row.getStyleAttributes().isHided() && !checkInfo.getNumber().contains(text)) {
                row.getStyleAttributes().setHided(true);
            }
            if (!TBL_NAME.equals(filter) || row.getStyleAttributes().isHided() || checkInfo.getName().contains(text)) continue;
            row.getStyleAttributes().setHided(true);
        }
    }

    private void onClickForBtnGroupSearch() {
        String text = this.companyTextField.getText();
        String filter = ((FilterFieldItem)this.companySearchField.getSelectedItem()).getName();
        StringBuffer newCondition = new StringBuffer();
        if (TBL_NUMBER.equals(filter)) {
            newCondition.append("  number like '%").append(text).append("%'");
        } else if (TBL_NAME.equals(filter)) {
            newCondition.append("  name like '%").append(text).append("%'");
        }
        if (!newCondition.equals(this.oldGroupSearchCondition)) {
            this.oldGroupSearchCondition = newCondition.toString();
            if (StringUtils.isEmpty((String)text)) {
                this.loadGroupForAssigned(null);
            } else {
                this.loadGroupForAssigned(this.oldGroupSearchCondition);
            }
            this.loadUserSelectedStatus();
        }
    }

    private void onClickForBtnUserSearch() {
        String text = StringUtils.trim((String)this.itemTextField.getText());
        String newCondition = this.itemSearchField.getSelectedItem().toString() + text;
        if (!newCondition.equals(this.oldUserSearchCondition)) {
            this.loadUserForAssigned();
            this.loadUserSelectedStatus();
            this.userFastQuery();
        }
    }

    private void afterLoad() {
        this.innerLoadData();
        this.initControl();
        this.initBtnStatus();
        this.loadUserSelectedStatus();
        this.loadFields();
        ClientHelper.setTableKeyBoardManager((KDTable)this.tblAccountForAssigned);
        ClientHelper.setTableKeyBoardManager((KDTable)this.tblCompanyForAssigned);
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.companyTextField, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.itemTextField, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
        this.tblAccountForAssigned.getIndexColumn().getStyleAttributes().setHided(true);
        this.treeRender = new GroupTreeRender();
        this.tblCompanyForAssigned.getColumn(TBL_NUMBER).setRenderer((IBasicRender)this.treeRender);
    }

    private void innerLoadData() {
        this.loadGroupForAssigned(null);
        this.loadUserForAssigned();
    }

    private void initControl() {
        this.initFilterFields();
    }

    private void initBtnStatus() {
        this.rbAssigned.setEnabled(true);
        this.rbNotAssigned.setEnabled(true);
        this.btnAllSelect.setEnabled(true);
        this.btnAllDisSelect.setEnabled(true);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAllSelect.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnAllDisSelect.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnAssign.setIcon(EASResource.getIcon((String)"imgTbtn_distribute"));
        this.selectall.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
        this.modfiys.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.btnSelectAllOU.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnDisselectAllOU.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnCompanySearch.setIcon(EASResource.getIcon((String)"imgTbtn_find"));
        this.btnItemSearch.setIcon(EASResource.getIcon((String)"imgTbtn_find"));
    }

    private void initFilterFields() {
        this.itemSearchField.removeAllItems();
        this.companySearchField.removeAllItems();
        this.itemSearchField.addItems((Object[])this.getGroupFilterFields());
        this.companySearchField.addItems((Object[])this.getUserFilterFields());
    }

    private FilterFieldItem[] getGroupFilterFields() {
        ArrayList al = new ArrayList();
        int sizeOfAL = al.size();
        FilterFieldItem[] ffis = new FilterFieldItem[sizeOfAL];
        if (ffis.length == 0) {
            ffis = new FilterFieldItem[]{new FilterFieldItem(TBL_NUMBER, TDUtils.getString("com.kingdee.eas.tm.td.TDCommonResource", "Number", null), ConstDataType.STRING), new FilterFieldItem(TBL_NAME, TDUtils.getString("com.kingdee.eas.tm.td.TDCommonResource", "Name", null), ConstDataType.STRING)};
        }
        return ffis;
    }

    private FilterFieldItem[] getUserFilterFields() {
        ArrayList al = new ArrayList();
        int sizeOfAL = al.size();
        FilterFieldItem[] ffis = new FilterFieldItem[sizeOfAL];
        if (ffis.length == 0) {
            ffis = new FilterFieldItem[]{new FilterFieldItem(TBL_NUMBER, TDUtils.getString("com.kingdee.eas.tm.td.TDCommonResource", "Number", null), ConstDataType.STRING), new FilterFieldItem(TBL_NAME, TDUtils.getString("com.kingdee.eas.tm.td.TDCommonResource", "Name", null), ConstDataType.STRING)};
        }
        return ffis;
    }

    protected void loadGroupForAssigned(String filterStr) {
        try {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            if (!StringUtils.isEmpty((String)filterStr)) {
                filter = new FilterInfo(filterStr);
            }
            SorterItemInfo dsf = new SorterItemInfo("longNumber");
            evi.getSorter().add(dsf);
            evi.setFilter(filter);
            GroupCollection companyColl = GroupFactory.getRemoteInstance().getGroupCollection(evi);
            this.tblCompanyForAssigned.checkParsed();
            this.tblCompanyForAssigned.removeRows();
            if (companyColl != null && companyColl.size() > 0) {
                GroupInfo child = null;
                int count = companyColl.size();
                for (int i = 0; i < count; ++i) {
                    IRow row = this.tblCompanyForAssigned.addRow();
                    child = companyColl.get(i);
                    row.getCell("id").setUserObject((Object)child);
                    row.getCell(TBL_SELECTED).setValue((Object)Boolean.FALSE);
                    row.getCell(TBL_SELECTED).getStyleAttributes().setLocked(false);
                    row.getCell(TBL_NUMBER).setValue((Object)child.getNumber());
                    row.getCell(TBL_NUMBER).setUserObject((Object)child);
                    row.getCell(TBL_NAME).setValue((Object)child.getName());
                    row.getCell(TBL_ISDEFAULT).setValue((Object)Boolean.FALSE);
                    row.getCell(TBL_ISDEFAULT).getStyleAttributes().setLocked(false);
                    row.getCell("level").setValue((Object)child.getLevel());
                    row.getCell("isLeaf").setValue((Object)child.isIsLeaf());
                }
                this.setTreeDisplayStyle();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void loadUserForAssigned() {
        try {
            UserCollection userColl = this.getAllUserForAssign();
            if (userColl != null) {
                this.tblAccountForAssigned.checkParsed();
                this.tblAccountForAssigned.removeRows();
                int count = userColl.size();
                for (int i = 0; i < count; ++i) {
                    IRow row = this.tblAccountForAssigned.addRow();
                    UserInfo info = userColl.get(i);
                    row.getCell("id").setValue((Object)info.getId().toString());
                    row.getCell(TBL_SELECTED).setValue((Object)false);
                    row.getCell(TBL_NUMBER).setValue((Object)info.getNumber());
                    row.getCell(TBL_NUMBER).setUserObject((Object)info);
                    row.getCell(TBL_NAME).setValue((Object)info.getName());
                    row.getCell("type").setValue((Object)info.getType());
                }
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void loadUserSelectedStatus() {
        this.hideTblUserForAssigned();
        boolean isAssigned = this.rbAssigned.isSelected();
        ArrayList showList = null;
        this.getAssignedUserIdList();
        showList = this.userAssignedIDList;
        if (showList != null) {
            int count = this.tblAccountForAssigned.getRowCount();
            for (int i = 0; i < count; ++i) {
                IRow row = this.tblAccountForAssigned.getRow(i);
                UserInfo info = (UserInfo)row.getCell(TBL_NUMBER).getUserObject();
                String id = info.getId().toString();
                if (showList.contains(id) && isAssigned) {
                    row.getStyleAttributes().setHided(false);
                    continue;
                }
                if (isAssigned || !this.rbNotAssigned.isSelected() || showList.contains(id)) continue;
                row.getStyleAttributes().setHided(false);
            }
        }
    }

    protected void getAssignedUserIdList() {
        this.userAssignedIDList.clear();
        HashSet<String> uncatchGroupIDList = new HashSet<String>();
        int count = this.tblCompanyForAssigned.getRowCount();
        for (int i = 0; i < count; ++i) {
            GroupInfo group;
            String groupID;
            IRow row = this.tblCompanyForAssigned.getRow(i);
            if (!((Boolean)row.getCell(TBL_SELECTED).getValue()).booleanValue() || StringUtils.isEmpty((String)(groupID = (group = (GroupInfo)row.getCell(TBL_NUMBER).getUserObject()).getId().toString()))) continue;
            uncatchGroupIDList.add(groupID);
        }
        try {
            if (uncatchGroupIDList != null && uncatchGroupIDList.size() > 0) {
                this.userAssignedIDList = (ArrayList)UserGroupFactory.getRemoteInstance().getUserIDList(uncatchGroupIDList);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void hideTblUserForAssigned() {
        int count = this.tblAccountForAssigned.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow row = this.tblAccountForAssigned.getRow(i);
            row.getCell(TBL_SELECTED).setValue((Object)false);
            row.getStyleAttributes().setHided(true);
        }
    }

    protected UserCollection getAllUserForAssign() throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isDelete", (Object)false, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isForbidden", (Object)false, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        view.setSelector(sic);
        UserCollection userColl = UserFactory.getRemoteInstance().getUserCollection(view);
        return userColl;
    }

    @Override
    public void actionSelectAllOU_actionPerformed(ActionEvent e) throws Exception {
        int count = this.tblCompanyForAssigned.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow row = this.tblCompanyForAssigned.getRow(i);
            if (row.getStyleAttributes().isHided()) continue;
            row.getCell(TBL_SELECTED).setValue((Object)true);
        }
        this.rbAssigned.setSelected(false);
        this.rbNotAssigned.setSelected(false);
    }

    @Override
    public void actionDisselectAllOU_actionPerformed(ActionEvent e) throws Exception {
        int count = this.tblCompanyForAssigned.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow row = this.tblCompanyForAssigned.getRow(i);
            if (row.getStyleAttributes().isHided()) continue;
            row.getCell(TBL_SELECTED).setValue((Object)false);
            row.getCell(TBL_ISDEFAULT).setValue((Object)false);
        }
        this.loadUserSelectedStatus();
    }

    @Override
    public void actionAllSelect_actionPerformed(ActionEvent e) throws Exception {
        int count = this.tblAccountForAssigned.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow row = this.tblAccountForAssigned.getRow(i);
            if (row.getStyleAttributes().isHided()) continue;
            row.getCell(TBL_SELECTED).setValue((Object)true);
        }
    }

    @Override
    public void actionAllDisselect_actionPerformed(ActionEvent e) throws Exception {
        int count = this.tblAccountForAssigned.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow row = this.tblAccountForAssigned.getRow(i);
            if (row.getStyleAttributes().isHided()) continue;
            row.getCell(TBL_SELECTED).setValue((Object)false);
        }
    }

    @Override
    protected void companyTextField_keyPressed(KeyEvent e) throws Exception {
        if (e.getKeyCode() == 10) {
            this.onClickForBtnGroupSearch();
        }
    }

    @Override
    protected void itemTextField_keyPressed(KeyEvent e) throws Exception {
        if (e.getKeyCode() == 10) {
            this.onClickForBtnUserSearch();
        }
    }

    @Override
    public void actionAssigned_actionPerformed(ActionEvent e) throws Exception {
        this.rbNotAssigned.setSelected(false);
        this.btnAssign.setText(TDUtils.getString("com.kingdee.eas.tm.td.TDCommonResource", "unAssign", null));
        this.btnAssign.setToolTipText(TDUtils.getString("com.kingdee.eas.tm.td.TDCommonResource", "unAssign", null));
        this.loadUserSelectedStatus();
        this.userFastQuery();
    }

    @Override
    public void actionNotAssigned_actionPerformed(ActionEvent e) throws Exception {
        this.rbAssigned.setSelected(false);
        this.btnAssign.setText(TDUtils.getString("com.kingdee.eas.tm.td.TDCommonResource", "assign", null));
        this.btnAssign.setToolTipText(TDUtils.getString("com.kingdee.eas.tm.td.TDCommonResource", "assign", null));
        this.loadUserSelectedStatus();
        this.userFastQuery();
    }

    protected void verify() {
        this.storeFields();
        this.verifyInput();
    }

    protected void verifyInput() {
    }

    @Override
    public void storeFields() {
        this.storeGroupAssigned();
        this.storeUserAssigned();
    }

    protected void storeGroupAssigned() {
        this.groupCols.clear();
        int count = this.tblCompanyForAssigned.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow row = this.tblCompanyForAssigned.getRow(i);
            if (!((Boolean)row.getCell(TBL_SELECTED).getValue()).booleanValue()) continue;
            GroupInfo info = (GroupInfo)((GroupInfo)row.getCell(TBL_NUMBER).getUserObject()).clone();
            boolean isDefault = (Boolean)row.getCell(TBL_ISDEFAULT).getValue();
            info.setDefault(isDefault);
            info.put(TBL_ISDEFAULT, isDefault);
            this.groupCols.add(info);
        }
    }

    protected void storeUserAssigned() {
        boolean assign = this.rbAssigned.isSelected();
        this.userCols.clear();
        int count = this.tblAccountForAssigned.getRowCount();
        for (int i = 0; i < count; ++i) {
            UserInfo info;
            IRow row = this.tblAccountForAssigned.getRow(i);
            if (!assign) {
                if (row.getStyleAttributes().isHided() || !((Boolean)row.getCell(TBL_SELECTED).getValue()).booleanValue() || this.userAssignedIDList.contains((info = (UserInfo)((UserInfo)row.getCell(TBL_NUMBER).getUserObject()).clone()).getId().toString())) continue;
                this.userCols.add(info);
                continue;
            }
            if (!((Boolean)row.getCell(TBL_SELECTED).getValue()).booleanValue() || !this.userAssignedIDList.contains((info = (UserInfo)((UserInfo)row.getCell(TBL_NUMBER).getUserObject()).clone()).getId().toString())) continue;
            this.userCols.add(info);
        }
    }

    @Override
    public void actionAssign_actionPerformed(ActionEvent e) throws Exception {
        boolean check = false;
        int rowcount = this.tblCompanyForAssigned.getRowCount();
        for (int i = 0; i < rowcount; ++i) {
            IRow row = this.tblCompanyForAssigned.getRow(i);
            if (!((Boolean)row.getCell(TBL_SELECTED).getValue()).booleanValue()) continue;
            check = true;
            break;
        }
        if (check) {
            int i;
            boolean isAssign;
            this.verify();
            GroupCollection groupCols = this.getGroupCols();
            UserCollection userCols = this.getUserCols();
            if (groupCols == null || userCols == null) {
                return;
            }
            if (groupCols.size() == 0 || userCols.size() == 0) {
                if (this.rbAssigned.isSelected()) {
                    MsgBox.showInfo((Component)((Object)this), (String)TDUtils.getString("com.kingdee.eas.tm.td.cloud.TDCloudResource", "SelectUsersForUnAssign", null));
                }
                if (this.rbNotAssigned.isSelected()) {
                    MsgBox.showInfo((Component)((Object)this), (String)TDUtils.getString("com.kingdee.eas.tm.td.cloud.TDCloudResource", "SelectUsersForAssign", null));
                }
                return;
            }
            boolean bl = isAssign = !this.rbAssigned.isSelected();
            if (!isAssign) {
                StringBuffer confirmStr = new StringBuffer();
                confirmStr.append(TDUtils.getString("com.kingdee.eas.tm.td.cloud.TDCloudResource", "UnAssignConfirm", null, new Object[]{groupCols.size(), userCols.size()}));
                if (!MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)confirmStr.toString()))) {
                    return;
                }
            }
            List errorList = UserGroupFactory.getRemoteInstance().assignUser((IObjectCollection)groupCols, (IObjectCollection)userCols, isAssign);
            if (isAssign && (errorList == null || errorList.size() == 0)) {
                MsgBox.showInfo((Component)((Object)this), (String)TDUtils.getString("com.kingdee.eas.tm.td.cloud.TDCloudResource", "AssignSuccess", null));
            } else if (!isAssign) {
                if (!(isAssign || errorList != null && errorList.size() != 0)) {
                    MsgBox.showInfo((Component)((Object)this), (String)TDUtils.getString("com.kingdee.eas.tm.td.cloud.TDCloudResource", "unAssignSuccess", null));
                } else if (!isAssign) {
                    // empty if block
                }
            }
            this.loadGroupForAssigned(this.oldGroupSearchCondition);
            HashMap<String, GroupInfo> groupMap = new HashMap<String, GroupInfo>();
            int count = groupCols.size();
            for (i = 0; i < count; ++i) {
                GroupInfo info = groupCols.get(i);
                groupMap.put(info.getId().toString(), info);
            }
            count = this.tblCompanyForAssigned.getRowCount();
            for (i = 0; i < count; ++i) {
                IRow row = this.tblCompanyForAssigned.getRow(i);
                GroupInfo info = (GroupInfo)row.getCell(TBL_NUMBER).getUserObject();
                if (!groupMap.containsKey(info.getId().toString())) continue;
                row.getCell(TBL_SELECTED).setValue((Object)Boolean.TRUE);
            }
            this.rbAssigned.setSelected(true);
            this.btnAssign.setText(TDUtils.getString("com.kingdee.eas.tm.td.TDCommonResource", "unAssign", null));
            this.btnAssign.setToolTipText(TDUtils.getString("com.kingdee.eas.tm.td.TDCommonResource", "unAssign", null));
            this.rbNotAssigned.setSelected(false);
            this.tblAccountForAssigned.getLayoutManager().scrollRowToShow(0);
            this.loadUserSelectedStatus();
            this.userFastQuery();
        } else {
            MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.cloud.TDCloudResource", "SelectGroups", null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expandGroup(IRow row) {
        NumberExpandInfo acctNumberExpandInfo = (NumberExpandInfo)row.getCell(TBL_NUMBER).getValue();
        boolean isExpandStatus = acctNumberExpandInfo.isExpandStatus();
        String acctId = (String)row.getCell("id").getValue();
        int level = 0;
        if (row.getCell("level") != null) {
            level = (Integer)row.getCell("level").getValue();
        }
        if (isExpandStatus) {
            int level2;
            IRow child;
            acctNumberExpandInfo.setExpandStatus(false);
            this.tblCompanyForAssigned.setRefresh(false);
            int count = this.tblCompanyForAssigned.getRowCount();
            for (int i = row.getRowIndex() + 1; i < count && ((child = this.tblCompanyForAssigned.getRow(i)).getCell("level") == null || (level2 = ((Integer)child.getCell("level").getValue()).intValue()) > level); ++i) {
                NumberExpandInfo childInfo = (NumberExpandInfo)child.getCell(TBL_NUMBER).getValue();
                childInfo.setExpandStatus(false);
                child.getStyleAttributes().setHided(true);
            }
            this.tblCompanyForAssigned.setRefresh(true);
            this.tblCompanyForAssigned.reLayoutAndPaint();
        } else {
            acctNumberExpandInfo.setExpandStatus(true);
            int i = row.getRowIndex() + 1;
            boolean hasChildrenDataGotten = false;
            if (i < this.tblCompanyForAssigned.getRowCount()) {
                IRow next = this.tblCompanyForAssigned.getRow(i);
                NumberExpandInfo nextNumberExpandInfo = (NumberExpandInfo)next.getCell(TBL_NUMBER).getValue();
                hasChildrenDataGotten = true;
            }
            if (!hasChildrenDataGotten) {
                this.setCursorOfWair();
                EntityViewInfo childQuery = new EntityViewInfo();
                FilterInfo childFilter = new FilterInfo();
                childQuery.setFilter(childFilter);
                childFilter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)acctId));
                childFilter.setMaskString("#0");
                Object rowset = null;
                try {
                    if (rowset != null && rowset.size() > 0) {
                        int start = row.getRowIndex() + 1;
                        while (rowset.next()) {
                            IRow child = this.tblCompanyForAssigned.addRow(start);
                            ++start;
                            int colcount = this.tblCompanyForAssigned.getColumnCount();
                            for (int col = 0; col < colcount; ++col) {
                                IColumn column = this.tblCompanyForAssigned.getColumn(col);
                                String field = column.getFieldName();
                                if (field == null || field.length() < 1) continue;
                                Object value = rowset.getObject(field);
                                if (field.equals(TBL_NUMBER)) {
                                    NumberExpandInfo childNumberExpandInfo = new NumberExpandInfo();
                                    childNumberExpandInfo.setAcctId(rowset.getString("id"));
                                    childNumberExpandInfo.setLevel(rowset.getInt("level"));
                                    childNumberExpandInfo.setLeaf(rowset.getBoolean("isLeaf"));
                                    childNumberExpandInfo.setNumber(rowset.getString(TBL_NUMBER));
                                    childNumberExpandInfo.setExpandStatus(false);
                                    value = childNumberExpandInfo;
                                }
                                child.getCell(col).setValue(value);
                            }
                        }
                        this.tblCompanyForAssigned.setRowCount(this.tblCompanyForAssigned.getRowCount() + rowset.size());
                    }
                }
                catch (Exception e) {
                    this.handleException(e);
                }
                finally {
                    this.setCursorOfDefault();
                }
            }
            int count = this.tblCompanyForAssigned.getRowCount();
            while (i < count) {
                IRow child = this.tblCompanyForAssigned.getRow(i);
                NumberExpandInfo childNumberExpandInfo = (NumberExpandInfo)child.getCell(TBL_NUMBER).getValue();
                String childNumber = childNumberExpandInfo.getNumber();
                String parentId = (String)child.getCell("parent.id").getValue();
                if (parentId != null && parentId.equals(acctId)) {
                    this.expandChildAcct(child);
                }
                ++i;
            }
        }
    }

    private void expandChildAcct(IRow row) {
        NumberExpandInfo acctNumberExpandInfo = (NumberExpandInfo)row.getCell(TBL_NUMBER).getValue();
        String acctNumber = acctNumberExpandInfo.getNumber();
        boolean isExpandStatus = acctNumberExpandInfo.isExpandStatus();
        String acctId = (String)row.getCell("id").getValue();
        row.getStyleAttributes().setHided(false);
        if (isExpandStatus) {
            IRow child;
            NumberExpandInfo childNumberExpandInfo;
            String childNumber;
            int count = this.tblCompanyForAssigned.getRowCount();
            for (int i = row.getRowIndex() + 1; i < count && (childNumber = (childNumberExpandInfo = (NumberExpandInfo)(child = this.tblCompanyForAssigned.getRow(i)).getCell(TBL_NUMBER).getValue()).getNumber()).startsWith(acctNumber); ++i) {
                String parentId = (String)child.getCell("parent.id").getValue();
                if (!parentId.equals(acctId)) continue;
                this.expandChildAcct(child);
            }
        }
    }

    private void setTreeDisplayStyle() {
        int count = this.tblCompanyForAssigned.getRowCount();
        for (int i = 0; i < count; ++i) {
            Object numberValue;
            IRow row = this.tblCompanyForAssigned.getRow(i);
            if (row == null) continue;
            String id = (String)row.getCell("id").getValue();
            int level = 1;
            if (row.getCell("level").getValue() != null && row.getCell("level").getValue() instanceof Integer) {
                level = (Integer)row.getCell("level").getValue();
            }
            if (!((numberValue = row.getCell(TBL_NUMBER).getValue()) instanceof String)) {
                return;
            }
            String number = (String)numberValue;
            boolean isLeaf = false;
            if (row.getCell("isLeaf").getValue() != null && row.getCell("isLeaf").getValue() instanceof Boolean) {
                isLeaf = (Boolean)row.getCell("isLeaf").getValue();
            }
            NumberExpandInfo numberExpandInfo = new NumberExpandInfo();
            numberExpandInfo.setAcctId(id);
            numberExpandInfo.setLevel(level);
            numberExpandInfo.setLeaf(isLeaf);
            numberExpandInfo.setNumber(number);
            numberExpandInfo.setExpandStatus(true);
            row.getCell(TBL_NUMBER).setValue((Object)numberExpandInfo);
        }
    }

    public GroupCollection getGroupCols() {
        return this.groupCols;
    }

    public void setGroupCols(GroupCollection groupCols) {
        this.groupCols = groupCols;
    }

    public UserCollection getUserCols() {
        return this.userCols;
    }

    public void setUserCols(UserCollection userCols) {
        this.userCols = userCols;
    }

    class GroupTreeRender
    implements IBasicRender {
        private int TABSIZE = 8;
        private int ICONSIZE = 10;
        private int margin = 2;
        protected SimpleTextRender simpleRender = new SimpleTextRender();
        protected HashMap acctIdToPos = new HashMap();

        GroupTreeRender() {
        }

        protected void drawExpanded(Graphics g, int x, int y) {
            g.drawRect(x, y, this.ICONSIZE, this.ICONSIZE);
            int lineSize = this.ICONSIZE - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.ICONSIZE / 2, x + this.margin + lineSize, y + this.ICONSIZE / 2);
        }

        protected void drawCollapsed(Graphics g, int x, int y) {
            g.drawRect(x, y, this.ICONSIZE, this.ICONSIZE);
            int lineSize = this.ICONSIZE - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.ICONSIZE / 2, x + this.margin + lineSize, y + this.ICONSIZE / 2);
            g.drawLine(x + this.ICONSIZE / 2, y + this.margin, x + this.ICONSIZE / 2, y + this.margin + lineSize);
        }

        protected void drawLeaf(Graphics g, int x, int y) {
        }

        public boolean inRect(NumberExpandInfo numberExpandInfo, int x, int y) {
            String acctId = numberExpandInfo.getAcctId();
            Rectangle rec = (Rectangle)this.acctIdToPos.get(acctId);
            if (rec != null) {
                return rec.getX() < (double)x && rec.getX() + rec.getWidth() > (double)x;
            }
            return false;
        }

        public void draw(Graphics graphics, Shape clip, Object obj, Style style) {
            if (obj instanceof NumberExpandInfo) {
                NumberExpandInfo numberExpandInfo = (NumberExpandInfo)obj;
                int ident = numberExpandInfo.getLevel() * this.TABSIZE;
                Rectangle rect = clip.getBounds();
                int x = rect.x + ident;
                int y = rect.y + (rect.height - this.ICONSIZE) / 2;
                Rectangle iconRect = new Rectangle(x, y, this.ICONSIZE, this.ICONSIZE);
                this.acctIdToPos.put(numberExpandInfo.getAcctId(), iconRect);
                this.simpleRender.draw(graphics, (Shape)new Rectangle(x + this.ICONSIZE + this.TABSIZE, rect.y, rect.width - x - this.ICONSIZE - this.TABSIZE, rect.height), numberExpandInfo.getNumber(), style);
                this.paintIcon(graphics, numberExpandInfo, iconRect);
            } else if (obj != null) {
                this.simpleRender.draw(graphics, clip, obj.toString(), style);
            }
        }

        private void paintIcon(Graphics graphics, NumberExpandInfo numberExpandInfo, Rectangle iconRect) {
            if (numberExpandInfo.isLeaf()) {
                this.drawLeaf(graphics, iconRect.x, iconRect.y);
            } else if (numberExpandInfo.isExpandStatus()) {
                this.drawExpanded(graphics, iconRect.x, iconRect.y);
            } else if (!numberExpandInfo.isExpandStatus()) {
                this.drawCollapsed(graphics, iconRect.x, iconRect.y);
            }
        }
    }

    class NumberExpandInfo {
        private String acctId;
        private String number;
        private boolean isExpandStatus;
        private int level;
        private boolean isLeaf;

        NumberExpandInfo() {
        }

        public boolean isExpandStatus() {
            return this.isExpandStatus;
        }

        public void setExpandStatus(boolean isExpandStatus) {
            this.isExpandStatus = isExpandStatus;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String toString() {
            return this.number;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public boolean isLeaf() {
            return this.isLeaf;
        }

        public void setLeaf(boolean isLeaf) {
            this.isLeaf = isLeaf;
        }

        public String getAcctId() {
            return this.acctId;
        }

        public void setAcctId(String acctId) {
            this.acctId = acctId;
        }
    }

    public class FilterFieldItem {
        private String ffiName;
        private String ffiDisplayName;
        private ConstDataType fficdt;

        public FilterFieldItem(String name, String displayName, ConstDataType cdt) {
            this.ffiName = name;
            this.ffiDisplayName = displayName;
            this.fficdt = cdt;
        }

        public String toString() {
            return this.ffiDisplayName;
        }

        public String getName() {
            return this.ffiName;
        }

        public ConstDataType getType() {
            return this.fficdt;
        }
    }
}

