/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.tree.DefaultLNTreeNodeCtrl;
import com.kingdee.eas.framework.client.tree.ILNTreeNodeCtrl;
import com.kingdee.eas.framework.client.tree.ITreeBuilder;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.framework.client.tree.TreeBuilderFactory;
import com.kingdee.eas.tm.td.cloud.GroupFactory;
import com.kingdee.eas.tm.td.cloud.GroupInfo;
import com.kingdee.eas.tm.td.cloud.OrgGroupCollection;
import com.kingdee.eas.tm.td.cloud.OrgGroupFactory;
import com.kingdee.eas.tm.td.cloud.OrgGroupInfo;
import com.kingdee.eas.tm.td.cloud.client.AbstractOrgGroupListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.Action;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class OrgGroupListUI
extends AbstractOrgGroupListUI {
    private static final Logger logger = CoreUIObject.getLogger(OrgGroupListUI.class);
    private TreeSelectionListener treeSelectionListener = null;
    private ITreeBuilder treeBuilder = null;
    private KDTreeNode rootNode = null;
    private TreeBaseInfo sourceTreeNode;
    private static final String COL_ORGNUMBER = "orgNumber";
    private static final String COL_ORGNAME = "orgName";
    private static final String COL_GROUP = "group";
    private static final String COL_OBJECT = "OBJECT";

    public void onLoad() throws Exception {
        super.onLoad();
        this.afterLoad();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    protected void initListener() {
        if (this.treeSelectionListener == null) {
            this.treeMain.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    try {
                        OrgGroupListUI.this.treeMain_valueChanged(e);
                    }
                    catch (Exception exc) {
                        OrgGroupListUI.this.handUIException(exc);
                    }
                }
            });
        }
    }

    protected void afterLoad() throws Exception {
        this.initTree();
        this.initGroupButton();
        this.initWorkButton();
        this.btnMultidimensionalView.addAssistMenuItem((Action)((Object)this.actionViewUser));
        this.btnMultidimensionalView.addAssistMenuItem((Action)((Object)this.actionViewGroup));
    }

    private KDTreeNode getSelectedTreeNode() {
        return (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        this.sourceTreeNode = this.getSelectedTreeItem();
        if (this.sourceTreeNode != null) {
            this.execQuery();
        }
    }

    public TreeBaseInfo getSelectedTreeItem() throws EASBizException, BOSException {
        TreeBaseInfo sourceTreeNode = null;
        if (this.getSelectedTreeNode() != null && this.getSelectedTreeNode().getUserObject() instanceof TreeBaseInfo) {
            sourceTreeNode = (TreeBaseInfo)this.getSelectedTreeNode().getUserObject();
            if (!this.getTreeInterface().exists((IObjectPK)new ObjectUuidPK(sourceTreeNode.getId()))) {
                throw new EASBizException(EASBizException.CHECKEXIST);
            }
        }
        return sourceTreeNode;
    }

    public String getGroupEditUIName() {
        return "com.kingdee.eas.tm.td.cloud.client.GroupEditUI";
    }

    public void openGroupEditUI(String oprtState) throws EASBizException, BOSException {
        GroupInfo groupInfo = (GroupInfo)this.getSelectedTreeItem();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)groupInfo.getId().toString());
        uiContext.put((Object)"groupInfo", (Object)groupInfo);
        IUIWindow w = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getGroupEditUIName(), (Map)uiContext, null, oprtState);
        w.show();
    }

    @Override
    public void actionGroupAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.checkTreeNodeSelected(e);
        this.openGroupEditUI(OprtState.ADDNEW);
        this.refresh(e);
    }

    @Override
    public void actionGroupView_actionPerformed(ActionEvent e) throws Exception {
        this.checkTreeNodeSelected(e);
        this.openGroupEditUI(OprtState.VIEW);
        this.refresh(e);
    }

    @Override
    public void actionGroupEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkTreeNodeSelected(e);
        this.openGroupEditUI(OprtState.EDIT);
        this.refresh(e);
    }

    @Override
    public void actionGroupRemove_actionPerformed(ActionEvent e) throws Exception {
    }

    public void checkTreeNodeSelected(ActionEvent e) {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        ItemAction action = this.getActionFromActionEvent(e);
        if (treeNode == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Leaf_MustSelected"));
            SysUtil.abort();
        }
        if (!action.equals((Object)this.actionGroupAddNew) && !(treeNode.getUserObject() instanceof TreeBaseInfo)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Root_CannotSelected"));
            SysUtil.abort();
        }
        if (!action.equals((Object)this.actionGroupAddNew) && treeNode.getUserObject() instanceof TreeBaseInfo) {
            try {
                this.checkTreeObjectExists(e);
            }
            catch (Exception e1) {
                e1.printStackTrace();
                SysUtil.abort();
            }
        }
    }

    private void checkTreeObjectExists(ActionEvent e) throws Exception {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        if (treeNode.getUserObject() == null) {
            return;
        }
        if (!this.getTreeInterface().exists((IObjectPK)new ObjectUuidPK(((TreeBaseInfo)treeNode.getUserObject()).getId().toString()))) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
    }

    public void refresh(ActionEvent e) {
    }

    protected void execQuery() throws BOSException {
        this.tblMain.repaint();
        this.tblMain.removeRows();
        if (this.sourceTreeNode == null) {
            return;
        }
        String longNumber = this.sourceTreeNode.getLongNumber();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (this.isIncludeSub.isSelected()) {
            filter.getFilterItems().add(new FilterItemInfo("group.longNumber", (Object)(longNumber + "%"), CompareType.LIKE));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("group.longNumber", (Object)longNumber, CompareType.EQUALS));
        }
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("group.*"));
        view.setSelector(sic);
        OrgGroupCollection orgGroupColl = OrgGroupFactory.getRemoteInstance().getOrgGroupCollection(view);
        int count = orgGroupColl.size();
        OrgGroupInfo info = null;
        IRow row = null;
        for (int i = 0; i < count; ++i) {
            info = orgGroupColl.get(i);
            row = this.tblMain.addRow();
            row.getCell(COL_ORGNUMBER).setValue((Object)info.getCompany().getNumber());
            row.getCell(COL_ORGNAME).setValue((Object)info.getCompany().getName());
            row.getCell(COL_GROUP).setValue((Object)info.getGroup());
            row.getCell(COL_OBJECT).setValue((Object)info);
        }
        this.tblMain.setRefresh(true);
        this.tblMain.reLayoutAndPaint();
        this.tblMain.setEditable(false);
        this.tblMain.getSelectManager().setSelectMode(10);
    }

    protected void initGroupButton() {
        this.treeMainView.getControlPane().add((Component)this.btnGroupAddNew);
        this.treeMainView.getControlPane().add((Component)this.btnGroupView);
        this.treeMainView.getControlPane().add((Component)this.btnGroupEdit);
        this.treeMainView.getControlPane().add((Component)this.btnGroupRemove);
    }

    protected void initWorkButton() {
        this.getUIToolBar().remove((Component)this.btnGroupAddNew);
        this.getUIToolBar().remove((Component)this.btnGroupView);
        this.getUIToolBar().remove((Component)this.btnGroupEdit);
        this.getUIToolBar().remove((Component)this.btnGroupRemove);
        super.initWorkButton();
        this.btnGroupAddNew.setText(null);
        this.btnGroupAddNew.setIcon(EASResource.getIcon((String)"imgTree_new"));
        this.btnGroupView.setText(null);
        this.btnGroupView.setIcon(EASResource.getIcon((String)"imgTree_view"));
        this.btnGroupEdit.setText(null);
        this.btnGroupEdit.setIcon(EASResource.getIcon((String)"imgTree_edit"));
        this.btnGroupRemove.setText(null);
        this.btnGroupRemove.setIcon(EASResource.getIcon((String)"imgTree_delete"));
        this.btnAddNew.setIcon(EASResource.getIcon((String)"imgTbtn_citecompany"));
        this.btnRemove.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnAssign.setIcon(EASResource.getIcon((String)"imgTbtn_distribute"));
        this.btnMultidimensionalView.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
    }

    protected void initTree() throws Exception {
        TreeSelectionListener[] listeners = this.treeMain.getTreeSelectionListeners();
        if (listeners.length > 0) {
            this.treeSelectionListener = listeners[0];
            this.treeMain.removeTreeSelectionListener(this.treeSelectionListener);
        }
        this.treeBuilder = TreeBuilderFactory.createTreeBuilder((ILNTreeNodeCtrl)this.getLNTreeNodeCtrl(), (int)this.getTreeInitialLevel(), (int)this.getTreeExpandLevel(), (FilterInfo)this.getDefaultFilterForTree(), (SelectorItemCollection)this.getSelectorForTree());
        if (this.getRootName() != null) {
            this.rootNode = new KDTreeNode(this.getRootObject());
            ((DefaultTreeModel)this.treeMain.getModel()).setRoot((TreeNode)this.rootNode);
        } else {
            ((DefaultTreeModel)this.treeMain.getModel()).setRoot(null);
        }
        this.treeBuilder.buildTree(this.treeMain);
        this.treeMain.addTreeSelectionListener(this.treeSelectionListener);
        this.treeMain.setShowPopMenuDefaultItem(true);
    }

    protected SelectorItemCollection getSelectorForTree() {
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add("name");
        sc.add("number");
        sc.add("level");
        sc.add("longnumber");
        sc.add("isLeaf");
        return sc;
    }

    protected FilterInfo getDefaultFilterForTree() {
        FilterInfo filter = new FilterInfo();
        FilterInfo treeFilter = this.getLeftTreeFilter();
        try {
            if (treeFilter != null) {
                filter.mergeFilter(treeFilter, "AND");
            }
        }
        catch (BOSException ex) {
            MsgBox.showError((Component)((Object)this), (String)ex.getMessage());
            super.abort();
        }
        return filter;
    }

    protected FilterInfo getLeftTreeFilter() {
        FilterInfo filter = new FilterInfo();
        return filter;
    }

    protected String getRootName() {
        return "\u5206\u7ec4";
    }

    protected Object getRootObject() {
        return this.getRootName();
    }

    protected int getTreeInitialLevel() {
        return 6;
    }

    protected int getTreeExpandLevel() {
        return 6;
    }

    protected ILNTreeNodeCtrl getLNTreeNodeCtrl() throws Exception {
        return new DefaultLNTreeNodeCtrl(this.getTreeInterface());
    }

    protected ITreeBase getTreeInterface() throws BOSException {
        return GroupFactory.getRemoteInstance();
    }
}

