/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.f7.NewOrgF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.cloud.EnableStateEnum;
import com.kingdee.eas.tm.td.cloud.TaxLeadTimeFactory;
import com.kingdee.eas.tm.td.cloud.TaxLeadTimeInfo;
import com.kingdee.eas.tm.td.cloud.client.AbstractTaxLeadTimeEditUI;
import com.kingdee.eas.tm.td.common.permsupport.IPermSupport4EditUI;
import com.kingdee.eas.tm.td.common.uihelper.EditUIHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class TaxLeadTimeEditUI
extends AbstractTaxLeadTimeEditUI
implements IPermSupport4EditUI {
    private static final Logger logger = CoreUIObject.getLogger(TaxLeadTimeEditUI.class);
    private static final String TDRESOURCE = "com.kingdee.eas.tm.td.cloud.TDCloudResource";
    private EditUIHelper uiHelper = new EditUIHelper(this);
    private String currentCUID;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.initBtnStatus();
        this.currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
    }

    private void refresh(IObjectPK pk) throws Exception {
        this.setDataObject(this.getValue(pk));
        this.loadFields();
        this.initOldData((IObjectValue)this.editData);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
        if (company != null) {
            this.initCompanyFilter(company.getId().toString());
        } else {
            this.initCompanyFilter(null);
        }
        this.addIntEditor();
    }

    private void initCompanyFilter(String companyID) throws EASBizException, BOSException {
        NewOrgF7 orgF7 = new NewOrgF7();
        orgF7.setNeedAddOrgRange(false);
        orgF7.setIsCUFilter(true);
        orgF7.setMultiSelect(false);
        orgF7.setContainSealUp(false);
        orgF7.setNeedConsiderFaultTree(false);
        CompanyOrgUnitInfo company = null;
        if (companyID != null) {
            company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID));
        }
        if (company != null && company.getCU() != null) {
            orgF7.setCurrentCUID(company.getCU().getId().toString());
        } else {
            orgF7.setCurrentCUID(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        }
        orgF7.showCheckBoxOfShowingAllOUs();
        this.prmtCompany.setSelector((KDPromptSelector)orgF7);
    }

    private void addIntEditor() {
        this.txtReportDays.setDataType(0);
        this.txtReportDays.setSupportedEmpty(false);
        this.txtReportDays.setNegatived(true);
        this.txtReportDays.setDecimalSeparatorAlwaysShown(false);
        this.txtReportDays.setHorizontalAlignment(4);
        this.txtAuditDays.setDataType(0);
        this.txtAuditDays.setSupportedEmpty(false);
        this.txtAuditDays.setNegatived(true);
        this.txtAuditDays.setDecimalSeparatorAlwaysShown(false);
        this.txtAuditDays.setHorizontalAlignment(4);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanAddnew(this.currentCUID);
        super.actionAddNew_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.editData.getId().toString());
        this.uiHelper.checkCanRemove(this.currentCUID, ids);
        super.actionRemove_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanEdit(this.currentCUID, this.editData.getId().toString());
        super.actionEdit_actionPerformed(e);
        this.initBtnStatus();
    }

    private void initBtnStatus() {
        if (this.editData.getId() == null) {
            this.btnCancel.setEnabled(false);
            this.btnCancelCancel.setEnabled(false);
            this.menuItemCancelCancel.setEnabled(false);
            this.menuItemCancel.setEnabled(false);
            return;
        }
        if (this.editData.getState().equals((Object)EnableStateEnum.ENABLE)) {
            this.btnRemove.setEnabled(false);
            this.btnCancel.setEnabled(true);
            this.btnCancelCancel.setEnabled(false);
            this.menuItemCancel.setEnabled(true);
            this.menuItemCancelCancel.setEnabled(false);
            this.btnEdit.setEnabled(false);
        } else {
            this.btnRemove.setEnabled(true);
            this.btnCancel.setEnabled(false);
            this.btnCancelCancel.setEnabled(true);
            this.menuItemCancel.setEnabled(false);
            this.menuItemCancelCancel.setEnabled(true);
            this.btnEdit.setEnabled(true);
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.inputCheck();
        super.actionSave_actionPerformed(e);
        super.actionSubmit_actionPerformed(e);
        this.setOprtState("VIEW");
        if (this.editData != null && this.editData.getId() != null) {
            String billId = this.editData.getId().toString();
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)billId));
            this.refresh((IObjectPK)pk);
        }
    }

    private void inputCheck() {
        StringBuffer sb = new StringBuffer();
        if (this.txtNumber.getText().isEmpty()) {
            sb.append("\u3001" + this.txtNumber.getBoundLabelText());
        }
        if (this.prmtCompany.getValue() == null) {
            sb.append("\u3001" + this.contCompany.getBoundLabelText());
        }
        if (this.prmtTaxNotes.getValue() == null) {
            sb.append("\u3001" + this.contTaxNotes.getBoundLabelText());
        }
        if (sb.length() > 0) {
            sb.append(TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "Data_NotNull", TDUtils.getLocale())).append("\r\n");
            MsgBox.showWarning((String)sb.substring(1));
            SysUtil.abort();
        }
        try {
            if (this.txtDescription.getText().getBytes("utf8").length > 255) {
                sb.append(EASResource.getString((String)TDRESOURCE, (String)"DESCRIPTION"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (sb.length() > 0) {
            sb.append(EASResource.getString((String)TDRESOURCE, (String)"OVER_LENGTH"));
            MsgBox.showWarning((String)sb.substring(1));
            SysUtil.abort();
        }
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        String billId = this.editData.getId().toString();
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(billId);
        this.uiHelper.checkBaseDataPermission(this.currentCUID, ids);
        ArrayList errors = TaxLeadTimeFactory.getRemoteInstance().cancelCancel(new HashSet(ids));
        if (errors.size() > 0) {
            MsgBox.showWarning((Component)((Object)this), (String)((String)errors.get(0)));
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Startup_OK"));
            this.setOprtState("VIEW");
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)billId));
            this.refresh((IObjectPK)pk);
        }
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        String billId = this.editData.getId().toString();
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(billId);
        this.uiHelper.checkBaseDataPermission(this.currentCUID, ids);
        ArrayList errors = TaxLeadTimeFactory.getRemoteInstance().cancel(new HashSet(ids));
        if (errors.size() > 0) {
            MsgBox.showWarning((Component)((Object)this), (String)((String)errors.get(0)));
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Forbid _OK"));
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)billId));
            this.refresh((IObjectPK)pk);
        }
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        TaxLeadTimeInfo editData = (TaxLeadTimeInfo)newData;
        editData.setNumber(null);
        editData.setState(EnableStateEnum.DISABLE);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TaxLeadTimeFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        TaxLeadTimeInfo info = new TaxLeadTimeInfo();
        info.setState(EnableStateEnum.DISABLE);
        Date date = new Date();
        info.setCreateTime(new Timestamp(date.getTime()));
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        return info;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }

    @Override
    public String getBizOrgProperty(OrgType orgType) throws BOSException, EASBizException {
        return "CU";
    }

    @Override
    public String getPermItem(String status) {
        return null;
    }

    @Override
    public KDBizPromptBox getPermMainBizOrg() {
        return null;
    }

    @Override
    public IObjectValue getValueObject() {
        return this.editData;
    }

    @Override
    public ICoreBase getPermInterface() throws Exception {
        return this.getBizInterface();
    }
}

