/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.cloud.EnableStateEnum;
import com.kingdee.eas.tm.td.cloud.TaxTimeTableFactory;
import com.kingdee.eas.tm.td.cloud.TaxTimeTableInfo;
import com.kingdee.eas.tm.td.cloud.client.AbstractTaxTimeTableListUI;
import com.kingdee.eas.tm.td.cloud.client.TaxTimeTableEditUI;
import com.kingdee.eas.tm.td.common.permsupport.IPermSupport4ListUI;
import com.kingdee.eas.tm.td.common.uihelper.ListUIHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class TaxTimeTableListUI
extends AbstractTaxTimeTableListUI
implements IPermSupport4ListUI {
    private static final Logger logger = CoreUIObject.getLogger(TaxTimeTableListUI.class);
    private ListUIHelper uiHelper = new ListUIHelper(this);
    private String currentCUID;

    public void onLoad() throws Exception {
        super.onLoad();
        this.currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected String getEditUIName() {
        return TaxTimeTableEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TaxTimeTableFactory.getRemoteInstance();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.uiHelper.checkCanRemove(this.currentCUID, this.getSelectedIdValues());
        ArrayList result = TaxTimeTableFactory.getRemoteInstance().batchDelete(new HashSet(this.getSelectedIdValues()));
        String error = "";
        String errorDetail = "";
        if (result != null && !result.isEmpty()) {
            error = EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.TaxBaseResource", (String)"REMOVE_ERROR");
            errorDetail = this.buildErrorMsg(result);
            MsgBox.showDetailAndOK(null, (String)error, (String)errorDetail, (int)1);
        }
        this.refreshList();
    }

    public String buildErrorMsg(ArrayList msg) {
        StringBuffer retMsg = new StringBuffer();
        for (int i = 0; i < msg.size(); ++i) {
            retMsg.append(msg.get(i)).append("\r\n");
        }
        return retMsg.toString();
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.uiHelper.checkBaseDataPermission(this.currentCUID, this.getSelectedIdValues());
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Cancel");
        String cancelError = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_CancelError");
        if (this.confirmDialog(cancelMsg)) {
            ArrayList errorList = TaxTimeTableFactory.getRemoteInstance().cancel(new HashSet(this.getSelectedIdValues()));
            if (errorList.size() > 0) {
                StringBuffer errorDetailMSG = new StringBuffer();
                for (int i = 0; i < errorList.size(); ++i) {
                    errorDetailMSG.append((String)errorList.get(i)).append("\n");
                }
                MsgBox.showDetailAndOK((Component)((Object)this), (String)cancelError, (String)errorDetailMSG.toString(), (int)8188);
            }
            this.actionRefresh_actionPerformed(e);
        }
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.uiHelper.checkBaseDataPermission(this.currentCUID, this.getSelectedIdValues());
        ArrayList errorList = TaxTimeTableFactory.getRemoteInstance().cancelCancel(new HashSet(this.getSelectedIdValues()));
        String cancelCancelError = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_CancelCancelError");
        if (errorList.size() > 0) {
            StringBuffer errorDetailMSG = new StringBuffer();
            for (int i = 0; i < errorList.size(); ++i) {
                errorDetailMSG.append((String)errorList.get(i)).append("\n");
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)cancelCancelError, (String)errorDetailMSG.toString(), (int)8188);
        }
        this.actionRefresh_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanAddnew(this.currentCUID);
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.uiHelper.checkCanEdit(this.currentCUID, this.getSelectedKeyValue());
        String id = this.getSelectedKeyValue();
        TaxTimeTableInfo info = TaxTimeTableFactory.getRemoteInstance().getTaxTimeTableInfo((IObjectPK)new ObjectUuidPK(id));
        if (EnableStateEnum.ENABLE.equals((Object)info.getState())) {
            MsgBox.showWarning((String)TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "Active_Error", TDUtils.getLocale()));
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return this.uiHelper.getHasPermissionOrgFilterForQuery();
    }

    @Override
    public String getBizOrgProperty(OrgType orgType) throws BOSException, EASBizException {
        return "CU";
    }

    @Override
    public ICoreBase getPermInterface() throws Exception {
        return this.getBizInterface();
    }

    @Override
    public void initPermActions() throws BOSException, EASBizException {
    }

    @Override
    public void initPermMainOrgContext(String orgID) throws Exception {
    }
}

