/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.datamodel.check.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.TaxDraftRecordCollection;
import com.kingdee.eas.tm.td.TaxDraftRecordFactory;
import com.kingdee.eas.tm.td.TaxDraftRecordInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckAccountInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckAccountViewCollection;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckAccountViewFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckAccountViewInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.check.info.CheckAccountDetailResultVo;
import com.kingdee.eas.tm.td.cloud.datamodel.check.info.CheckAccountResultVo;
import com.kingdee.eas.tm.td.cloud.datamodel.check.processor.CheckAccountDetailProcessor;
import com.kingdee.eas.tm.td.cloud.utils.TDCloudUtil;
import com.kingdee.eas.tm.td.utils.TDSelectorFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CheckAccountProcessor {
    public Map execute(Context ctx, Map params) throws Exception {
        Set idSet = (Set)params.get("checkIds");
        Map values = (Map)params.get("values");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(TDSelectorFactory.getAllReportSelectors());
        TaxDraftRecordCollection reportColl = TaxDraftRecordFactory.getLocalInstance(ctx).getTaxDraftRecordCollection(view);
        Map<String, List<CheckAccountInfo>> companyCheckMap = this.getCheckAccountViewMap(ctx, reportColl);
        ArrayList<CheckAccountResultVo> resultList = new ArrayList<CheckAccountResultVo>();
        TaxDraftRecordInfo reportInfo = null;
        List<CheckAccountInfo> checkList = null;
        CheckAccountInfo checkInfo = null;
        CheckAccountResultVo resultVo = null;
        String reportID = null;
        Iterator it = reportColl.iterator();
        while (it.hasNext()) {
            boolean isSubmit2Cacl;
            reportInfo = (TaxDraftRecordInfo)it.next();
            reportID = reportInfo.getId().toString();
            if (values != null && values.containsKey(reportID)) {
                reportInfo = (TaxDraftRecordInfo)values.get(reportID);
            }
            if (isSubmit2Cacl = TDUtils.getBooleanParam(ctx, reportInfo.getCompanyOrgUnit().getId().toString(), "VATD004")) {
                TDUtils.calculateReport(ctx, reportInfo);
            }
            if ((checkList = companyCheckMap.get(reportInfo.getCompanyOrgUnit().getId().toString())) == null || checkList.size() == 0) continue;
            int size = checkList.size();
            for (int i = 0; i < size; ++i) {
                checkInfo = checkList.get(i);
                if (!this.verify(ctx, reportInfo, checkInfo).booleanValue()) continue;
                resultVo = new CheckAccountResultVo(reportInfo, checkInfo);
                CheckAccountDetailProcessor detailProcessor = new CheckAccountDetailProcessor(ctx, reportInfo, checkInfo);
                detailProcessor.execute();
                resultVo.setDetailList(detailProcessor.getDetailList());
                resultVo.setErrorList(detailProcessor.getErrorList());
                resultList.add(resultVo);
            }
        }
        if (resultList.size() > 0) {
            this.writeCheckResultRecord(ctx, resultList, params);
        }
        HashMap<String, ArrayList<CheckAccountResultVo>> ret = new HashMap<String, ArrayList<CheckAccountResultVo>>();
        ret.put("resultList", resultList);
        return ret;
    }

    private void writeCheckResultRecord(Context ctx, List<CheckAccountResultVo> resultList, Map params) throws Exception {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(this.getCheckResultInsertSQL());
            CheckAccountResultVo checkResultVo2 = null;
            CheckAccountDetailResultVo detailResultVo = null;
            int state = -1;
            ArrayList<Object[]> updateParamsList = new ArrayList<Object[]>();
            for (CheckAccountResultVo checkResultVo2 : resultList) {
                int size = checkResultVo2.getDetailList().size();
                for (int i = 0; i < size; ++i) {
                    detailResultVo = checkResultVo2.getDetailList().get(i);
                    state = this.isExists(ctx, new Object[]{checkResultVo2.getCheckInfo().getId().toString(), detailResultVo.getEntryInfo().getId().toString(), checkResultVo2.getReportInfo().getId().toString(), detailResultVo.getSheetName()});
                    if (3 == state) continue;
                    if (state > 0) {
                        Object[] updateParams = new Object[]{checkResultVo2.getReportInfo().getCompanyOrgUnit().getId().toString(), checkResultVo2.getReportInfo().getTaxType().getId().toString(), checkResultVo2.getReportInfo().getYear(), checkResultVo2.getReportInfo().getPeriod(), checkResultVo2.getCheckInfo().getAccount().getId().toString(), detailResultVo.getEntryInfo().getCheckFormula(), detailResultVo.isPass() ? 1 : 2, detailResultVo.isPass() ? null : detailResultVo.getEntryInfo().getRiskLevel().getValue(), detailResultVo.getEntryInfo().getPrompt(), checkResultVo2.getCheckInfo().getDescription(), timestamp, detailResultVo.getEntryInfo().getCheckFormulaAlias(), detailResultVo.getCheckAllDetial(), checkResultVo2.getCheckInfo().getId().toString(), detailResultVo.getEntryInfo().getId().toString(), checkResultVo2.getReportInfo().getId().toString(), detailResultVo.getSheetName()};
                        updateParamsList.add(updateParams);
                        continue;
                    }
                    pstmt.setString(1, BOSUuid.create((String)"1F638B05").toString());
                    pstmt.setString(2, checkResultVo2.getReportInfo().getCompanyOrgUnit().getId().toString());
                    pstmt.setString(3, checkResultVo2.getReportInfo().getTaxType().getId().toString());
                    pstmt.setInt(4, checkResultVo2.getReportInfo().getYear());
                    pstmt.setInt(5, checkResultVo2.getReportInfo().getPeriod());
                    pstmt.setString(6, checkResultVo2.getReportInfo().getId().toString());
                    pstmt.setString(7, checkResultVo2.getCheckInfo().getAccount().getId().toString());
                    pstmt.setString(8, detailResultVo.getSheetName());
                    pstmt.setString(9, checkResultVo2.getCheckInfo().getId().toString());
                    pstmt.setString(10, checkResultVo2.getCheckInfo().getCheckItemType().getId().toString());
                    pstmt.setString(11, detailResultVo.getEntryInfo().getId().toString());
                    pstmt.setString(12, detailResultVo.getEntryInfo().getCheckFormula());
                    if (detailResultVo.isPass()) {
                        pstmt.setInt(13, 1);
                        pstmt.setString(14, null);
                    } else {
                        pstmt.setInt(13, 2);
                        pstmt.setString(14, detailResultVo.getEntryInfo().getRiskLevel().getValue());
                    }
                    pstmt.setString(15, detailResultVo.getEntryInfo().getPrompt());
                    pstmt.setString(16, checkResultVo2.getCheckInfo().getDescription());
                    pstmt.setTimestamp(17, timestamp);
                    pstmt.setTimestamp(18, timestamp);
                    pstmt.setString(19, detailResultVo.getEntryInfo().getCheckFormulaAlias());
                    pstmt.setString(20, detailResultVo.getCheckAllDetial());
                    pstmt.addBatch();
                }
            }
            pstmt.executeBatch();
            if (updateParamsList.size() > 0) {
                StringBuffer sql = new StringBuffer();
                sql.append(" update T_TD_CheckAccountResult set ");
                sql.append(" FCompanyID=?,FTaxTypeID=?,FYear=? ,FMonth=? ,FAccountID=?,FCheckContent=?,");
                sql.append(" FState=?,FRiskLevel=?,FPrompt=?,FDescription=?,FLastUpdateTime=?,");
                sql.append(" FCheckFormulaAlias=?,FCheckDetail=?");
                sql.append(" WHERE FCheckAcctID=? and FCheckAcctEntryID=? and FReportID=? and FSheetName=?");
                DbUtil.executeBatch((Context)ctx, (String)sql.toString(), updateParamsList);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private int isExists(Context ctx, Object[] params) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT FState from T_TD_CheckAccountResult ");
        sb.append(" WHERE FCheckAcctID=? and FCheckAcctEntryID=? and FReportID=? and FSheetName=?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{params[0], params[1], params[2], params[3]});
        try {
            if (rs.next()) {
                return rs.getInt("FState");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return -1;
    }

    protected String getCheckResultInsertSQL() {
        StringBuffer sb = new StringBuffer();
        sb.append(" INSERT INTO T_TD_CheckAccountResult(");
        sb.append(" FID,FCompanyID,FTaxTypeID,FYear ,FMonth ,FReportID ,FAccountID ,FSheetName,FCheckAcctID,FCheckItemTypeID,FCheckAcctEntryID,FCheckContent,");
        sb.append(" FState,FRiskLevel,FPrompt,FDescription,FCreateTime,FLastUpdateTime,FCheckFormulaAlias,FCheckDetail)");
        sb.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        return sb.toString();
    }

    private Boolean verify(Context ctx, TaxDraftRecordInfo reportInfo, CheckAccountInfo checkInfo) throws BOSException {
        if (!this.verifyIfClause(ctx, reportInfo, checkInfo).booleanValue()) {
            return false;
        }
        if (!this.verifyAccontConfig(ctx, reportInfo, checkInfo).booleanValue()) {
            return false;
        }
        return true;
    }

    private Boolean verifyIfClause(Context ctx, TaxDraftRecordInfo reportInfo, CheckAccountInfo checkInfo) throws BOSException {
        if (!StringUtils.isEmpty((String)checkInfo.getIfClause())) {
            String ifClause = checkInfo.getIfClause();
            String filterItems = ifClause + " and id ='" + reportInfo.getId().toString() + "'";
            String reportQueryPK = "com.kingdee.eas.tm.td.app.TaxDraftReportQuery";
            String sql = TDCloudUtil.structureFilter(ctx, filterItems, reportQueryPK);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                if (rs.next()) {
                    return true;
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            return false;
        }
        return true;
    }

    private Boolean verifyAccontConfig(Context ctx, TaxDraftRecordInfo reportInfo, CheckAccountInfo checkInfo) throws BOSException {
        if (reportInfo.getRelateAccount() == null) {
            return false;
        }
        if (!reportInfo.getRelateAccount().getId().toString().equals(checkInfo.getAccount().getId().toString())) {
            return false;
        }
        return true;
    }

    private Map<String, List<CheckAccountInfo>> getCheckAccountViewMap(Context ctx, TaxDraftRecordCollection reportColl) throws BOSException {
        HashSet<String> companyIds = new HashSet<String>();
        TaxDraftRecordInfo reportInfo = null;
        Iterator it = reportColl.iterator();
        while (it.hasNext()) {
            reportInfo = (TaxDraftRecordInfo)it.next();
            companyIds.add(reportInfo.getCompanyOrgUnit().getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", companyIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("checkAcct.state", (Object)0, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        view.setSelector(TDSelectorFactory.getCheckAccountViewSelectors());
        CheckAccountViewCollection viewColl = CheckAccountViewFactory.getLocalInstance(ctx).getCheckAccountViewCollection(view);
        CheckAccountViewInfo viewInfo = null;
        HashMap<String, List<CheckAccountInfo>> companyCheckMap = new HashMap<String, List<CheckAccountInfo>>();
        String companyId = null;
        Iterator it2 = viewColl.iterator();
        while (it2.hasNext()) {
            viewInfo = (CheckAccountViewInfo)it2.next();
            companyId = viewInfo.getCompany().getId().toString();
            if (!companyCheckMap.containsKey(companyId)) {
                companyCheckMap.put(companyId, new ArrayList());
            }
            ((List)companyCheckMap.get(companyId)).add(viewInfo.getCheckAcct());
        }
        return companyCheckMap;
    }
}

