/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.datamodel.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.ListUiHelper;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.TaxDraftRecordFactory;
import com.kingdee.eas.tm.td.TaxDraftRecordInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckResultStateEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckTypeEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.client.AbstractCheckAccountResultListUI;
import com.kingdee.eas.tm.td.utils.TDSelectorFactory;
import com.kingdee.eas.tm.td.utils.TableUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class CheckAccountResultListUI
extends AbstractCheckAccountResultListUI {
    private static final Logger logger = CoreUIObject.getLogger(CheckAccountResultListUI.class);

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        super.onLoad();
        this.initBtnStatus();
    }

    protected void initBtnStatus() {
        this.menuBiz.setEnabled(true);
        this.menuBiz.setVisible(true);
        this.actionCancel.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.btnAddNew.setVisible(false);
        this.btnView.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnRemove.setVisible(false);
        this.menuItemAddNew.setVisible(false);
        this.menuItemView.setVisible(false);
        this.menuItemEdit.setVisible(false);
        this.menuItemRemove.setVisible(false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        super.afterTableFillData(e);
        int begin = e.getFirstRow();
        int end = e.getLastRow();
        IRow row = null;
        ICell cell = null;
        int n = end;
        for (int i = begin; i <= n; ++i) {
            BizEnumValueDTO state;
            row = this.tblMain.getRow(i);
            cell = row.getCell("state");
            if (row == null || (state = (BizEnumValueDTO)row.getCell("state").getValue()) == null) continue;
            this.fillCellColor(cell, Integer.parseInt(state.getValue().toString()));
        }
    }

    protected void fillCellColor(ICell cell, int state) {
        if (CheckResultStateEnum.PASS.getValue() == state) {
            cell.getStyleAttributes().setBackground(new Color(27, 152, 105));
        } else if (CheckResultStateEnum.FAIL.getValue() == state) {
            cell.getStyleAttributes().setBackground(new Color(238, 44, 44));
        } else if (CheckResultStateEnum.ANALYZED.getValue() == state) {
            cell.getStyleAttributes().setBackground(Color.yellow);
        } else if (CheckResultStateEnum.MANUAL_PASS.getValue() == state) {
            cell.getStyleAttributes().setBackground(Color.gray);
        } else if (CheckResultStateEnum.EXCEPTION.getValue() == state) {
            cell.getStyleAttributes().setBackground(new Color(255, 130, 71));
        }
    }

    @Override
    public void actionViewCheckAcct_actionPerformed(ActionEvent e) throws Exception {
        this.viewBill(e, "com.kingdee.eas.tm.td.cloud.datamodel.client.CheckAccountEditUI", "checkAcct.id");
    }

    @Override
    public void actionViewReport_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        String billId = ListUiHelper.getSelectedKeyValue((int[])selectRows, (KDTable)this.tblMain, (String)"report.id");
        this.viewReport(billId);
    }

    public void viewReport(String billId) throws Exception {
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        TaxDraftRecordInfo reportInfo = TaxDraftRecordFactory.getRemoteInstance().getTaxDraftRecordInfo((IObjectPK)pk, TDSelectorFactory.getTaxDraftRecordSelectors());
        UIContext uiContext = new UIContext(this.getUIContext().get("Owner"));
        uiContext.put((Object)"InitDataObject", (Object)reportInfo);
        final IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(this.getTaxDraftRptUI(reportInfo), (Map)uiContext, null, OprtState.VIEW);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                uiWindow.show();
            }
        });
    }

    protected String getTaxDraftRptUI(TaxDraftRecordInfo reportInfo) {
        String taxFlag = reportInfo.getTaxType().getSimName();
        String recordType = reportInfo.getRecordType().getName();
        return TDUtils.getTaxDraftRptUI(taxFlag, recordType);
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.openAuditView(e);
    }

    protected void viewBill(ActionEvent e, String uiPK, String keyName) throws Exception {
        this.checkSelected();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        String id = ListUiHelper.getSelectedKeyValue((int[])selectRows, (KDTable)this.tblMain, (String)keyName);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)id);
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = null;
        uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiPK, (Map)uiContext, null, OprtState.VIEW) : UIFactory.createUIFactory((String)this.getEditUIModal()).create(uiPK, (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected void openAuditView(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        if (ids == null || ids.size() == 0) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ids", (Object)ids);
        uiContext.put((Object)"checkType", (Object)this.getCheckType());
        String uiClass = "com.kingdee.eas.tm.td.cloud.datamodel.client.CheckResultAuditUI";
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClass, (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        this.refreshList();
    }

    protected CheckTypeEnum getCheckType() {
        return CheckTypeEnum.TAXACCOUNT;
    }

    protected String[] getNotOrderColumns() {
        return new String[]{"checkDetail"};
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        IObjectPK pk = null;
        if (this.isSupportedBatchActions() && (pk = TableUtil.getOrgPK(this.getDetailTable(), this.getMainBizOrgColumn())) != null) {
            return pk;
        }
        if (this.getMainOrgContext() != null && this.getMainOrgContext().get((Object)this.getMainBizOrgType()) != null) {
            pk = new ObjectUuidPK(((OrgUnitInfo)this.getMainOrgContext().get((Object)this.getMainBizOrgType())).getId().toString());
            return pk;
        }
        return super.getOrgPK(action);
    }

    protected KDTable getDetailTable() {
        return this.tblMain;
    }

    protected String getMainBizOrgColumn() {
        return "company.id";
    }

    public boolean isSupportedBatchActions() {
        return true;
    }
}

