/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.datamodel.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.rpt.client.FormulaPickerUI;
import com.kingdee.eas.fi.rpt.client.IFormulaPickerListener;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.tm.td.cloud.EnableStateEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckItemFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckItemInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckResultTypeEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckTypeEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.DiffTypeEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.OperateSymbolEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.RiskLevelEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.client.AbstractCheckItemEditUI;
import com.kingdee.eas.tm.td.cloud.datamodel.client.CheckItemFilterUI;
import com.kingdee.eas.tm.td.common.permsupport.IPermSupport4EditUI;
import com.kingdee.eas.tm.td.common.uihelper.EditUIHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class CheckItemEditUI
extends AbstractCheckItemEditUI
implements IFormulaPickerListener,
IPermSupport4EditUI {
    private static final Logger logger = CoreUIObject.getLogger(CheckItemEditUI.class);
    private static final String TDRESOURCE = "com.kingdee.eas.tm.td.cloud.TDCloudResource";
    private EditUIHelper uiHelper = new EditUIHelper((EditUI)this);
    private String currentCUID;
    private ItemListener operateSymbolListener = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.afterLoad();
        this.initBtnStatus();
        this.reInitBtnStatus();
    }

    private void reInitBtnStatus() {
        this.btnFilter.setEnabled(true);
        this.chkMenuItemSubmitAndAddNew.setSelected(false);
        this.btnCancel.setVisible(true);
        this.btnCancelCancel.setVisible(true);
        EnableStateEnum status = this.editData.getState();
        boolean isLight = false;
        if (EnableStateEnum.DISABLE.equals((Object)status)) {
            isLight = true;
        }
        this.actionRemove.setEnabled(isLight);
        this.actionCancel.setEnabled(!isLight);
        this.actionCancelCancel.setEnabled(isLight);
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.actionCancel.setEnabled(false);
            this.actionCancelCancel.setEnabled(false);
            this.actionEdit.setEnabled(false);
            this.actionSave.setEnabled(true);
            this.actionRemove.setEnabled(false);
            this.actionCopy.setEnabled(false);
        } else if (this.getOprtState().equals(OprtState.EDIT)) {
            this.actionEdit.setEnabled(false);
            this.actionSave.setEnabled(true);
            this.actionCopy.setEnabled(true);
        } else if (this.getOprtState().equals(OprtState.VIEW)) {
            this.actionEdit.setEnabled(isLight);
            this.actionSave.setEnabled(false);
        }
    }

    @Override
    protected void afterLoad() {
        super.afterLoad();
        this.txtRange.setPrecision(8);
        this.txtRange.setNegatived(false);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtItemType.setEntityViewInfo(view);
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        CheckItemInfo editData = (CheckItemInfo)newData;
        editData.setNumber(editData.getNumber() + "Copy");
        editData.setName(editData.getName() + "Copy");
    }

    @Override
    public void loadFields() {
        this.removeEventLisener();
        super.loadFields();
        this.currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        this.txtRange.setValue((Object)this.editData.getRange());
        if (this.editData.getCheckResult() != null) {
            int selected = this.editData.getCheckResult().getValue();
            switch (selected) {
                case 1: {
                    this.btnForbidSub.setSelected(true);
                    break;
                }
                case 2: {
                    this.btnShowError.setSelected(true);
                }
            }
        } else {
            this.btnForbidSub.setSelected(true);
            this.editData.setCheckResult(CheckResultTypeEnum.UNCONFIRM);
        }
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        this.reInitBtnStatus();
        this.initComponents();
        this.addEventLisener();
    }

    private void addEventLisener() {
        if (this.operateSymbolListener == null) {
            this.operateSymbolListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    CheckItemEditUI.this.operateSymbol_dataChanged(e);
                }
            };
        }
        this.comboOperateSymbol.addItemListener(this.operateSymbolListener);
    }

    private void removeEventLisener() {
        if (this.operateSymbolListener != null) {
            this.comboOperateSymbol.removeItemListener(this.operateSymbolListener);
        }
    }

    protected void operateSymbol_dataChanged(ItemEvent e) {
        if (e.getStateChange() == 2) {
            if (!OperateSymbolEnum.EQUAL.equals(this.comboOperateSymbol.getSelectedItem()) && !OperateSymbolEnum.UNEQUAL.equals(this.comboOperateSymbol.getSelectedItem())) {
                this.txtRange.setValue((Object)BigDecimal.ZERO);
            }
            this.initComponents();
        }
    }

    protected void initComponents() {
        this.txtRange.setEnabled(OperateSymbolEnum.EQUAL.equals(this.comboOperateSymbol.getSelectedItem()) || OperateSymbolEnum.UNEQUAL.equals(this.comboOperateSymbol.getSelectedItem()));
    }

    protected IObjectValue createNewData() {
        CheckItemInfo checkItemInfo = new CheckItemInfo();
        checkItemInfo.setOperateSymbol(OperateSymbolEnum.EQUAL);
        checkItemInfo.setRangeType(DiffTypeEnum.STANDARDVALUE);
        checkItemInfo.setRange(BigDecimal.ZERO);
        checkItemInfo.setRiskLevel(RiskLevelEnum.Level3);
        checkItemInfo.setCheckResult(CheckResultTypeEnum.UNCONFIRM);
        return checkItemInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CheckItemFactory.getRemoteInstance();
    }

    private void checkRequiredFields() {
        StringBuffer sb = new StringBuffer();
        if (this.txtNumber.getText().isEmpty()) {
            sb.append(EASResource.getString((String)TDRESOURCE, (String)"NUMBER"));
        }
        if (this.txtName.getText().isEmpty()) {
            sb.append(EASResource.getString((String)TDRESOURCE, (String)"NAME"));
        }
        if (this.prmtTaxType.getValue() == null) {
            sb.append(EASResource.getString((String)TDRESOURCE, (String)"TAXTYPE"));
        }
        if (this.txtLFormula.getText().isEmpty()) {
            sb.append(EASResource.getString((String)TDRESOURCE, (String)"LFORMULA"));
        }
        if (this.txtRFormula.getText().isEmpty()) {
            sb.append(EASResource.getString((String)TDRESOURCE, (String)"RFORMULA"));
        }
        if (this.prmtItemType.getValue() == null) {
            sb.append("\u3001\u4e8b\u9879\u7c7b\u578b");
        }
        if (sb.length() > 0) {
            sb.append(EASResource.getString((String)TDRESOURCE, (String)"NOTNULL"));
            MsgBox.showWarning((String)sb.substring(1));
            SysUtil.abort();
        }
        try {
            if (this.txtDescription.getText().getBytes("utf8").length > 1024) {
                sb.append(EASResource.getString((String)TDRESOURCE, (String)"DESCRIPTION"));
            }
            if (this.txtPrompt.getText().getBytes("utf8").length > 500) {
                sb.append(EASResource.getString((String)TDRESOURCE, (String)"PROMPT"));
            }
            if (this.txtLFormula.getText().getBytes("utf8").length > 255) {
                sb.append(EASResource.getString((String)TDRESOURCE, (String)"LFORMULA"));
            }
            if (this.txtRFormula.getText().getBytes("utf8").length > 255) {
                sb.append(EASResource.getString((String)TDRESOURCE, (String)"RFORMULA"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (sb.length() > 0) {
            sb.append(EASResource.getString((String)TDRESOURCE, (String)"OVER_LENGTH"));
            MsgBox.showWarning((String)sb.substring(1));
            SysUtil.abort();
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.checkRequiredFields();
        if (this.btnForbidSub.isSelected()) {
            this.editData.setCheckResult(CheckResultTypeEnum.UNCONFIRM);
        }
        if (this.btnShowError.isSelected()) {
            this.editData.setCheckResult(CheckResultTypeEnum.SHOWERROR);
        }
        this.editData.setNumber(this.txtNumber.getText());
        boolean checkNumber = CheckItemFactory.getRemoteInstance().checkNumberDup(null, this.editData);
        if (!checkNumber) {
            MsgBox.showInfo((String)EASResource.getString((String)TDRESOURCE, (String)"Number_Not_Repeat", (Object[])new String[]{this.editData.getNumber()}));
            SysUtil.abort();
        }
        super.actionSave_actionPerformed(e);
        if (!this.getOprtState().equals(OprtState.ADDNEW)) {
            if (this.editData.getState() != null && EnableStateEnum.ENABLE.equals((Object)this.editData.getState())) {
                this.setOprtState("VIEW");
            } else {
                this.setOprtState("EDIT");
            }
        }
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
    }

    @Override
    public void actionLFormula_actionPerformed(ActionEvent e) throws Exception {
        this.openFormula(true, false);
    }

    @Override
    public void actionRFormula_actionPerformed(ActionEvent e) throws Exception {
        this.openFormula(false, false);
    }

    @Override
    public void actionSetFilter_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() != null) {
            String billId = this.editData.getId().toString();
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(billId);
            this.uiHelper.checkBaseDataPermission(this.currentCUID, ids);
        }
        UIContext uiContext = new UIContext();
        FilterInfo filterInfo = new FilterInfo();
        if (this.editData != null && this.editData.getIfClause() != null) {
            filterInfo = new FilterInfo(this.editData.getIfClause());
        }
        uiContext.put("filterInfo", filterInfo);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.tm.td.cloud.datamodel.client.CheckItemFilterUI", (Map)uiContext);
        CheckItemFilterUI filterPanel = (CheckItemFilterUI)uiWindow.getUIObject();
        uiWindow.show();
        if (!filterPanel.isCancel()) {
            this.editData.setIfClause(filterPanel.getFilterInfo().toString());
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("ifClause"));
        sic.add(new SelectorItemInfo("checkResult"));
        return sic;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return null;
    }

    protected KDTable getDetailTable() {
        return null;
    }

    public void pickerReturnee(FormulaPickerUI picker, String formulaLine, boolean isOk) {
        if (isOk && this.isLeft) {
            this.txtLFormula.setText(this.txtLFormula.getText() + formulaLine);
        } else if (isOk && !this.isLeft) {
            this.txtRFormula.setText(this.txtRFormula.getText() + formulaLine);
        }
    }

    @Override
    protected CheckTypeEnum getCheckType() {
        return CheckTypeEnum.TAXDECLARE;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.editData.setNumber(this.txtNumber.getText());
        boolean checkNumber = CheckItemFactory.getRemoteInstance().checkNumberDup(null, this.editData);
        if (!checkNumber) {
            MsgBox.showInfo((String)EASResource.getString((String)TDRESOURCE, (String)"Number_Not_Repeat", (Object[])new String[]{this.editData.getNumber()}));
            SysUtil.abort();
        }
        super.actionSubmit_actionPerformed(e);
        this.setOprtState("EDIT");
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanEdit(this.currentCUID, this.editData.getId().toString());
        super.actionEdit_actionPerformed(e);
        this.loadFields();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanAddnew(this.currentCUID);
        super.actionAddNew_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.editData.getId().toString());
        this.uiHelper.checkCanRemove(this.currentCUID, ids);
        super.actionRemove_actionPerformed(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        String billId = this.editData.getId().toString();
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(billId);
        this.uiHelper.checkBaseDataPermission(this.currentCUID, ids);
        if (!this.uiHelper.modifySaveOrExit((ItemAction)this.actionSubmit, this.btnSubmit, (ItemAction)this.actionSave, this.btnSave, this.isModifySave())) {
            return;
        }
        super.actionCancelCancel_actionPerformed(e);
        if (this.editData.getState() != null && EnableStateEnum.ENABLE.equals((Object)this.editData.getState())) {
            this.setOprtState("VIEW");
        } else {
            this.setOprtState("EDIT");
        }
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        String billId = this.editData.getId().toString();
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(billId);
        this.uiHelper.checkBaseDataPermission(this.currentCUID, ids);
        super.actionCancel_actionPerformed(e);
        this.reInitBtnStatus();
    }

    @Override
    public String getBizOrgProperty(OrgType orgType) throws BOSException, EASBizException {
        return "CU";
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        IObjectPK pk = null;
        try {
            pk = this.uiHelper.getOrgPK();
        }
        catch (Exception e) {
            logger.error((Object)e);
            this.handUIException(e);
        }
        if (pk != null) {
            return pk;
        }
        if (this.getMainOrgContext() != null && this.getMainOrgContext().get((Object)this.getMainBizOrgType()) != null) {
            pk = new ObjectUuidPK(((OrgUnitInfo)this.getMainOrgContext().get((Object)this.getMainBizOrgType())).getId().toString());
            return pk;
        }
        return super.getOrgPK(action);
    }

    @Override
    public String getPermItem(String status) {
        return null;
    }

    @Override
    public KDBizPromptBox getPermMainBizOrg() {
        return null;
    }

    @Override
    public IObjectValue getValueObject() {
        return this.editData;
    }

    @Override
    public ICoreBase getPermInterface() throws Exception {
        return this.getBizInterface();
    }
}

