/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.datamodel.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.tm.td.TDFacadeFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckItemFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckItemInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckTypeEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.client.AbstractCheckItemListUI;
import com.kingdee.eas.tm.td.cloud.datamodel.client.CheckItemEditUI;
import com.kingdee.eas.tm.td.common.permsupport.IPermSupport4ListUI;
import com.kingdee.eas.tm.td.common.uihelper.ListUIHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class CheckItemListUI
extends AbstractCheckItemListUI
implements IPermSupport4ListUI {
    private static final Logger logger = CoreUIObject.getLogger(CheckItemListUI.class);
    private ListUIHelper uiHelper = new ListUIHelper((ListUI)this);
    private String currentCUID;

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.afterLoad();
        this.initBtnStatus();
        this.currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        try {
            while (rowSet.next()) {
                if (rowSet.getString("range") != null) continue;
                rowSet.updateString("range", "0");
                rowSet.getString("range");
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnCancel.setVisible(true);
        this.btnCancelCancel.setVisible(true);
        this.btnCancel.setEnabled(true);
        this.btnCancelCancel.setEnabled(true);
    }

    protected String getEditUIName() {
        return CheckItemEditUI.class.getName();
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.uiHelper.checkBaseDataPermission(this.currentCUID, this.getSelectedIdValues());
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_CancelCancel");
        if (this.confirmDialog(cancelMsg)) {
            if (UtilRequest.isPrepare((String)"ActionCancelCancel", (CoreUIObject)this)) {
                this.prepareCancelCancel(null).callHandler();
            }
            this.cancelCancel();
            this.refresh(e);
        }
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkBaseDataPermission(this.currentCUID, this.getSelectedIdValues());
        super.actionCancel_actionPerformed(e);
        this.refresh(e);
    }

    @Override
    public void actionAssign_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkBaseDataPermission(this.currentCUID, this.getSelectedIdValues());
        super.actionAssign_actionPerformed(e);
        this.refresh(e);
    }

    @Override
    public void actionViewCompany_actionPerformed(ActionEvent e) throws Exception {
        TDFacadeFactory.getRemoteInstance().checkFunctionPermission(this.currentCUID, "td_checkitem_viewcompany");
        super.actionViewCompany_actionPerformed(e);
        this.refresh(e);
    }

    @Override
    public void actionViewItem_actionPerformed(ActionEvent e) throws Exception {
        TDFacadeFactory.getRemoteInstance().checkFunctionPermission(this.currentCUID, "td_checkitem_viewitem");
        super.actionViewItem_actionPerformed(e);
        this.refresh(e);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CheckItemFactory.getRemoteInstance();
    }

    @Override
    protected CheckTypeEnum getCheckType() {
        return CheckTypeEnum.TAXDECLARE;
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.uiHelper.checkCanEdit(this.currentCUID, this.getSelectedKeyValue());
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.uiHelper.checkCanRemove(this.currentCUID, this.getSelectedIdValues());
        super.actionRemove_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanAddnew(this.currentCUID);
        super.actionAddNew_actionPerformed(e);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return this.uiHelper.getHasPermissionOrgFilterForQuery();
    }

    @Override
    public String getBizOrgProperty(OrgType orgType) throws BOSException, EASBizException {
        return "CU";
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        ObjectUuidPK pk = null;
        if (this.isSupportedBatchActions() && !this.uiHelper.isAddNew(action)) {
            CheckItemInfo info = null;
            try {
                if (!StringUtils.isEmpty((String)this.getSelectedKeyValue()) && (info = CheckItemFactory.getRemoteInstance().getCheckItemInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()))) != null && info.getCU() != null) {
                    pk = new ObjectUuidPK(info.getCU().getId().toString());
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            if (pk != null) {
                return pk;
            }
        }
        if (this.getMainOrgContext() != null && this.getMainOrgContext().get((Object)this.getMainBizOrgType()) != null) {
            pk = new ObjectUuidPK(((OrgUnitInfo)this.getMainOrgContext().get((Object)this.getMainBizOrgType())).getId().toString());
            return pk;
        }
        return super.getOrgPK(action);
    }

    public boolean isSupportedBatchActions() {
        return true;
    }

    @Override
    public ICoreBase getPermInterface() throws Exception {
        return this.getBizInterface();
    }

    @Override
    public void initPermActions() throws BOSException, EASBizException {
    }

    @Override
    public void initPermMainOrgContext(String orgID) throws Exception {
    }
}

