/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.datamodel.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.tm.td.basedata.DSTypeEnum;
import com.kingdee.eas.tm.td.basedata.client.DataSourceListUI;
import com.kingdee.eas.tm.td.cloud.datamodel.DataFetchFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.FetchTypeEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.client.AbstractDataFetchListUI;
import com.kingdee.eas.tm.td.common.permsupport.IPermSupport;
import com.kingdee.eas.tm.td.common.uihelper.ListUIHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class DataFetchListUI
extends AbstractDataFetchListUI
implements IPermSupport {
    private static final Logger logger = CoreUIObject.getLogger(DataFetchListUI.class);
    private static final String COL_STATE = "state";
    private ListUIHelper uiHelper = new ListUIHelper(this);
    protected String currentCUID;

    protected ICoreBase getBizInterface() throws Exception {
        return DataFetchFactory.getRemoteInstance();
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    public String getKeyFieldName() {
        return "id";
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnCancel.setEnabled(true);
        this.btnCancelCancel.setEnabled(true);
        this.btnCancel.setVisible(true);
        this.btnCancelCancel.setVisible(true);
    }

    protected void checkStateEnableEdit() throws Exception {
        this.checkSelected();
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.getDetailTable());
        BizEnumValueDTO state = (BizEnumValueDTO)row.getCell(COL_STATE).getValue();
        if (state.getInt() == 1) {
            MsgBox.showInfo((String)"\u542f\u7528\u72b6\u6001\u4e0d\u80fd\u7f16\u8f91");
            SysUtil.abort();
        }
    }

    protected void checkStateEnableRemove() throws Exception {
        this.checkSelected();
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.getDetailTable());
        BizEnumValueDTO state = (BizEnumValueDTO)row.getCell(COL_STATE).getValue();
        if (state.getInt() == 1) {
            MsgBox.showInfo((String)"\u542f\u7528\u72b6\u6001\u4e0d\u80fd\u5220\u9664");
            SysUtil.abort();
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.uiHelper.checkCanEdit(this.currentCUID, this.getSelectedKeyValue());
        this.checkStateEnableEdit();
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.uiHelper.checkCanRemove(this.currentCUID, this.getSelectedIdValues());
        this.checkStateEnableRemove();
        super.actionRemove_actionPerformed(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        this.uiHelper.checkBaseDataPermission(this.currentCUID, ids);
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_CancelCancel");
        if (this.confirmDialog(cancelMsg)) {
            if (UtilRequest.isPrepare((String)"ActionCancelCancel", (CoreUIObject)this)) {
                this.prepareCancelCancel(null).callHandler();
            }
            this.cancelCancel();
            this.refresh(e);
        }
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        this.uiHelper.checkBaseDataPermission(this.currentCUID, ids);
        super.actionCancel_actionPerformed(e);
        this.refresh(e);
    }

    @Override
    public void actionDataSourceSet_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String dataFetchId = this.getSelectedKeyValue();
        this.uiHelper.checkCanEdit(this.currentCUID, dataFetchId);
        UIContext uiContext = new UIContext();
        uiContext.put("dataFetchId", dataFetchId);
        uiContext.put("dsType", DSTypeEnum.DataFetch);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DataSourceListUI.class.getName(), (Map)uiContext);
        uiWindow.show();
    }

    @Override
    public void actionDataConditionSet_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String dataFetchId = this.getSelectedKeyValue();
        this.uiHelper.checkCanEdit(this.currentCUID, dataFetchId);
        Set dataSourceIds = DataFetchFactory.getRemoteInstance().getDataSourceByID(dataFetchId);
        if (dataSourceIds.size() == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.TDResource", (String)"NEED_ADD_DATASOURCE"));
            return;
        }
        UIContext uiContext = new UIContext();
        uiContext.put("dsType", DSTypeEnum.DataFetch);
        uiContext.put("orgUnitId", SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        uiContext.put("dataFetchId", dataFetchId);
        uiContext.put("dataSourceSet", dataSourceIds);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.tm.td.basedata.client.TakeDataContditionListUI", (Map)uiContext);
        uiWindow.show();
    }

    protected KDTable getDetailTable() {
        return this.tblMain;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfo = super.getDefaultFilterForQuery();
        filterInfo.getFilterItems().add(new FilterItemInfo("fetchType", (Object)this.getFetchType().getValue(), CompareType.EQUALS));
        return filterInfo;
    }

    protected abstract FetchTypeEnum getFetchType();
}

