/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.datamodel.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.ssc.CheckResultFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckTypeEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.client.AbstractItemCheckResultListUI;
import com.kingdee.eas.tm.td.utils.TableUtil;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.util.Set;
import org.apache.log4j.Logger;

public class ItemCheckResultListUI
extends AbstractItemCheckResultListUI {
    private static final Logger logger = CoreUIObject.getLogger(ItemCheckResultListUI.class);

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfo = super.getDefaultFilterForQuery();
        if (this.getUIContext().containsKey("isFromTaxDraft")) {
            Set checkIds = (Set)this.getUIContext().get("checkIds");
            Set checkItemIds = (Set)this.getUIContext().get("checkItemIds");
            if (checkIds != null && checkIds.size() > 0) {
                filterInfo.getFilterItems().add(new FilterItemInfo("report.id", (Object)checkIds, CompareType.INCLUDE));
            }
            if (checkItemIds != null && checkItemIds.size() > 0) {
                filterInfo.getFilterItems().add(new FilterItemInfo("item.id", (Object)checkItemIds, CompareType.INCLUDE));
            }
            this.getUIContext().remove("isFromTaxDraft");
        } else if (this.getUIContext().containsKey("isFromTaxDraftWF")) {
            String reportNumber = (String)this.getUIContext().get("reportNumber");
            if (!StringUtils.isEmpty((String)reportNumber)) {
                filterInfo.getFilterItems().add(new FilterItemInfo("report.number", (Object)reportNumber, CompareType.EQUALS));
            }
            this.getUIContext().remove("isFromTaxDraftWF");
        }
        return filterInfo;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initBtnStatus();
    }

    @Override
    protected void initBtnStatus() {
        super.initBtnStatus();
        this.btnViewIndex.setVisible(false);
        this.btnIndexCalculate.setVisible(false);
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CheckResultFactory.getRemoteInstance();
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        super.afterTableFillData(e);
        int begin = e.getFirstRow();
        int end = e.getLastRow();
        IRow row = null;
        ICell cell = null;
        int n = end;
        for (int i = begin; i <= n; ++i) {
            BizEnumValueDTO state;
            row = this.tblMain.getRow(i);
            cell = row.getCell("state");
            if (row == null || (state = (BizEnumValueDTO)row.getCell("state").getValue()) == null) continue;
            this.fillCellColor(cell, Integer.parseInt(state.getValue().toString()));
        }
    }

    @Override
    public boolean isAutoIgnoreZero() {
        return false;
    }

    @Override
    public void actionViewItem_actionPerformed(ActionEvent e) throws Exception {
        this.viewBill(e, "com.kingdee.eas.tm.td.cloud.datamodel.client.CheckItemEditUI", "item.id");
    }

    @Override
    public void actionViewReport_actionPerformed(ActionEvent e) throws Exception {
        this.viewBill(e, "com.kingdee.eas.tm.td.client.TaxDraftWFEditUI", "report.id");
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.openAuditView(e);
    }

    @Override
    protected CheckTypeEnum getCheckType() {
        return CheckTypeEnum.TAXDECLARE;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        IObjectPK pk = null;
        if (this.isSupportedBatchActions() && (pk = TableUtil.getOrgPK(this.getDetailTable(), this.getMainBizOrgColumn())) != null) {
            return pk;
        }
        if (this.getMainOrgContext() != null && this.getMainOrgContext().get((Object)this.getMainBizOrgType()) != null) {
            pk = new ObjectUuidPK(((OrgUnitInfo)this.getMainOrgContext().get((Object)this.getMainBizOrgType())).getId().toString());
            return pk;
        }
        return super.getOrgPK(action);
    }

    protected KDTable getDetailTable() {
        return this.tblMain;
    }

    protected String getMainBizOrgColumn() {
        return "company.id";
    }

    public boolean isSupportedBatchActions() {
        return true;
    }
}

