/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.datamodel.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.tm.td.cloud.datamodel.ItemCollection;
import com.kingdee.eas.tm.td.cloud.datamodel.ItemFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.ItemInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.ItemMappingCollection;
import com.kingdee.eas.tm.td.cloud.datamodel.ItemMappingInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.ItemTypeInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.client.AbstractItemFormulaFillEditUI;
import com.kingdee.eas.tm.td.cloud.datamodel.client.RowIdxComparer;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ItemFormulaFillEditUI
extends AbstractItemFormulaFillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(ItemFormulaFillEditUI.class);
    private ArrayList rptArr = null;
    private ArrayList rptArrSelected = null;
    private Sheet rptTable = null;
    private int rowsize = 0;

    public void setRptArr(ArrayList arr) {
        this.rptArr = arr;
    }

    public ArrayList getRptArr() {
        if (this.rptArr == null) {
            this.rptArr = new ArrayList();
        }
        return this.rptArr;
    }

    public void setRptArrSelected(ArrayList arr) {
        this.rptArrSelected = arr;
    }

    public ArrayList getRptArrSelected() {
        if (this.rptArrSelected == null) {
            this.rptArrSelected = new ArrayList();
        }
        return this.rptArrSelected;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initParam();
        this.loadItem();
        this.initItemTypeF7();
        this.loadOther();
    }

    private void initParam() {
        this.rptTable = (Sheet)this.getUIContext().get("rptTable");
        if (this.rptTable == null) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u62a5\u8868\u4e0d\u80fd\u4e3a\u7a7a");
            SysUtil.abort();
        }
    }

    private void loadOther() throws BOSException {
        int top = this.rptTable.getActiveRow();
        int left = this.rptTable.getActiveCol();
        top = top < 0 ? 0 : top;
        left = left < 0 ? 0 : left;
        this.txtPosition.setText(TableToolkit.xy2range((int)left, (int)top));
    }

    private void initItemTypeF7() throws Exception {
        this.prmtItemType.setEditFormat("$name$");
        this.prmtItemType.setDisplayFormat("$name$");
        this.prmtItemType.setCommitFormat("$name$");
        this.prmtItemType.setQueryInfo("com.kingdee.eas.tm.td.cloud.app.ItemTypeQuery");
        this.prmtItemType.setEditable(false);
        this.prmtItemType.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                try {
                    ItemFormulaFillEditUI.this.loadItem();
                }
                catch (BOSException e) {
                    logger.error((Object)"load rptitem error", (Throwable)e);
                }
            }
        });
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAdd.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnReduce.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        this.btnAddAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btnReduceAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.btnMoveUp.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnMoveDown.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btnMoveTop.setIcon(EASResource.getIcon((String)"imgTbtn_movetop1"));
        this.btnMoveBottom.setIcon(EASResource.getIcon((String)"imgTbtn_movebottom"));
    }

    private void loadItem() throws BOSException {
        this.getRptArr().clear();
        ItemCollection rptItemCL = this.getItemCollection();
        ItemCollection rptItemCL2 = (ItemCollection)((Object)rptItemCL.clone());
        int iCount = this.getRptArrSelected().size();
        if (iCount > 0) {
            for (int i = 0; i < iCount; ++i) {
                ItemInfo itemInfo = (ItemInfo)this.getRptArrSelected().get(i);
                if (!rptItemCL.containsObject((IObjectValue)itemInfo)) continue;
                rptItemCL.remove(itemInfo);
            }
        }
        ItemFormulaFillEditUI.addCollectionToArrayList(this.getRptArr(), (IObjectCollection)rptItemCL2);
        Collections.sort(this.getRptArr());
        this.addArrayListToTable(this.getRptArr(), this.itemGrid);
    }

    public static ArrayList addCollectionToArrayList(ArrayList arr, IObjectCollection collection) {
        if (collection == null || collection.size() == 0) {
            return null;
        }
        int i = arr.size();
        Object obj2 = null;
        for (Object obj2 : collection) {
            if (obj2 != null) {
                arr.add(i, obj2);
            }
            ++i;
        }
        return arr;
    }

    private void addArrayListToTable(ArrayList rptArr, KDTable table) {
        table.checkParsed();
        table.removeRows();
        table.getStyleAttributes().setLocked(true);
        int count = rptArr.size();
        ItemInfo rpt = null;
        IRow r = null;
        for (int i = 0; i < count; ++i) {
            rpt = (ItemInfo)rptArr.get(i);
            r = table.addRow();
            r.getCell(0).setValue((Object)rpt.getNumber());
            r.getCell(1).setValue((Object)rpt.getName());
            r.getCell(2).setValue((Object)rpt.getId());
            r.getCell(3).setValue((Object)rpt);
        }
    }

    private ItemCollection getItemCollection() throws BOSException {
        ItemTypeInfo itemTypeInfo = (ItemTypeInfo)this.prmtItemType.getValue();
        EntityViewInfo view = new EntityViewInfo();
        if (itemTypeInfo != null) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("itemType.id", (Object)itemTypeInfo.getId().toString(), CompareType.EQUALS));
            view.setFilter(filter);
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("sumItems.*"));
        sic.add(new SelectorItemInfo("sumItems.sourceItem.number"));
        sic.add(new SelectorItemInfo("sumItems.sourceItem.formula"));
        view.setSelector(sic);
        return ItemFactory.getRemoteInstance().getItemCollection(view);
    }

    private ItemCollection getSelectedCollectionFromTable(KDTable table) {
        ItemCollection rptItemcol = null;
        int size = table.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock sb = table.getSelectManager().get(i);
            int n = sb.getBottom();
            for (int j = sb.getTop(); j <= n; ++j) {
                if (rptItemcol == null) {
                    rptItemcol = new ItemCollection();
                }
                ItemInfo rptInfo = (ItemInfo)table.getRow(j).getCell(3).getValue();
                if (table.getName().equals(this.itemSelectedGrid.getName()) && this.prmtItemType.getValue() != null && rptInfo.getItemType() != null && !rptInfo.getItemType().getId().toString().equals(((ItemTypeInfo)this.prmtItemType.getValue()).getId().toString())) {
                    this.getRptArrtemp(table).remove(rptInfo);
                    continue;
                }
                rptItemcol.add(rptInfo);
                this.getRptArrtemp(table).remove(rptInfo);
            }
        }
        return rptItemcol;
    }

    private ItemCollection getCollectionFromTable(KDTable table) {
        ItemCollection rptItemcol = null;
        int size = table.getRowCount();
        for (int i = 0; i < size; ++i) {
            if (rptItemcol == null) {
                rptItemcol = new ItemCollection();
            }
            ItemInfo rptInfo = (ItemInfo)table.getRow(i).getCell(3).getValue();
            if (table.getName().equals(this.itemSelectedGrid.getName()) && this.prmtItemType.getValue() != null && rptInfo.getItemType() != null && !rptInfo.getItemType().getId().toString().equals(((ItemTypeInfo)this.prmtItemType.getValue()).getId().toString())) {
                this.getRptArrtemp(table).remove(rptInfo);
                continue;
            }
            rptItemcol.add(rptInfo);
            this.getRptArrtemp(table).remove(rptInfo);
        }
        return rptItemcol;
    }

    private ArrayList getRptArrtemp(KDTable table) {
        ArrayList rptArr = null;
        if (table.equals(this.itemGrid)) {
            rptArr = this.getRptArr();
        } else if (table.equals(this.itemSelectedGrid)) {
            rptArr = this.getRptArrSelected();
        }
        return rptArr;
    }

    @Override
    public void actionAdd_actionPerformed(ActionEvent e) throws Exception {
        super.actionAdd_actionPerformed(e);
        ItemCollection rptItemcol = this.getSelectedCollectionFromTable(this.itemGrid);
        ItemFormulaFillEditUI.addCollectionToArrayList(this.getRptArrSelected(), (IObjectCollection)rptItemcol);
        this.addArrayListToTable(this.getRptArrSelected(), this.itemSelectedGrid);
        Collections.sort(this.getRptArr());
        this.addArrayListToTable(this.getRptArr(), this.itemGrid);
    }

    @Override
    public void actionReduce_actionPerformed(ActionEvent e) throws Exception {
        super.actionReduce_actionPerformed(e);
        ItemCollection rptItemcol = this.getSelectedCollectionFromTable(this.itemSelectedGrid);
        ItemFormulaFillEditUI.addCollectionToArrayList(this.getRptArr(), (IObjectCollection)rptItemcol);
        this.addArrayListToTable(this.getRptArrSelected(), this.itemSelectedGrid);
        Collections.sort(this.getRptArr());
        this.addArrayListToTable(this.getRptArr(), this.itemGrid);
    }

    @Override
    public void actionMoveUp_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveUp_actionPerformed(e);
        this.moveUp();
        ItemCollection rptItemcol = this.getCollectionFromTable(this.itemSelectedGrid);
        ItemFormulaFillEditUI.addCollectionToArrayList(this.getRptArrSelected(), (IObjectCollection)rptItemcol);
    }

    @Override
    public void actionMoveDown_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveDown_actionPerformed(e);
        this.moveDown(null);
        ItemCollection rptItemcol = this.getCollectionFromTable(this.itemSelectedGrid);
        ItemFormulaFillEditUI.addCollectionToArrayList(this.getRptArrSelected(), (IObjectCollection)rptItemcol);
    }

    @Override
    public void actionAddAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddAll_actionPerformed(e);
        ItemFormulaFillEditUI.addArrayListToArrayList(this.getRptArrSelected(), this.getRptArr());
        this.getRptArr().clear();
        Collections.sort(this.getRptArrSelected());
        this.addArrayListToTable(this.getRptArrSelected(), this.itemSelectedGrid);
        this.addArrayListToTable(this.getRptArr(), this.itemGrid);
    }

    @Override
    public void actionReduceAll_actionPerformed(ActionEvent e) throws Exception {
        int iCount;
        super.actionReduceAll_actionPerformed(e);
        if (this.prmtItemType.getValue() != null && (iCount = this.getRptArrSelected().size()) > 0) {
            for (int i = 0; i < this.getRptArrSelected().size(); ++i) {
                ItemInfo rptItemInfo = (ItemInfo)this.getRptArrSelected().get(i);
                if (rptItemInfo.getItemType() == null || rptItemInfo.getItemType().getId().toString().equals(((ItemTypeInfo)this.prmtItemType.getValue()).getId().toString().toString())) continue;
                this.getRptArrSelected().remove(rptItemInfo);
            }
        }
        ItemFormulaFillEditUI.addArrayListToArrayList(this.getRptArr(), this.getRptArrSelected());
        this.getRptArrSelected().clear();
        this.addArrayListToTable(this.getRptArrSelected(), this.itemSelectedGrid);
        Collections.sort(this.getRptArr());
        this.addArrayListToTable(this.getRptArr(), this.itemGrid);
    }

    public static ArrayList addArrayListToArrayList(ArrayList arrTo, ArrayList arrFrom) {
        if (arrFrom == null || arrFrom.size() == 0) {
            return null;
        }
        Object obj = null;
        int i = arrTo.size();
        int n = arrFrom.size();
        for (int j = 0; j < n; ++j) {
            obj = arrFrom.get(j);
            if (obj != null) {
                arrTo.add(i, obj);
            }
            ++i;
        }
        return arrTo;
    }

    @Override
    public void actionMoveTop_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveTop_actionPerformed(e);
        while (this.moveUp()) {
        }
        ItemCollection rptItemcol = this.getCollectionFromTable(this.itemSelectedGrid);
        ItemFormulaFillEditUI.addCollectionToArrayList(this.getRptArrSelected(), (IObjectCollection)rptItemcol);
    }

    @Override
    public void actionMoveBottom_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveBottom_actionPerformed(e);
        while (this.moveDown("bottom")) {
        }
        this.rowsize = 0;
        ItemCollection rptItemcol = this.getCollectionFromTable(this.itemSelectedGrid);
        ItemFormulaFillEditUI.addCollectionToArrayList(this.getRptArrSelected(), (IObjectCollection)rptItemcol);
    }

    private Point getStartPos() {
        String str = this.txtPosition.getText();
        Range range = this.rptTable.getRange(str, true);
        if (range == null || range.getBlock(0).getCol() < 0 || range.getBlock(0).getRow() < 0) {
            MsgBox.showError((String)"\u586b\u5145\u4f4d\u7f6e\u8bbe\u7f6e\u6709\u8bef\uff0c\u8bf7\u4fee\u6539\uff01");
            SysUtil.abort();
        }
        Point p = new Point(range.getBlock(0).getCol(), range.getBlock(0).getRow());
        return p;
    }

    @Override
    public void actionOk_actionPerformed(ActionEvent e) throws Exception {
        Point startP = this.getStartPos();
        int left = startP.x;
        int top = startP.y;
        int colCount = this.rptTable.getMaxColIndex();
        int rowCount = this.rptTable.getMaxRowIndex();
        ItemInfo itemInfo = null;
        int size = this.getRptArrSelected().size();
        for (int i = 0; i < size; ++i) {
            itemInfo = (ItemInfo)this.getRptArrSelected().get(i);
            this.rptTable.getRange(top, left).setValue(new Variant((Object)itemInfo.getNumber()));
            if (!itemInfo.isIsSumItem()) {
                this.rptTable.getRange(top, left + 1).setFormula("=" + itemInfo.getFormula());
            } else {
                ItemMappingCollection sumItems = itemInfo.getSumItems();
                HashMap<String, ItemInfo> sumItemsMap = new HashMap<String, ItemInfo>();
                Iterator sumItemsIter = sumItems.iterator();
                ItemMappingInfo mappingInfo = null;
                while (sumItemsIter.hasNext()) {
                    mappingInfo = (ItemMappingInfo)sumItemsIter.next();
                    sumItemsMap.put(mappingInfo.getSourceItem().getNumber(), mappingInfo.getSourceItem());
                }
                Pattern pt = Pattern.compile("([\\(]*)([^\\+|^\\-|^\\*|^\\/|^\\(|^\\))]{1,})([\\+|\\-|\\*|\\/|\\(|\\)]*)");
                String sumItemFormula = itemInfo.getSumItemFormula();
                Matcher matcher = pt.matcher(sumItemFormula);
                String itemNumber = null;
                while (matcher.find()) {
                    itemNumber = matcher.group(2);
                    if (!sumItemsMap.containsKey(itemNumber)) continue;
                    sumItemFormula = sumItemFormula.replace(itemNumber, ((ItemInfo)sumItemsMap.get(itemNumber)).getFormula());
                }
                this.rptTable.getRange(top, left + 1).setFormula("=" + sumItemFormula);
                this.rptTable.getRange(top, left + 2).setValue(new Variant((Object)itemInfo.getName()));
            }
            ++top;
        }
        this.destroyWindow();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
        this.destroyWindow();
    }

    protected boolean moveUp() {
        IRow[] rows = this.getTableSelection(this.itemSelectedGrid);
        Arrays.sort(rows, new RowIdxComparer());
        if (rows.length > 0) {
            if (rows[0].getRowIndex() == 0) {
                return false;
            }
        } else {
            return false;
        }
        this.itemSelectedGrid.getSelectManager().removeAll();
        boolean moved = false;
        for (int i = 0; i < rows.length; ++i) {
            IRow row = rows[i];
            int r = rows[i].getRowIndex();
            if (r == 0) break;
            moved = true;
            this.itemSelectedGrid.removeRow(r);
            this.itemSelectedGrid.addRow(r - 1, row);
            KDTSelectBlock sel = new KDTSelectBlock();
            sel.setTable(this.itemSelectedGrid);
            sel.setTop(r - 1);
            sel.setBottom(r - 1);
            sel.setMode(2);
            this.itemSelectedGrid.getSelectManager().add(sel);
        }
        if (moved) {
            this.itemSelectedGrid.setRefresh(true);
        }
        return true;
    }

    protected boolean moveDown(String bottom) {
        IRow row;
        int r;
        int rowcount = this.itemSelectedGrid.getRowCount();
        IRow[] rows = this.getTableSelection(this.itemSelectedGrid);
        Arrays.sort(rows, new RowIdxComparer());
        if (rows.length > 0) {
            if ("bottom".equals(bottom)) {
                if (this.rowsize == 0) {
                    this.rowsize = rows.length;
                } else if (this.rowsize != rows.length) {
                    return false;
                }
            }
            if (rows[rows.length - 1].getRowIndex() == rowcount - 1) {
                return false;
            }
        } else {
            return false;
        }
        this.itemSelectedGrid.getSelectManager().removeAll();
        boolean moved = false;
        for (int i = rows.length - 1; i >= 0 && (r = (row = rows[i]).getRowIndex()) != rowcount - 1; --i) {
            moved = true;
            this.itemSelectedGrid.removeRow(r);
            this.itemSelectedGrid.addRow(r + 1, row);
            KDTSelectBlock sel = new KDTSelectBlock();
            sel.setTable(this.itemSelectedGrid);
            sel.setTop(r + 1);
            sel.setBottom(r + 1);
            sel.setMode(2);
            this.itemSelectedGrid.getSelectManager().add(sel);
        }
        if (moved) {
            this.itemSelectedGrid.setRefresh(true);
        }
        return true;
    }

    protected IRow[] getTableSelection(KDTable tbl) {
        ArrayList blocks = tbl.getSelectManager().getBlocks();
        ArrayList<IRow> rows = new ArrayList<IRow>();
        for (int i = 0; i < blocks.size(); ++i) {
            KDTSelectBlock block = (KDTSelectBlock)blocks.get(i);
            if (block.getMode() == 8) {
                for (int j = 0; j < tbl.getRowCount(); ++j) {
                    rows.add(tbl.getRow(j));
                }
                break;
            }
            int smallLine = block.getBeginRow() < block.getEndRow() ? block.getBeginRow() : block.getEndRow();
            int bigLine = block.getBeginRow() > block.getEndRow() ? block.getBeginRow() : block.getEndRow();
            for (int row = smallLine; row <= bigLine; ++row) {
                rows.add(tbl.getRow(row));
            }
        }
        return rows.toArray(new IRow[rows.size()]);
    }
}

