/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.datamodel.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.tm.td.cloud.GroupCollection;
import com.kingdee.eas.tm.td.cloud.GroupFactory;
import com.kingdee.eas.tm.td.cloud.GroupInfo;
import com.kingdee.eas.tm.td.cloud.OrgGroupCollection;
import com.kingdee.eas.tm.td.cloud.OrgGroupFactory;
import com.kingdee.eas.tm.td.cloud.OrgGroupInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.rpt.client.AbstractDataFetchAnalysisConditionUI;
import com.kingdee.eas.tm.td.cloud.datamodel.utils.DataModelUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.util.Calendar;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class DataFetchAnalysisConditionUI
extends AbstractDataFetchAnalysisConditionUI {
    private static final long serialVersionUID = 3356398126793853450L;
    private static final Logger logger = CoreUIObject.getLogger(DataFetchAnalysisConditionUI.class);
    private DataChangeListener prmtGroupListener = null;

    @Override
    public void loadFields() {
        this.removeListeners();
        super.loadFields();
        this.initListeners();
    }

    private void removeListeners() {
        if (this.prmtGroupListener != null) {
            this.prmtGroup.removeDataChangeListener(this.prmtGroupListener);
        }
    }

    private void initListeners() {
        if (this.prmtGroupListener == null) {
            this.prmtGroupListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    try {
                        DataFetchAnalysisConditionUI.this.prmtCompany.setValue(null);
                        DataFetchAnalysisConditionUI.this.initCompanyFilter();
                    }
                    catch (BOSException e) {
                        DataFetchAnalysisConditionUI.this.handUIException(e);
                    }
                }
            };
        }
        this.prmtGroup.addDataChangeListener(this.prmtGroupListener);
    }

    private void initCompanyFilter() throws BOSException {
        if (this.prmtGroup.getValue() == null) {
            return;
        }
        GroupInfo group = (GroupInfo)this.prmtGroup.getValue();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        GroupCollection groupColl = GroupFactory.getRemoteInstance().getGroupCollection(" where longNumber like '" + group.getLongNumber() + "%'");
        HashSet<String> groupIncludeChildrenIds = new HashSet<String>();
        int size = groupColl.size();
        for (int i = 0; i < size; ++i) {
            groupIncludeChildrenIds.add(groupColl.get(i).getId().toString());
        }
        filter.getFilterItems().add(new FilterItemInfo("group.id", groupIncludeChildrenIds, CompareType.INCLUDE));
        view.setFilter(filter);
        OrgGroupCollection coll = OrgGroupFactory.getRemoteInstance().getOrgGroupCollection(view);
        OrgGroupInfo orgGroupInfo = null;
        HashSet<String> orgIds = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            orgGroupInfo = coll.get(i);
            orgIds.add(orgGroupInfo.getCompany().getId().toString());
        }
        view = new EntityViewInfo();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", orgIds, CompareType.INCLUDE));
        view.setFilter(filter);
        this.prmtCompany.setEntityViewInfo(view);
    }

    private void initDataFetchFilter() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtDataFetch.setEntityViewInfo(view);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.afterLoad();
    }

    private void afterLoad() {
        this.initPeriodControl();
        this.initDataFetchFilter();
        this.prmtCompany.setEnabledMultiSelection(true);
    }

    private void initPeriodControl() {
        Calendar cale = Calendar.getInstance();
        int year = cale.get(1);
        int month = cale.get(2) + 1;
        this.spinBeginYear.setValue((Object)year);
        this.spinEndYear.setValue((Object)year);
        this.spinBeginPeriod.setValue((Object)month);
        this.spinEndPeriod.setValue((Object)month);
    }

    public boolean verify() {
        StringBuffer sb = new StringBuffer();
        if (this.prmtGroup.getValue() == null) {
            sb.append("\u3001\u5206\u7ec4");
        }
        if (this.prmtDataFetch.getValue() == null) {
            sb.append("\u3001\u65b9\u6848");
        }
        if (sb.length() > 0) {
            sb.append("\u4e0d\u80fd\u4e3a\u7a7a");
            MsgBox.showWarning((String)sb.substring(1));
            SysUtil.abort();
        }
        return true;
    }

    public void onInit(RptParams initParams) throws Exception {
    }

    public RptParams getCustomCondition() {
        RptParams para = new RptParams();
        para.setObject("yearFrom", this.spinBeginYear.getValue());
        para.setObject("monthFrom", this.spinBeginPeriod.getValue());
        para.setObject("yearTo", this.spinEndYear.getValue());
        para.setObject("monthTo", this.spinEndPeriod.getValue());
        para.setObject("companys", (Object)DataModelUtil.getF7Values(this.prmtCompany));
        para.setObject("group", this.prmtGroup.getValue());
        para.setObject("dataFetch", this.prmtDataFetch.getValue());
        return para;
    }

    public void setCustomCondition(RptParams params) {
        this.prmtGroup.setValue(params.getObject("group"));
        this.prmtCompany.setValue(params.getObject("companys"));
        this.prmtDataFetch.setValue(params.getObject("dataFetch"));
        this.spinBeginYear.setValue(params.getObject("yearFrom"));
        this.spinBeginPeriod.setValue(params.getObject("monthFrom"));
        this.spinEndYear.setValue(params.getObject("yearTo"));
        this.spinEndPeriod.setValue(params.getObject("monthTo"));
    }

    public void clear() {
        this.prmtGroup.setValue(null);
        this.prmtCompany.setValue(null);
        this.prmtDataFetch.setValue(null);
        this.initPeriodControl();
    }
}

