/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.datamodel.rpt.client;

import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CityInfo;
import com.kingdee.eas.basedata.assistant.ProvinceInfo;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.tm.td.cloud.datamodel.HalfYearEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.QuarterEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.StatPeriodEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.rpt.client.AbstractItemAnalysisConditionUI;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class ItemAnalysisConditionUI
extends AbstractItemAnalysisConditionUI {
    private static final Logger logger = CoreUIObject.getLogger(ItemAnalysisConditionUI.class);
    private DataChangeListener regionDataChangeListener;
    private DataChangeListener cityDataChangeListener;
    private ItemListener statPeriodItemListener;

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadFields();
        this.initCtr();
        this.initDefaultValue();
    }

    private void initCtr() {
        this.prmtDistrict.setEnabledMultiSelection(true);
        this.prmtCity.setEnabledMultiSelection(true);
        this.prmtRegion.setEnabledMultiSelection(true);
        this.prmtCompany.setEnabledMultiSelection(true);
    }

    @Override
    public void loadFields() {
        this.removeAllListener();
        super.loadFields();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)0, CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtDimension.setEntityViewInfo(view);
        this.initAllListener();
    }

    private void initAllListener() {
        if (this.regionDataChangeListener == null) {
            this.regionDataChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    ItemAnalysisConditionUI.this.conditionUI_dealRegionData(eventObj);
                }
            };
        }
        this.prmtRegion.addDataChangeListener(this.regionDataChangeListener);
        if (this.cityDataChangeListener == null) {
            this.cityDataChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    ItemAnalysisConditionUI.this.conditionUI_dealCityData(e);
                }
            };
        }
        this.prmtCity.addDataChangeListener(this.cityDataChangeListener);
        if (this.statPeriodItemListener == null) {
            this.statPeriodItemListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ItemAnalysisConditionUI.this.conditionUI_dealstatPeriodData(e);
                }
            };
        }
        this.statPeriod.addItemListener(this.statPeriodItemListener);
    }

    protected void conditionUI_dealstatPeriodData(ItemEvent e) {
        if (e.getItem() != null && e.getItem() instanceof StatPeriodEnum) {
            int statPeriod = ((StatPeriodEnum)((Object)e.getItem())).getValue();
            if (statPeriod == 1) {
                this.showStatPeriod("month", true);
            } else if (statPeriod == 2) {
                this.showStatPeriod("quarter", true);
            } else if (statPeriod == 3) {
                this.showStatPeriod("halfYear", true);
            } else if (statPeriod == 4) {
                this.showStatPeriod("year", true);
            } else {
                this.showStatPeriod("month", true);
            }
        }
    }

    private void showStatPeriod(String string, boolean b) {
        Calendar calendar = Calendar.getInstance();
        int yearValue = calendar.get(1);
        int monthValue = calendar.get(2);
        boolean year = false;
        boolean halfYear = false;
        boolean quarter = false;
        boolean month = true;
        if (string.equals("quarter")) {
            year = true;
            month = false;
            quarter = true;
        } else if (string.equals("halfYear")) {
            year = true;
            halfYear = true;
            month = false;
        } else if (string.equals("year")) {
            year = true;
            month = false;
        } else {
            this.statPeriod.removeItemListener(this.statPeriodItemListener);
            this.statPeriod.setSelectedIndex(1);
            this.statPeriod.addItemListener(this.statPeriodItemListener);
        }
        this.yearLabel.setVisible(year);
        this.spinYearFrom.setVisible(year);
        this.spinYearFrom.setValue((Object)yearValue);
        this.yearFromLabel.setVisible(year);
        this.yearToLetterLabel.setVisible(year);
        this.spinYearTo.setVisible(year);
        this.spinYearTo.setValue((Object)yearValue);
        this.yearToLabel.setVisible(year);
        this.comboHalfYear.setVisible(halfYear);
        this.halfYearFromLabel.setVisible(halfYear);
        this.halfYearToLabel.setVisible(halfYear);
        this.comboHalfYearTo.setVisible(halfYear);
        this.quarterFromLabel.setVisible(quarter);
        this.comboQuarterFrom.setVisible(quarter);
        this.comboQuarterTo.setVisible(quarter);
        this.quarterToLabel.setVisible(quarter);
        this.periodFromLabel.setVisible(month);
        this.spinPeriodFromYear.setVisible(month);
        this.spinPeriodFromYear.setValue((Object)yearValue);
        this.periodFromYearLabel.setVisible(month);
        this.spinPeriodFromMonth.setVisible(month);
        this.spinPeriodFromMonth.setValue((Object)monthValue);
        this.periodFromMonthLabel.setVisible(month);
        this.periodToLabel.setVisible(month);
        this.spinPeriodToYear.setVisible(month);
        this.spinPeriodToYear.setValue((Object)yearValue);
        this.periodToYearLabel.setVisible(month);
        this.spinPeriodToMonth.setVisible(month);
        this.spinPeriodToMonth.setValue((Object)monthValue);
        this.periodToMonthLabel.setVisible(month);
    }

    protected void conditionUI_dealCityData(DataChangeEvent e) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (e.getNewValue() != null && e.getNewValue() instanceof Object[]) {
            Object[] objects = (Object[])e.getNewValue();
            ArrayList<String> list = new ArrayList<String>();
            int len = objects.length;
            for (int i = 0; i < len; ++i) {
                if (objects[i] == null || !(objects[i] instanceof CityInfo)) continue;
                list.add(((CityInfo)objects[i]).getNumber().toString());
            }
            filter.getFilterItems().add(new FilterItemInfo("city.number", new HashSet(list), CompareType.EQUALS));
        }
        view.setFilter(filter);
        this.prmtDistrict.setEntityViewInfo(view);
        this.prmtDistrict.setValue(null);
    }

    protected void conditionUI_dealRegionData(DataChangeEvent e) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (e.getNewValue() != null && e.getNewValue() instanceof Object[]) {
            Object[] objects = (Object[])e.getNewValue();
            ArrayList<String> list = new ArrayList<String>();
            int len = objects.length;
            for (int i = 0; i < len; ++i) {
                if (objects[i] == null || !(objects[i] instanceof ProvinceInfo)) continue;
                list.add(((ProvinceInfo)objects[i]).getId().toString());
            }
            filter.getFilterItems().add(new FilterItemInfo("province.id", new HashSet(list), CompareType.INCLUDE));
        }
        view.setFilter(filter);
        this.prmtCity.setEntityViewInfo(view);
        this.prmtCity.setValue(null);
        this.prmtDistrict.setValue(null);
    }

    private void removeAllListener() {
        if (this.regionDataChangeListener != null) {
            this.prmtRegion.removeDataChangeListener(this.regionDataChangeListener);
        }
        if (this.cityDataChangeListener != null) {
            this.prmtCity.removeDataChangeListener(this.cityDataChangeListener);
        }
        if (this.statPeriodItemListener != null) {
            this.statPeriod.removeItemListener(this.statPeriodItemListener);
        }
    }

    private void initDefaultValue() {
        this.showStatPeriod("month", true);
    }

    public void onInit(RptParams initParams) throws Exception {
    }

    public RptParams getCustomCondition() {
        RptParams params = new RptParams();
        params.setObject("group", this.prmtGroup.getValue());
        params.setObject("dimension", this.prmtDimension.getValue());
        params.setObject("country", this.prmtCountry.getValue());
        params.setObject("area", this.prmtArea.getValue());
        params.setObject("region", this.prmtRegion.getValue());
        params.setObject("city", this.prmtCity.getValue());
        params.setObject("district", this.prmtDistrict.getValue());
        params.setObject("taxType", this.prmtTaxType.getValue());
        params.setObject("company", this.prmtCompany.getValue());
        params.setString("mainGovAgency", this.txtMainGovAgency.getText());
        params.setInt("statPeriod", this.statPeriod.getSelectedIndex());
        params.setInt("periodFromYear", ((Integer)this.spinPeriodFromYear.getValue()).intValue());
        params.setInt("periodFromMonth", ((Integer)this.spinPeriodFromMonth.getValue()).intValue());
        params.setInt("periodToYear", ((Integer)this.spinPeriodToYear.getValue()).intValue());
        params.setInt("periodToMonth", ((Integer)this.spinPeriodToMonth.getValue()).intValue());
        params.setInt("quarterFrom", ((QuarterEnum)((Object)this.comboQuarterFrom.getSelectedItem())).getValue());
        params.setInt("quarterTo", ((QuarterEnum)((Object)this.comboQuarterTo.getSelectedItem())).getValue());
        params.setInt("halfYearFrom", ((HalfYearEnum)((Object)this.comboHalfYear.getSelectedItem())).getValue());
        params.setInt("halfYearTo", ((HalfYearEnum)((Object)this.comboHalfYearTo.getSelectedItem())).getValue());
        params.setInt("yearFrom", ((Integer)this.spinYearFrom.getValue()).intValue());
        params.setInt("yearTo", ((Integer)this.spinYearTo.getValue()).intValue());
        params.setBoolean("isSummary", this.isSummary.isSelected());
        return params;
    }

    public void setCustomCondition(RptParams params) {
        this.prmtGroup.setValue(params.getObject("group"));
        this.prmtDimension.setValue(params.getObject("dimension"));
        this.prmtCountry.setValue(params.getObject("country"));
        this.prmtArea.setValue(params.getObject("area"));
        this.prmtRegion.setValue(params.getObject("region"));
        this.prmtCity.setValue(params.getObject("city"));
        this.prmtDistrict.setValue(params.getObject("district"));
        this.prmtTaxType.setValue(params.getObject("taxType"));
        this.prmtCompany.setValue(params.getObject("company"));
        this.txtMainGovAgency.setText(params.getString("mainGovAgency"));
        int statPeriod = params.getInt("statPeriod");
        this.statPeriod.setSelectedIndex(statPeriod);
        if (statPeriod == 0) {
            this.showStatPeriod("month", true);
        } else if (statPeriod == 1) {
            this.spinPeriodFromYear.setValue((Object)params.getInt("periodFromYear"));
            this.spinPeriodFromMonth.setValue((Object)params.getInt("periodFromMonth"));
            this.spinPeriodToYear.setValue((Object)params.getInt("periodToYear"));
            this.spinPeriodToMonth.setValue((Object)params.getInt("periodToMonth"));
        } else if (statPeriod == 2) {
            this.spinYearFrom.setValue((Object)params.getInt("yearFrom"));
            this.spinYearTo.setValue((Object)params.getInt("yearTo"));
            this.comboQuarterFrom.setSelectedIndex(params.getInt("quarterFrom") - 1);
            this.comboQuarterTo.setSelectedIndex(params.getInt("quarterTo") - 1);
        } else if (statPeriod == 3) {
            this.spinYearFrom.setValue((Object)params.getInt("yearFrom"));
            this.spinYearTo.setValue((Object)params.getInt("yearTo"));
            this.comboHalfYear.setSelectedIndex(params.getInt("halfYearFrom") - 1);
            this.comboHalfYearTo.setSelectedIndex(params.getInt("halfYearTo") - 1);
        } else {
            this.spinYearFrom.setValue((Object)params.getInt("yearFrom"));
            this.spinYearTo.setValue((Object)params.getInt("yearTo"));
        }
        this.isSummary.setSelected(params.getBoolean("isSummary"));
    }
}

