/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.datamodel.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.basedata.assistant.AreaInfo;
import com.kingdee.eas.basedata.assistant.CityInfo;
import com.kingdee.eas.basedata.assistant.ProvinceInfo;
import com.kingdee.eas.basedata.assistant.RegionInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.cloud.GroupInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.ItemAnalysisFacadeFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.ItemDimensionInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.rpt.client.AbstractItemAnalysisRptUI;
import com.kingdee.eas.tm.td.cloud.datamodel.rpt.client.ItemAnalysisConditionUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Font;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ItemAnalysisRptUI
extends AbstractItemAnalysisRptUI {
    private static final Logger logger = CoreUIObject.getLogger(ItemAnalysisRptUI.class);
    private KDTDataFillListener tblListener;
    private final Color color = new Color(253, 242, 170);
    private final Font font = new Font(null, 1, 9);
    private static final String RES = "com.kingdee.eas.tm.td.ItemAnalysisResource";

    public ItemAnalysisRptUI() throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tblMain.getDataRequestManager().setDataRequestMode(1);
        this.tblMain.getDataRequestManager().setPageRowCount(500);
        this.enableExportExcel(this.tblMain);
        this.tblMain.setEditable(false);
        if (this.tblListener == null) {
            this.tblListener = new KDTDataFillListener(){

                public void afterDataFill(KDTDataRequestEvent e) {
                    ItemAnalysisRptUI.this.rptUI_handleDataAfterFill(e);
                }
            };
        }
        this.tblMain.addKDTDataFillListener(this.tblListener);
    }

    protected void rptUI_handleDataAfterFill(KDTDataRequestEvent e) {
        int firstRow = e.getFirstRow();
        int lastRow = e.getLastRow() + 1;
        for (int i = firstRow; i < lastRow; ++i) {
            String company;
            String companyColumn;
            IRow row = this.tblMain.getRow(i);
            if (((BigDecimal)row.getCell("Fisleaf").getValue()).intValue() == 0) {
                companyColumn = EASResource.getString((String)RES, (String)"Company");
                row.getStyleAttributes().setBackground(this.color);
                company = row.getCell(companyColumn).getValue().toString();
                company = "+" + company;
                row.getCell(companyColumn).setValue((Object)company);
                row.getStyleAttributes().setFont(this.font);
                continue;
            }
            companyColumn = EASResource.getString((String)RES, (String)"Company");
            company = row.getCell(companyColumn).getValue().toString();
            company = " -" + company;
            row.getCell(companyColumn).setValue((Object)company);
        }
    }

    public void getData(KDTDataRequestEvent e) {
        try {
            this.tblMain.getDataRequestManager().removeDataRequestListener((KDTDataRequestListener)this);
            int from = e.getFirstRow();
            int len = e.getLastRow() - from + 1;
            RptParams param = new RptParams();
            if (from == 0) {
                param = this.buildRptParams();
                RptParams rptParams = this.getRemoteInstance().createTempTable(param);
                this.setTempTable(rptParams.getString("tempTable"));
                RptTableHeader header = (RptTableHeader)rptParams.getObject("header");
                KDTableUtil.setHeader((RptTableHeader)header, (KDTable)this.tblMain);
            }
            param.setString("tempTable", this.getTempTable());
            RptParams rpt = this.getRemoteInstance().query(param, from, len);
            int total = rpt.getInt("totalCount");
            if (from == 0) {
                this.tblMain.setRowCount(total);
            }
            RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
            KDTableUtil.insertRows((RptRowSet)rs, (int)from, (KDTable)this.tblMain);
            this.tblMain.setRowCount(rs.getRowCount());
            this.tblMain.doLayout();
            this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        }
        catch (Exception e1) {
            this.handleException(e1);
        }
    }

    private RptParams buildRptParams() {
        RptParams param = new RptParams();
        param.setObject("tempTable", (Object)this.getTempTable());
        param.setInt("webOrGui", 1);
        if (this.params.getObject("group") == null) {
            String groupNotNull = TDUtils.getString(RES, "GroupNotNull", null);
            MsgBox.showInfo((String)groupNotNull);
            this.abort();
        } else if (this.params.getObject("group") instanceof GroupInfo) {
            String groupId = ((GroupInfo)this.params.getObject("group")).getId().toString();
            param.setObject("groupId", (Object)groupId);
        }
        if (this.params.getObject("dimension") == null) {
            String dimensionNotNull = TDUtils.getString(RES, "DimensionNotNull", null);
            MsgBox.showInfo((String)dimensionNotNull);
            this.abort();
        } else if (this.params.getObject("dimension") instanceof ItemDimensionInfo) {
            String itemDimensionId = ((ItemDimensionInfo)this.params.getObject("dimension")).getId().toString();
            param.setObject("itemDimensionId", (Object)itemDimensionId);
        }
        param.setObject("country", this.params.getObject("country"));
        param.setObject("area", this.params.getObject("area"));
        param.setObject("region", this.params.getObject("region"));
        param.setObject("city", this.params.getObject("city"));
        param.setObject("district", this.params.getObject("district"));
        if (this.params.getObject("taxType") instanceof TaxItemTypeInfo) {
            String taxTypeId = ((TaxItemTypeInfo)this.params.getObject("taxType")).getId().toString();
            param.setObject("taxTypeId", (Object)taxTypeId);
        }
        if (this.params.getObject("company") != null && this.params.getObject("company") instanceof Object[]) {
            Object[] objects = (Object[])this.params.getObject("company");
            HashSet<String> companyIds = new HashSet<String>();
            int len = objects.length;
            for (int i = 0; i < len; ++i) {
                if (!(objects[i] instanceof CompanyOrgUnitInfo)) continue;
                String companyId = ((CompanyOrgUnitInfo)objects[i]).getId().toString();
                companyIds.add(companyId);
            }
            param.setObject("companyIds", companyIds);
        }
        if (!"".equals(this.params.getString("mainGovAgency"))) {
            param.setString("mainGovAgency", this.params.getString("mainGovAgency"));
        }
        int statPeriod = this.params.getInt("statPeriod");
        param.setObject("statPeriod", (Object)statPeriod);
        if (statPeriod == 1) {
            param.setObject("periodFrom", (Object)(this.params.getObject("periodFromYear") + "-" + this.params.getObject("periodFromMonth")));
            param.setObject("periodTo", (Object)(this.params.getObject("periodToYear") + "-" + this.params.getObject("periodToMonth")));
        } else if (statPeriod == 2) {
            param.setObject("yearFrom", this.params.getObject("yearFrom"));
            param.setObject("yearTo", this.params.getObject("yearTo"));
            param.setObject("quarterFrom", this.params.getObject("quarterFrom"));
            param.setObject("quarterTo", this.params.getObject("quarterTo"));
        } else if (statPeriod == 3) {
            param.setObject("halfYearFrom", this.params.getObject("halfYearFrom"));
            param.setObject("halfYearTo", this.params.getObject("halfYearTo"));
            param.setObject("yearFrom", this.params.getObject("yearFrom"));
            param.setObject("yearTo", this.params.getObject("yearTo"));
        } else {
            param.setObject("yearFrom", this.params.getObject("yearFrom"));
            param.setObject("yearTo", this.params.getObject("yearTo"));
        }
        param.setObject("isSummary", this.params.getObject("isSummary"));
        this.dealDim(param);
        return param;
    }

    private void dealDim(RptParams param) {
        int dimType = 0;
        HashSet dimIdSet = new HashSet();
        Object district = this.params.getObject("district");
        Object city = this.params.getObject("city");
        Object region = this.params.getObject("region");
        Object area = this.params.getObject("area");
        Object country = this.params.getObject("country");
        if (district != null) {
            Object[] objects;
            if (district instanceof Object[] && (objects = (Object[])district)[0] != null && objects.length > 0) {
                dimType = 5;
                dimIdSet.addAll(this.getIds(district));
            }
        } else if (city != null) {
            Object[] objects;
            if (city instanceof Object[] && (objects = (Object[])city)[0] != null && objects.length > 0) {
                dimType = 4;
                dimIdSet.addAll(this.getIds(city));
            }
        } else if (region != null) {
            Object[] objects;
            if (region instanceof Object[] && (objects = (Object[])region).length > 0 && objects[0] != null) {
                dimType = 3;
                dimIdSet.addAll(this.getIds(region));
            }
        } else if (area != null) {
            Object[] objects;
            if (area instanceof Object[] && (objects = (Object[])area).length > 0 && objects[0] != null) {
                dimType = 2;
                dimIdSet.addAll(this.getIds(area));
            }
        } else if (country != null) {
            dimType = 1;
        }
        param.setObject("dimType", (Object)dimType);
        param.setObject("dimIdSet", dimIdSet);
    }

    private Set getIds(Object object) {
        HashSet<String> ids;
        block5: {
            ArrayList list;
            block7: {
                block6: {
                    block4: {
                        ids = new HashSet<String>();
                        list = new ArrayList();
                        Collections.addAll(list, (Object[])((Object[])object));
                        if (!(list.get(0) instanceof RegionInfo)) break block4;
                        int size = list.size();
                        for (int i = 0; i < size; ++i) {
                            RegionInfo regionInfo = (RegionInfo)list.get(0);
                            ids.add(regionInfo.get("id").toString());
                        }
                        break block5;
                    }
                    if (!(list.get(0) instanceof CityInfo)) break block6;
                    int size = list.size();
                    for (int i = 0; i < size; ++i) {
                        CityInfo cityInfo = (CityInfo)list.get(i);
                        ids.add(cityInfo.getId().toString());
                    }
                    break block5;
                }
                if (!(list.get(0) instanceof ProvinceInfo)) break block7;
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    ProvinceInfo provinceInfo = (ProvinceInfo)list.get(i);
                    ids.add(provinceInfo.get("id").toString());
                }
                break block5;
            }
            if (!(list.get(0) instanceof AreaInfo)) break block5;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                AreaInfo areaInfo = (AreaInfo)list.get(i);
                ids.add(areaInfo.getId().toString());
            }
        }
        return ids;
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return ItemAnalysisFacadeFactory.getRemoteInstance();
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    protected RptParams getParamsForInit() {
        return null;
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        ItemAnalysisConditionUI conditionUI = new ItemAnalysisConditionUI();
        return conditionUI;
    }

    protected void query() {
        this.tblMain.removeColumns();
        this.tblMain.removeRows();
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        IRow row = this.tblMain.getRow(rowIndex);
        if (row == null) {
            return;
        }
        String companyColumn = EASResource.getString((String)RES, (String)"Company");
        int columnIndex = row.getCell(companyColumn).getColumnIndex();
        int level = ((BigDecimal)row.getCell("FLevel").getValue()).intValue();
        int clickColumn = e.getColIndex();
        if (clickColumn == columnIndex) {
            int rowIsLeaf;
            int total = this.tblMain.getRowCount();
            String companyName = row.getCell(columnIndex).getValue().toString();
            int isleaf = ((BigDecimal)row.getCell("Fisleaf").getValue()).intValue();
            if ("+".equals(companyName.trim().substring(0, 1))) {
                row.getCell(columnIndex).setValue((Object)companyName.replace("+", "-"));
                String parentId = "";
                if (row.getCell("FGroupID").getValue() != null) {
                    parentId = row.getCell("FGroupID").getValue().toString();
                }
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < level; ++i) {
                    sb.append("  ");
                }
                RptParams param = this.buildRptParams();
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("parentId", parentId);
                paramMap.put("level", level);
                paramMap.put("analysisDimensionId", param.getObject("itemDimensionId"));
                paramMap.put("taxTypeId", param.getObject("taxTypeId"));
                paramMap.put("tempTable", param.getObject("tempTable"));
                paramMap.put("statPeriod", param.getObject("statPeriod"));
                paramMap.put("webOrGui", 1);
                Map dataMap = ItemAnalysisFacadeFactory.getRemoteInstance().findDataByParent(paramMap);
                List data = (List)dataMap.get("data");
                List headerList = (List)dataMap.get("headerListKey");
                total += data.size();
                int len = data.size();
                for (int i = 0; i < len; ++i) {
                    IRow row2 = this.tblMain.addRow(i + rowIndex + 1);
                    HashMap rowData = (HashMap)data.get(i);
                    int rowLeaf = ((BigDecimal)rowData.get("FINDEX")).intValue();
                    if (rowLeaf == 2) {
                        row2.getStyleAttributes().setBackground(this.color);
                        row2.getStyleAttributes().setFont(this.font);
                    }
                    int columns = rowData.size();
                    for (int j = 0; j < columns; ++j) {
                        Object object = rowData.get(headerList.get(j));
                        if ("FBILLNAME".equals(headerList.get(j))) {
                            object = rowLeaf == 2 ? sb.toString() + "+" + object : sb.toString() + "-" + object;
                        }
                        if ("FCOMPANYTOTAL".equals(headerList.get(j)) && ((BigDecimal)object).intValue() == 0) {
                            object = "";
                        }
                        row2.getCell(j).setValue(object);
                    }
                }
                this.tblMain.setRowCount(total);
            } else if ("-".equals(companyName.trim().substring(0, 1)) && (rowIsLeaf = ((BigDecimal)row.getCell("Fisleaf").getValue()).intValue()) != 1) {
                int rowLevel;
                for (int i = rowIndex + 1; i < total && this.tblMain.getRow(i) != null && level < (rowLevel = ((BigDecimal)this.tblMain.getRow(i).getCell("FLevel").getValue()).intValue()); ++i) {
                    this.tblMain.removeRow(i);
                    --i;
                }
                row.getCell(columnIndex).setValue((Object)companyName.replace("-", "+"));
                row.getStyleAttributes().setFont(this.font);
            }
            this.tblMain.doLayout();
        }
        super.tblMain_tableClicked(e);
    }
}

