/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.est.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.td.FilterCommonStatusEnum;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.DataSourceFactory;
import com.kingdee.eas.tm.td.basedata.DataSourceInfo;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.basedata.client.GetDataFormula;
import com.kingdee.eas.tm.td.basedata.client.GetDataFormulaUI;
import com.kingdee.eas.tm.td.common.permsupport.IPermSupport4EditUI;
import com.kingdee.eas.tm.td.common.uihelper.EditUIHelper;
import com.kingdee.eas.tm.td.est.CalcFormulaFactory;
import com.kingdee.eas.tm.td.est.CalcFormulaInfo;
import com.kingdee.eas.tm.td.est.EstStateEnum;
import com.kingdee.eas.tm.td.est.TaxMethodEnum;
import com.kingdee.eas.tm.td.est.client.AbstractCalcFormulaEditUI;
import com.kingdee.eas.tm.td.est.client.util.EstClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CalcFormulaEditUI
extends AbstractCalcFormulaEditUI
implements IPermSupport4EditUI {
    private static final Logger logger = CoreUIObject.getLogger(CalcFormulaEditUI.class);
    private EditUIHelper uiHelper = new EditUIHelper(this);
    private String currentCUID;
    private Map btnMap = new HashMap();
    private DataChangeListener prmtDisplayExprChange = null;
    private SelectorListener prmtDisplayExprSelector = null;
    private DataChangeListener prmtTaxItemTypeChange = null;

    public CalcFormulaEditUI() throws Exception {
        this.btnMap.put("actionRemove", this.actionRemove);
        this.btnMap.put("actionCancel", this.actionCancel);
        this.btnMap.put("actionCancelCancel", this.actionCancelCancel);
        this.btnMap.put("actionEdit", this.actionEdit);
        this.btnMap.put("actionSave", this.actionSubmit);
        this.btnMap.put("actionCopy", this.actionCopy);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
    }

    protected void removeListener() {
        if (this.prmtDisplayExprChange != null) {
            this.prmtDisplayExpr.removeDataChangeListener(this.prmtDisplayExprChange);
            this.prmtDisplayBasisExpr.removeDataChangeListener(this.prmtDisplayExprChange);
        }
        if (this.prmtTaxItemTypeChange != null) {
            this.prmtTaxItemType.removeDataChangeListener(this.prmtTaxItemTypeChange);
        }
        if (this.prmtDisplayExprSelector != null) {
            this.prmtDisplayExpr.removeSelectorListener(this.prmtDisplayExprSelector);
            this.prmtDisplayBasisExpr.removeSelectorListener(this.prmtDisplayExprSelector);
        }
    }

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        this.initComboTaxMethod(this.editData.getTaxItemType());
        this.initActionEnableByState();
        this.initListeners();
        this.prmtDisplayBasisExpr.setEditable(false);
        this.txtBasisExpr.setEditable(false);
        this.prmtDisplayExpr.setEditable(false);
        this.txtExpr.setEditable(false);
        this.initOldData((IObjectValue)this.editData);
    }

    private void initActionEnableByState() {
        EstStateEnum state = this.editData.getState();
        boolean isLight = false;
        if (EstStateEnum.FORBIDDEN.equals((Object)state)) {
            isLight = true;
        }
        this.uiHelper.initBtnStatus(this.btnMap, isLight);
        if (this.editData != null && this.editData.getId() != null && this.editData.isIsPreset()) {
            this.actionRemove.setEnabled(false);
            this.txtNumber.setEnabled(false);
            this.prmtTaxItemType.setEnabled(false);
            this.comboTaxMethod.setEnabled(false);
        } else {
            this.actionRemove.setEnabled(isLight);
        }
    }

    protected void unLockUI() {
        super.unLockUI();
        this.prmtDisplayBasisExpr.setEditable(false);
        this.txtBasisExpr.setEditable(false);
        this.prmtDisplayExpr.setEditable(false);
        this.txtExpr.setEditable(false);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanAddnew(this.currentCUID);
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanEdit(this.currentCUID, this.editData.getId().toString());
        super.actionEdit_actionPerformed(e);
        this.loadFields();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.editData.getId().toString());
        this.uiHelper.checkCanRemove(this.currentCUID, ids);
        super.actionRemove_actionPerformed(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.editData.getId().toString());
        this.uiHelper.checkBaseDataPermission(this.currentCUID, ids);
        try {
            TDUtils.tryLock(ids);
            super.actionCancel_actionPerformed(e);
            this.initActionEnableByState();
        }
        finally {
            TDUtils.releaseLock(ids);
        }
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.editData.getId().toString());
        this.uiHelper.checkBaseDataPermission(this.currentCUID, ids);
        if (!this.uiHelper.modifySaveOrExit((ItemAction)this.actionSubmit, this.btnSubmit, (ItemAction)this.actionSave, this.btnSave, this.isModifySave())) {
            return;
        }
        try {
            TDUtils.tryLock(ids);
            super.actionCancelCancel_actionPerformed(e);
            if (this.editData.getState() != null && EstStateEnum.USING.equals((Object)this.editData.getState())) {
                this.setOprtState("VIEW");
            } else {
                this.setOprtState("EDIT");
            }
            this.setDataObject((IObjectValue)this.editData);
            this.loadFields();
        }
        finally {
            TDUtils.releaseLock(ids);
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        if (!this.getOprtState().equals(OprtState.ADDNEW)) {
            if (this.editData.getState() != null && EstStateEnum.USING.equals((Object)this.editData.getState())) {
                this.setOprtState("VIEW");
            } else {
                this.setOprtState("EDIT");
            }
        }
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
    }

    protected void initListeners() {
        if (this.prmtDisplayExprChange == null) {
            this.prmtDisplayExprChange = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    if (CalcFormulaEditUI.this.getOprtState().equals(OprtState.VIEW)) {
                        return;
                    }
                    if (e.getNewValue() == null) {
                        KDTextField expr = null;
                        KDBizPromptBox display = null;
                        if (CalcFormulaEditUI.this.prmtDisplayBasisExpr.equals(e.getSource())) {
                            expr = CalcFormulaEditUI.this.txtBasisExpr;
                            display = CalcFormulaEditUI.this.prmtDisplayBasisExpr;
                        } else {
                            expr = CalcFormulaEditUI.this.txtExpr;
                            display = CalcFormulaEditUI.this.prmtDisplayExpr;
                        }
                        expr.setText(null);
                        display.setData(null);
                    }
                }
            };
        }
        this.prmtDisplayExpr.setRefresh(false);
        this.prmtDisplayExpr.addDataChangeListener(this.prmtDisplayExprChange);
        this.prmtDisplayBasisExpr.setRefresh(false);
        this.prmtDisplayBasisExpr.addDataChangeListener(this.prmtDisplayExprChange);
        if (this.prmtDisplayExprSelector == null) {
            this.prmtDisplayExprSelector = new SelectorListener(){

                public void willShow(SelectorEvent e) {
                    try {
                        if (CalcFormulaEditUI.this.getOprtState().equals(OprtState.VIEW)) {
                            return;
                        }
                        UIContext uiContext = new UIContext();
                        DataSourceInfo ds = (DataSourceInfo)CalcFormulaEditUI.this.prmtDataSource.getValue();
                        if (ds == null) {
                            MsgBox.showInfo((String)CalcFormulaEditUI.this.getResource("Msg_NoDataSource"));
                            return;
                        }
                        KDTextField expr = null;
                        KDBizPromptBox display = null;
                        if (CalcFormulaEditUI.this.prmtDisplayBasisExpr.equals(e.getSource())) {
                            expr = CalcFormulaEditUI.this.txtBasisExpr;
                            display = CalcFormulaEditUI.this.prmtDisplayBasisExpr;
                        } else {
                            expr = CalcFormulaEditUI.this.txtExpr;
                            display = CalcFormulaEditUI.this.prmtDisplayExpr;
                        }
                        GetDataFormula dataFormula = new GetDataFormula(ds, expr.getText(), Boolean.FALSE);
                        uiContext.put("DataQueryFormula", dataFormula);
                        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(GetDataFormulaUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
                        uiWindow.show();
                        GetDataFormulaUI formulaUI = (GetDataFormulaUI)uiWindow.getUIObject();
                        if (!formulaUI.isCancel()) {
                            dataFormula = (GetDataFormula)formulaUI.getData();
                            expr.setText(dataFormula.getFormulaExpr());
                            display.setData((Object)dataFormula.getFormualAlias());
                        }
                    }
                    catch (Exception err) {
                        logger.error((Object)err);
                        CalcFormulaEditUI.this.handleException(err);
                    }
                }
            };
        }
        this.prmtDisplayExpr.addSelectorListener(this.prmtDisplayExprSelector);
        this.prmtDisplayBasisExpr.addSelectorListener(this.prmtDisplayExprSelector);
        if (this.prmtTaxItemTypeChange == null) {
            this.prmtTaxItemTypeChange = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    CalcFormulaEditUI.this.initComboTaxMethod((TaxItemTypeInfo)e.getNewValue());
                }
            };
        }
        this.prmtTaxItemType.addDataChangeListener(this.prmtTaxItemTypeChange);
    }

    private void initComboTaxMethod(TaxItemTypeInfo taxItemTypeInfo) {
        if (taxItemTypeInfo != null && "ZCyrvv6oAnPgU0ETqMCc49uK96Y=".equals(taxItemTypeInfo.getId().toString())) {
            this.comboTaxMethod.setEnabled(true);
            this.comboTaxMethod.removeItem((Object)FilterCommonStatusEnum.NULL);
        } else {
            this.comboTaxMethod.setEnabled(false);
            this.comboTaxMethod.removeAllItems();
            this.comboTaxMethod.addItem((Object)FilterCommonStatusEnum.NULL);
            this.comboTaxMethod.addItems(TaxMethodEnum.getEnumList().toArray());
            this.comboTaxMethod.setSelectedItem((Object)FilterCommonStatusEnum.NULL);
        }
    }

    protected IObjectValue createNewData() {
        CalcFormulaInfo info = new CalcFormulaInfo();
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        info.setState(EstStateEnum.USING);
        try {
            DataSourceInfo ds = DataSourceFactory.getRemoteInstance().getDataSourceInfo((IObjectPK)new ObjectUuidPK("iwoAAABLm3ivQ3S3"));
            info.setDataSource(ds);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return info;
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        EstClientUtils.textFieldTrim(this.getComponents());
        if (this.comboTaxMethod.getSelectedItem() == null || this.comboTaxMethod.getSelectedItem().equals((Object)FilterCommonStatusEnum.NULL)) {
            this.editData.put("taxMethod", null);
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        ArrayList<String> errorList = new ArrayList<String>();
        if (this.txtNumber.getText() == null || this.txtNumber.getText().isEmpty()) {
            errorList.add(this.getResource("Error_FieldsNull", new Object[]{this.txtNumber.getBoundLabelText()}));
        }
        if (this.txtName.getText() == null || this.txtName.getText().isEmpty()) {
            errorList.add(this.getResource("Error_FieldsNull", new Object[]{this.txtName.getBoundLabelText()}));
        }
        if (this.prmtTaxItemType.getValue() == null || this.prmtTaxItemType.getValue().toString().isEmpty()) {
            errorList.add(this.getResource("Error_FieldsNull", new Object[]{this.contTaxItemType.getBoundLabelText()}));
        }
        if (this.prmtDataSource.getValue() == null || this.prmtDataSource.getValue().toString().isEmpty()) {
            errorList.add(this.getResource("Error_FieldsNull", new Object[]{this.contDataSource.getBoundLabelText()}));
        }
        if (this.prmtDisplayBasisExpr.getValue() == null || this.prmtDisplayBasisExpr.getValue().toString().isEmpty()) {
            errorList.add(this.getResource("Error_FieldsNull", new Object[]{this.contDisplayBasisExpr.getBoundLabelText()}));
        }
        if (this.prmtDisplayExpr.getValue() == null || this.prmtDisplayExpr.getValue().toString().isEmpty()) {
            errorList.add(this.getResource("Error_FieldsNull", new Object[]{this.contDisplayExpr.getBoundLabelText()}));
        }
        if (errorList.size() > 0) {
            MsgBox.showWarning((String)TDUtils.buildErrorMsg(errorList));
            SysUtil.abort();
        }
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        CalcFormulaInfo info = (CalcFormulaInfo)newData;
        info.setNumber(info.getNumber() + "copy");
        info.setName(info.getName() + "copy");
        info.setState(EstStateEnum.USING);
        info.setIsPreset(false);
        info.setIsDefault(false);
        info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setLastUpdateUser(null);
        Timestamp tt = new Timestamp(System.currentTimeMillis());
        info.setCreateTime(tt);
        info.setLastUpdateTime(null);
    }

    private String getResource(String key) {
        return TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", key, this.getLocale());
    }

    private String getResource(String key, Object[] objects) {
        return TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", key, this.getLocale(), objects);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CalcFormulaFactory.getRemoteInstance();
    }

    protected BOSObjectType getBOSObjectType() {
        return BOSObjectType.create((String)"6C3ED36E");
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("dataSource.entry.*"));
        return sic;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        IObjectPK pk = null;
        try {
            pk = this.uiHelper.getOrgPK();
        }
        catch (Exception e) {
            logger.error((Object)e);
            this.handUIException(e);
        }
        if (pk != null) {
            return pk;
        }
        if (this.getMainOrgContext() != null && this.getMainOrgContext().get((Object)this.getMainBizOrgType()) != null) {
            pk = new ObjectUuidPK(((OrgUnitInfo)this.getMainOrgContext().get((Object)this.getMainBizOrgType())).getId().toString());
            return pk;
        }
        return super.getOrgPK(action);
    }

    @Override
    public String getBizOrgProperty(OrgType orgType) throws BOSException, EASBizException {
        return "CU";
    }

    @Override
    public ICoreBase getPermInterface() throws Exception {
        return this.getBizInterface();
    }

    @Override
    public String getPermItem(String status) {
        return null;
    }

    @Override
    public KDBizPromptBox getPermMainBizOrg() {
        return null;
    }

    @Override
    public IObjectValue getValueObject() {
        return this.editData;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }
}

