/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.est.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.DSTypeEnum;
import com.kingdee.eas.tm.td.basedata.client.DataSourceListUI;
import com.kingdee.eas.tm.td.common.permsupport.IPermSupport4ListUI;
import com.kingdee.eas.tm.td.common.uihelper.ListUIHelper;
import com.kingdee.eas.tm.td.est.CalcFormulaFactory;
import com.kingdee.eas.tm.td.est.CalcFormulaInfo;
import com.kingdee.eas.tm.td.est.EstStateEnum;
import com.kingdee.eas.tm.td.est.client.AbstractCalcFormulaListUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class CalcFormulaListUI
extends AbstractCalcFormulaListUI
implements IPermSupport4ListUI {
    private static final Logger logger = CoreUIObject.getLogger(CalcFormulaListUI.class);
    private ListUIHelper uiHelper = null;
    private String currentCUID;

    public CalcFormulaListUI() throws Exception {
        logger.info((Object)"CalcFormulaListUI");
        this.uiHelper = new ListUIHelper(this);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
    }

    protected String getEditUIName() {
        return "com.kingdee.eas.tm.td.est.client.CalcFormulaEditUI";
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = this.uiHelper.getHasPermissionOrgFilterForQuery();
        return filter;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CalcFormulaFactory.getRemoteInstance();
    }

    @Override
    public void actionDataSourceSet_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext();
        uiContext.put("dsType", DSTypeEnum.Formula);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DataSourceListUI.class.getName(), (Map)uiContext);
        uiWindow.show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        this.uiHelper.checkBaseDataPermission(this.currentCUID, ids);
        try {
            TDUtils.tryLock(ids);
            ArrayList error = CalcFormulaFactory.getRemoteInstance().cancel(new HashSet(ids));
            if (error.size() > 0) {
                String cancelError = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_CancelError");
                String errorMsg = TDUtils.buildErrorMsg(error);
                MsgBox.showDetailAndOK((Component)((Object)this), (String)cancelError, (String)errorMsg, (int)8188);
            }
            this.actionRefresh_actionPerformed(e);
        }
        finally {
            TDUtils.releaseLock(ids);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        this.uiHelper.checkBaseDataPermission(this.currentCUID, ids);
        try {
            TDUtils.tryLock(ids);
            ArrayList error = CalcFormulaFactory.getRemoteInstance().cancelCancel(new HashSet(ids));
            if (error.size() > 0) {
                String cancelError = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_CancelCancelError");
                String errorDetailMSG = TDUtils.buildErrorMsg(error);
                MsgBox.showDetailAndOK((Component)((Object)this), (String)cancelError, (String)errorDetailMSG, (int)8188);
            }
            this.actionRefresh_actionPerformed(e);
        }
        finally {
            TDUtils.releaseLock(ids);
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanAddnew(this.currentCUID);
        super.actionAddNew_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.confirmRemove()) {
            this.checkSelected();
            ArrayList errorMsg = CalcFormulaFactory.getRemoteInstance().deleteBatch(new HashSet(this.getSelectedIdValues()));
            if (errorMsg != null && !errorMsg.isEmpty()) {
                String error = EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"REMOVE_ERROR");
                String detailMsg = TDUtils.buildErrorMsg(errorMsg);
                MsgBox.showDetailAndOK(null, (String)error, (String)detailMsg, (int)1);
            }
            this.refreshList();
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        CalcFormulaInfo info = CalcFormulaFactory.getRemoteInstance().getCalcFormulaInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
        this.uiHelper.checkCanEdit(this.currentCUID, this.getSelectedKeyValue());
        if (EstStateEnum.USING.equals((Object)info.getState())) {
            MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "Error_USINGEdit", this.getLocale()));
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    @Override
    public String getBizOrgProperty(OrgType orgType) throws BOSException, EASBizException {
        return "CU";
    }

    @Override
    public ICoreBase getPermInterface() throws Exception {
        return this.getBizInterface();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        try {
            this.initPermActions();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void initPermActions() throws BOSException, EASBizException {
    }

    @Override
    public void initPermMainOrgContext(String orgID) throws Exception {
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }
}

