/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.est.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.basedata.common.perf.client.JobMonitorManager;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.est.ESTFacadeFactory;
import com.kingdee.eas.tm.td.est.RealEstateGroupInfo;
import com.kingdee.eas.tm.td.est.client.AbstractEstCalculateConditionUI;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class EstCalculateConditionUI
extends AbstractEstCalculateConditionUI {
    private static final Logger logger = CoreUIObject.getLogger(EstCalculateConditionUI.class);

    public void onLoad() throws Exception {
        TDUtils.setMainBizOrgFilter(this.prmtCompany, OrgType.Company, "ert_estCalculateRecord_calculate");
        super.onLoad();
        Date now = new Date();
        this.prmtCompany.setValue((Object)TDUtils.getPermissionCompany("ert_estCalculateRecord_calculate"));
        this.spYearFrom.setValue((Object)(now.getYear() + 1900));
        this.spMonthFrom.setModel((SpinnerModel)new SpinnerNumberModel(now.getMonth() + 1, 1, 12, 1));
        this.spYearTo.setValue((Object)(now.getYear() + 1900));
        this.spMonthTo.setModel((SpinnerModel)new SpinnerNumberModel(now.getMonth() + 1, 1, 12, 1));
        this.prmtCompany.setEnabledMultiSelection(true);
        this.prmtGroup.setEnabledMultiSelection(true);
        this.chkCalculate.setSelected(true);
        this.chkCreateReport.setSelected(true);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onInit(RptParams initParams) throws Exception {
    }

    public RptParams getCustomCondition() {
        RptParams params = new RptParams();
        params.setObject("company", this.prmtCompany.getValue());
        params.setObject("group", this.prmtGroup.getValue());
        params.setObject("yearFrom", this.spYearFrom.getValue());
        params.setObject("monthFrom", this.spMonthFrom.getValue());
        params.setObject("yearTo", this.spYearTo.getValue());
        params.setObject("monthTo", this.spMonthTo.getValue());
        params.setObject("iscalculate", (Object)this.chkCalculate.isSelected());
        params.setObject("isCreateReport", (Object)this.chkCreateReport.isSelected());
        return params;
    }

    public void setCustomCondition(RptParams params) {
        if (params.getObject("company") != null) {
            this.prmtCompany.setValue(params.getObject("company"));
        }
        if (params.getObject("group") != null) {
            this.prmtGroup.setValue(params.getObject("group"));
        }
        if (params.getObject("yearFrom") != null) {
            this.spYearFrom.setValue(params.getObject("yearFrom"));
        }
        if (params.getObject("monthFrom") != null) {
            this.spMonthFrom.setValue(params.getObject("monthFrom"));
        }
        if (params.getObject("yearTo") != null) {
            this.spYearTo.setValue(params.getObject("yearTo"));
        }
        if (params.getObject("monthTo") != null) {
            this.spMonthTo.setValue(params.getObject("monthTo"));
        }
        if (params.getObject("iscalculate") != null) {
            this.chkCalculate.setSelected(params.getBoolean("iscalculate"));
        } else {
            this.chkCalculate.setSelected(true);
        }
        if (params.getObject("isCreateReport") != null) {
            this.chkCreateReport.setSelected(params.getBoolean("isCreateReport"));
        } else {
            this.chkCreateReport.setSelected(true);
        }
    }

    @Override
    public void actionCalculate_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> errorList = new ArrayList<String>();
        Object comValus = this.prmtCompany.getValue();
        HashSet<String> companyIds = new HashSet<String>();
        if (comValus instanceof CompanyOrgUnitInfo[]) {
            CompanyOrgUnitInfo[] companys = (CompanyOrgUnitInfo[])comValus;
            for (int i = 0; i < companys.length; ++i) {
                companyIds.add(companys[i].getId().toString());
            }
        } else if (comValus instanceof CompanyOrgUnitInfo) {
            companyIds.add(((CompanyOrgUnitInfo)comValus).getId().toString());
        } else if (comValus instanceof Object[]) {
            Object[] objects = (Object[])comValus;
            CompanyOrgUnitInfo[] companys = new CompanyOrgUnitInfo[objects.length];
            System.arraycopy(objects, 0, companys, 0, objects.length);
            for (int i = 0; i < companys.length; ++i) {
                companyIds.add(companys[i].getId().toString());
            }
        } else {
            errorList.add(TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "Error_TaskCompany", this.getLocale()));
        }
        Object groupValue = this.prmtGroup.getValue();
        HashSet<String> groupIds = new HashSet<String>();
        if (groupValue instanceof RealEstateGroupInfo[]) {
            RealEstateGroupInfo[] groups = (RealEstateGroupInfo[])groupValue;
            for (int i = 0; i < groups.length; ++i) {
                if (groups[i] == null) continue;
                groupIds.add(groups[i].getId().toString());
            }
        } else if (groupValue instanceof RealEstateGroupInfo) {
            groupIds.add(((RealEstateGroupInfo)groupValue).getId().toString());
        } else if (groupValue instanceof Object[]) {
            Object[] objects = (Object[])groupValue;
            RealEstateGroupInfo[] groups = new RealEstateGroupInfo[objects.length];
            System.arraycopy(objects, 0, groups, 0, objects.length);
            for (int i = 0; i < groups.length; ++i) {
                if (groups[i] == null) continue;
                groupIds.add(groups[i].getId().toString());
            }
        }
        int periodFrom = (Integer)this.spYearFrom.getValue() * 100 + (Integer)this.spMonthFrom.getValue();
        int periodTo = (Integer)this.spYearTo.getValue() * 100 + (Integer)this.spMonthTo.getValue();
        if (periodFrom > periodTo) {
            errorList.add(TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "Error_InvalidPeriod", this.getLocale()));
        }
        if (errorList.size() > 0) {
            MsgBox.showWarning((String)TDUtils.buildErrorMsg(errorList));
            return;
        }
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put("periodFrom", Integer.valueOf(periodFrom));
        params.put("periodTo", Integer.valueOf(periodTo));
        params.put("companyIds", companyIds);
        params.put("groupIds", groupIds);
        params.put("isCalculate", Boolean.valueOf(this.chkCalculate.isSelected()));
        params.put("isCreateReport", Boolean.valueOf(this.chkCreateReport.isSelected()));
        JobMonitorManager jobMonitor = JobMonitorManager.getInstance();
        Map resultMap = ESTFacadeFactory.getRemoteInstance().calculateAndDeclare(params);
        List jobList = (List)resultMap.get("jobList");
        for (int i = 0; i < jobList.size(); ++i) {
            Map jobMap = (Map)jobList.get(i);
            jobMonitor.addMonitorInfo((String)jobMap.get("jobInstExtId"), (String)jobMap.get("title"));
        }
        if (resultMap.get("error") != null) {
            String errMsg = (String)resultMap.get("error");
            logger.error((Object)errMsg);
            MsgBox.showError((String)errMsg);
        } else {
            Util.getWindow((Component)this.getCommonQueryPanel()).dispose();
            MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "Msg_AddJob", this.getLocale()));
        }
    }
}

