/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.est.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.kscript.runtime.Interpreter;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.td.PeriodTypeEnum;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.est.ContractEntryCollection;
import com.kingdee.eas.tm.td.est.ContractEntryInfo;
import com.kingdee.eas.tm.td.est.ContractEntryStateEnum;
import com.kingdee.eas.tm.td.est.ContractTaxEntryCollection;
import com.kingdee.eas.tm.td.est.ContractTaxEntryInfo;
import com.kingdee.eas.tm.td.est.EstCalculateRecordCollection;
import com.kingdee.eas.tm.td.est.EstCalculateRecordFactory;
import com.kingdee.eas.tm.td.est.EstCalculateRecordInfo;
import com.kingdee.eas.tm.td.est.EstTaxCycleEnum;
import com.kingdee.eas.tm.td.est.IRealEstate;
import com.kingdee.eas.tm.td.est.RealEstateFactory;
import com.kingdee.eas.tm.td.est.RealEstateInfo;
import com.kingdee.eas.tm.td.est.RentTypeEnum;
import com.kingdee.eas.tm.td.est.RentalEstateCollection;
import com.kingdee.eas.tm.td.est.RentalEstateFactory;
import com.kingdee.eas.tm.td.est.RentalEstateInfo;
import com.kingdee.eas.tm.td.est.TaxMethodEnum;
import com.kingdee.eas.tm.td.est.util.EstConstant;
import com.kingdee.eas.tm.td.est.util.EstUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EstCalcStrategy {
    private static String FIELD_FIRST = "FirstRent";
    private static String FIELD_LAST = "LastRent";
    private Context ctx;
    private RealEstateInfo realEstateInfo;
    private PeriodInfo periodInfo;
    private Date pBeginDate;
    private Date pEndDate;
    private CompanyOrgUnitInfo company;
    private boolean isPriceOnly = false;
    private List errorList = new ArrayList();
    private EstCalculateRecordCollection colls = new EstCalculateRecordCollection();

    public EstCalcStrategy(Context ctx, RealEstateInfo realEstateInfo, PeriodInfo period) throws BOSException {
        this.ctx = ctx;
        this.realEstateInfo = realEstateInfo;
        this.periodInfo = period;
        this.pBeginDate = this.periodInfo.getBeginDate();
        this.pEndDate = this.periodInfo.getEndDate();
        this.company = realEstateInfo.getCompany();
        this.isPriceOnly = realEstateInfo.isIsPriceOnly();
    }

    public Map doCalc() {
        HashMap<String, StringBuffer> calcResult = new HashMap<String, StringBuffer>();
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("realEstate.id", (Object)this.realEstateInfo.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)"1"));
            view.setFilter(filter);
            view.setSelector(this.getRentalEstateSelector());
            this.ctx.put((Object)"disablePermissionForKScript", (Object)true);
            RentalEstateCollection rentColl = RentalEstateFactory.getLocalInstance(this.ctx).getRentalEstateCollection(view);
            this.ctx.remove((Object)"disablePermissionForKScript");
            for (int i = 0; i < rentColl.size(); ++i) {
                RentalEstateInfo rentalInfo = rentColl.get(i);
                ContractTaxEntryCollection taxColl = rentalInfo.getContractTaxEntry();
                for (int j = 0; j < taxColl.size(); ++j) {
                    ContractTaxEntryInfo taxEntryInfo = taxColl.get(j);
                    if (this.isPriceOnly && "ZCyrvv6oAnPgU0ETqMCc49uK96Y=".equals(taxEntryInfo.getTaxItemType().getId().toString())) continue;
                    if (EstTaxCycleEnum.ASRENTCYCLE == taxEntryInfo.getTaxCycle()) {
                        this.calc4Rent(rentalInfo, taxEntryInfo);
                        continue;
                    }
                    if (EstTaxCycleEnum.ONCE == taxEntryInfo.getTaxCycle()) {
                        this.calc4Once(rentalInfo, taxEntryInfo);
                        continue;
                    }
                    this.calc4Cycle(rentalInfo, taxEntryInfo);
                }
            }
            int periodNumber = this.periodInfo.getPeriodNumber();
            int firstMonth = this.realEstateInfo.getFirstPaymentMonth().getValue();
            int cycle = this.realEstateInfo.getTaxCycle().getValue();
            if (periodNumber % cycle == firstMonth % cycle) {
                PeriodInfo firstPeriod = this.getFirstPeriod(periodNumber, cycle);
                ArrayList<Integer> dateList = new ArrayList<Integer>();
                for (int i = 0; i < cycle; ++i) {
                    dateList.add(firstPeriod.getNumber() + i);
                }
                IRealEstate iRealEstate = RealEstateFactory.getLocalInstance(this.ctx);
                Map rentAreaMap = iRealEstate.getRentArea(this.realEstateInfo.getId().toString(), dateList);
                this.calc4Price(firstPeriod, cycle, rentAreaMap);
            }
            if (this.colls.size() > 0) {
                EstCalculateRecordFactory.getLocalInstance(this.ctx).batchAddNew(this.colls);
            }
            RealEstateFactory.getLocalInstance(this.ctx).submit((CoreBaseInfo)this.realEstateInfo);
        }
        catch (Exception e) {
            this.errorList.add(e.getMessage());
        }
        if (!this.errorList.isEmpty()) {
            StringBuffer errorMsg = new StringBuffer();
            errorMsg.append(TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "Error_DoCalc", this.ctx.getLocale(), new Object[]{this.realEstateInfo.getNumber(), this.realEstateInfo.getName()})).append('\n');
            for (int i = 0; i < this.errorList.size(); ++i) {
                errorMsg.append(this.errorList.get(i)).append('\n');
            }
            calcResult.put("errorMsg", errorMsg);
        }
        return calcResult;
    }

    private void calc4Price(PeriodInfo firstPeriod, int cycle, Map rentAreaMap) {
        EstCalculateRecordInfo record = this.createRecord(null);
        record.setPeriodType(this.getPeriodType(this.realEstateInfo.getTaxCycle().getValue()));
        record.setFirstPeriod(firstPeriod);
        try {
            int monthCount;
            int monthNumber = firstPeriod.getNumber();
            BigDecimal oldArea = (BigDecimal)rentAreaMap.get(monthNumber);
            PeriodInfo changePeriod = firstPeriod;
            for (monthCount = 0; monthCount < cycle; ++monthCount) {
                BigDecimal newArea = (BigDecimal)rentAreaMap.get(monthNumber + monthCount);
                if (this.isPriceOnly || oldArea.compareTo(newArea) == 0) continue;
                changePeriod = PeriodUtils.getPeriodInfo((Context)this.ctx, (int)firstPeriod.getPeriodYear(), (int)(firstPeriod.getPeriodNumber() + monthCount), (CompanyOrgUnitInfo)this.company);
                this.calc4Price(changePeriod, cycle - monthCount, rentAreaMap);
                break;
            }
            record.setLastPeriod(PeriodUtils.getPeriodInfo((Context)this.ctx, (int)firstPeriod.getPeriodYear(), (int)(firstPeriod.getPeriodNumber() + monthCount - 1), (CompanyOrgUnitInfo)this.company));
            record.setRentArea(oldArea);
            this.realEstateInfo.setRentArea(oldArea);
            BigDecimal rentValue = oldArea.divide(this.realEstateInfo.getBuildingArea(), EstConstant.PRECISION_20, RoundingMode.HALF_UP).multiply(this.realEstateInfo.getTaxValue()).setScale(EstConstant.PRECISION_2, RoundingMode.HALF_UP);
            record.setRentOriginalValue(rentValue);
            this.realEstateInfo.setRentOriginalValue(rentValue);
            Map result = this.calcPriceBasis();
            if (result.get("basis") != null) {
                BigDecimal basis = ((BigDecimal)result.get("basis")).multiply(new BigDecimal(monthCount));
                record.setTaxBasis(basis.setScale(EstConstant.PRECISION_2, RoundingMode.HALF_UP));
                Map amtResult = this.calcPriceTaxAmount(basis);
                if (amtResult.get("taxAmount") != null) {
                    record.setTaxAmount((BigDecimal)amtResult.get("taxAmount"));
                } else {
                    record.setTaxAmount(BigDecimal.ZERO);
                    record.setCalculateResult((String)amtResult.get("error"));
                }
            } else {
                record.setTaxBasis(BigDecimal.ZERO);
                record.setTaxAmount(BigDecimal.ZERO);
                record.setCalculateResult((String)result.get("error"));
            }
        }
        catch (Exception e) {
            this.errorList.add(e.getMessage());
            record.setCalculateResult(e.getMessage());
        }
    }

    private PeriodInfo getFirstPeriod(int periodNumber, int cycle) throws BOSException, EASBizException {
        int firstCalcMonth;
        for (firstCalcMonth = 1; periodNumber < firstCalcMonth || periodNumber >= firstCalcMonth + cycle; firstCalcMonth += cycle) {
        }
        return PeriodUtils.getPeriodInfo((Context)this.ctx, (int)this.periodInfo.getPeriodYear(), (int)firstCalcMonth, (CompanyOrgUnitInfo)this.company);
    }

    private void calc4Rent(RentalEstateInfo rentalInfo, ContractTaxEntryInfo taxEntryInfo) throws EASBizException, BOSException {
        ContractEntryCollection contractEntryColl = rentalInfo.getContractEntry();
        for (int i = 0; i < contractEntryColl.size(); ++i) {
            ContractEntryInfo contractEntryInfo = contractEntryColl.get(i);
            if (ContractEntryStateEnum.TERMINATION.equals((Object)contractEntryInfo.getState())) continue;
            Date fDate = contractEntryInfo.getFirstDate();
            Date lDate = contractEntryInfo.getLastDate();
            Date signDate = contractEntryInfo.getSignDate();
            if (signDate.before(fDate)) {
                signDate = fDate;
            }
            if ((signDate.before(this.pBeginDate) || signDate.after(this.pEndDate)) && !EstUtils.hasDupDays(fDate, lDate, this.pBeginDate, this.pEndDate)) continue;
            Calendar begin = Calendar.getInstance();
            begin.setTime(fDate);
            Calendar end = Calendar.getInstance();
            end.setTime(lDate);
            Calendar sign = Calendar.getInstance();
            sign.setTime(signDate);
            int rentCycle = contractEntryInfo.getTaxCycle().getValue();
            int periodNumber = this.periodInfo.getPeriodNumber();
            if (rentCycle == 0) {
                PeriodInfo period = PeriodUtils.getPeriodInfo((Date)signDate, (CompanyOrgUnitInfo)this.company);
                if (period.getPeriodNumber() != periodNumber) continue;
                continue;
            }
            int firstMonth = begin.get(2) + 1;
            boolean needCalc = false;
            BigDecimal first = BigDecimal.ZERO;
            BigDecimal last = BigDecimal.ZERO;
            boolean includeFirst = false;
            int startMonth = periodNumber;
            if (RentTypeEnum.FIRST.equals((Object)contractEntryInfo.getRentType())) {
                ++firstMonth;
            }
            StringBuffer errorStr = new StringBuffer();
            PeriodInfo firstPeriod = this.periodInfo;
            if (periodNumber == sign.get(2) + 1 && this.periodInfo.getPeriodYear() == sign.get(1)) {
                startMonth = firstMonth;
                if (begin.get(5) != begin.getActualMinimum(5)) {
                    Map result = this.calcBasis(rentalInfo, contractEntryInfo, taxEntryInfo, FIELD_FIRST);
                    if (result.get("basis") != null) {
                        first = (BigDecimal)result.get("basis");
                    } else {
                        errorStr.append(result.get("error"));
                    }
                    if (RentTypeEnum.LAST.equals((Object)contractEntryInfo.getRentType())) {
                        includeFirst = true;
                    }
                }
                needCalc = true;
                firstPeriod = PeriodUtils.getPeriodInfo((Context)this.ctx, (int)begin.get(1), (int)firstMonth, (CompanyOrgUnitInfo)this.company);
            } else if (periodNumber % rentCycle == firstMonth % rentCycle) {
                if (periodNumber == firstMonth && this.periodInfo.getPeriodYear() == begin.get(1)) continue;
                needCalc = true;
            }
            if (!needCalc) continue;
            Calendar today = Calendar.getInstance();
            today.setTime(lDate);
            today.set(1, this.periodInfo.getPeriodYear());
            BigDecimal basis = BigDecimal.ZERO;
            Map result = this.calcBasis(rentalInfo, contractEntryInfo, taxEntryInfo, null);
            if (result.get("basis") != null) {
                basis = (BigDecimal)result.get("basis");
            } else {
                errorStr.append(result.get("error"));
            }
            if (EstUtils.isSameMonth(fDate, lDate)) {
                basis = basis.multiply(new BigDecimal(end.get(5) - begin.get(5))).divide(EstConstant.DIVISOR, EstConstant.PRECISION_20, RoundingMode.HALF_UP);
            } else {
                int month = 0;
                if (includeFirst) {
                    --rentCycle;
                    ++startMonth;
                }
                for (int j = 0; j < rentCycle; ++j) {
                    today.set(5, today.getActualMinimum(5));
                    today.set(2, startMonth - 1 + month);
                    today.set(5, today.getActualMaximum(5));
                    if (today.after(end) || today.equals(end)) {
                        Map res = this.calcBasis(rentalInfo, contractEntryInfo, taxEntryInfo, FIELD_LAST);
                        if (res.get("basis") != null) {
                            last = (BigDecimal)res.get("basis");
                            break;
                        }
                        errorStr.append(res.get("error"));
                        break;
                    }
                    ++month;
                }
                BigDecimal totalMonth = new BigDecimal(month);
                basis = first.add(basis.multiply(totalMonth)).add(last);
            }
            EstCalculateRecordInfo record = this.createRecord(taxEntryInfo);
            record.setFirstPeriod(firstPeriod);
            record.setLastPeriod(PeriodUtils.getPeriodInfo((Context)this.ctx, (int)today.get(1), (int)(today.get(2) + 1), (CompanyOrgUnitInfo)this.company));
            record.setPeriodType(this.getPeriodType(contractEntryInfo.getTaxCycle().getValue()));
            record.setContractNumber(contractEntryInfo.getContractNumber());
            record.setTaxBasis(basis.setScale(EstConstant.PRECISION_2, RoundingMode.HALF_UP));
            Map amtResult = this.calcTaxAmount(rentalInfo, contractEntryInfo, taxEntryInfo, basis);
            if (amtResult.get("taxAmount") != null) {
                record.setTaxAmount(((BigDecimal)amtResult.get("taxAmount")).setScale(EstConstant.PRECISION_2, RoundingMode.HALF_UP));
            } else {
                record.setTaxAmount(BigDecimal.ZERO);
                errorStr.append(amtResult.get("error"));
            }
            if (errorStr.length() <= 0) continue;
            record.setCalculateResult(errorStr.toString());
        }
    }

    private PeriodTypeEnum getPeriodType(int value) {
        switch (value) {
            case 0: {
                return PeriodTypeEnum.PERLY;
            }
            case 1: {
                return PeriodTypeEnum.MONTHLY;
            }
            case 3: {
                return PeriodTypeEnum.QUARTERLY;
            }
            case 6: {
                return PeriodTypeEnum.HALFYEAR;
            }
            case 12: {
                return PeriodTypeEnum.YEARLY;
            }
        }
        return PeriodTypeEnum.MONTHLY;
    }

    private void calc4Once(RentalEstateInfo rentalInfo, ContractTaxEntryInfo taxEntryInfo) throws EASBizException, BOSException {
        ContractEntryCollection contractColl = rentalInfo.getContractEntry();
        for (int i = 0; i < contractColl.size(); ++i) {
            Date fDate;
            ContractEntryInfo contractEntryInfo = contractColl.get(i);
            if (ContractEntryStateEnum.TERMINATION.equals((Object)contractEntryInfo.getState())) continue;
            Date signDate = contractEntryInfo.getSignDate();
            if (signDate.before(fDate = contractEntryInfo.getFirstDate())) {
                signDate = fDate;
            }
            if (signDate.before(this.pBeginDate) || signDate.after(this.pEndDate)) continue;
            BigDecimal basis = BigDecimal.ZERO;
            StringBuffer errorStr = new StringBuffer();
            Map result = this.calcBasis(rentalInfo, contractEntryInfo, taxEntryInfo, null);
            if (result.get("basis") != null) {
                basis = (BigDecimal)result.get("basis");
            } else {
                errorStr.append(result.get("error"));
            }
            EstCalculateRecordInfo record = this.createRecord(taxEntryInfo);
            record.setFirstPeriod(PeriodUtils.getPeriodInfo((Context)this.ctx, (Date)contractEntryInfo.getFirstDate(), (CompanyOrgUnitInfo)this.company));
            record.setLastPeriod(PeriodUtils.getPeriodInfo((Context)this.ctx, (Date)contractEntryInfo.getLastDate(), (CompanyOrgUnitInfo)this.company));
            record.setPeriodType(PeriodTypeEnum.PERLY);
            record.setContractNumber(contractEntryInfo.getContractNumber());
            record.setTaxBasis(basis.setScale(EstConstant.PRECISION_2, RoundingMode.HALF_UP));
            Map amtResult = this.calcTaxAmount(rentalInfo, contractEntryInfo, taxEntryInfo, basis);
            if (amtResult.get("taxAmount") != null) {
                record.setTaxAmount((BigDecimal)amtResult.get("taxAmount"));
            } else {
                record.setTaxAmount(BigDecimal.ZERO);
                errorStr.append(amtResult.get("error"));
            }
            if (errorStr.length() <= 0) continue;
            record.setCalculateResult(errorStr.toString());
        }
    }

    private void calc4Cycle(RentalEstateInfo rentalInfo, ContractTaxEntryInfo taxEntryInfo) throws EASBizException, BOSException {
        int periodNumber = this.periodInfo.getPeriodNumber();
        int firstMonth = taxEntryInfo.getFirstPaymentMonth().getValue();
        int cycle = taxEntryInfo.getTaxCycle().getValue();
        if (periodNumber % cycle == firstMonth % cycle) {
            PeriodInfo firstPeriod = this.getFirstPeriod(periodNumber, cycle);
            ContractEntryCollection contractColl = rentalInfo.getContractEntry();
            for (int i = 0; i < contractColl.size(); ++i) {
                ContractEntryInfo contractEntryInfo = contractColl.get(i);
                if (ContractEntryStateEnum.TERMINATION.equals((Object)contractEntryInfo.getState())) continue;
                BigDecimal totalBasis = BigDecimal.ZERO;
                PeriodInfo calcPeriod = firstPeriod;
                BigDecimal basis = BigDecimal.ZERO;
                StringBuffer errorStr = new StringBuffer();
                Map result = this.calcBasis(rentalInfo, contractEntryInfo, taxEntryInfo, null);
                if (result.get("basis") != null) {
                    basis = (BigDecimal)result.get("basis");
                } else {
                    errorStr.append(result.get("error"));
                }
                boolean hasRent = false;
                for (int j = 0; j < cycle; ++j) {
                    if (EstUtils.withinDateRange(contractEntryInfo.getFirstDate(), contractEntryInfo.getLastDate(), calcPeriod.getBeginDate())) {
                        if (!hasRent) {
                            firstPeriod = calcPeriod;
                            hasRent = true;
                        }
                        BigDecimal actBasis = basis;
                        totalBasis = totalBasis.add(actBasis);
                    }
                    if (j == cycle - 1) continue;
                    calcPeriod = PeriodUtils.getNextPeriodInfo((Context)this.ctx, (PeriodInfo)calcPeriod);
                }
                if (!hasRent) continue;
                EstCalculateRecordInfo record = this.createRecord(taxEntryInfo);
                record.setFirstPeriod(firstPeriod);
                record.setLastPeriod(calcPeriod);
                record.setPeriodType(this.getPeriodType(taxEntryInfo.getTaxCycle().getValue()));
                record.setContractNumber(contractEntryInfo.getContractNumber());
                record.setTaxBasis(totalBasis.setScale(EstConstant.PRECISION_2, RoundingMode.HALF_UP));
                Map amtResult = this.calcTaxAmount(rentalInfo, contractEntryInfo, taxEntryInfo, totalBasis);
                if (amtResult.get("taxAmount") != null) {
                    record.setTaxAmount((BigDecimal)amtResult.get("taxAmount"));
                } else {
                    record.setTaxAmount(BigDecimal.ZERO);
                    errorStr.append(amtResult.get("error"));
                }
                if (errorStr.length() > 0) {
                    record.setCalculateResult(errorStr.toString());
                }
                if (!"ZCyrvv6oAnPgU0ETqMCc49uK96Y=".equals(taxEntryInfo.getTaxItemType().getId().toString())) continue;
                record.setTaxMethod(TaxMethodEnum.RENT);
            }
        }
    }

    private EstCalculateRecordInfo createRecord(ContractTaxEntryInfo taxEntryInfo) {
        EstCalculateRecordInfo record = new EstCalculateRecordInfo();
        record.setCompany(this.company);
        record.setRealEstateGroup(this.realEstateInfo.getRealEstateGroup());
        record.setLandData(this.realEstateInfo.getLandData());
        record.setRealEstate(this.realEstateInfo);
        record.setTaxPeriod(this.periodInfo);
        if (taxEntryInfo != null) {
            record.setTaxItemType(taxEntryInfo.getTaxItemType());
            record.setDisplayExpr(taxEntryInfo.getCalcFormula().getDisplayExpr());
            record.setTaxBasisExpr(taxEntryInfo.getCalcFormula().getDisplayBasisExpr());
            record.setRentalEstate(taxEntryInfo.getRentalEstate());
        } else {
            TaxItemTypeInfo taxItem = new TaxItemTypeInfo();
            taxItem.setId(BOSUuid.read((String)"ZCyrvv6oAnPgU0ETqMCc49uK96Y="));
            record.setTaxItemType(taxItem);
            record.setTaxMethod(TaxMethodEnum.PRICE);
            record.setDisplayExpr(this.realEstateInfo.getCalcFormula().getDisplayExpr());
            record.setTaxBasisExpr(this.realEstateInfo.getCalcFormula().getDisplayBasisExpr());
        }
        record.setCalculateResult(TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "Msg_success", this.ctx.getLocale()));
        this.colls.add(record);
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map calcBasis(RentalEstateInfo rentalInfo, ContractEntryInfo contractEntryInfo, ContractTaxEntryInfo taxEntryInfo, String fieldName) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        BigDecimal monthRent = contractEntryInfo.getMonthRent();
        try {
            if (fieldName != null && contractEntryInfo.get(fieldName) != null) {
                contractEntryInfo.setMonthRent((BigDecimal)contractEntryInfo.get(fieldName));
            }
            Interpreter interpreter = new Interpreter(this.ctx);
            HashMap<String, Serializable> localCtx = new HashMap<String, Serializable>();
            localCtx.put("realEstate", this.realEstateInfo);
            localCtx.put("contractEntry", contractEntryInfo);
            localCtx.put("rentalEstate", rentalInfo);
            localCtx.put("contractTaxEntry", taxEntryInfo);
            localCtx.put("realEstateGroup", this.realEstateInfo.getRealEstateGroup());
            Object eval = interpreter.eval(taxEntryInfo.getCalcFormula().getBasisExpr(), localCtx);
            BigDecimal basis = new BigDecimal(eval.toString()).setScale(EstConstant.PRECISION_20, RoundingMode.HALF_UP);
            result.put("basis", basis);
        }
        catch (Exception e) {
            String errorMsg = TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "CalcBasisFailed", this.ctx.getLocale());
            if (taxEntryInfo != null && taxEntryInfo.getCalcFormula() != null) {
                errorMsg = TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "Error_CalcBasis", this.ctx.getLocale(), new Object[]{TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "RentalEstate", this.ctx.getLocale()) + taxEntryInfo.getRentalEstate().getNumber(), taxEntryInfo.getCalcFormula().getNumber()});
            }
            result.put("error", errorMsg);
            this.errorList.add(errorMsg);
        }
        finally {
            contractEntryInfo.setMonthRent(monthRent);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map calcTaxAmount(RentalEstateInfo rentalInfo, ContractEntryInfo contractEntryInfo, ContractTaxEntryInfo taxEntryInfo, BigDecimal basis) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Interpreter interpreter = new Interpreter(this.ctx);
            HashMap<String, Serializable> localCtx = new HashMap<String, Serializable>();
            localCtx.put("realEstate", this.realEstateInfo);
            localCtx.put("contractEntry", contractEntryInfo);
            localCtx.put("rentalEstate", rentalInfo);
            localCtx.put("contractTaxEntry", taxEntryInfo);
            localCtx.put("realEstateGroup", this.realEstateInfo.getRealEstateGroup());
            rentalInfo.setTaxBasis(basis);
            Object eval = interpreter.eval(taxEntryInfo.getCalcFormula().getExpr(), localCtx);
            BigDecimal taxAmount = new BigDecimal(eval.toString()).setScale(EstConstant.PRECISION_2, RoundingMode.HALF_UP);
            result.put("taxAmount", taxAmount);
        }
        catch (Exception e) {
            String errorMsg = TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "Error_CalcTaxAmount", this.ctx.getLocale(), new Object[]{e.getMessage()});
            result.put("error", errorMsg);
            this.errorList.add(errorMsg);
        }
        finally {
            rentalInfo.setTaxBasis(null);
        }
        return result;
    }

    private Map calcPriceBasis() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Interpreter interpreter = new Interpreter(this.ctx);
            HashMap<String, Serializable> localCtx = new HashMap<String, Serializable>();
            localCtx.put("realEstate", this.realEstateInfo);
            localCtx.put("realEstateGroup", this.realEstateInfo.getRealEstateGroup());
            Object eval = interpreter.eval(this.realEstateInfo.getCalcFormula().getBasisExpr(), localCtx);
            BigDecimal basis = new BigDecimal(eval.toString()).setScale(EstConstant.PRECISION_20, RoundingMode.HALF_UP);
            result.put("basis", basis);
        }
        catch (Exception e) {
            String errorMsg = TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "CalcBasisFailed", this.ctx.getLocale());
            if (this.realEstateInfo != null && this.realEstateInfo.getCalcFormula() != null) {
                String realEstate = TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "RealEstate", this.ctx.getLocale()).substring(1);
                errorMsg = TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "Error_CalcBasis", this.ctx.getLocale(), new Object[]{realEstate + this.realEstateInfo.getNumber(), this.realEstateInfo.getCalcFormula().getNumber()});
            }
            result.put("error", errorMsg);
            this.errorList.add(errorMsg);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map calcPriceTaxAmount(BigDecimal basis) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Interpreter interpreter = new Interpreter(this.ctx);
            HashMap<String, Serializable> localCtx = new HashMap<String, Serializable>();
            localCtx.put("realEstate", this.realEstateInfo);
            localCtx.put("realEstateGroup", this.realEstateInfo.getRealEstateGroup());
            this.realEstateInfo.setTaxBasis(basis);
            Object eval = interpreter.eval(this.realEstateInfo.getCalcFormula().getExpr(), localCtx);
            BigDecimal taxAmount = new BigDecimal(eval.toString()).setScale(EstConstant.PRECISION_2, RoundingMode.HALF_UP);
            result.put("taxAmount", taxAmount);
        }
        catch (Exception e) {
            String errorMsg = TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "Error_CalcTaxAmount", this.ctx.getLocale(), new Object[]{e.getMessage()});
            result.put("error", errorMsg);
            this.errorList.add(errorMsg);
        }
        finally {
            this.realEstateInfo.setTaxBasis(null);
        }
        return result;
    }

    private SelectorItemCollection getRentalEstateSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("rentalArea"));
        sic.add(new SelectorItemInfo("sysNumber"));
        sic.add(new SelectorItemInfo("contractEntry.id"));
        sic.add(new SelectorItemInfo("contractEntry.contractNumber"));
        sic.add(new SelectorItemInfo("contractEntry.leaseholder"));
        sic.add(new SelectorItemInfo("contractEntry.signDate"));
        sic.add(new SelectorItemInfo("contractEntry.firstDate"));
        sic.add(new SelectorItemInfo("contractEntry.lastDate"));
        sic.add(new SelectorItemInfo("contractEntry.monthRent"));
        sic.add(new SelectorItemInfo("contractEntry.taxCycle"));
        sic.add(new SelectorItemInfo("contractEntry.rentType"));
        sic.add(new SelectorItemInfo("contractEntry.firstRent"));
        sic.add(new SelectorItemInfo("contractEntry.lastRent"));
        sic.add(new SelectorItemInfo("contractTaxEntry.id"));
        sic.add(new SelectorItemInfo("contractTaxEntry.taxItemType.id"));
        sic.add(new SelectorItemInfo("contractTaxEntry.taxItemType.name"));
        sic.add(new SelectorItemInfo("contractTaxEntry.taxItemType.number"));
        sic.add(new SelectorItemInfo("contractTaxEntry.taxRate"));
        sic.add(new SelectorItemInfo("contractTaxEntry.taxCycle"));
        sic.add(new SelectorItemInfo("contractTaxEntry.firstPaymentMonth"));
        sic.add(new SelectorItemInfo("contractTaxEntry.calcFormula.id"));
        sic.add(new SelectorItemInfo("contractTaxEntry.calcFormula.name"));
        sic.add(new SelectorItemInfo("contractTaxEntry.calcFormula.number"));
        sic.add(new SelectorItemInfo("contractTaxEntry.calcFormula.displayBasisExpr"));
        sic.add(new SelectorItemInfo("contractTaxEntry.calcFormula.basisExpr"));
        sic.add(new SelectorItemInfo("contractTaxEntry.calcFormula.displayExpr"));
        sic.add(new SelectorItemInfo("contractTaxEntry.calcFormula.expr"));
        sic.add(new SelectorItemInfo("contractTaxEntry.calcFormula.taxMethod"));
        sic.add(new SelectorItemInfo("contractTaxEntry.calcFormula.dataSource.id"));
        sic.add(new SelectorItemInfo("contractTaxEntry.calcFormula.dataSource.entry.id"));
        sic.add(new SelectorItemInfo("contractTaxEntry.calcFormula.dataSource.entry.isMainTable"));
        sic.add(new SelectorItemInfo("contractTaxEntry.calcFormula.dataSource.entry.tableName"));
        sic.add(new SelectorItemInfo("contractTaxEntry.calcFormula.dataSource.entry.tableName"));
        sic.add(new SelectorItemInfo("contractTaxEntry.calcFormula.dataSource.entry.tableAlias"));
        sic.add(new SelectorItemInfo("contractTaxEntry.calcFormula.dataSource.entry.joinType"));
        sic.add(new SelectorItemInfo("contractTaxEntry.calcFormula.dataSource.entry.joinCondition"));
        sic.add(new SelectorItemInfo("contractTaxEntry.calcFormula.dataSource.entry.parentTable.id"));
        return sic;
    }
}

