/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.formula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.td.basedata.util.SCMMDUtil;
import com.kingdee.eas.tm.td.formula.AbstractBatchCalculater;
import com.kingdee.eas.tm.td.formula.ParamsInfo;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class EstBaseDataCalculater
extends AbstractBatchCalculater {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.formula.EstBaseDataCalculater");

    public EstBaseDataCalculater(ICalculateContextProvider contextProvider) {
        this.contextProvider = contextProvider;
    }

    @Override
    public void execute(SortedParameterArray paramArray) {
        super.execute(paramArray);
        IReportPropertyAdapter reportAdapter = this.contextProvider.getReportAdapter();
        int querySize = paramArray.size();
        String rptID = reportAdapter.getReportProperty("Report.ID").toString();
        ReportBaseInfo info = (ReportBaseInfo)reportAdapter.getReportProperty("editData");
        for (int i = 0; i < querySize; ++i) {
            Parameter params = paramArray.getParameter(i);
            ParamsInfo formulaParam = new ParamsInfo();
            formulaParam.buildEstBaseDataParam(params);
            formulaParam.setInfo(info);
            this.innerExecute(formulaParam);
        }
    }

    protected void innerExecute(ParamsInfo param) {
        String bosType = param.getBosType();
        String objectValue = param.getObjectValue();
        String entryObjectValue = param.getEntryObjectValue();
        String fieldName = param.getFieldName();
        EntityObjectInfo entity = this.getEntity(bosType);
        if (fieldName.isEmpty()) {
            param.getBackFiller().setValue((Object)"");
            return;
        }
        String[] props = fieldName.split("\\.");
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        ev.setFilter(filter);
        int index = 0;
        if (!StringUtils.isEmpty((String)entryObjectValue)) {
            if (props.length < 2 || !SCMMDUtil.isEntryProperty(entity, entity.getPropertyByName(props[0]))) {
                param.getBackFiller().setValue((Object)"");
                return;
            }
            index = 1;
            PropertyInfo entryProperyInfo = entity.getPropertyByName(props[0]);
            RelationshipInfo relationInfo = ((LinkPropertyInfo)entryProperyInfo).getRelationship();
            entity = relationInfo.getSupplierObject();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)entryObjectValue, CompareType.EQUALS));
        } else {
            if (SCMMDUtil.isEntryProperty(entity, entity.getPropertyByName(props[0]))) {
                param.getBackFiller().setValue((Object)"");
                return;
            }
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)objectValue, CompareType.EQUALS));
        }
        CoreBaseCollection coll = null;
        try {
            ICoreBase coreBase = (ICoreBase)BOSObjectFactory.createBOSObject((Context)this.ctx, (BOSObjectType)BOSObjectType.create((String)entity.getType().toString()));
            coll = coreBase.getCollection(ev);
        }
        catch (BOSException e1) {
            param.getBackFiller().setValue((Object)"");
            return;
        }
        if (coll == null || coll.size() == 0) {
            param.getBackFiller().setValue((Object)"");
            return;
        }
        IObjectValue valueInfo = coll.getObject(0);
        PropertyInfo property = null;
        if (props.length == 1) {
            if (valueInfo.get(props[0]) == null) {
                param.getBackFiller().setValue((Object)"");
            } else {
                property = entity.getPropertyByName(fieldName);
                param.getBackFiller().setValue(this.getPropertyValue(property, valueInfo.get(props[0])));
            }
            return;
        }
        IObjectValue tempInfo = null;
        IObjectValue seftInfo = valueInfo;
        EntityObjectInfo tempEntity = entity;
        for (int i = index; i < props.length; ++i) {
            property = tempEntity.getPropertyByName(props[i]);
            if (i == props.length - 1) {
                param.getBackFiller().setValue(this.getPropertyValue(property, seftInfo.get(props[i])));
                return;
            }
            if (property instanceof LinkPropertyInfo) {
                tempEntity = ((LinkPropertyInfo)property).getRelationship().getSupplierObject();
            }
            if (seftInfo.get(props[i]) instanceof IObjectValue) {
                tempInfo = (IObjectValue)seftInfo.get(props[i]);
                String id = tempInfo.getString("id");
                IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)this.ctx);
                try {
                    seftInfo = iDynamicObject.getValue(tempInfo.getBOSType(), (IObjectPK)new ObjectUuidPK(id));
                    continue;
                }
                catch (BOSException e) {
                    param.getBackFiller().setValue((Object)"");
                    return;
                }
            }
            param.getBackFiller().setValue((Object)"");
            return;
        }
    }
}

